<?php

namespace App\Http\Controllers\Individual;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Customer\Customer;
use App\Models\BankDetails\BankDetails;
use App\Models\Individual\IndividualCustome;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Facades\Redirect;

class IndividualCustomerController extends Controller
{
    public function index(Request $request)
    {
        $individual_customer = IndividualCustome::where('approval', 1)->orderBy('id', 'DESC')->paginate(5);
        //dd($customer);
        return view('individual-customer.index', compact('individual_customer'))
            ->with('i', ($request->input('page', 1) - 1) * 5);
    }


    public function create()
    {
        return view('individual-customer.create');
    }

    public function store(Request $request)
    {
        $email = $request->input('email');
        $phone = $request->input('phone');

        $record = IndividualCustome::where('email', '=', $email)->orWhere('phone', '=', $phone)->first();

        if ($record) {
         
         return redirect()->route('customer.index')->with('error', 'Email Or Mobile already exist');;

        } 
        
        else {
        
        $customer = new IndividualCustome;
        $customer->first_name = $request->input("first_name");
        $customer->middle_name = $request->input("middle_name");
        $customer->last_name = $request->input("last_name");
        $customer->gender = $request->input("gender");
        $customer->dob = $request->input("dob");
        $customer->email = $request->input("email");
        $customer->phone = $request->input("phone");
        $customer->citizenship = $request->input("citizenship");
        $customer->emergency_contact = $request->input("emergency_contact");
        $customer->blood_group = $request->input("blood_group");


        $customer->billing_address_line_1 = $request->input("billing_address_line_1");
        $customer->billing_address_line_2 = $request->input("billing_address_line_2");
        $customer->billing_city_town = $request->input("billing_city_town");
        $customer->billing_state_province = $request->input("billing_state_province");
        $customer->billing_country = $request->input("billing_country");
        $customer->billing_pincode = $request->input("billing_pincode");

        $customer->res_address_line_1 = $request->input("res_address_line_1");
        $customer->res_address_line_2 = $request->input("res_address_line_2");
        $customer->res_city_town = $request->input("res_city_town");
        $customer->res_state_province = $request->input("res_state_province");
        $customer->res_country = $request->input("res_country");
        $customer->res_pincode = $request->input("res_pincode");

        $customer->payment_method = $request->input("payment_method");
        $customer->terms = $request->input("terms");
        $customer->credit_limit = $request->input("credit_limit");
        $customer->payment_currency = $request->input("payment_currency");



        $customer->passport_number = $request->input("passport_number");
        $customer->passport_issue_date = $request->input("passport_issue_date");
        $customer->passport_expiry_date = $request->input("passport_expiry_date");

        if ($request->file('passport_file')) {
            $passport_file = $request->file('passport_file');
            $filename = time() . '.' . $passport_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $passport_file->move($path, $filename);
            $customer->passport_file = $filename;
        }

        $customer->driving_license = $request->input("driving_license");
        $customer->driving_issue_date = $request->input("driving_issue_date");
        $customer->driving_expiry_date = $request->input("driving_expiry_date");

        if ($request->file('driving_file')) {
            $driving_file = $request->file('driving_file');
            $filename = time() . '.' . $driving_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $driving_file->move($path, $filename);
            $customer->driving_file = $filename;
        }

        $customer->gov_id_number = $request->input("gov_id_number");
        $customer->gov_issue_date = $request->input("gov_issue_date");
        $customer->gov_expiry_date = $request->input("gov_expiry_date");

        if ($request->file('gov_file')) {
            $gov_file = $request->file('gov_file');
            $filename = time() . '.' . $gov_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $gov_file->move($path, $filename);
            $customer->gov_file = $filename;
        }

        $customer->tax_kra_pan_number = $request->input("tax_kra_pan_number");
        $customer->tax_issue_date = $request->input("tax_issue_date");
        $customer->tax_expiry_date = $request->input("tax_expiry_date");

        if ($request->file('tax_file')) {
            $tax_file = $request->file('tax_file');
            $filename = time() . '.' . $tax_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $tax_file->move($path, $filename);
            $customer->tax_file = $filename;
        }


        if ($request->file('yellow_fever_file')) {
            $yellow_fever_file = $request->file('yellow_fever_file');
            $filename = time() . '.' . $yellow_fever_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $yellow_fever_file->move($path, $filename);
            $customer->yellow_fever_file = $filename;
        }
        if ($request->file('Covid_file')) {
            $Covid_file = $request->file('Covid_file');
            $filename = time() . '.' . $Covid_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $Covid_file->move($path, $filename);
            $customer->Covid_file = $filename;
        }
        if ($request->file('other_file')) {
            $other_file = $request->file('other_file');
            $filename = time() . '.' . $other_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $other_file->move($path, $filename);
            $customer->other_file = $filename;
        }

        $customer->company_name = $request->input("company_name");
        $customer->policy_number = $request->input("policy_number");
        $customer->issue_date = $request->input("issue_date");
        $customer->expiry_date = $request->input("expiry_date");

        if ($request->file('insurance_file')) {
            $insurance_file = $request->file('insurance_file');
            $filename = time() . '.' . $insurance_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $insurance_file->move($path, $filename);
            $customer->insurance_file = $filename;
        }
        
        

        $customer->save();
        
        $customer_id= $customer->id;
        
        $BankDetails = new BankDetails();
        $BankDetails->customer_id = $customer_id;
        $BankDetails->customer_type = "Individual";
        $BankDetails->bank_name = $request->input("bank_name");
        $BankDetails->account_number = $request->input("account_number");
        $BankDetails->iban_number = $request->input("iban_number");
        $BankDetails->bank_code = $request->input("bank_code");
        $BankDetails->swift_code = $request->input("swift_code");
        $BankDetails->currency = $request->input("currency");
        $BankDetails->bank_branch = $request->input("bank_branch");
        $BankDetails->save();
        
        
        session()->flash('success', 'You\'ve Created Customer Successfully');
        return redirect()->route('ind_customer.index');
     }
   }
   
    public function add_bank(Request $request)
    {
        $customer_id = $request->input("customer_id");

        $BankDetails = new BankDetails();
        $BankDetails->customer_id = $customer_id;
        $BankDetails->customer_type = "Individual";
        $BankDetails->bank_name = $request->input("bank_name");
        $BankDetails->account_number = $request->input("account_number");
        $BankDetails->iban_number = $request->input("iban_number");
        $BankDetails->bank_code = $request->input("bank_code");
        $BankDetails->swift_code = $request->input("swift_code");
        $BankDetails->currency = $request->input("currency");
        $BankDetails->bank_branch = $request->input("bank_branch");
        $BankDetails->save();
            
         return redirect()->back()->with('success', 'Bank Added Successfully');

    }
    
    public function delete_bank($id)
    {
        $bank = BankDetails::find($id);
        $bank->delete();
        return redirect()->back()->with('success', 'Deleted Successfully');
    }


    public function show($id)
    {
        $cust = IndividualCustome::find($id);
        $banks = BankDetails::where('customer_id', $id)->where('customer_type', 'Individual')->get();
        //dd($cust);
        return view('individual-customer.show', compact('cust', 'banks'));
    }


    public function edit($id)
    {
        $cust = IndividualCustome::find($id);
        $banks = BankDetails::where('customer_id', $id)->where('customer_type', 'Individual')->get();
        //dd($cust);
        return view('individual-customer.edit', compact('cust', 'banks'));
    }


    public function update($id, Request $request)
    {
        $customer = IndividualCustome::find($id);
        $customer->first_name = $request->input("first_name");
        $customer->middle_name = $request->input("middle_name");
        $customer->last_name = $request->input("last_name");
        $customer->gender = $request->input("gender");
        $customer->dob = $request->input("dob");
        $customer->email = $request->input("email");
        $customer->phone = $request->input("phone");
        $customer->citizenship = $request->input("citizenship");
        $customer->emergency_contact = $request->input("emergency_contact");
        $customer->blood_group = $request->input("blood_group");


        $customer->billing_address_line_1 = $request->input("billing_address_line_1");
        $customer->billing_address_line_2 = $request->input("billing_address_line_2");
        $customer->billing_city_town = $request->input("billing_city_town");
        $customer->billing_state_province = $request->input("billing_state_province");
        $customer->billing_country = $request->input("billing_country");
        $customer->billing_pincode = $request->input("billing_pincode");

        $customer->res_address_line_1 = $request->input("res_address_line_1");
        $customer->res_address_line_2 = $request->input("res_address_line_2");
        $customer->res_city_town = $request->input("res_city_town");
        $customer->res_state_province = $request->input("res_state_province");
        $customer->res_country = $request->input("res_country");
        $customer->res_pincode = $request->input("res_pincode");

        $customer->payment_method = $request->input("payment_method");
        $customer->terms = $request->input("terms");
        $customer->credit_limit = $request->input("credit_limit");
        $customer->payment_currency = $request->input("payment_currency");



        $customer->passport_number = $request->input("passport_number");
        $customer->passport_issue_date = $request->input("passport_issue_date");
        $customer->passport_expiry_date = $request->input("passport_expiry_date");

        if ($request->file('passport_file')) {
            $passport_file = $request->file('passport_file');
            $filename = time() . '.' . $passport_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $passport_file->move($path, $filename);
            $customer->passport_file = $filename;
        }

        $customer->driving_license = $request->input("driving_license");
        $customer->driving_issue_date = $request->input("driving_issue_date");
        $customer->driving_expiry_date = $request->input("driving_expiry_date");

        if ($request->file('driving_file')) {
            $driving_file = $request->file('driving_file');
            $filename = time() . '.' . $driving_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $driving_file->move($path, $filename);
            $customer->driving_file = $filename;
        }

        $customer->gov_id_number = $request->input("gov_id_number");
        $customer->gov_issue_date = $request->input("gov_issue_date");
        $customer->gov_expiry_date = $request->input("gov_expiry_date");

        if ($request->file('gov_file')) {
            $gov_file = $request->file('gov_file');
            $filename = time() . '.' . $gov_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $gov_file->move($path, $filename);
            $customer->gov_file = $filename;
        }

        $customer->tax_kra_pan_number = $request->input("tax_kra_pan_number");
        $customer->tax_issue_date = $request->input("tax_issue_date");
        $customer->tax_expiry_date = $request->input("tax_expiry_date");

        if ($request->file('tax_file')) {
            $tax_file = $request->file('tax_file');
            $filename = time() . '.' . $tax_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $tax_file->move($path, $filename);
            $customer->tax_file = $filename;
        }


        if ($request->file('yellow_fever_file')) {
            $yellow_fever_file = $request->file('yellow_fever_file');
            $filename = time() . '.' . $yellow_fever_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $yellow_fever_file->move($path, $filename);
            $customer->yellow_fever_file = $filename;
        }
        if ($request->file('Covid_file')) {
            $Covid_file = $request->file('Covid_file');
            $filename = time() . '.' . $Covid_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $Covid_file->move($path, $filename);
            $customer->Covid_file = $filename;
        }
        if ($request->file('other_file')) {
            $other_file = $request->file('other_file');
            $filename = time() . '.' . $other_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $other_file->move($path, $filename);
            $customer->other_file = $filename;
        }

        $customer->company_name = $request->input("company_name");
        $customer->policy_number = $request->input("policy_number");
        $customer->issue_date = $request->input("issue_date");
        $customer->expiry_date = $request->input("expiry_date");

        if ($request->file('insurance_file')) {
            $insurance_file = $request->file('insurance_file');
            $filename = time() . '.' . $insurance_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $insurance_file->move($path, $filename);
            $customer->insurance_file = $filename;
        }

        $customer->status = $request->input("status") ? "Active" : "Inactive";

        $customer->save();
        session()->flash('success', 'You\'ve Updated Customer Successfully');
        return Redirect::back()->withErrors(['msg' => 'The Message']);
    }



    public function destroy($id)
    {
        $customer = IndividualCustome::find($id);
        $customer->delete();
        session()->flash('success', 'You\'ve Deleted Customer Successfully');
        return Redirect::back()->withErrors(['msg' => 'The Message']);
    }
}
