<?php

namespace App\Http\Controllers\IndividualApproval;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Individual\IndividualCustome;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\DB;

class IndividualApprovalController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $individual_customer = IndividualCustome::orderBy('id', 'DESC')->get();
        return view('ind_approval.index', compact('individual_customer'));
    }


    function status_update($id)
    {
        //get product status with the help of product ID
        $individual_customer = IndividualCustome::select('approval')
            ->where('id', '=', $id)
            ->first();

            //dd($customer);

        //Check user status
        if ($individual_customer->approval == '1') {
            $status = '0';
        } else {
            $status = '1';
        }

        //update product status
        $values = array('approval' => $status);
        //dd($values);
        IndividualCustome::where('id',$id)->update($values);

        session()->flash('msg', 'Product status has been updated successfully.');
        return Redirect::back()->withErrors(['msg' => 'The Message']);;
    }
}
