<?php

namespace App\Http\Controllers\Insurance;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Insurance\Insurance;
use App\Models\InsurancePlan\InsurancePlan;
use Illuminate\Support\Facades\Redirect;


class InsuranceController extends Controller
{
    public function index(Request $request)
    {
        $insurance = Insurance::orderBy('id', 'DESC')->get();
        //dd($hotel);
        return view('insurance.index', compact('insurance'))
            ->with('i', ($request->input('page', 1) - 1) * 5);
    }


    function status_update($id)
    {
        //get product status with the help of product ID
        $insurance = Insurance::select('status')
            ->where('id', '=', $id)
            ->first();

        //dd($customer);

        //Check user status
        if ($insurance->status == 'Active') {
            $status = 'Inactive';
        } else {
            $status = 'Active';
        }

        //update product status
        $values = array('status' => $status);
        //dd($values);
        Insurance::where('id', $id)->update($values);

        session()->flash('success', 'You\'ve Change Status Successfully');

        return Redirect::back();
    }

    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        $insurance = new Insurance;
        $insurance->company_name = $request->input("company_name");
        $insurance->status = $request->input("status") ? "Active" : "Inactive";
        
        $insurance->save();
        session()->flash('success', 'You\'ve Added Insurance Successfully');

        return redirect()->route('insurance.index');
    }

    public function show()
    {
        //
    }


    public function edit($id, Request $request)
    {
        $insurance = Insurance::find($id);    
        $insurance_pln = InsurancePlan::orderBy('id', 'DESC')->paginate(5);
        //dd($serv_edit);
        return view('insurance.edit', compact('insurance','insurance_pln'))->with('i', ($request->input('page', 1) - 1) * 5);
    }


    public function update($id, Request $request)
    {
        $insurance = Insurance::find($id);
        $insurance->company_name = $request->input("company_name");
        $insurance->status = $request->input("status") ? "Active" : "Inactive";
        $insurance->save();
        session()->flash('success', 'You\'ve Updated Insurance Successfully');

        return Redirect::back();
    }

    public function destroy($id)
    {
        $insurance = Insurance::find($id);
        $insurance->delete();
        session()->flash('success', 'You\'ve Deleted Insurance Successfully');

        return Redirect::back();
    }
}
