<?php

namespace App\Http\Controllers\Master;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Master\Designation;
use Illuminate\Support\Facades\Redirect;

class DesignationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        $designation = Designation::orderBy('id', 'DESC')->get();
        //dd($hotel);
        return view('master.designation.index', compact('designation'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $cat = new Designation;
        $cat->designation_title = $request->input("designation");
        $cat->save();
        session()->flash('success', 'You\'ve Added Designation successfully.');
        
        return Redirect::back();
    }
    function status_update($id)
    {
        echo "here we are";
        
        //get product status with the help of product ID
        $srvice = Category::select('status')
            ->where('id', '=', $id)
            ->first();

        //dd($customer);

        //Check user status
        if ($srvice->status == 'Active') {
            $status = 'Inactive';
        } else {
            $status = 'Active';
        }

        //update product status
        $values = array('status' => $status);
        //dd($values);
        Category::where('id', $id)->update($values);

        session()->flash('success', 'You\'ve Changed Status successfully.');
        
        return Redirect::back();
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    
     public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $hservice = Designation::find($id);
        //dd($emp);
        return response()->json([
            'status' => 200,
            'category' => $hservice,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        //
        $id = $request->input('cat_id');
        $cat = Designation::find($id);
        $cat->category_name = $request->input("cat_name");
        $cat->update();
        session()->flash('success', 'You\'ve Updated Designation successfully.');
        
        return Redirect::back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $cat = Designation::find($id);
        $type= $cat->designation_title;
        if($type=="HR Manager"){
          session()->flash('success', 'Locked item can\'t be deleted');
        return Redirect::back();    
        }
        else if($type=="Reporting Manager"){
          session()->flash('success', 'Locked item can\'t be deleted');
        return Redirect::back();    
        }
        else{
        $cat->delete();
        session()->flash('success', 'You\'ve Deleted Designation successfully.');
        
        return Redirect::back();    
        }
        
    }

}
