<?php

namespace App\Http\Controllers\Payments;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\View;

use App\Models\Account\Account;
use App\Models\DSR\DSR;
use App\Models\DSR\DsrHotelService;
use App\Models\DSR\DsrTourService;
use App\Models\DSR\DsrFlightService;
use App\Models\DSR\DsrVisaService;
use App\Models\DSR\DsrServicePassenger;
use App\Models\DSR\DsrInsuranceService;
use App\Models\DSR\DsrOtherService;
use App\Models\DSR\CarhireService;
use App\Models\DSR\AssistService;
use App\Models\Passengers\Passengers;
use App\Models\Hotel\Hotel;
use App\Models\Flight\Flight;
use App\Models\Visa\Visa;
use App\Models\Insurance\Insurance;
use App\Models\InsurancePlan\InsurancePlan;
use App\Models\Inventory\Inventory;
use App\Models\HotelService\HotelService;
use App\Models\TourPackage\TourPackage;
use App\Models\HotelServices\RoomBed;
use App\Models\HotelServices\RoomMeal;
use App\Models\Customer\Customer;
use App\Models\Taxmaster\Taxmaster;
use App\Models\Items\Items;
use App\Models\Invoice\Invoice;
use App\Models\Invoice\InvoiceServices;
use App\Models\Proforma\Proforma;
use App\Models\Assist\Assist;
use App\Models\Carhire\Carhire;
use App\Models\Proforma\ProformaServices;
use App\Models\Individual\IndividualCustome;
use App\Models\Supplier\Supplier;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Facades\Redirect;

use App\Models\Transaction\Transaction;
use App\Models\Debitnote\Debitnote;
use App\Models\Bills\Bills;
use App\Models\Payments\PaymentsMade;

class PaymentMadeController extends Controller
{
    public function index(Request $request)
    {
        $dsr = PaymentsMade::all();
        return view('paymentmade.index', compact('dsr'));
    }

    public function create(Request $request)
    {
        $id="";
        $taxmaster= Taxmaster::all();
        $other= Taxmaster::all();
        $supplier= Supplier::all();
        $dsr = PaymentsMade::all();

        $individual = IndividualCustome::where('approval', '=', 1)->select('*')->get();
        $corporate = Customer::where('approval', 1)->get();
        $passengers = Passengers::all();
        $hotels = Hotel::all();
        $tour = TourPackage::all();
        $room = HotelService::all();
        $flight = Flight::all();
        $visa = Visa::all();
        $insurance = Insurance::all();
        $carhire = Carhire::all();
        $assist = Assist::all();
        $insuranceplan = InsurancePlan::all();
        $other = Inventory::all();
        $taxmaster = Taxmaster::all();
        $bed = RoomBed::all();
        $meal = RoomMeal::all();
        $invoice = Bills::where('payment_status', 'Unpaid')->get();

        return view('paymentmade.create', compact('id','dsr','supplier','invoice','corporate','tour','bed','meal','room','taxmaster','individual','passengers','hotels', 'flight', 'visa', 'insurance', 'insuranceplan', 'other', 'carhire', 'assist'));
    }

    public function createx($id)
    {
        $invoice = Bills::where('bill_id', $id)->get();
        $taxmaster= Taxmaster::all();
        $other= Taxmaster::all();
        $supplier= Supplier::all();
        $dsr = PaymentsMade::all();

        $individual = IndividualCustome::where('approval', '=', 1)->select('*')->get();
        $corporate = Customer::where('approval', 1)->get();
        $passengers = Passengers::all();
        $hotels = Hotel::all();
        $tour = TourPackage::all();
        $room = HotelService::all();
        $flight = Flight::all();
        $visa = Visa::all();
        $insurance = Insurance::all();
        $carhire = Carhire::all();
        $assist = Assist::all();
        $insuranceplan = InsurancePlan::all();
        $other = Inventory::all();
        $taxmaster = Taxmaster::all();
        $bed = RoomBed::all();
        $meal = RoomMeal::all();
        $account = Account::all();

        return view('paymentmade.createx', compact('id','dsr','account','supplier','invoice','corporate','tour','bed','meal','room','taxmaster','individual','passengers','hotels', 'flight', 'visa', 'insurance', 'insuranceplan', 'other', 'carhire', 'assist'));
    }

    public function store(Request $request)
    {
        $maxDsrNumber = PaymentsMade::max('payment_id');
        $lastDsrNumber = (int) substr($maxDsrNumber, -7);
        $newDsrNumber = $lastDsrNumber + 1;
        $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);
        $series = 'PayID';
        $dsr_number = $series . '-' . $paddedDsrNumber;

        $bill_id = $request->input("bill_id");
        $amount_received = $request->input("payment_amount");
        
        $bill=  Bills::where('bill_id',$bill_id)->first();
        $total = $bill->total;
        $paid_amount= $bill->paid_amount;

        $Payments = new PaymentsMade;

        if ($request->file('payments_file')) {
            $photo = $request->file('payments_file');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $Payments->file = $filename;
        }

        $Payments->payment_id = $dsr_number;
        // $Payments->supplier_id = $request->input("supplier_id");
        $Payments->supplier = $request->input("supplier");
        $Payments->date = $request->input("date");
        $Payments->bill_id = $request->input("bill_id");
        $Payments->amount = $request->input("payment_amount");
        $Payments->reference = $request->input("reference");
        $Payments->notes = $request->input("customer_note");
        $Payments->payment_mode = $request->input("payment_mode");
        $Payments->paid_through = $request->input("paid_through");
        $Payments->save();

        //dd($values);
        
        if($paid_amount == 0){
        
         if($total == $amount_received){
          $values = array('payment_status' => "Paid", 'paid_amount' => $amount_received);

          }
          else if($total > $amount_received){
          $values = array('payment_status' => "Unpaid", 'paid_amount' => $amount_received);
          }
        
        }
        else{
            
            $amount_received= $paid_amount+$amount_received;
            
             if($total == $amount_received){
          $values = array('payment_status' => "Paid", 'paid_amount' => $amount_received);

          }
          else if($total > $amount_received){
          $values = array('payment_status' => "Unpaid", 'paid_amount' => $amount_received);
          }
            
        }

        Bills::where('bill_id',$bill_id)->update($values);

        
        $maxDsrNumber = Transaction::max('transaction_id');
        $lastDsrNumber = (int) substr($maxDsrNumber, -7);
        $newDsrNumber = $lastDsrNumber + 1;
        $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);
        $series = 'Txn';
        $txn_id = $series . '-' . $paddedDsrNumber;
        
        $payment_amount = $request->input("payment_amount");
        $account_id= $request->input("paid_through");
        $date= $request->input("date");

        $account = Account::find($account_id);
        $balance= $account->balance;
        $balance= $balance-$payment_amount;
        $account->balance = $balance;
        $account->save();
        
        $transaction = new Transaction;
        $transaction->transaction_id =$txn_id;
        $transaction->date = $date;
        $transaction->account_id = $account_id;
        $transaction->transaction_type = 'Vendor Payment';
        $transaction->credit = $payment_amount;
        $transaction->save();
        
        session()->flash('success', 'Payment Made Successfully');        
        return redirect()->route('PaymentMade');        

    }
}
