<?php

namespace App\Http\Controllers\Proforma;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use PDF;
use Illuminate\Support\Facades\Redirect;
use App\Models\Proforma\Proforma;
use App\Models\Proforma\ProformaServices;

use App\Models\DSR\DSR;
use App\Models\DSR\DsrHotelService;
use App\Models\DSR\DsrTourService;
use App\Models\DSR\DsrFlightService;
use App\Models\DSR\DsrVisaService;
use App\Models\DSR\DsrServicePassenger;
use App\Models\DSR\DsrInsuranceService;
use App\Models\DSR\DsrOtherService;
use App\Models\DSR\CarhireService;
use App\Models\DSR\AssistService;
use App\Models\Passengers\Passengers;
use App\Models\Hotel\Hotel;
use App\Models\Flight\Flight;
use App\Models\Visa\Visa;
use App\Models\Insurance\Insurance;
use App\Models\InsurancePlan\InsurancePlan;
use App\Models\Inventory\Inventory;
use App\Models\HotelService\HotelService;
use App\Models\TourPackage\TourPackage;
use App\Models\HotelServices\RoomBed;
use App\Models\HotelServices\RoomMeal;
use App\Models\Customer\Customer;
use App\Models\Taxmaster\Taxmaster;
use App\Models\Items\Items;
use App\Models\Invoice\Invoice;
use App\Models\Invoice\InvoiceServices;
use App\Models\Assist\Assist;
use App\Models\Carhire\Carhire;
use App\Models\Individual\IndividualCustome;

class ProformaController extends Controller
{
    public function index(Request $request)
    {
        $dsr = Proforma::where('status', '=', 1)->orderBy('proforma_id')->get();
  return view('proforma.index', compact('dsr'));
    }
    
    public function Create()
    {
                session()->forget('cart');

        
          // Get the current maximum order number from the database
          $maxDsrNumber = Proforma::max('proforma_id');

          // Parse the Dsr number to get the numeric part
          $lastDsrNumber = (int) substr($maxDsrNumber, -7);
  
          // Increment the Dsr number
          $newDsrNumber = $lastDsrNumber + 1;
  
          // Pad the Dsr number with leading zeros to get the final Dsr number
          $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);
  
          // Build the final Dsr ID with the series
          $series = 'PFM';
          $id = $series . '-' . $paddedDsrNumber;



        $corporate = Customer::where('approval', '=', 1)->select('*')->get();
        $cdata = Customer::where('approval', '=', 1)->get();
        $individual = IndividualCustome::where('approval', '=', 1)->get();
        $idata = IndividualCustome::where('approval', '=', 1)->get();

        

        $individual = IndividualCustome::where('approval', '=', 1)->select('*')->get();
        $corporate = Customer::where('approval', 1)->get();
        $passengers = Passengers::all();
        $hotels = Hotel::all();
        $tour = TourPackage::all();
        $room = HotelService::all();
        $flight = Flight::all();
        $visa = Visa::all();
        $insurance = Insurance::all();
        $carhire = Carhire::all();
        $assist = Assist::all();
        $insuranceplan = InsurancePlan::all();
        $other = Inventory::all();
        $taxmaster = Taxmaster::all();
        $bed = RoomBed::all();
        $meal = RoomMeal::all();


        $services['hotel'] = DsrHotelService::where('dsr_number', $id)->get();
        $services['flight'] = DsrFlightService::where('dsr_number', $id)->get();
        $services['visa'] = DsrVisaService::where('dsr_number', $id)->get();
        $services['insurance'] = DsrInsuranceService::where('dsr_number', $id)->get();
        $services['other'] = DsrOtherService::where('dsr_number', $id)->get();
        //dd($emp);
        return view('proforma.create', compact('id','cdata','idata','services','corporate','tour','bed','meal','room','taxmaster','individual','passengers','hotels', 'flight', 'visa', 'insurance', 'insuranceplan', 'other', 'carhire', 'assist'));
    }
    
     public function store(Request $request)
    {
          // Get the current maximum order number from the database
        $maxDsrNumber = Proforma::max('proforma_id');

        // Parse the Dsr number to get the numeric part
        $lastDsrNumber = (int) substr($maxDsrNumber, -6);

        // Increment the Dsr number
        $newDsrNumber = $lastDsrNumber + 1;

        // Pad the Dsr number with leading zeros to get the final Dsr number
        $paddedDsrNumber = str_pad($newDsrNumber, 6, '0', STR_PAD_LEFT);

        // Build the final Dsr ID with the series
        $series = 'NP';
        $dsr_number = $series . '-' . $paddedDsrNumber;

        $type=$request->input("customer_type");
        if ($type=="Corporate") {
            $customer_id = $request->input("corporate_id");
            $customer_name = $request->input("select_company_name");

        }
        elseif ($type=="Individual") {
            $customer_id = $request->input("individual_id");
            $customer_name = $request->input("select_individual_name");
        }
        elseif ($type=="New") {
            $customer_id = 0;
            $customer_name = $request->input("customer_name");
            $email = $request->input("email");
            $phone = $request->input("mobile");
            $address = $request->input("address");

            
        }

        $Quotation = new Proforma;

        if ($request->file('quotation_file')) {
            $photo = $request->file('quotation_file');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $Quotation->file = $filename;
        }

        $Quotation->customer_type = $request->input("customer_type");
        $Quotation->customer_id = $customer_id;
        $Quotation->customer_name = $customer_name;
        $Quotation->proforma_id = $dsr_number;
        $Quotation->currency = $request->input("currency");
        $Quotation->date = $request->input("quotation_date");
        $Quotation->expiry_date = $request->input("expiry_date");
        $Quotation->reference_no = $request->input("reference_no");
        $Quotation->customer_note = $request->input("customer_note");
        $Quotation->terms = $request->input("terms");
        $Quotation->subtotal = $request->input("subtotal");
        $Quotation->shipping_charge = $request->input("shipping_charge");
        $Quotation->adjustment_charge = $request->input("adjustment_charge");
        $Quotation->total = $request->input("quotation_total");
        $Quotation->tax_type = $request->input("tax_type");
        $Quotation->status = 1;
        $Quotation->save();

        $quantity = $request->input("quantity");

        foreach($quantity as $key => $value) {
            $Items = new Items();
            $Items->quotation_id = $dsr_number;
            $Items->item_details = $request->input("item_details")[$key];
            $Items->quantity = $request->input("quantity")[$key];
            $Items->rate = $request->input("rate")[$key];
            $Items->discount = $request->input("discount")[$key];
            $Items->tax_rate = $request->input("tax_rate")[$key];
            $Items->tax_amount = $request->input("tax_amount")[$key];
            $Items->total = $request->input("total")[$key];

            // $Items->rate = $request->input("rate");
            $Items->save();
        } 

        session()->flash('success', 'You\'ve Added Proforma Successfully');
        return redirect()->route('Proforma');

      
                

    }
    
     public function update(Request $request)
    {
        

        $type=$request->input("customer_type");
        if ($type=="Corporate") {
            $customer_id = $request->input("corporate_id");
            $customer_name = $request->input("select_company_name");

        }
        elseif ($type=="Individual") {
            $customer_id = $request->input("individual_id");
            $customer_name = $request->input("select_individual_name");
        }
        elseif ($type=="New") {
            $customer_id = 0;
            $customer_name = $request->input("customer_name");
            $email = $request->input("email");
            $phone = $request->input("mobile");
            $address = $request->input("address");

            
        }

            $id = $request->input("id");

        $Quotation =  Proforma::find($id);

        if ($request->file('quotation_file')) {
            $photo = $request->file('quotation_file');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $Quotation->file = $filename;
        }

        $Quotation->customer_type = $request->input("customer_type");
        $Quotation->customer_id = $customer_id;
        $Quotation->customer_name = $customer_name;
        $Quotation->currency = $request->input("currency");
        $Quotation->date = $request->input("quotation_date");
        $Quotation->expiry_date = $request->input("expiry_date");
        $Quotation->reference_no = $request->input("reference_no");
        $Quotation->customer_note = $request->input("customer_note");
        $Quotation->terms = $request->input("terms");
        $Quotation->subtotal = $request->input("subtotal");
        $Quotation->shipping_charge = $request->input("shipping_charge");
        $Quotation->adjustment_charge = $request->input("adjustment_charge");
        $Quotation->total = $request->input("quotation_total");
        $Quotation->tax_type = $request->input("tax_type");
        $Quotation->status = 1;
        $Quotation->save();

        $quantity = $request->input("quantity");

        foreach($quantity as $key => $value) {

    $id= $request->input("itm-id")[$key];
            $Items =  Items::find($id);
            $Items->item_details = $request->input("item_details")[$key];
            $Items->quantity = $request->input("quantity")[$key];
            $Items->rate = $request->input("rate")[$key];
            $Items->discount = $request->input("discount")[$key];
            $Items->tax_rate = $request->input("tax_rate")[$key];
            $Items->tax_amount = $request->input("tax_amount")[$key];
            $Items->total = $request->input("total")[$key];

            // $Items->rate = $request->input("rate");
            $Items->save();
        } 

        session()->flash('success', 'You\'ve Updated Proforma Successfully');
        return redirect()->route('Proforma');

      
                

    }
    
    public function edit($id)
    {
          
        $proforma = Proforma::find($id);
        $proforma_id =$proforma->proforma_id;

        $corporate = Customer::where('approval', '=', 1)->select('*')->get();
        $cdata = Customer::where('approval', '=', 1)->get();
        $individual = IndividualCustome::where('approval', '=', 1)->get();
        $idata = IndividualCustome::where('approval', '=', 1)->get();

        

        $individual = IndividualCustome::where('approval', '=', 1)->select('*')->get();
        $corporate = Customer::where('approval', 1)->get();
        $passengers = Passengers::all();
        $hotels = Hotel::all();
        $tour = TourPackage::all();
        $room = HotelService::all();
        $flight = Flight::all();
        $visa = Visa::all();
        $insurance = Insurance::all();
        $carhire = Carhire::all();
        $assist = Assist::all();
        $insuranceplan = InsurancePlan::all();
        $other = Inventory::all();
        $taxmaster = Taxmaster::all();
        $bed = RoomBed::all();
        $meal = RoomMeal::all();




        $services['hotel'] = Items::where('quotation_id', $proforma_id)->get();        $services['flight'] = DsrFlightService::where('dsr_number', $id)->get();
       
        return view('proforma.edit', compact('id','proforma','cdata','idata','services','corporate','tour','bed','meal','room','taxmaster','individual','passengers','hotels', 'flight', 'visa', 'insurance', 'insuranceplan', 'other', 'carhire', 'assist'));
    }
    
    
     public function convertToInvoice($id)
    {
        
        $Quotation = Proforma::where('proforma_id', $id)->first();

        $quotation_id= $Quotation->proforma_id;
        $customer_name= $Quotation->customer_name;
        $subtotal= $Quotation->subtotal;
        $shipping_charge= $Quotation->shipping_charge;
        $adjustment_charge= $Quotation->adjustment_charge;
        $total= $Quotation->total;

        do {
           
            $invoice_no=rand(100000,999999);

            $records=DB::table('invoice')
                   ->where('invoice_no',$invoice_no)
                   ->exists();     
                   
           
         } while ($records ==1);

        $Invoice = new Invoice;
        $Invoice->invoice_no = $invoice_no;
        $Invoice->dsr_number = $quotation_id;
        $Invoice->invoice_to = $customer_name;
        $Invoice->subtotal = $subtotal;
        $Invoice->shipping_charge = $shipping_charge;
        $Invoice->adjustment_charge = $adjustment_charge;
        $Invoice->total = $total;
        $Invoice->status = 0;
        $Invoice->save();

        $items=Items::where('quotation_id', $id)->get();

        // items Services
        foreach ($items as $data) {
            $description=$data->item_details;
            $quantity=$data->quantity;
            $vat=$data->tax_rate;
            $price=$data->rate;
            $amount=$data->total;


            $InvoiceServices = new InvoiceServices();
            $InvoiceServices->invoice_id = $invoice_no;
            $InvoiceServices->description = $description;
            $InvoiceServices->quantity = $quantity;
            $InvoiceServices->vat = $vat;
            $InvoiceServices->price = $price;
            $InvoiceServices->amount = $amount;
            $InvoiceServices->save();
        }
        
        session()->flash('success', 'Converted to Invoice Successfully');
        return Redirect::back();
    }
    
    
    public function download($id){

    $quotation =$proforma = Proforma::find($id);
        $proforma_no =$proforma->proforma_id;
        $taxmaster = Taxmaster::all();


        $services['hotel'] = Items::where('quotation_id', $proforma_no)->get();
        

        // return view('quotation.download', compact('id','quotation','services'));
    
    // return view('quotation.download', compact('data', 'passengers', 'hotels', 'flights', 'visas', 'insurances', 'others'));
    
    $pdf = PDF::loadView('proforma.download', compact('id','proforma','services', 'taxmaster'));
return $pdf->download('proforma.pdf');


    
}

public function view($id){

    $quotation =$proforma = Proforma::find($id);
       $proforma_no =$proforma->proforma_id;
        $taxmaster = Taxmaster::all();


        $services['hotel'] = Items::where('quotation_id', $proforma_no)->get();
        

        return view('proforma.download', compact('id','proforma','services', 'taxmaster'));
    
}

}
