<?php

namespace App\Http\Controllers\PurchaseOrder;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\View;

use App\Models\DSR\DSR;
use App\Models\DSR\DsrHotelService;
use App\Models\DSR\DsrTourService;
use App\Models\DSR\DsrFlightService;
use App\Models\DSR\DsrVisaService;
use App\Models\DSR\DsrServicePassenger;
use App\Models\DSR\DsrInsuranceService;
use App\Models\DSR\DsrOtherService;
use App\Models\DSR\CarhireService;
use App\Models\DSR\AssistService;
use App\Models\Passengers\Passengers;
use App\Models\Hotel\Hotel;
use App\Models\Flight\Flight;
use App\Models\Visa\Visa;
use App\Models\Insurance\Insurance;
use App\Models\InsurancePlan\InsurancePlan;
use App\Models\Inventory\Inventory;
use App\Models\HotelService\HotelService;
use App\Models\TourPackage\TourPackage;
use App\Models\HotelServices\RoomBed;
use App\Models\HotelServices\RoomMeal;
use App\Models\Customer\Customer;
use App\Models\Taxmaster\Taxmaster;
use App\Models\Items\Items;
use App\Models\Invoice\Invoice;
use App\Models\Invoice\InvoiceServices;
use App\Models\Proforma\Proforma;
use App\Models\Assist\Assist;
use App\Models\Carhire\Carhire;
use App\Models\Proforma\ProformaServices;
use App\Models\Individual\IndividualCustome;
use App\Models\Supplier\Supplier;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Facades\Redirect;

use App\Models\PurchaseOrder\PurchaseOrder;

class PurchaseOrderController extends Controller
{

    public function index(Request $request)
    {
        $dsr = PurchaseOrder::all();
        return view('purchaseorder.index', compact('dsr'));
    }

    public function create(Request $request)
    {
        
                 session()->forget('cart');
        
        $maxDsrNumber = PurchaseOrder::max('purchaseorder_id');
        $lastDsrNumber = (int) substr($maxDsrNumber, -7);
        $newDsrNumber = $lastDsrNumber + 1;
        $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);

        // Build the final Dsr ID with the series
        $series = 'PO';
        $po_id = $series . '-' . $paddedDsrNumber;

        
        $id="";
        $taxmaster= Taxmaster::all();
        $other= Taxmaster::all();
        $supplier= Supplier::all();
        $dsr = PurchaseOrder::all();

        $individual = IndividualCustome::where('approval', '=', 1)->select('*')->get();
        $corporate = Customer::where('approval', 1)->get();
        $passengers = Passengers::all();
        $hotels = Hotel::all();
        $tour = TourPackage::all();
        $room = HotelService::all();
        $flight = Flight::all();
        $visa = Visa::all();
        $insurance = Insurance::all();
        $carhire = Carhire::all();
        $assist = Assist::all();
        $insuranceplan = InsurancePlan::all();
        $other = Inventory::all();
        $taxmaster = Taxmaster::all();
        $bed = RoomBed::all();
        $meal = RoomMeal::all();
        $invoice = Invoice::all();

        return view('purchaseorder.create', compact('id','po_id','dsr','supplier','invoice','corporate','tour','bed','meal','room','taxmaster','individual','passengers','hotels', 'flight', 'visa', 'insurance', 'insuranceplan', 'other', 'carhire', 'assist'));
    }

    public function store(Request $request)
    {
        $maxDsrNumber = PurchaseOrder::max('purchaseorder_id');
        $lastDsrNumber = (int) substr($maxDsrNumber, -6);
        $newDsrNumber = $lastDsrNumber + 1;
        $paddedDsrNumber = str_pad($newDsrNumber, 6, '0', STR_PAD_LEFT);

        // Build the final Dsr ID with the series
        $series = 'NPO';
        $dsr_number = $series . '-' . $paddedDsrNumber;

    $PurchaseOrder = new PurchaseOrder;

        // if ($request->file('PurchaseOrder_file')) {
        //     $photo = $request->file('purchaseorder_file');
        //     $filename = time() . '.' . $photo->getClientOriginalExtension();
        //     $path = public_path('uploads');
        //     $photo->move($path, $filename);
        //     $PurchaseOrder->file = $filename;
        // }

        $PurchaseOrder->supplier = $request->input("supplier");
        $PurchaseOrder->PurchaseOrder_id = $dsr_number;
        $PurchaseOrder->date = $request->input("date");
        $PurchaseOrder->delivery_date = $request->input("delivery_date");
        $PurchaseOrder->reference_no = $request->input("reference_no");
        $PurchaseOrder->shipping_preferences = $request->input("shipping_preferences");
        $PurchaseOrder->payment_terms = $request->input("payment_terms");
        $PurchaseOrder->notes = $request->input("customer_note");
        $PurchaseOrder->subtotal = $request->input("subtotal");
        // $PurchaseOrder->discount = $request->input("discount");
        $PurchaseOrder->adjustment_charge = $request->input("adjustment_charge");
        $PurchaseOrder->total = $request->input("purchase_total");
        $PurchaseOrder->save();

        $quantity = $request->input("quantity");

        foreach($quantity as $key => $value) {
            $Items = new Items();
            $Items->quotation_id = $dsr_number;
            $Items->item_details = $request->input("item_details")[$key];
            $Items->quantity = $request->input("quantity")[$key];
            $Items->rate = $request->input("rate")[$key];
            $Items->tax_rate = $request->input("tax_rate")[$key];
            $Items->tax_amount = $request->input("tax_amount")[$key];
            $Items->discount = $request->input("discount")[$key];
            $Items->total = $request->input("total")[$key];

            // $Items->rate = $request->input("rate");
            $Items->save();
         } 

        // Alert::success('Congrats', 'You\'ve Added Debitnote Successfully');
        return redirect()->route('PurchaseOrder');
     }
}
