@extends('layouts.master')

@section('content')

<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-left">
            <h2>Proforma List</h2>
        </div>
        <br>
        <div class="mt-5 mb-3">
            <!-- <a type="button" href="{{ route('customer.create') }}" class="btn btn-success btn-icon-text mb-2 mb-md-0">
                <i class="btn-icon-prepend" data-feather="user"></i>
                Create Customer
            </a> -->
        </div>
    </div>
</div>

@if ($message = Session::get('success'))
@include('sweetalert::alert')
@endif


<div class="col-md-12 grid-margin stretch-card">
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table id="dataTableExample" class="table">
                    <thead class="text-center">
                        <tr>
                            <th>No</th>
                            <th>Proforma No</th>
                            <th>Customer Name</th>
                            <th>Approval</th>
                            <th>Status</th>
                            <th>PDF</th>
                            <th width="280px">Action</th>
                        </tr>
                    </thead>
                    <tbody class="text-center">
                        @foreach ($customer as $key => $cust)
                        <tr class="fw-bold fs-5">
                            <td>{{ $key+1 }}</td>
                            <td>{{ $cust->proforma_no}}</td>
                            <td>{{ $cust->customer_name }}</td>
                            <td>
                                <?php if ($cust->status == '1') { ?>

                                    <a href="{{url('/proforma_approval',$cust->id)}}" class="btn btn-danger btn-sm">Unapprove</a>

                                <?php } else { ?>

                                    <a href="{{url('/proforma_approval',$cust->id)}}" class="btn btn-success btn-sm">Approve</a>

                                <?php } ?>
                            </td>
                            @if($cust->status == "1")
                            <td><span class="badge bg-primary">Approved</span></td>
                            @else
                            <td><span class="badge bg-warning">pending</span></td>
                            @endif
                            <td><a href="{{url('/status_update',$cust->id)}}" class="btn btn-primary btn-sm">Download</a></td>
                            <td>
                                <a href="/invoice/{{$cust->invoice_no}}/view"><i class="text-primary btn-icon-prepend" data-feather="eye"></i></a>
                                <a href="/invoice/{{$cust->invoice_no}}/download"><i class="text-primary btn-icon-prepend" data-feather="download"></i></a>
                                <!-- <a href="customer/{{$cust->id}}/edit/"><i class="text-success btn-icon-prepend" data-feather="edit"></i></a> -->
                                <!-- <a href="customer/{{$cust->id}}/delete/"><i class="text-danger btn-icon-prepend" data-feather="trash"></i></a> -->
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<script>
    $(function() {
        $('.toggle-class').change(function() {
            alert("ok");
            var status = $(this).prop('checked') == true ? 1 : 0;
            var user_id = $(this).data('id');

            $.ajax({
                type: "GET",
                dataType: "json",
                url: '/changeStatus',
                data: {
                    'status': status,
                    'user_id': user_id
                },
                success: function(data) {
                    console.log(data.success)
                }
            });
        })
    })
</script>
@endsection