@extends('layouts.master')


@section('content')

<div class="pull-right mt-3 mb-3">
    <a type="button" href="{{ route('hotel.index') }}" class="btn btn-primary btn-icon-text mb-2 mb-md-0">
        <i class="btn-icon-prepend" data-feather="arrow-left-circle"></i>
        Back
    </a>
</div>
@if($errors->any())
<h4>{{$errors->first()}}</h4>
@endif
@include('sweetalert::alert')

<h1>Edit/Update Hotel &nbsp;&nbsp;&nbsp;&nbsp;</h1>


<div class="row mt-3">
    <div class="col-md-12 stretch-card">
        <div class="card card-shadow-apply">
            {!! Form::model($hotel, ['method' => 'PATCH','id'=>'quickForm','enctype'=>'multipart/form-data','route' => ['hotel.update', $hotel->id]]) !!}
            <div class="card-header">
                <label class="form-label float-end">
                    Active
                </label>
                <div class="form-check form-switch mb-5 float-end">
                    <input name="status" type="checkbox" class="form-check-input" id="formSwitch1" {{ $hotel->status == 'Active' ? 'checked' : '' }}>
                </div>
                <label class="form-label float-end">
                    Inactive&nbsp;&nbsp;
                </label>
            </div>
            <div class="card-body">
                <h6 class="card-title" style="font-size:1.2em;font-weight:550;letter-spacing:1px">Update
                    Hotel</h6>

                <div class="row">
                    <h3 class="heading">Basic Details</h3>

                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label class="form-label">Hotel Type
                                <span class="required-field">*</span>

                            </label>
                            <select name="hotel_type" class="js-example-basic-single form-select" data-width="100%">
                                <option Selected>{{$hotel->hotel_type}}</option>
                                <option value="Resort">Resort</option>
                                <option value="Home-Stay">Home-Stay</option>
                                <option value="Rental">Rental</option>
                                <option value="Tent">Tent</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-sm-6">
                        <div class="mb-3">

                            <label class="form-label">Hotel Name
                                <span class="required-field">*</span>
                            </label>
                            <input type="text" name="hotel_name" value="{{$hotel->hotel_name}}" class="form-control">
                        </div>
                    </div><!-- Col -->


                </div><!-- Row -->
                <div class="row">

                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label class="form-label">Address Line 1
                                <span class="required-field">*</span>
                            </label>
                            <input type="text" name="address_line_1" value="{{$hotel->hotel_name}}" class="form-control">

                        </div>
                    </div>
                    <!-- Col -->

                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label class="form-label">Address Line 2
                                <small class="optional-color">(optional)</small>
                            </label>
                            <input type="text" name="address_line_2" value="{{$hotel->address_line_2}}" class="form-control">
                        </div>
                    </div>


                </div><!-- Row -->


                <div class="row">
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label class="form-label">City/Town</label>
                            <input type="text" name="city_town" value="{{$hotel->city_town}}" class="form-control">
                        </div>
                    </div><!-- Col -->
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label class="form-label">State/Province</label>
                            <input type="text" name="state_province" value="{{$hotel->state_province}}" class="form-control">
                        </div>
                    </div><!-- Col -->
                </div>

                <div class="row">

                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label class="form-label">Country
                                <span class="required-field">*</span>

                            </label>
                            <select name="country" class="js-example-basic-single form-select" data-width="100%">
                                <option Selected>{{$hotel->country}}</option>
                                <option value="India">India</option>
                                <option value="Saudi">Saudi</option>
                                <option value="China">China</option>
                                <option value="Abc">Abc</option>
                                <option value="Afghanistan">Afghanistan</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label class="form-label">Pincode
                                <span class="required-field">*</span>
                            </label>
                            <input type="number" name="pincode" value="{{$hotel->pincode}}" class="form-control">
                        </div>
                    </div><!-- Col -->
                </div><!-- Row -->

                <div class="buttons-alignment mt-4">
                    <button type="submit" class="btn btn-success submit-button-alignment">Update</button>
                </div>
                {!! Form::close() !!}
            </div>
        </div>

    </div>
</div>



@if ($message = Session::get('success'))
@include('sweetalert::alert')
@endif

<div class="col-md-12 grid-margin stretch-card mt-5">
    <div class="card">
        <h4 class="p-3" style="font-weight:550;letter-spacing:1px">{{$hotel->hotel_name}} Service List</h4>
        <div class="p-3">
            <button type="button" class="btn btn-success btn-icon-text mb-2 mb-md-0" data-bs-toggle="modal" data-bs-target="#AddService">
                <i class="btn-icon-prepend" data-feather="home"></i>
                Add Hotel Service
            </button>
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table id="dataTableExample" class="table">
                    <thead class="text-center">
                        <tr>
                            <th>No</th>
                            <th>Room Name</th>
                            <th>Occupancy</th>
                            <th>Bed</th>
                            <th>Price</th>
                            <th>Status</th>
                            <th width="280px">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($service as $key => $hs)
                        <tr class="fw-bold fs-5">
                            <td>{{ ++$i }}</td>
                            <td>{{ $hs->room_name_number}}</td>
                            <td>{{ $hs->occupancy}}</td>
                            <td>{{ $hs->bed }}</td>
                            <td>{{ $hs->price }}</td>
                            <td>
                                <?php if ($hs->status == 'Active') { ?>

                                    <a href="{{url('/status-update',$hs->id)}}" class="btn btn-success btn-sm">Active</a>

                                <?php } else { ?>

                                    <a href="{{url('/status-update',$hs->id)}}" class="btn btn-danger btn-sm">Inactive</a>

                                <?php } ?>
                            </td>
                            <td>
                                <button type="button" value="{{$hs->id}}" class=" btn btn-white editbtn"><i class="text-success btn-icon-prepend" data-feather="edit"></i></button>

                                <a href="/hotel_sevice/{{$hs->id}}/delete/"><i class="text-danger btn-icon-prepend" data-feather="trash"></i></a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>






<!-- Add Service Modal -->
<div class="modal" id="AddService">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">

            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Add Hotel Service</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <!-- Modal body -->
            <div class="modal-body">
                <div class="row mt-3">

                    {!! Form::open(array('route' => 'hotel_sevice.store','method'=>'POST','id'=>'quickForm','enctype'=>'multipart/form-data')) !!}
                    <div class="row">
                        <h3 class="heading">Basic Details</h3>
                        <div class="col-sm-6">
                            <div class="mb-3">

                                <label class="form-label">Room Name/Number
                                    <span class="required-field">*</span>
                                </label>
                                <input type="text" name="room_name_number" class="form-control">
                            </div>
                        </div><!-- Col -->

                        <div class="col-sm-6">
                            <div class="mb-3">
                                <label class="form-label">Occupancy
                                    <span class="required-field">*</span>

                                </label>
                                <select name="occupancy" class="js-example-basic-single form-select" data-width="100%">
                                    <option Selected>Select</option>
                                    <option value="Single Room">Single Room</option>
                                    <option value="Double Room">Double Room</option>
                                    <option value="Triple Room">Triple Room</option>
                                    <option value="Family Room">Family Room</option>
                                    <option value="One Bedroom">One Bedroom</option>
                                    <option value="Two Bedroom">Two Bedroom</option>
                                    <option value="Studio">Studio</option>
                                </select>
                            </div>
                        </div>

                        <!-- Col -->
                    </div><!-- Row -->


                    <div class="row">
                        <div class="col-sm-6">
                            <div class="mb-3">
                                <label class="form-label">Meal
                                    <span class="required-field">*</span>
                                </label>
                                <select name="meal" class="js-example-basic-single form-select" data-width="100%">
                                    <option Selected>Select</option>
                                    <option value="Room Only">Room Only</option>
                                    <option value="Bread & Breakfast">Bread & Breakfast</option>
                                    <option value="Half Board">Half Board</option>
                                    <option value="Full Board">Full Board</option>
                                    <option value="All Inclusive">All Inclusive(Breakfast,Lunch,Dinner & Drinks)</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="mb-3">
                                <label class="form-label">Bed
                                    <span class="required-field">*</span>
                                </label>
                                <select name="bed" class="js-example-basic-single form-select" data-width="100%">
                                    <option Selected>Select</option>
                                    <option value="Single">Single</option>
                                    <option value="Queen">Queen</option>
                                    <option value="King">King</option>
                                    <option value="Twin">Twin</option>
                                    <option value="Double">Double</option>
                                    <option value="Triple">Triple</option>
                                    <option value="Family">Family</option>
                                    <option value="Extra Bed">Extra Bed</option>
                                </select>
                            </div>
                        </div>
                    </div>


                    <div class="row">

                        <div class="col-sm-6">
                            <div class="mb-3">
                                <label class="form-label">Currency</label>
                                <select name="currency" class="js-example-basic-single form-select" data-width="100%">
                                    <option Selected>Select</option>
                                    <option value="Dinar">Dinar</option>
                                    <option value="Rupees">Rupees</option>
                                    <option value="Riyal">Riyal</option>
                                    <option value="Albanian Lak">Albanian Lak</option>
                                    <option value="Afghan Afghan">Afghan Afghani</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="mb-3">

                                <label class="form-label">Price
                                    <span class="required-field">*</span>
                                </label>
                                <input type="number" name="price" class="form-control">
                            </div>
                        </div><!-- Col -->
                    </div>



                    <div class="row">
                        <div class="col-sm-12">
                            <div class="mb-3">
                                <label class="form-label">Discription
                                    <small class="optional-color">(optional)</small>
                                </label>
                                <textarea name="discription" class="form-control" id="exampleFormControlTextarea1" rows="3"></textarea>
                            </div>
                        </div><!-- Col -->

                    </div><!-- Row -->

                    <!-- Modal footer -->
                    <div class="modal-footer">
                        <div class="buttons-alignment mt-4">
                            <button type="submit" class="btn btn-primary submit-button-alignment">Submit</button>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Edit Service Modal -->
<div class="modal" id="EditService">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">

            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Edit Hotel Service</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <!-- Modal body -->
            <div class="modal-body">
                <div class="row mt-3">

                    <form action="{{url('hotel_sevice_update')}}" method="POST">
                        @csrf
                        @method('PUT')

                        <input type="hidden" name="service_id" id="service_id" class="form-control">

                        <div class="row">
                            <h3 class="heading">Basic Details</h3>
                            <div class="col-sm-6">
                                <div class="mb-3">

                                    <label class="form-label">Room Name/Number
                                        <span class="required-field">*</span>
                                    </label>
                                    <input type="text" name="room_name_number" id="room_name" class="form-control">
                                </div>
                            </div><!-- Col -->

                            <div class="col-sm-6">
                                <div class="mb-3">
                                    <label class="form-label">Occupancy
                                        <span class="required-field">*</span>

                                    </label>
                                    <select name="occupancy" id="occupancy" class="js-example-basic-single form-select" data-width="100%">
                                        <option Selected>Select</option>
                                        <option value="Single Room">Single Room</option>
                                        <option value="Double Room">Double Room</option>
                                        <option value="Triple Room">Triple Room</option>
                                        <option value="Family Room">Family Room</option>
                                        <option value="One Bedroom">One Bedroom</option>
                                        <option value="Two Bedroom">Two Bedroom</option>
                                        <option value="Studio">Studio</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Col -->
                        </div><!-- Row -->


                        <div class="row">
                            <div class="col-sm-6">
                                <div class="mb-3">
                                    <label class="form-label">Meal
                                        <span class="required-field">*</span>
                                    </label>
                                    <select name="meal" id="meal" class="js-example-basic-single form-select" data-width="100%">
                                        <option Selected>Select</option>
                                        <option value="Room Only">Room Only</option>
                                        <option value="Bread & Breakfast">Bread & Breakfast</option>
                                        <option value="Half Board">Half Board</option>
                                        <option value="Full Board">Full Board</option>
                                        <option value="All Inclusive">All Inclusive(Breakfast,Lunch,Dinner & Drinks)</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="mb-3">
                                    <label class="form-label">Bed
                                        <span class="required-field">*</span>
                                    </label>
                                    <select name="bed" id="bed" class="js-example-basic-single form-select" data-width="100%">
                                        <option Selected>Select</option>
                                        <option value="Single">Single</option>
                                        <option value="Queen">Queen</option>
                                        <option value="King">King</option>
                                        <option value="Twin">Twin</option>
                                        <option value="Double">Double</option>
                                        <option value="Triple">Triple</option>
                                        <option value="Family">Family</option>
                                        <option value="Extra Bed">Extra Bed</option>
                                    </select>
                                </div>
                            </div>
                        </div>


                        <div class="row">

                            <div class="col-sm-6">
                                <div class="mb-3">
                                    <label class="form-label">Currency</label>
                                    <select name="currency" id="currency" class="js-example-basic-single form-select" data-width="100%">
                                        <option Selected>Select</option>
                                        <option value="Dinar">Dinar</option>
                                        <option value="Rupees">Rupees</option>
                                        <option value="Riyal">Riyal</option>
                                        <option value="Albanian Lak">Albanian Lak</option>
                                        <option value="Afghan Afghani">Afghan Afghani</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="mb-3">

                                    <label class="form-label">Price
                                        <span class="required-field">*</span>
                                    </label>
                                    <input type="text" id="price" name="price" class="form-control">
                                </div>
                            </div><!-- Col -->
                        </div>



                        <div class="row">
                            <div class="col-sm-12">
                                <div class="mb-3">
                                    <label class="form-label">Discription
                                        <small class="optional-color">(optional)</small>
                                    </label>
                                    <textarea name="discription" id="discription" class="form-control" id="exampleFormControlTextarea1" rows="3"></textarea>
                                </div>
                            </div><!-- Col -->

                        </div><!-- Row -->

                        <!-- Modal footer -->
                        <div class="modal-footer">
                            <div class="buttons-alignment mt-4">
                                <button type="submit" class="btn btn-success  submit-button-alignment">Update</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Edit Service Modal -->
<div class="modal" id="viewbtn">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">

            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Edit Hotel Service</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <!-- Modal body -->
            <div class="modal-body">
                <div class="row mt-3">

                    <form action="{{url('hotel_sevice_update')}}" method="POST">
                        @csrf
                        @method('PUT')

                        <input type="hidden" name="service_id" id="service_id" class="form-control">

                        <div class="row">
                            <h3 class="heading">Basic Details</h3>
                            <div class="col-sm-6">
                                <div class="mb-3">

                                    <label class="form-label">Room Name/Number
                                        <span class="required-field">*</span>
                                    </label>
                                    <input type="text" name="room_name_number" id="room_name" class="form-control">
                                </div>
                            </div><!-- Col -->

                            <div class="col-sm-6">
                                <div class="mb-3">
                                    <label class="form-label">Occupancy
                                        <span class="required-field">*</span>

                                    </label>
                                    <select name="occupancy" id="occupancy" class="js-example-basic-single form-select" data-width="100%">
                                        <option Selected>Select</option>
                                        <option value="Single Room">Single Room</option>
                                        <option value="Double Room">Double Room</option>
                                        <option value="Triple Room">Triple Room</option>
                                        <option value="Family Room">Family Room</option>
                                        <option value="One Bedroom">One Bedroom</option>
                                        <option value="Two Bedroom">Two Bedroom</option>
                                        <option value="Studio">Studio</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Col -->
                        </div><!-- Row -->


                        <div class="row">
                            <div class="col-sm-6">
                                <div class="mb-3">
                                    <label class="form-label">Meal
                                        <span class="required-field">*</span>
                                    </label>
                                    <select name="meal" id="meal" class="js-example-basic-single form-select" data-width="100%">
                                        <option Selected>Select</option>
                                        <option value="Room Only">Room Only</option>
                                        <option value="Bread & Breakfast">Bread & Breakfast</option>
                                        <option value="Half Board">Half Board</option>
                                        <option value="Full Board">Full Board</option>
                                        <option value="All Inclusive">All Inclusive(Breakfast,Lunch,Dinner & Drinks)</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="mb-3">
                                    <label class="form-label">Bed
                                        <span class="required-field">*</span>
                                    </label>
                                    <select name="bed" id="bed" class="js-example-basic-single form-select" data-width="100%">
                                        <option Selected>Select</option>
                                        <option value="Single">Single</option>
                                        <option value="Queen">Queen</option>
                                        <option value="King">King</option>
                                        <option value="Twin">Twin</option>
                                        <option value="Double">Double</option>
                                        <option value="Triple">Triple</option>
                                        <option value="Family">Family</option>
                                        <option value="Extra Bed">Extra Bed</option>
                                    </select>
                                </div>
                            </div>
                        </div>


                        <div class="row">

                            <div class="col-sm-6">
                                <div class="mb-3">
                                    <label class="form-label">Currency</label>
                                    <select name="currency" id="currency" class="js-example-basic-single form-select" data-width="100%">
                                        <option Selected>Select</option>
                                        <option value="Dinar">Dinar</option>
                                        <option value="Rupees">Rupees</option>
                                        <option value="Riyal">Riyal</option>
                                        <option value="Albanian Lak">Albanian Lak</option>
                                        <option value="Afghan Afghani">Afghan Afghani</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="mb-3">

                                    <label class="form-label">Price
                                        <span class="required-field">*</span>
                                    </label>
                                    <input type="text" id="price" name="price" class="form-control">
                                </div>
                            </div><!-- Col -->
                        </div>



                        <div class="row">
                            <div class="col-sm-12">
                                <div class="mb-3">
                                    <label class="form-label">Discription
                                        <small class="optional-color">(optional)</small>
                                    </label>
                                    <textarea name="discription" id="discription" class="form-control" id="exampleFormControlTextarea1" rows="3"></textarea>
                                </div>
                            </div><!-- Col -->

                        </div><!-- Row -->

                        <!-- Modal footer -->
                        <div class="modal-footer">
                            <div class="buttons-alignment mt-4">
                                <button type="submit" class="btn btn-success  submit-button-alignment">Update</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        $(document).on('click', '.editbtn', function() {
            var service_id = $(this).val();
            //alert(service_id);
            $('#EditService').modal('show');

            $.ajax({
                type: "GET",
                url: "/hotel_sevice/" + service_id + "/edit",
                success: function(response) {
                    //console.log(response.service.room_name_number);
                    $('#room_name').val(response.service.room_name_number);
                    $('#occupancy').val(response.service.occupancy);
                    $('#meal').val(response.service.meal);
                    $('#bed').val(response.service.bed);
                    $('#currency').val(response.service.currency);
                    $('#price').val(response.service.price);
                    $('#discription').val(response.service.discription);
                    $('#service_id').val(service_id);
                }
            });
        });
    });
</script>

@endsection