<?php

namespace App\Exports;
use App\Models\Attendance\Attendance;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class AttendanceList implements FromCollection, WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */
     protected $id;

    public function __construct($date)
    {
        $this->date = $date;
    }
    
    public function collection()
    {
         // Fetch your data and return it as a collection
    return Attendance::select('date', 'employee_id', 'employee_name', 'status', 'login_time', 'checkin_status', 'logout_time', 'checkout_status', 'leavetype', 'reason')
            ->where('date', $this->date)
            ->get();    
        
    }
    
    public function headings(): array
    {
        return [
            'Date',
            'Employee ID',
            'Name',
            'Status',
            'Checkin',
            'Status',
            'Checkout',
            'Status',
            'Leave Type',
            'Reason',
        ];
    }
}
