<?php

namespace App\Http\Controllers\Account;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Account\Account;
use App\Models\Account\AccountFile;
use App\Models\Transaction\Transaction;
use Illuminate\Support\Facades\Redirect;

class AccountController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $parent = Account::select('*')->get();
        //dd($parent);
        $account = Account::all();
        $acc = Account::whereNull('account_id')->get();
        return view('accounts.index', compact('account','parent', 'acc'));
    }

    public function search(Request $request)
    {
        $q = $request->input("q");
        $parent = Account::select('*')->get();
        //dd($parent);
        $account = Account::where('account_name', 'LIKE', '%' . $q . '%')->get();
        $acc = Account::whereNull('account_id')->get();
        return view('accounts.search', compact('account','parent', 'acc'));
    }




function status_update($id) {
    
    function update_status_recursive($account_id, $status) {
    // Update all accounts with the given account_id
    $accounts = Account::where('account_id', $account_id)->get();
    foreach($accounts as $account) {
        $account->status = $status;
        $account->save();

        // Recursively update child accounts
        update_status_recursive($account->id, $status);
    }
}
    
    $account = Account::find($id);
    $acc_id = $account->account_id;
    if($acc_id !=""){
        
        $parent_account = Account::find($acc_id);
        $parent_status = $parent_account->status;
    
    if($parent_status=='Active'){
        $account_p = Account::find($id);
        $account_p->status = $account->status=='Active' ? 'Inactive' : 'Active';
        $account_p->save();
    }
    else{
        session()->flash('success', 'You cant make child account active if its parent account is in inactive state.');
       return Redirect::back()->withErrors(['msg' => 'The Message']);
    }
        
        
        
    }

    
    $account->status = $account->status=='Active' ? 'Inactive' : 'Active';
    $account->save();
        
    $stats = $account->status;
    if($stats=='Active'){
        $status='Active';
    }
    elseif($stats=='Inactive'){
        $status='Inactive';
    }

    // Update status for current account and child accounts
    update_status_recursive($account->id, $status);
        
    session()->flash('success', 'You\'ve Change Status successfully.');
    return Redirect::back()->withErrors(['msg' => 'The Message']);
}



    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($id)
    {
       //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $account = new Account;
        $account->account_type = $request->input("account_type");
        $account->account_name = $request->input("account_name");
        $account->account_code = $request->input("account_code");
        $account->account_no = $request->input("account_no");
        $account->account_id = $request->input("account_id");
        $account->description = $request->input("description");
        $account->save();
        //dd($account);
        session()->flash('success', 'You\'ve Created Account successfully.');
        return redirect()->route('account.index');
    }
    
    public function file_store(Request $request)
    {
                $file = $request->file('account_file');
                $filename = time() . '.' . $file->getClientOriginalExtension();
                $path = public_path('uploads');
                $file->move($path, $filename);
                
                $fileupload=new AccountFile;
                $fileupload->account_id= $request->input("account_id");;
                $fileupload->file= $filename;
                $fileupload->save();
        
        
        session()->flash('success', 'File Uploaded successfully.');
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function show()
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $parent = Account::select('*')->get();
        $account = Account::find($id);
        $files = AccountFile::where('account_id', $id)->get();
        $transactions = Transaction::where('account_id', $id)->get();
        //dd($serv_edit);
        return view('accounts.edit', compact('account','parent','transactions', 'files'));
    }
    
     public function edits($id)
    {
        $parent = Account::select('*')->get();
        $account = Account::find($id);
        return view('accounts.edits', compact('account','parent'));
    }
    

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function update($id, Request $request)
    {
        $account = Account::find($id);
        $account->account_type = $request->input("account_type");
        $account->account_name = $request->input("account_name");
        $account->account_code = $request->input("account_code");
        $account->account_no = $request->input("account_no");
        $account->description = $request->input("description");
        $account->save();
        session()->flash('success', 'You\'ve Updated Account successfully.');
        return Redirect::back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $account = Account::find($id);
        $account->delete();
        session()->flash('success', 'You\'ve Deleted Account successfully.');
        return Redirect::back();
    }
}
