<?php

namespace App\Http\Controllers\Attendance;

use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use App\Exports\AttendanceList;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;

use Excel;

use App\Models\Employee\Employee;
use App\Models\Attendance\Attendance;
use App\Models\Master\Leave;
use App\Models\Master\Shift;


class AttendanceController extends Controller
{
    public function markattendence(Request $request)
    {
        $user = Auth::user();
        $user_role = $user->roles;
        $employee_id = $user->employee_id;
        if ($user_role=='Super Admin') {
          $employee = Employee::orderBy('id', 'DESC')->get();
        }
        elseif ($user_role=='HR') {
          $employee = Employee::where('hr_manager', $employee_id)->get();
        }
        elseif ($user_role=='Reporting Manager') {
          $employee = Employee::where('reporting_manager', $employee_id)->get();
        }
        
        // $employee = Employee::all();
        $leave = Leave::all();
        return view('attendance.list', compact('employee', 'leave'));
    }

    public function export($date)
{
    return Excel::download(new AttendanceList($date), 'attendance.xlsx');
}


    public function attendence($id = null)
    {
        $user = Auth::user();
        $user_role = $user->roles;
        $employee_id = $user->employee_id;
        
    	$date =date('Y-m-d');
    	if($user_role=="Super Admin"){
          $employee = Attendance::where('date', $date)->get();
    	}
    	else{
        $employee = Attendance::where('date', $date)->where('attendance_taker', $employee_id)->get();
    	}
        return view('attendance.index', compact('date', 'employee'));
    }

    public function attendence_other($id)
    {
        $user = Auth::user();
        $user_role = $user->roles;
        $employee_id = $user->employee_id;
        
    	$date =$id;
        if($user_role=="Super Admin"){
          $employee = Attendance::where('date', $date)->get();
    	}
    	else{
        $employee = Attendance::where('date', $date)->where('attendance_taker', $employee_id)->get();
    	}
    	
        return view('attendance.index', compact('date', 'employee'));
    }

    public function report()
    {
    	$user = Auth::user();
        $user_role = $user->roles;
        $employee_id = $user->employee_id;
        if ($user_role=='Super Admin') {
          $udata = Employee::orderBy('id', 'DESC')->get();
        }
        elseif ($user_role=='HR') {
          $udata = Employee::where('hr_manager', $employee_id)->get();
        }
        elseif ($user_role=='Reporting Manager') {
          $udata = Employee::where('reporting_manager', $employee_id)->get();
        }

    	$date =date('Y-m-d');
        $employee = Employee::all();

        return view('attendance.services', compact('date', 'employee'));
    }

    public function viewreport(Request $request)
    {
    	$date =date('Y-m-d');

        $from_date =$request->input("from_date");
        $to_date =$request->input("to_date");
        $employee_id =$request->input("employee_id");

        $employee = Attendance::where('employee_id', $employee_id)
        ->whereBetween('date', [$from_date, $to_date])
        ->get();

        return view('attendance.report', compact('date', 'employee'));
    }

    public function save(Request $request)
    {

        // Validate the request data if needed
        // $validatedData = $request->validate([
        //     'date' => 'required|date',
        //     'employee_id' => 'required|integer',
        //     'login_time' => 'nullable|date_format:H:i:s',
        //     'logout_time' => 'nullable|date_format:H:i:s',
        // ]);
        $user = Auth::user();
        $attendance_taker = $user->employee_id;
        
        $employee_id =$request->input("employee_id");
        $date =$request->input("date");
        $attendance = Attendance::where('date', $date)->where('attendance_taker', $attendance_taker)->count();
        if ($attendance!==0) {
        	session()->flash('success', 'Attendance Already marked for this Date ');
            return Redirect::back()->withErrors(['msg' => 'The Message']);

        }


foreach ($employee_id as $key => $value) {
    $employee_id = $request->input("employee_id")[$key];

    $employee = Employee::where('employee_id', $employee_id)->first();
    $shift_id = $employee->shift_id;
    $shift = Shift::where('id', $shift_id)->first();

    $status = $request->input("status")[$key];
    $checkin = strtotime($request->input("checkin")[$key]);
    $checkout = strtotime($request->input("checkout")[$key]);

    $checkin_status = "";
    $checkout_status = "";
    $checkin_time_difference = "";
    $checkout_time_difference = "";

    if ($status == "Present") {
        $shift_checkin_time = strtotime($shift->checkin_time);
        $shift_checkout_time = strtotime($shift->checkout_time);

        if ($shift_checkin_time == $checkin) {
            $checkin_status = "On Time";
        } else if ($shift_checkin_time < $checkin) {
            $checkin_status = "Delay Checkin";
            $checkin_time_difference = round(($checkin - $shift_checkin_time) / 60);
        } else if ($shift_checkin_time > $checkin) {
            $checkin_status = "Early Checkin";
            $checkin_time_difference = round(($shift_checkin_time - $checkin) / 60);
        }

        if ($shift_checkout_time == $checkout) {
            $checkout_status = "On Time";
        } else if ($shift_checkout_time < $checkout) {
            $checkout_status = "Overtime";
            $checkout_time_difference = round(($checkout - $shift_checkout_time) / 60);
        } else if ($shift_checkout_time > $checkout) {
            $checkout_status = "Early Checkout";
            $checkout_time_difference = round(($shift_checkout_time - $checkout) / 60);
        }
    }

    $Attendance = new Attendance;
    $Attendance->date = $date;
    $Attendance->attendance_taker = $attendance_taker;
    $Attendance->employee_id = $request->input("employee_id")[$key];
    $Attendance->employee_name = $request->input("employee_name")[$key];
    $Attendance->status = $request->input("status")[$key];
    $Attendance->login_time = $request->input("checkin")[$key];
    $Attendance->logout_time = $request->input("checkout")[$key];
    $Attendance->leavetype = $request->input("leavetype")[$key];
    $Attendance->checkin_status = $checkin_status;
    $Attendance->checkout_status = $checkout_status;
    $Attendance->checkin_time_difference = $checkin_time_difference;
    $Attendance->checkout_time_difference = $checkout_time_difference;
    $Attendance->save();
}

        session()->flash('success', 'Attendance Saved successfully.');
        // return Redirect::back()->withErrors(['msg' => 'The Message']);
        return Redirect::route('Attendance');

    }

    public function update(Request $request)
    {

        
        $id =$request->input("id");
        
        $Attendance = Attendance::find($id);
        $Attendance->status = $request->input("status");
        $Attendance->login_time = $request->input("login_time");
        $Attendance->logout_time = $request->input("logout_time");
        $Attendance->leavetype = $request->input("leavetype");
        $Attendance->reason = $request->input("reason");
        $Attendance->save();

        session()->flash('success', 'Attendance Updated successfully.');
        return Redirect::back()->withErrors(['msg' => 'The Message']);

    }

    public function login(Request $request)
    {
        // Validate the request data if needed
        // $validatedData = $request->validate([
        //     'date' => 'required|date',
        //     'employee_id' => 'required|integer',
        //     'login_time' => 'nullable|date_format:H:i:s',
        //     'logout_time' => 'nullable|date_format:H:i:s',
        // ]);

        $Attendance = new Attendance;
        $Attendance->date = date('Y-m-d');
        $Attendance->employee_id = $request->input("employee_id");
        $Attendance->login_time = $request->input("login_time");
        $Attendance->logout_time = $request->input("login_time");
        $Attendance->save();

        session()->flash('success', 'Logged In successfully.');
        return Redirect::back()->withErrors(['msg' => 'The Message']);

    }

    public function logout(Request $request)
    {

        $id = $request->input("employee_id");
        $Attendance = Attendance::where('employee_id', $id)->first();
        $Attendance->logout_time = $request->input("logout_time");
        $Attendance->save();

        session()->flash('success', 'Logged Out successfully.');
        return Redirect::back()->withErrors(['msg' => 'The Message']);

    }




}
