<?php

namespace App\Http\Controllers\Carhire;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Carhire\Carhire;
use Illuminate\Support\Facades\Redirect;

class CarhireController extends Controller
{
    public function index(Request $request)
    {
        $car = Carhire::orderBy('id', 'DESC')->get();
        //dd($hotel);
        return view('car.index', compact('car'));
    }

    function status_update($id)
    {
        return Redirect::back();
        //get product status with the help of product ID
        $car = Carhire::select('status')
            ->where('id', '=', $id)
            ->first();

        //dd($customer);

        //Check user status
        if ($car->status == 'Active') {
            $status = 'Inactive';
        } else {
            $status = 'Active';
        }

        //update product status
        $values = array('status' => $status);
        //dd($values);
        Carhire::where('id', $id)->update($values);

        session()->flash('success', 'You\'ve Change Status successfully.');
        
        return Redirect::back();
    }


    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        $carhire = new Carhire;
        $carhire->type_of_vehicle = $request->input("type_of_vehicle");
        $carhire->select_days = $request->input("select_days");
        $carhire->currency = $request->input("currency");
        $carhire->price = $request->input("price");
        $carhire->description = $request->input("description");
        $carhire->status = $request->input("status")?"Active":"Inactive";
        $carhire->save();
        session()->flash('success', 'You\'ve Added Carhire successfully.');
        
        return Redirect::back();
    }

    public function show()
    {
        //
    }


    public function edit($id)
    {
        $car = Carhire::find($id);
        //dd($emp);
        return response()->json([
            'status' => 200,
            'car' => $car,
        ]);
    }


    public function update(Request $request)
    {
        $id = $request->input('car_id');
        $carhire = Carhire::find($id);
        $carhire->type_of_vehicle = $request->input("type_of_vehicle");
        $carhire->select_days = $request->input("select_days");
        $carhire->currency = $request->input("currency");
        $carhire->price = $request->input("price");
        $carhire->description = $request->input("description");
        $carhire->status = $request->input("status")?"Active":"Inactive";
        
        $carhire->update();
        session()->flash('success', 'You\'ve Updated CarHire successfully.');
        
        return Redirect::back();
    }

    public function destroy($id)
    {
        $carhire = Carhire::find($id);
        $carhire->delete();
        session()->flash('success', 'You\'ve Deleted Carhire successfully.');
        
        return Redirect::back();
    }
}