<?php

namespace App\Http\Controllers\Grn;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Grn\ServiceMaster;
use Illuminate\Support\Facades\Redirect;

class ServiceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        $services = ServiceMaster::all();
        return view('grn.services', compact('services'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $cat = new ServiceMaster;
        $cat->service = $request->input("cat_name");
        $cat->save();
        session()->flash('success', 'You\'ve Added Services successfully.');
        
        return Redirect::back();
    }
    function status_update($id)
    {
        echo "here we are";
        
        //get product status with the help of product ID
        $srvice = Category::select('status')
            ->where('id', '=', $id)
            ->first();

        //dd($customer);

        //Check user status
        if ($srvice->status == 'Active') {
            $status = 'Inactive';
        } else {
            $status = 'Active';
        }

        //update product status
        $values = array('status' => $status);
        //dd($values);
        Category::where('id', $id)->update($values);

        session()->flash('success', 'You\'ve Changed Status successfully.');
        
        return Redirect::back();
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    
     public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $hservice = Category::find($id);
        //dd($emp);
        return response()->json([
            'status' => 200,
            'category' => $hservice,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        //
        $id = $request->input('cat_id');
        $cat = Category::find($id);
        $cat->category_name = $request->input("cat_name");
        $cat->update();
        session()->flash('success', 'You\'ve Updated Category successfully.');
        
        return Redirect::back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $cat = ServiceMaster::find($id);
        $cat->delete();
        session()->flash('success', 'You\'ve Deleted Service successfully.');
        
        return Redirect::back();
    }

}
