<?php

namespace App\Http\Controllers\HotelServices;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HotelService\HotelService;
use App\Models\HotelServices\RoomBed;
use App\Models\HotelServices\RoomMeal;
use App\Models\Hotel\Hotel;
use Illuminate\Support\Facades\Redirect;

class HotelServiceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        
    }

    public function room_bed($id)
    {
        $bed = RoomBed::where('room_id', $id)->get();
        $hotel = HotelService::where('id', $id)->first();
        //dd($hotel);
        return view('hotel.bed', compact('bed', 'hotel'));
    }

    public function room_meal($id)
    {
        $meal = RoomMeal::where('room_id', $id)->get();
        $hotel = HotelService::where('id', $id)->first();
        //dd($hotel);
        return view('hotel.meal', compact('meal', 'hotel'));
    }

    function status_update($id)
    {
        return Redirect::back();
        //get product status with the help of product ID
        $srvice = HotelService::select('status')
            ->where('id', '=', $id)
            ->first();

            //dd($customer);

        //Check user status
        if ($srvice->status == 'Active') {
            $status = 'Inactive';
        } else {
            $status = 'Active';
        }

        //update product status
        $values = array('status' => $status);
        //dd($values);
        HotelService::where('id',$id)->update($values);

        session()->flash('success', 'You\'ve Change Status Successfully');
        
        return Redirect::back()->withErrors(['msg' => 'The Message']);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $hservice = new HotelService;
        $hservice->hotel_id = $request->input("hotel_id");
        $hservice->room_name_number = $request->input("room_name_number");
        $hservice->occupancy = $request->input("occupancy");
        $hservice->meal = $request->input("meal");
        $hservice->bed = $request->input("bed");
        $hservice->currency = $request->input("currency");
        $hservice->price = $request->input("price");
        $hservice->discription = $request->input("discription");
        $hservice->status = $request->input("status")?"Active":"Inactive";
        $hservice->save();
        session()->flash('success', 'You\'ve Added Services Successfully');

        return Redirect::back();
    }

    public function addBed(Request $request)
    {
        $bed = new RoomBed;
        $bed->room_id = $request->input("room_id");
        $bed->bed = $request->input("bed");
        $bed->price = $request->input("price");
        $bed->save();
        session()->flash('success', 'You\'ve Added Services Successfully');

        return Redirect::back();
    }

    public function addMeal(Request $request)
    {
        $meal = new RoomMeal;
        $meal->room_id = $request->input("room_id");
        $meal->meal = $request->input("meal");
        $meal->price = $request->input("price");
        $meal->save();
        session()->flash('success', 'You\'ve Added Services Successfully');

        return Redirect::back();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function show()
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $hservice = HotelService::find($id);
        //dd($emp);
        return response()->json([
            'status' => 200,
            'service' => $hservice,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $id = $request->input('service_id');
        $hservice = HotelService::find($id);
        $hservice->room_name_number = $request->input("room_name_number");
        $hservice->occupancy = $request->input("occupancy");
        $hservice->meal = $request->input("meal");
        $hservice->bed = $request->input("bed");
        $hservice->currency = $request->input("currency");
        $hservice->price = $request->input("price");
        $hservice->discription = $request->input("discription");
        $hservice->status = $request->input("status")?"Active":"Inactive";
        
        $hservice->update();
        session()->flash('success', 'You\'ve Updated  Services Successfully');

        return Redirect::back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $hservice = HotelService::find($id);
        $hservice->delete();
        return Redirect::back();
    }
    public function destroy_room_bed($id)
    {
        $hservice = RoomBed::find($id);
        $hservice->delete();
        session()->flash('success', 'You\'ve Deleted Bed Successfully');

        return Redirect::back();
    }
    public function destroy_room_meal($id)
    {
        $hservice = RoomMeal::find($id);
        $hservice->delete();
        session()->flash('success', 'You\'ve Deleted Meal Successfully');

        return Redirect::back();
    }
}
