<?php

namespace App\Http\Controllers\Itinerary;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\Itinerary\Itinerary;
use Illuminate\Support\Facades\Redirect;


class ItineraryController extends Controller
{
    public function index()
    {
        return Itinerary::all();
    }

    function status_update($id)
    {
        //get product status with the help of product ID
        $Itinerary = Itinerary::select('status')
            ->where('id', '=', $id)
            ->first();

        //dd($customer);

        //Check user status
        if ($Itinerary->status == 'Active') {
            $status = 'Inactive';
        } else {
            $status = 'Active';
        }

        //update product status
        $values = array('status' => $status);
        //dd($values);
        Itinerary::where('id', $id)->update($values);

        session()->flash('success', 'You\'ve Change Status successfully.');
        
        return Redirect::back();
    }



    public function create()
    {
    }

    public function store(Request $request)
    {
        $Itinerary = new Itinerary;
        $Itinerary->tour_package_id = $request->input("tour_package_id");
        $Itinerary->day = $request->input("day");
        $Itinerary->day_plan = $request->input("day_plan");
        $Itinerary->description = $request->input("description");

        $Itinerary->save();
                if ($request->hasFile('photos')) {
    $photos = $request->file('photos');
    $i =0;
    // Loop through each uploaded photo
    foreach ($photos as $photo) {
        $i++;
        $filename = time() . $i . '.' . $photo->getClientOriginalExtension();
        $path = public_path('uploads');
        $photo->move($path, $filename);

        // Assuming you have a table named "itineraries" to store the filenames, use query builder to insert each filename
        DB::table('itinerary_images')->insert([
            'itinerary_id' => $Itinerary->id,
            'image' => $filename,
            // Any other fields you want to set for the itinerary
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }
}


        session()->flash('success', 'You\'ve Added Itinerary successfully.');

        return Redirect::back();
    }

    public function show()
    {
    }


    public function edit($id)
    {
        $Itinerary = Itinerary::find($id);
        //dd($emp);
        return response()->json([
            'status' => 200,
            'itinerary' => $Itinerary,
        ]);
    }


    public function update(Request $request)
    {
        $id = $request->input('itinerary_id');
        $Itinerary = Itinerary::find($id);
        $Itinerary->day = $request->input("day");
        $Itinerary->day_plan = $request->input("day_plan");
        $Itinerary->description = $request->input("description");

        if ($request->file('photo')) {
            $photo = $request->file('photo');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $Itinerary->photo = $filename;
        }
        $Itinerary->update();
        session()->flash('success', 'You\'ve Update Itinerary successfully.');

        return Redirect::back();
    }


    public function destroy($id)
    {
        $Itinerary = Itinerary::find($id);
        $Itinerary->delete();
        session()->flash('success', 'You\'ve Deleted Itinerary Successfully');

        return Redirect::back();
    }
}
