<?php

namespace App\Http\Controllers\Payments;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\View;

use App\Models\Account\Account;
use App\Models\DSR\DSR;
use App\Models\DSR\DsrHotelService;
use App\Models\DSR\DsrTourService;
use App\Models\DSR\DsrFlightService;
use App\Models\DSR\DsrVisaService;
use App\Models\DSR\DsrServicePassenger;
use App\Models\DSR\DsrInsuranceService;
use App\Models\DSR\DsrOtherService;
use App\Models\DSR\CarhireService;
use App\Models\DSR\AssistService;
use App\Models\Passengers\Passengers;
use App\Models\Hotel\Hotel;
use App\Models\Flight\Flight;
use App\Models\Visa\Visa;
use App\Models\Insurance\Insurance;
use App\Models\InsurancePlan\InsurancePlan;
use App\Models\Inventory\Inventory;
use App\Models\HotelService\HotelService;
use App\Models\TourPackage\TourPackage;
use App\Models\HotelServices\RoomBed;
use App\Models\HotelServices\RoomMeal;
use App\Models\Customer\Customer;
use App\Models\Taxmaster\Taxmaster;
use App\Models\Items\Items;
use App\Models\Invoice\Invoice;
use App\Models\Invoice\InvoiceServices;
use App\Models\Proforma\Proforma;
use App\Models\Assist\Assist;
use App\Models\Carhire\Carhire;
use App\Models\Transaction\Transaction;
use App\Models\Proforma\ProformaServices;
use App\Models\Individual\IndividualCustome;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Facades\Redirect;

use App\Models\Payments\PaymentsReceived;
use App\Models\Creditnote\Creditnote;


class PaymentsController extends Controller
{
    public function index(Request $request)
    {
        $dsr = PaymentsReceived::all();
        return view('payment.index', compact('dsr'));
    }

    public function store(Request $request)
    {
          // Get the current maximum order number from the database
        $maxDsrNumber = PaymentsReceived::max('payment_id');
        // Parse the Dsr number to get the numeric part
        $lastDsrNumber = (int) substr($maxDsrNumber, -7);
        // Increment the Dsr number
        $newDsrNumber = $lastDsrNumber + 1;
        // Pad the Dsr number with leading zeros to get the final Dsr number
        $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);
        // Build the final Dsr ID with the series
        $series = 'PayID';
        $dsr_number = $series . '-' . $paddedDsrNumber;

        $invoice_id = $request->input("invoice_id");
        $amount_received = $request->input("amount_received");
        $account_id= $request->input("deposited_to");
        $date= $request->input("payment_date");

        $Payments = new PaymentsReceived;

        if ($request->file('Payments_file')) {
            $photo = $request->file('Payments_file');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $Payments->file = $filename;
        }

        $Payments->payment_id = $dsr_number;
        $Payments->customer_type = $request->input("customer_type");
        $Payments->customer_id = $request->input("customer_id");
        $Payments->customer_name = $request->input("customer_name");
        $Payments->date = $request->input("payment_date");
        $Payments->invoice_id = $request->input("invoice_id");
        $Payments->amount_received = $request->input("amount_received");
        $Payments->bank_charges = $request->input("bank_charges");
        $Payments->reference_no = $request->input("reference_no");
        $Payments->notes = $request->input("customer_note");
        $Payments->payment_mode = $request->input("payment_mode");
        $Payments->deposited_to = $request->input("deposited_to");
        $Payments->save();

        // $values = array('payment_status' => "Paid", 'paid_amount' => $amount_received);
        // //dd($values);
        //  $invoice = Invoice::where('invoice_id',$invoice_id)->update($values);
        // $invoice = Invoice::where('invoice_id',$invoice_id);
        $invoice = Invoice::where('invoice_id',$invoice_id)->first();
        $total= $invoice->total;
        $paid_amount= $invoice->paid_amount;
        
        if($paid_amount == 0){

          if($total == $amount_received){
               $status= 'Paid';
          }
          else if($total > $amount_received){
              $status= 'Unpaid';
          }
        
        }
        else{
            $amount_received= $paid_amount+$amount_received;
            
          if($total == $amount_received){
               $status= 'Paid';
          }
          else if($total > $amount_received){
              $status= 'Unpaid';
          }
            
        }

        
        $invoice = Invoice::where('invoice_id',$invoice_id)->first();
        $invoice->paid_amount =$amount_received;
        $invoice->payment_status =$status;
        $invoice->save();
        
        $maxDsrNumber = Transaction::max('transaction_id');
        $lastDsrNumber = (int) substr($maxDsrNumber, -7);
        $newDsrNumber = $lastDsrNumber + 1;
        $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);
        $series = 'Txn';
        $txn_id = $series . '-' . $paddedDsrNumber;
        
        $amount_received = $request->input("amount_received");
        $account_id= $request->input("deposited_to");
        $date= $request->input("payment_date");

        $account = Account::find($account_id);
        $balance= $account->balance;
        $balance= $balance+$amount_received;
        $account->balance = $balance;
        $account->save();
        

        
        $transaction = new Transaction;
        $transaction->transaction_id =$txn_id;
        $transaction->date = $date;
        $transaction->account_id = $account_id;
        $transaction->transaction_type = 'Invoice Payment';
        $transaction->debit = $amount_received;
        $transaction->save();

        $maxDsrNumber = Transaction::max('transaction_id');
        $lastDsrNumber = (int) substr($maxDsrNumber, -7);
        $newDsrNumber = $lastDsrNumber + 1;
        $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);
        $series = 'Txn';
        $txn_id = $series . '-' . $paddedDsrNumber;
        
        $amount_received = $request->input("amount_received");
        $date= $request->input("payment_date");

        $account = Account::find(80);
        $balance= $account->balance;
        $balance= $balance+$amount_received;
        $account->balance = $balance;
        $account->save();
        
        $transaction = new Transaction;
        $transaction->transaction_id =$txn_id;
        $transaction->date = $date;
        $transaction->account_id = 80;
        $transaction->transaction_type = 'Invoice Payment';
        $transaction->credit = $amount_received;
        $transaction->save();
        

        // Alert::success('Congrats', 'Payment Added Successfully');
        session()->flash('success', 'Payment Received Successfully');        
        return redirect()->route('Paymentreceived');
                

    }

    public function create()
    {
          // Get the current maximum order number from the database
          $maxDsrNumber = Creditnote::max('creditnote_id');

          // Parse the Dsr number to get the numeric part
          $lastDsrNumber = (int) substr($maxDsrNumber, -7);
  
          // Increment the Dsr number
          $newDsrNumber = $lastDsrNumber + 1;
  
          // Pad the Dsr number with leading zeros to get the final Dsr number
          $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);
  
          // Build the final Dsr ID with the series
          $series = 'QTN';
          $id = $series . '-' . $paddedDsrNumber;



        $corporate = Customer::where('approval', '=', 1)->select('*')->get();
        $cdata = Customer::where('approval', '=', 1)->get();
        $individual = IndividualCustome::where('approval', '=', 1)->get();
        $idata = IndividualCustome::where('approval', '=', 1)->get();

        

        $individual = IndividualCustome::where('approval', '=', 1)->select('*')->get();
        $corporate = Customer::where('approval', 1)->get();
        $passengers = Passengers::all();
        $hotels = Hotel::all();
        $tour = TourPackage::all();
        $room = HotelService::all();
        $flight = Flight::all();
        $visa = Visa::all();
        $insurance = Insurance::all();
        $carhire = Carhire::all();
        $assist = Assist::all();
        $insuranceplan = InsurancePlan::all();
        $other = Inventory::all();
        $taxmaster = Taxmaster::all();
        $bed = RoomBed::all();
        $meal = RoomMeal::all();
        $invoice = Invoice::where('payment_status', 'Unpaid')->get();


        $services['hotel'] = InvoiceServices::all();
        $services['flight'] = DsrFlightService::where('dsr_number', $id)->get();
        $services['visa'] = DsrVisaService::where('dsr_number', $id)->get();
        $services['insurance'] = DsrInsuranceService::where('dsr_number', $id)->get();
        $services['other'] = DsrOtherService::where('dsr_number', $id)->get();
        //dd($emp);
        return view('payment.create', compact('id','invoice','cdata','idata','services','corporate','tour','bed','meal','room','taxmaster','individual','passengers','hotels', 'flight', 'visa', 'insurance', 'insuranceplan', 'other', 'carhire', 'assist'));
    }

    public function createx($id)
    {



        $invoice = Invoice::where('invoice_id', $id)->get();

        
        $individual = IndividualCustome::where('approval', '=', 1)->get();
        $corporate = Customer::where('approval', 1)->get();
        $passengers = Passengers::all();
        $hotels = Hotel::all();
        $tour = TourPackage::all();
        $room = HotelService::all();
        $flight = Flight::all();
        $visa = Visa::all();
        $insurance = Insurance::all();
        $carhire = Carhire::all();
        $assist = Assist::all();
        $insuranceplan = InsurancePlan::all();
        $other = Inventory::all();
        $taxmaster = Taxmaster::all();
        $bed = RoomBed::all();
        $meal = RoomMeal::all();
        $account = Account::all();


        
        //dd($emp);
        return view('payment.createx', compact('id','invoice','corporate','account','tour','bed','meal','room','taxmaster','individual','passengers','hotels', 'flight', 'visa', 'insurance', 'insuranceplan', 'other', 'carhire', 'assist'));
    }

}
