<?php

namespace App\Models\Employee;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmployeeBankDetails extends Model
{
    use HasFactory;

    public $table = 'banking_details';

    protected $fillable = [
        'employee_id',
        'bank_name',
        'bank_code',
        'branch_name',
        'swift_code',
        'account_number',
        'currency',
    ];

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }
}
