@extends('includes.master') @section('content')

<div class="main-mobile-header doc-mobile-header">
    <a id="menuLink" href="#" class="menu-link"><i class="ri-menu-line"></i></a>
</div>

<div class="main main-app p-3 p-lg-4">
    <div class="mb-4">
        <ol class="breadcrumb fs-sm mb-1">
            <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
            <li class="breadcrumb-item active" aria-current="page">Add Employee</li>
        </ol>
    </div>

    <div class="">
        <div class="row">
            <div class="col-lg-8">
                <h2 class="main-title">Add Employee</h2>
            </div>
            <div style="text-align: right;" class="col-lg-4 text-right">
                <!--  <button type="button" class="btn btn-primary">Add Employee</button> -->
                <!-- <a href="/form" class="btn btn-primary">Add Employee</a>
 -->
            </div>
        </div>

        <hr class="main-separator" />

        <form action="{{ route('EmployeeStore') }}" method="POST" enctype="multipart/form-data" id="employee">
            @csrf
            <input type="hidden" name="id" value="employee" />

            <div class="card card-shadow-apply">
                <div class="card-body">
                    
    <!--                <div style="background: #fff; border-bottom: none;" class="card-header">-->
    <!--    <label class="form-label float-end">-->
    <!--        Active-->
    <!--    </label>-->
    <!--    <div class="form-check form-switch float-end"><input name="status" type="checkbox" class="form-check-input" id="formSwitch1" ></div>-->
    <!--    <label class="form-label float-end">-->
    <!--        Inactive&nbsp;&nbsp;-->
    <!--    </label>-->
    <!--</div>-->
    
    <!--<br>-->
                    
                    <div class="row">
                        <h3 class="heading">Personal Information</h3>
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    First Name
                                    <span class="required-field">*</span>
                                </label>
                                <input type="text" name="first_name" id="first_name" placeholder="First Name" class="form-control" required />
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Middle Name
                                </label>
                                <input type="text" name="middle_name" id="middle_name" placeholder="Middle Name" class="form-control"  />
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Last Name
                                    <span class="required-field">*</span>
                                </label>
                                <input type="text" name="last_name" id="last_name" placeholder="Last Name" class="form-control" required />
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Date of Birth
                                    <span class="required-field">*</span>
                                </label>
                                <input type="date" name="date_of_birth" id="date_of_birth" class="form-control" required />
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Gender
                                    <span class="required-field">*</span>
                                </label>
                                <select name="gender" id="gender" class="js-example-basic-single form-select select2" data-width="100%" required>
                                    <option value="Select" selected>Select</option>
                                    <option value="Male">Male</option>
                                    <option value="Female">Female</option>
                                    <option value="Others">Others</option>
                                </select>
                            </div>
                        </div>
                        <!-- Col -->
                        
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Marital Status
                                </label>
                                <select name="marital_status" id="marital_status" class="js-example-basic-single form-select select2" data-width="100%">
                                    <option value="" selected>Select</option>
                                    <option value="Single">Single</option>
                                    <option value="Married">Married</option>
                                    <option value="Divorced">Divorced</option>
                                    <option value="Widowed">Widowed</option>
                                </select>
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Nationality
                                </label>
                                <input type="text" name="nationality" id="nationality" placeholder="Nationality" class="form-control" />
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Social Security Number
                                </label>
                                <input type="text" name="social_security_number" id="social_security_number" placeholder="Social Security Number" class="form-control" />
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Profile Photo
                                </label>
                                <input type="file" name="profile_photo" id="profile_photo" placeholder="Profile Photo" class="form-control" />
                            </div>
                        </div>
                        <!-- Col -->
                    </div>
                    <!-- Row -->

        <div style="margin-top: 1rem;" class="add-btn">
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#exampleModal">Add Family</button>
        </div>

          <table  id="tableGrid2" class="table table-hover items-data">
          <!-- <thead >
            <tr>
              <th>Name</th>
              <th>Age</th>
              <th>Gender</th>
              <th>Relation</th>
            </tr>
          </thead>
          <tbody>
            <tr>
                <td>Rohan</td>
                <td>20</td>
                <td>Male</td>
                <td>Son</td>
            </tr>

          </tbody> -->
          
        </table>

                </div>
            </div>

            <div class="card card-shadow-apply mt-3">
                <div class="card-body">
                    <div class="row">
                        <h3 class="heading">Contact Information</h3>
                        
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Phone Number
                                    <span class="required-field">*</span>
                                </label>
                                <select name="phone_cc" id="" class="js-example-basic-single form-select select2" data-width="100%">
                                   <option selected>Select</option>
                                   @foreach($data as $code)
                                   <option value="{{$code['country_name']}} (+{{$code['phone_code']}})">{{$code['country_name']}} (+{{$code['phone_code']}})</option>
                                   @endforeach
                                </select>
                                <input type="text" name="phone_number" id="phone_number" placeholder="Phone Number" class="form-control" required />
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Email
                                    <span class="required-field">*</span>
                                </label>
                                <input type="email" name="email" id="email" placeholder="Email" class="form-control" required />
                            </div>
                        </div>
                        <br>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Emergency Contact Name
                                </label>
                                <input type="text" name="emergency_contact_name" id="emergency_contact_name" placeholder="Emergency Contact Name" class="form-control" />
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Emergency Contact Number
                                </label>
                                <select name="emergency_contact_cc" id="" class="js-example-basic-single form-select select2" data-width="100%">
                                   <option selected>Select</option>
                                   @foreach($data as $code)
                                   <option value="{{$code['country_name']}} (+{{$code['phone_code']}})">{{$code['country_name']}} (+{{$code['phone_code']}})</option>
                                   @endforeach
                                </select>
                                <input type="text" name="emergency_contact_number" id="emergency_contact_number" placeholder="Emergency Contact Number" class="form-control" />
                            </div>
                        </div>
                        <!-- Col -->
                    </div>
                    <!-- Row -->
                </div>
            </div>

             <div class="card card-shadow-apply mt-3">
        <div class="card-body">
            <div class="row">
                <!-- <h3 class="heading">Address</h3> -->
                <h3 class="heading">Address Details</h3>
                <br />
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">
                            Address Line 1
                        </label>
                        <input type="text" name="address_1" id="address_1" placeholder="Address" class="form-control" />
                    </div>
                </div>
                <!-- Col -->
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Address Line 2<small>(optional)</small></label>
                        <input type="text" name="address_2" placeholder="Address" class="form-control" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">
                            City/Town
                        </label>
                        <input type="text" name="city_town" id="city_town" placeholder="City" class="form-control" />
                    </div>
                </div>
                <!-- Col -->
            </div>
            <!-- Row -->
            <div class="row">
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">
                            State/Province
                        </label>
                        <input type="text" name="state_province" id="state_province" placeholder="State" class="form-control" />
                    </div>
                </div>
                <!-- Col -->
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">
                            Country
                        </label>
                        <select id="country" name="country" class="form-select select2">
                            <option value="select">Select</option>
                            <option value="Afghanistan">Afghanistan</option>
                            <option value="Åland Islands">Åland Islands</option>
                            <option value="Albania">Albania</option>
                            <option value="Algeria">Algeria</option>
                            <option value="American Samoa">American Samoa</option>
                            <option value="Andorra">Andorra</option>
                            <option value="Angola">Angola</option>
                            <option value="Anguilla">Anguilla</option>
                            <option value="Antarctica">Antarctica</option>
                            <option value="Antigua and Barbuda">Antigua and Barbuda</option>
                            <option value="Argentina">Argentina</option>
                            <option value="Armenia">Armenia</option>
                            <option value="Aruba">Aruba</option>
                            <option value="Australia">Australia</option>
                            <option value="Austria">Austria</option>
                            <option value="Azerbaijan">Azerbaijan</option>
                            <option value="Bahamas">Bahamas</option>
                            <option value="Bahrain">Bahrain</option>
                            <option value="Bangladesh">Bangladesh</option>
                            <option value="Barbados">Barbados</option>
                            <option value="Belarus">Belarus</option>
                            <option value="Belgium">Belgium</option>
                            <option value="Belize">Belize</option>
                            <option value="Benin">Benin</option>
                            <option value="Bermuda">Bermuda</option>
                            <option value="Bhutan">Bhutan</option>
                            <option value="Bolivia">Bolivia</option>
                            <option value="Bosnia and Herzegovina">Bosnia and Herzegovina</option>
                            <option value="Botswana">Botswana</option>
                            <option value="Bouvet Island">Bouvet Island</option>
                            <option value="Brazil">Brazil</option>
                            <option value="Brunei Darussalam">Brunei Darussalam</option>
                            <option value="Bulgaria">Bulgaria</option>
                            <option value="Burkina Faso">Burkina Faso</option>
                            <option value="Burundi">Burundi</option>
                            <option value="Cambodia">Cambodia</option>
                            <option value="Cameroon">Cameroon</option>
                            <option value="Canada">Canada</option>
                            <option value="Cape Verde">Cape Verde</option>
                            <option value="Cayman Islands">Cayman Islands</option>
                            <option value="Central African Republic">Central African Republic</option>
                            <option value="Chad">Chad</option>
                            <option value="Chile">Chile</option>
                            <option value="China">China</option>
                            <option value="Christmas Island">Christmas Island</option>
                            <option value="Cocos (Keeling) Islands">Cocos (Keeling) Islands</option>
                            <option value="Colombia">Colombia</option>
                            <option value="Comoros">Comoros</option>
                            <option value="Congo">Congo</option>
                            <option value="Cook Islands">Cook Islands</option>
                            <option value="Costa Rica">Costa Rica</option>
                            <option value="Cote D'ivoire">Cote D'ivoire</option>
                            <option value="Croatia">Croatia</option>
                            <option value="Cuba">Cuba</option>
                            <option value="Cyprus">Cyprus</option>
                            <option value="Czech Republic">Czech Republic</option>
                            <option value="Denmark">Denmark</option>
                            <option value="Djibouti">Djibouti</option>
                            <option value="Dominica">Dominica</option>
                            <option value="Dominican Republic">Dominican Republic</option>
                            <option value="Ecuador">Ecuador</option>
                            <option value="Egypt">Egypt</option>
                            <option value="El Salvador">El Salvador</option>
                            <option value="Equatorial Guinea">Equatorial Guinea</option>
                            <option value="Eritrea">Eritrea</option>
                            <option value="Estonia">Estonia</option>
                            <option value="Ethiopia">Ethiopia</option>
                            <option value="Falkland Islands (Malvinas)">Falkland Islands (Malvinas)</option>
                            <option value="Faroe Islands">Faroe Islands</option>
                            <option value="Fiji">Fiji</option>
                            <option value="Finland">Finland</option>
                            <option value="France">France</option>
                            <option value="French Guiana">French Guiana</option>
                            <option value="French Polynesia">French Polynesia</option>
                            <option value="French Southern Territories">French Southern Territories</option>
                            <option value="Gabon">Gabon</option>
                            <option value="Gambia">Gambia</option>
                            <option value="Georgia">Georgia</option>
                            <option value="Germany">Germany</option>
                            <option value="Ghana">Ghana</option>
                            <option value="Gibraltar">Gibraltar</option>
                            <option value="Greece">Greece</option>
                            <option value="Greenland">Greenland</option>
                            <option value="Grenada">Grenada</option>
                            <option value="Guadeloupe">Guadeloupe</option>
                            <option value="Guam">Guam</option>
                            <option value="Guatemala">Guatemala</option>
                            <option value="Guernsey">Guernsey</option>
                            <option value="Guinea">Guinea</option>
                            <option value="Guinea-bissau">Guinea-bissau</option>
                            <option value="Guyana">Guyana</option>
                            <option value="Haiti">Haiti</option>
                            <option value="Heard Island and Mcdonald Islands">Heard Island Mcdonald Islands</option>
                            <option value="Holy See (Vatican City State)">Holy See (Vatican City State)</option>
                            <option value="Honduras">Honduras</option>
                            <option value="Hong Kong">Hong Kong</option>
                            <option value="Hungary">Hungary</option>
                            <option value="Iceland">Iceland</option>
                            <option value="India">India</option>
                            <option value="Indonesia">Indonesia</option>
                            <option value="Iran, Islamic Republic of">Iran, Islamic Republic of</option>
                            <option value="Iraq">Iraq</option>
                            <option value="Ireland">Ireland</option>
                            <option value="Isle of Man">Isle of Man</option>
                            <option value="Israel">Israel</option>
                            <option value="Italy">Italy</option>
                            <option value="Jamaica">Jamaica</option>
                            <option value="Japan">Japan</option>
                            <option value="Jersey">Jersey</option>
                            <option value="Jordan">Jordan</option>
                            <option value="Kazakhstan">Kazakhstan</option>
                            <option value="Kenya">Kenya</option>
                            <option value="Kiribati">Kiribati</option>
                            <option value="Korea, Republic of">Korea, Republic of</option>
                            <option value="Kuwait">Kuwait</option>
                            <option value="Kyrgyzstan">Kyrgyzstan</option>
                            <option value="Latvia">Latvia</option>
                            <option value="Lebanon">Lebanon</option>
                            <option value="Lesotho">Lesotho</option>
                            <option value="Liberia">Liberia</option>
                            <option value="Libyan Arab Jamahiriya">Libyan Arab Jamahiriya</option>
                            <option value="Liechtenstein">Liechtenstein</option>
                            <option value="Lithuania">Lithuania</option>
                            <option value="Luxembourg">Luxembourg</option>
                            <option value="Macao">Macao</option>
                            <option value="Madagascar">Madagascar</option>
                            <option value="Malawi">Malawi</option>
                            <option value="Malaysia">Malaysia</option>
                            <option value="Maldives">Maldives</option>
                            <option value="Mali">Mali</option>
                            <option value="Malta">Malta</option>
                            <option value="Marshall Islands">Marshall Islands</option>
                            <option value="Martinique">Martinique</option>
                            <option value="Mauritania">Mauritania</option>
                            <option value="Mauritius">Mauritius</option>
                            <option value="Mayotte">Mayotte</option>
                            <option value="Mexico">Mexico</option>
                            <option value="Moldova, Republic of">Moldova, Republic of</option>
                            <option value="Monaco">Monaco</option>
                            <option value="Mongolia">Mongolia</option>
                            <option value="Montenegro">Montenegro</option>
                            <option value="Montserrat">Montserrat</option>
                            <option value="Morocco">Morocco</option>
                            <option value="Mozambique">Mozambique</option>
                            <option value="Myanmar">Myanmar</option>
                            <option value="Namibia">Namibia</option>
                            <option value="Nauru">Nauru</option>
                            <option value="Nepal">Nepal</option>
                            <option value="Netherlands">Netherlands</option>
                            <option value="Netherlands Antilles">Netherlands Antilles</option>
                            <option value="New Caledonia">New Caledonia</option>
                            <option value="New Zealand">New Zealand</option>
                            <option value="Nicaragua">Nicaragua</option>
                            <option value="Niger">Niger</option>
                            <option value="Nigeria">Nigeria</option>
                            <option value="Niue">Niue</option>
                            <option value="Norfolk Island">Norfolk Island</option>
                            <option value="Northern Mariana Islands">Northern Mariana Islands</option>
                            <option value="Norway">Norway</option>
                            <option value="Oman">Oman</option>
                            <option value="Pakistan">Pakistan</option>
                            <option value="Palau">Palau</option>
                            <option value="Panama">Panama</option>
                            <option value="Papua New Guinea">Papua New Guinea</option>
                            <option value="Paraguay">Paraguay</option>
                            <option value="Peru">Peru</option>
                            <option value="Philippines">Philippines</option>
                            <option value="Pitcairn">Pitcairn</option>
                            <option value="Poland">Poland</option>
                            <option value="Portugal">Portugal</option>
                            <option value="Puerto Rico">Puerto Rico</option>
                            <option value="Qatar">Qatar</option>
                            <option value="Reunion">Reunion</option>
                            <option value="Romania">Romania</option>
                            <option value="Russian Federation">Russian Federation</option>
                            <option value="Rwanda">Rwanda</option>
                            <option value="Saint Helena">Saint Helena</option>
                            <option value="Saint Kitts and Nevis">Saint Kitts and Nevis</option>
                            <option value="Saint Lucia">Saint Lucia</option>
                            <option value="Saint Pierre and Miquelon">Saint Pierre and Miquelon</option>
                            <option value="Saint Vincent Grenadines">Saint Vincent Grenadines</option>
                            <option value="Samoa">Samoa</option>
                            <option value="San Marino">San Marino</option>
                            <option value="Sao Tome and Principe">Sao Tome and Principe</option>
                            <option value="Saudi Arabia">Saudi Arabia</option>
                            <option value="Senegal">Senegal</option>
                            <option value="Serbia">Serbia</option>
                            <option value="Seychelles">Seychelles</option>
                            <option value="Sierra Leone">Sierra Leone</option>
                            <option value="Singapore">Singapore</option>
                            <option value="Slovakia">Slovakia</option>
                            <option value="Slovenia">Slovenia</option>
                            <option value="Solomon Islands">Solomon Islands</option>
                            <option value="Somalia">Somalia</option>
                            <option value="South Africa">South Africa</option>
                            <option value="Spain">Spain</option>
                            <option value="Sri Lanka">Sri Lanka</option>
                            <option value="Sudan">Sudan</option>
                            <option value="Suriname">Suriname</option>
                            <option value="Svalbard and Jan Mayen">Svalbard and Jan Mayen</option>
                            <option value="Swaziland">Swaziland</option>
                            <option value="Sweden">Sweden</option>
                            <option value="Switzerland">Switzerland</option>
                            <option value="Syrian Arab Republic">Syrian Arab Republic</option>
                            <option value="Taiwan">Taiwan</option>
                            <option value="Tajikistan">Tajikistan</option>
                            <option value="Tanzania, United Republic of">Tanzania, United Republic</option>
                            <option value="Thailand">Thailand</option>
                            <option value="Timor-leste">Timor-leste</option>
                            <option value="Togo">Togo</option>
                            <option value="Tokelau">Tokelau</option>
                            <option value="Tonga">Tonga</option>
                            <option value="Trinidad and Tobago">Trinidad and Tobago</option>
                            <option value="Tunisia">Tunisia</option>
                            <option value="Turkey">Turkey</option>
                            <option value="Turkmenistan">Turkmenistan</option>
                            <option value="Turks and Caicos Islands">Turks and Caicos Islands</option>
                            <option value="Tuvalu">Tuvalu</option>
                            <option value="Uganda">Uganda</option>
                            <option value="Ukraine">Ukraine</option>
                            <option value="United Arab Emirates">United Arab Emirates</option>
                            <option value="United Kingdom">United Kingdom</option>
                            <option value="United States">United States</option>
                            <option value="Uruguay">Uruguay</option>
                            <option value="Uzbekistan">Uzbekistan</option>
                            <option value="Vanuatu">Vanuatu</option>
                            <option value="Venezuela">Venezuela</option>
                            <option value="Viet Nam">Viet Nam</option>
                            <option value="Virgin Islands, British">Virgin Islands, British</option>
                            <option value="Virgin Islands, U.S.">Virgin Islands, U.S.</option>
                            <option value="Wallis and Futuna">Wallis and Futuna</option>
                            <option value="Western Sahara">Western Sahara</option>
                            <option value="Yemen">Yemen</option>
                            <option value="Zambia">Zambia</option>
                            <option value="Zimbabwe">Zimbabwe</option>
                        </select>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">
                            PO Box
                        </label>
                        <input type="text" name="pincode" id="pincode" placeholder="Pincode" class="form-control" />
                    </div>
                </div>
                <!-- Col -->
               <!--  <div class="col-sm-4">
                    <label class="form-label">
                        Address Type
                        <span class="required-field">*</span>
                    </label>
                    <select name="address_type" id="address_type" class="js-example-basic-single form-select select2" data-width="100%">
                        <option value="Select" selected>Select</option>
                        <option value="billing">Billing Address</option>
                        <option value="residential">Residential Address</option>
                        <option value="office">Office Address</option>
                        <option value="shipping">Shipping Address</option>
                    </select>
                </div> -->
            </div>
            <!-- Row -->
        </div>
    </div>

            <div class="card card-shadow-apply mt-3">
                <div class="card-body">
                    <div class="row">
                        <h3 class="heading">Banking Details</h3>
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Bank Name
                                </label>
                                <input type="text" name="bank_name" id="bank_name" placeholder="Bank Name" class="form-control" />
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Bank Code
                                </label>
                                <input type="text" name="bank_code" id="bank_code" placeholder="Bank Code" class="form-control" />
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Branch Name
                                </label>
                                <input type="text" name="branch_name" id="branch_name" placeholder="Branch Name" class="form-control" />
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Swift Code
                                </label>
                                <input type="text" name="swift_code" id="swift_code" placeholder="Swift Code" class="form-control" />
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Account No
                                </label>
                                <input type="text" name="account_number" id="account_number" placeholder="Account No" class="form-control" />
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Currency
                                </label>
                                <select name="currency" id="currency" class="form-select select2" data-width="100%">
                                        <option selected>Select</option>
                                        <option value="EUR">EUR</option>
                                        <option value="USD">USD</option>
                                        <option value="ZWD">ZWD</option>
                                </select>
                            </div>
                        </div>
                        <!-- Col -->
                    </div>
                    <!-- Row -->
                </div>
            </div>

            <div class="card card-shadow-apply mt-3">
                <div class="card-body">
                    <div class="row">
                        <h3 class="heading">Employment Information</h3>
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Employee ID
                                </label>
                                <input type="text" name="employee_id" id="employee_id" placeholder="Employee ID" class="form-control" />
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Employment Type
                                </label>
                                <select name="employment_type" id="employment_type" class="form-select select2" data-width="100%">
                                        <option selected>Select</option>
                                        <option value="Contract">Contract</option>
                                        <option value="Internship">Internship</option>
                                        <option value="Part Time">Part Time</option>
                                        <option value="Full Time">Full Time</option>
                                        
                                </select>
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Designation
                                </label>
                                <select name="job_title" id="job_title" class="form-select select2" data-width="100%">
                                        <option selected>Select</option>
                                        @foreach ($designation as $key => $data)
                                        <option value="{{ $data->designation_title }}">{{ $data->designation_title }}</option>
                                        @endforeach
                                </select>
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Department
                                </label>
                                <select name="department" id="department" class="form-select select2" data-width="100%">
                                        <option selected>Select</option>
                                        @foreach ($department as $key => $data)
                                        <option value="{{ $data->department_title }}">{{ $data->department_title }}</option>
                                        @endforeach
                                </select>
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Location
                                </label>
                                <select name="location" id="location" class="form-select select2" data-width="100%">
                                        <option selected>Select</option>
                                        @foreach ($location as $key => $data)
                                        <option value="{{ $data->location_title }}">{{ $data->location_title }}</option>
                                        @endforeach
                                </select>
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Date of Joining
                                </label>
                                <input type="date" name="date_of_joining" id="date_of_joining" class="form-control" />
                            </div>
                        </div>
                        <!-- Col -->
                        <div style="display:none;" class="col-sm-4 end_date">
                            <div class="mb-3">
                                <label class="form-label">
                                    End Date
                                </label>
                                <input type="date" name="end_date" id="end_date" class="form-control" />
                            </div>
                        </div>
                        <!-- Col -->
                        
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Reporting Manager
                                </label>
                                @if($user->roles=='Super Admin')                                 
                                <select name="reporting_manager" id="reporting_manager" class="form-select select2" data-width="100%">
                                        <option value="" selected>Select</option>
                                        @foreach ($reporting_manager as $key => $data)
                                        <option value="{{ $data->employee_id }}">{{ $data->first_name }}</option>
                                        @endforeach
                                </select>
                                @elseif($user->roles=='HR')
                                <select name="reporting_manager" id="reporting_manager" class="form-select select2" data-width="100%">
                                        <option value="" selected>Select</option>
                                        @foreach ($reporting_manager as $key => $data)
                                        <option value="{{ $data->employee_id }}">{{ $data->first_name }}</option>
                                        @endforeach
                                </select>
                                @elseif($user->roles=='Reporting Manager')
                                <input type="text" name="" id="" placeholder="" class="form-control" value="{{ $user->name }}" disabled />
                                <input type="hidden" name="reporting_manager" id="reporting_manager" placeholder="Employment Type" class="form-control" value="{{ $user->employee_id }}" />
                                @endif
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    HR Manager
                                </label>
                                @if($user->roles=='Super Admin') 
                                <select name="hr_manager" id="hr_manager" class="form-select select2" data-width="100%">
                                        <option value="" selected>Select</option>
                                        @foreach ($hr as $key => $data)
                                        <option value="{{ $data->employee_id }}">{{ $data->first_name }}</option>
                                        @endforeach
                                </select>
                                @elseif($user->roles=='HR')
                                <input type="text" name="" id="" placeholder="" class="form-control" value="{{ $user->name }}" disabled />
                                <input type="hidden" name="hr_manager" id="hr_manager" placeholder="Employment Type" class="form-control" value="{{ $user->employee_id }}" />
                                @elseif($user->roles=='Reporting Manager')                                
                                <select name="hr_manager" id="hr_manager" class="form-select select2" data-width="100%">
                                        <option value="" selected>Select</option>
                                        @foreach ($hr as $key => $data)
                                        <option value="{{ $data->employee_id }}">{{ $data->first_name }}</option>
                                        @endforeach
                                </select>
                                @endif
                                
                            </div>
                        </div>
                        <!-- Col -->
                        
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Shift Name
                                </label>
                                <select name="shift_id" id="shift_id" class="form-select select2" data-width="100%">
                                        <option value="" selected>Select</option>
                                        @foreach ($shift as $key => $data)
                                        <option value="{{ $data->id }}">{{ $data->name }} ({{ $data->checkin_time }} - {{ $data->checkout_time }})</option>
                                        @endforeach
                                </select>
                                
                            </div>
                        </div>
                        <!-- Col -->
                    </div>
                    <!-- Row -->
                </div>
                
                <div style="display:none;" class="card-body contract">
        <div class="row">
            <h3 class="heading">Contract</h3>

            <div class="col-sm-3">
                <div class="mb-3">
                    <label for="DateOfBirth" class="" style="margin-bottom: 8px;">Note </label>
                    <input name="contract" type="text" class="form-control" />
                </div>
            </div>

            <div class="col-sm-3">
                <div class="mb-3">
                    <label for="DateOfBirth" class="" style="margin-bottom: 8px;">Issue Date </label>
                    <input name="contract_issue_date" type="date" class="form-control"  />
                </div>
            </div>
            <div class="col-sm-3">
                <div class="mb-3">
                    <label for="DateOfBirth" class="" style="margin-bottom: 8px;">Expiry Date </label>
                    <input name="contract_expiry_date" type="date" class="form-control"  />
                </div>
            </div>
            <div class="col-sm-3">
                <div style="margin-top: 1.8rem;">
                    <input class="form-control" name="contract_attachment" type="file" id="formFile" />
                </div>
            </div>

            <!-- Col -->
        </div>
        <!-- Row -->
    </div>
                
            </div>

            <div class="card card-shadow-apply mt-3">
                <div class="card-body">
                    <div class="row">
                        <h3 class="heading">Remuneration and Benefits</h3>
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Salary
                                </label>
                                <input type="text" name="salary" id="salary" placeholder="Salary" class="form-control" />
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Pay Frequency
                                </label>
                                <select name="pay_frequency" id="pay_frequency" class="js-example-basic-single form-select select2" data-width="100%">
                                    <option value="" selected>Select</option>
                                    <option value="Weekly">Weekly</option>
                                    <option value="Monthly">Monthly</option>
                                </select>
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
    <div class="mb-3">
        <label class="form-label">Benefits</label>
        <div>
            
            <div class="multi-select">
                <div class="selected-items">
                    <span>Select Benefits</span>
                </div>
                <div class="items-list">
                    <ul>
                        @foreach($benefits as $data)
                        <li>
                            <label><input name="benefits[]" type="checkbox" value="{{$data->benefits}}" />{{$data->benefits}}</label>
                        </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Col -->
                    </div>
                    <!-- Row -->
                </div>
            </div>

            <div class="card card-shadow-apply mt-3">
                <div class="card-body">
                    <div class="row">
                        <h3 class="heading">TAX Details</h3>
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Tax Number
                                </label>
                                <input type="text" name="tax_number" id="tax_number" placeholder="Tax Number" class="form-control" />
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Issue Date
                                </label>
                                <input type="date" name="tax_issue_date" id="tax_issue_date" class="form-control" />
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Expiry Date
                                </label>
                                <input type="date" name="tax_expiry_date" id="tax_expiry_date" class="form-control" />
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Attachment
                                </label>
                                <input type="file" name="tax_attachment" id="tax_attachment" class="form-control" />
                            </div>
                        </div>
                        <!-- Col -->
                    </div>
                    <!-- Row -->
                </div>
            </div>

            <div class="card card-shadow-apply mt-3">
                <div class="card-body">
                    <div class="row">
                        <h3 class="heading">Other Tax Details</h3>
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Other Tax
                                </label>
                                <input type="text" name="other_tax" id="other_tax" placeholder="Other Tax" class="form-control" />
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">
                                    Attachment
                                </label>
                                <input type="file" name="other_tax_attachment" id="other_tax_attachment" class="form-control" />
                            </div>
                        </div>
                        <!-- Col -->
                    </div>
                    <!-- Row -->
                </div>
            </div>
         
               <div class="card card-shadow-apply mt-3">
    <div class="card-body">
        <div class="row">
            <h3 class="heading">Documents</h3>

            <div class="row"></div>

            <div class="col-sm-3">
                <div class="mb-3">
                    <label class="form-label">ID / Passport </label>
                    <input type="text" name="passport_id_number" placeholder="Passport" class="form-control"  />
                </div>
            </div>
            <!-- Col -->
            <div class="col-sm-3">
                <div class="mb-3"><label class="form-label" for="DateOfBirth" class="">Issue Date </label><input name="passport_issue_date" type="date" class="form-control"  /><small style="color: red;"></small></div>
            </div>
            <!-- Col -->
            <div class="col-sm-3">
                <div class="mb-3"><label class="form-label" for="DateOfBirth" class="">Expiry Date </label><input name="passport_expiry_date" type="date" class="form-control"  /><small style="color: red;"></small></div>
            </div>
            <!-- Col -->
            <div class="col-sm-3">
                <div style="margin-top: 1.8rem;">
                    <input class="form-control" name="passport_attachment" type="file" id="formFile" />
                </div>
            </div>

            <!-- Col -->
        </div>
        <!-- Row -->

        <div class="row">
            <div class="col-sm-3">
                <div class="mb-3">
                    <label class="form-label">Government ID </label>
                    <input type="text" name="government_id_number" placeholder="Government ID" class="form-control" />
                </div>
            </div>
            <!-- Col -->
            <div class="col-sm-3">
                <div class="mb-3"><label class="form-label" for="DateOfBirth" class="">Issue Date </label><input name="government_id_issue_date" type="date" class="form-control"  /><small style="color: red;"></small></div>
            </div>
            <!-- Col -->
            <div class="col-sm-3">
                <div class="mb-3"><label class="form-label" for="DateOfBirth" class="">Expiry Date </label><input name="government_id_expiry_date" type="date" class="form-control" /><small style="color: red;"></small></div>
            </div>
            <!-- Col -->

            <div class="col-sm-3">
                <div style="margin-top: 1.8rem;">
                    <input class="form-control" name="government_id_attachment" type="file" id="formFile" />
                </div>
            </div>

            <!-- Col -->
        </div>
        <div class="row">
            <div class="col-sm-3">
                <div class="mb-3">
                    <label class="form-label">Resume <small class="optional-color">(optional)</small> </label>
                    <input class="form-control" name="resume" type="file" id="formFile" />
                </div>
            </div>
            <!-- Col -->

            <div class="col-sm-3">
                <div class="mb-3">
                    <label class="form-label">Appraisal <small class="optional-color">(optional)</small> </label>
                    <input class="form-control" name="appraisal" type="file" id="formFile" />
                </div>
            </div>
            <!-- Col -->

            <div class="col-sm-3">
                <div class="mb-3">
                    <label class="form-label">Other Documents <small class="optional-color">(optional)</small> </label>
                    <input type="text" name="other_documents_name" placeholder="Other" class="form-control"  />
                </div>
            </div>
            <!-- Col -->

            <div class="col-sm-3">
                <div style="margin-top: 1.8rem;">
                    <input class="form-control" name="other_documents_attachment" type="file" id="formFile" />
                </div>
            </div>
        </div>
    </div>

    <div class="card-body">
        <div class="row">
            <h3 class="heading">Driving License</h3>
            <div class="col-sm-3">
                <div class="mb-3">
                    <label class="form-label">Driving License </label>
                    <input type="text" name="driving_license_number" placeholder="Driving Licence" class="form-control"  />
                </div>
            </div>
            <!-- Col -->

            <div class="col-sm-3">
                <div class="mb-3">
                    <label for="DateOfBirth" class="" style="margin-bottom: 8px;">Issue Date </label>
                    <input name="driving_license_issue_date" type="date" class="form-control"  />
                </div>
            </div>
            <div class="col-sm-3">
                <div class="mb-3">
                    <label for="DateOfBirth" class="" style="margin-bottom: 8px;">Expiry Date </label>
                    <input name="driving_license_expiry_date" type="date" class="form-control" />
                </div>
            </div>
            <div class="col-sm-3">
                <div style="margin-top: 1.8rem;">
                    <input class="form-control" name="driving_license_attachment" type="file" id="formFile" />
                </div>
            </div>

            <!-- Col -->
        </div>
        <!-- Row -->
    </div>

    

    <div class="card-body">
        <div class="row">
            <h3 class="heading">Insurance Details</h3>
            <div class="col-sm-3">
                <div class="mb-3">
                    <label class="form-label">Company Name </label>
                    <input type="text" name="insurance_company_name" placeholder="Company Name" class="form-control" />
                </div>
            </div>
            <!-- Col -->
            <div class="col-sm-3">
                <div class="mb-3">
                    <label class="form-label">Policy Number </label>
                    <input type="text" name="insurance_policy_number" placeholder="Policy No" class="form-control"  />
                </div>
            </div>
            <div class="col-sm-3">
                <div class="mb-3">
                    <label for="DateOfBirth" class="" style="margin-bottom: 8px;">Issue Date </label>
                    <input name="insurance_issue_date" type="date" class="form-control" />
                </div>
            </div>
            <div class="col-sm-3">
                <div class="mb-3">
                    <label for="DateOfBirth" class="" style="margin-bottom: 8px;">Expiry Date </label>
                    <input name="insurance_expiry_date" type="date" class="form-control" />
                </div>
            </div>
            <div class="col-sm-3">
                <div style="margin-top: 1.8rem;">
                    <input class="form-control" name="insurance_attachment" type="file" id="formFile" />
                </div>
            </div>

            <!-- Col -->
        </div>
        <!-- Row -->
        <button type="submit" onclick="myFunction()" class="btn btn-primary mt-3" style="margin-left: 90%;">Submit</button>
    </div>
</div>

           <!--  <div class="row">
                <div class="col-sm-12">
                    <div class="text-end mt-4">
                        <button type="submit" class="btn btn-primary">Submit</button>
                        <button type="reset" class="btn btn-outline-primary">Reset</button>
                    </div>
                </div>
            </div> -->

        </form>
   

<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-md" style="padding: 3rem;">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">
                    Add Family Member
                </h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-sm-12">
                        <form action="/set-data" method="POST" enctype="multipart/form-data" id="family-form">
                            @csrf

        
                            <div>
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="mb-3">
                                            <label class="form-label">First Name</label>
                                            <input name="first_name" type="text" class="form-control" />
                                        </div>
                                    </div>
                                    
                                    <div class="col-sm-6">
                                        <div class="mb-3">
                                            <label class="form-label">Middle Name</label>
                                            <input name="middle_name" type="text" class="form-control" />
                                        </div>
                                    </div>
                                    
                                    <div class="col-sm-6">
                                        <div class="mb-3">
                                            <label class="form-label">Last Name</label>
                                            <input name="last_name" type="text" class="form-control" />
                                        </div>
                                    </div>
                                    
                                   
                                    <div class="col-sm-6">
                                        <div class="mb-3">
                                            <label class="form-label">Age</label>
                                            <input name="age" type="text" class="form-control" />
                                            <!-- <select name="priority" class="form-select" data-width="100%">
                                                <option selected>Select</option>
                                                <option value="Low">Low</option>
                                                <option value="Medium">Medium</option>
                                                <option value="High">High</option>
                                            </select> -->
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="mb-3">
                                            <label class="form-label">Gender</label>
                                            <select name="gender" class="form-select" data-width="100%">
                                                <option selected>Select</option>
                                                <option value="Male">Male</option>
                                                <option value="Female">Female</option>
                                                <option value="Other">Other</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-sm-6">
                                        <div class="mb-3">
                                            <label class="form-label">Relation</label>
                                            <select name="relation" class="form-select" data-width="100%">
                                                <option selected>Select</option>
                                                <option value="Father">Father</option>
                                                <option value="Mother">Mother</option>
                                                <option value="Spouse">Spouse</option>
                                                <option value="Son">Son</option>
                                                <option value="Daughter">Daughter</option>
                                            </select>
                                        </div>
                                    </div>
                                     
                                </div>
                                <br />
                                <div class="row" style="margin: 0px 0px;">
                                    <div class="col-sm-7"></div>
                                    <div class="col-sm-5">
                                        <div class="row justify-content-end">
                                            <button type="submit" value="submit" class="btn btn-primary mr-2" style="width: 100px;">Submit</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <br />
            </div>
        </div>
    </div>
</div>


<br />
<br />
<br />

<!-- container -->

<style>
    tbody tr:hover {
        background-color: #f5f5f5;
    }
    .card-example > .card-body::before {
        content: "";
    }
</style>
<script type="text/javascript">
    function checkforuniquemail(emailinp) {
        var va = emailinp.value;

        $.ajax({
            type: "GET",
            url: '{{url("validate/mailunique")}}',
            data: {
                email: va,
                from: "create",
            },
            success: function (data) {
                console.log(data);
                if (data == "false") {
                    $("#email_unique_error").show();
                } else {
                    $("#email_unique_error").hide();
                }
                // $("#sampletablespace").html(data);
                // $(".tablefirst").hide();
            },
        });
    }

    $(".select2").select2();
</script>

<script>
    $(document).ready(function () {
        
         $('#employment_type').change(function() {
    const data = $(this).val();
    // do something with attributeValue
    if(data== "Contract"){
        $('.contract').show();
        $('.end_date').hide();
    }
    else if(data== "Internship"){
        $('.end_date').show();
        $('.contract').hide();
    }
    else if(data== "Part Time"){
        $('.end_date').show();
        $('.contract').hide();
    }
    else if(data== "Full Time"){
        $('.contract').hide();
        $('.end_date').hide();
    }
   
  });

        $('#family-form').on('submit', function (event) {
        event.preventDefault();
        
        $.ajax({
            url: "{{ route('setData') }}",
            method: 'POST',
            data: $(this).serialize(),
            success: function (response) {
                if (response.success) {
                    $('#family-form')[0].reset();
                    // Update table with new data
                    $.ajax({
                        url: "{{ route('getData') }}",
                        method: 'GET',
                        success: function (data) {
                            console.log(data)
                            $('.items-data').html(data);
                           $('#exampleModal').modal('hide');
                            
                        }
                    });
                }
            }
        });
    });

        $("#employee").validate({
            rules: {
                first_name: {
                    required: true,
                    maxlength: 20,
                },
                email: {
                    required: true,
                    maxlength: 100,
                },

                gender: {
                    required: true,
                    maxlength: 20,
                },
                mobile_number: {
                    required: true,
                    maxlength: 20,
                },

                address_type: {
                    required: true,
                    maxlength: 20,
                },
            },

            messages: {
                first_name: {
                    required: "Employee Name is required",
                    maxlength: "Employee Name cannot be more than 20 characters",
                },

                email: {
                    required: "Email is required",
                    maxlength: "Email cannot be more than 50 characters",
                },

                gender: {
                    required: "Gender is required",
                    maxlength: "Gender cannot be more than 20 characters",
                },

                mobile_number: {
                    required: "Mobile No is required",
                    maxlength: "Mobile No cannot be more than 20 characters",
                },

                address_type: {
                    required: "Address is required",
                    maxlength: "Address cannot be more than 20 characters",
                },
            },
        });
    });
</script>


<!-- jQuery code -->
<script>
    $(document).ready(function () {
        // hide the items list by default
        $(".multi-select .items-list").hide();

        // toggle the items list when clicking on the selected items div
        $(".multi-select .selected-items").on("click", function () {
            $(".multi-select .items-list").toggle();
        });

        // update the selected items when a checkbox is clicked
        $(".multi-select .items-list input[type=checkbox]").on("change", function () {
            var selectedItems = [];
            $(".multi-select .items-list input[type=checkbox]:checked").each(function () {
                selectedItems.push($(this).parent().text().trim());
            });

            if (selectedItems.length == 0) {
                $(".multi-select .selected-items span").html("Select Items");
            } else if (selectedItems.length == 1) {
                $(".multi-select .selected-items span").html(selectedItems[0]);
            } else {
                $(".multi-select .selected-items span").html(selectedItems.length + " Items Selected");
            }
        });
    });
</script>

<!-- CSS code -->
<style>
    .multi-select {
        position: relative;
        width: 200px;
    }

    .multi-select .selected-items {
        background-color: #eee;
        border: 1px solid #ccc;
        cursor: pointer;
        padding: 5px;
    }

    .multi-select .items-list {
        background-color: #fff;
        border: 1px solid #ccc;
        border-top: none;
        max-height: 150px;
        overflow-y: auto;
        position: absolute;
        top: 100%;
        left: 0;
        right: 0;
        z-index: 1;
    }

    .multi-select .items-list ul {
        list-style: none;
        margin: 0;
        padding: 5px;
    }

    .multi-select .items-list li {
        margin-bottom: 5px;
    }

    .multi-select .items-list label {
        display: block;
        padding: 5px;
    }

    .multi-select .items-list input[type="checkbox"] {
        margin-right: 5px;
    }
</style>


@endsection
