@extends('includes.master')

@section('content')

<div class="row">
  <div class="col-lg-12 margin-tb">
    <div class="pull-left">
      <h2>Employee List</h2>
    </div>
    <br>
    <div class="mt-5 mb-3">
      <a type="button" href="{{ route('employee.create') }}" class="btn btn-success btn-icon-text mb-2 mb-md-0">
        <i class="btn-icon-prepend" data-feather="user"></i>
        Create Employee
      </a>
    </div>
  </div>
</div>

@if ($message = Session::get('success'))
@include('sweetalert::alert')
@endif


<div class="col-md-12 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <div class="table-responsive">
        <table id="dataTableExample" class="table">
          <thead class="text-center">
            <tr>
              <th>No</th>
              <th>Name</th>
              <th>Email</th>
              <th>Gender</th>
              <!-- <th>mobile_number</th> -->
              <th>Designation</th>
              <th>Status</th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody>
            @foreach ($udata as $key => $emp)
            <tr class="fw-bold fs-5">
              <td>{{ ++$i }}</td>
              <td>{{ $emp->name }}</td>
              <td>{{ $emp->email }}</td>
              <td>{{ $emp->gender }}</td>
              <!-- <td>{{ $emp->mobile_number }}</td> -->
              <td>{{ $emp->designation}}</td>
              @if($emp->status == "Active")
              <td><span class="badge bg-success">Active</span></td>
              @else
              <td><span class="badge bg-danger">Inactive</span></td>
              @endif
              <td>
                <a href="employee/{{$emp->id}}/view/"><i class="text-primary btn-icon-prepend" data-feather="eye"></i></a>
                <a href="employee/{{$emp->id}}/edit/"><i class="text-success btn-icon-prepend" data-feather="edit"></i></a>
              </td>
            </tr>
            @endforeach

          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
@endsection