
@extends('includes.master')

@section('content')

<div class="main-mobile-header doc-mobile-header">
      <a id="menuLink" href="#" class="menu-link"><i class="ri-menu-line"></i></a>
    </div>

   

    



     <div class="main main-app p-3 p-lg-4">
     	
        <div class="mb-4">
          <ol class="breadcrumb fs-sm mb-1">
            <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
            <li class="breadcrumb-item active" aria-current="page">View Supplier</li>
          </ol>
        </div>


      


      <div class="">
        
        <div class="row">

          <div class="col-lg-8">
            <h2 class="main-title">View Supplier</h2>
            
          </div>
          <div style="text-align: right;" class="col-lg-4 text-right">

          </div>

        </div>

        <hr class="main-separator">        
    
        
        <div class="card card-shadow-apply">
    
    <form method="POST" action="{{ route('supplier.update', $sup->id) }}">
        @csrf @method('PUT')
        <input type="hidden" name="id" value="{{ $sup->id }}" />

    <div style="background: #fff; border-bottom: none;" class="card-header">
        <label class="form-label float-end">
            Active
        </label>
        <div class="form-check form-switch mb-5 float-end"><input name="status" type="checkbox" class="form-check-input" id="formSwitch1" {{ $sup->status == 'Active' ? 'checked' : '' }}></div>
        <label class="form-label float-end">
            Inactive&nbsp;&nbsp;
        </label>
    </div>
    <div class="card-body">
        <h6 class="card-title">Supplier Basic Details</h6>
        <br>
        <div class="row">
            <h3 class="heading">Basic Details</h3>
            <div class="col-sm-4">
                <div class="mb-3">
                    <label class="form-label">
                        Company Name
                        <span class="required-field">*</span>
                    </label>
                    <input type="text" name="company_name" value="{{$sup->company_name}}" class="form-control" disabled/>
                </div>
            </div>
            <!-- Col -->
            <div class="col-sm-4">
                <div class="mb-3">
                    <label class="form-label">Alias Name<small>(optional)</small></label>
                    <input type="text" name="alias_name" value="{{$sup->alias_name}}" class="form-control" disabled/>
                </div>
            </div>
            <div class="col-sm-4">
                <div class="mb-3">
                    <label class="form-label">
                        Email
                        <span class="required-field">*</span>
                    </label>
                    <input type="email" name="email" value="{{$sup->email}}" class="form-control" disabled/>
                </div>
            </div>
            <!-- Col -->
        </div>
        <!-- Row -->
        <div class="row">
            <div class="col-sm-4">
                <div class="mb-3">
                    <label class="form-label">
                        Phone
                        <span class="required-field">*</span>
                    </label>
                    <input type="tel" name="phone" value="{{$sup->phone}}" class="form-control" disabled/>
                </div>
            </div>
            <!-- Col -->
            <div class="col-sm-4">
                <div class="mb-3">
                    <label class="form-label">
                        Mobile
                        <span class="required-field">*</span>
                    </label>
                    <input type="tel" name="mobile" value="{{$sup->mobile}}" class="form-control" disabled/>
                </div>
            </div>
            <!-- Col -->
            <div class="col-sm-4">
                <div class="mb-3">
                    <label class="form-label">Website</label>
                    <input type="text" name="website" value="{{$sup->website}}" class="form-control" disabled/>
                </div>
            </div>
            <!-- Col -->
        </div>
        <!-- Row -->
        <div class="row">
            <div class="col-sm-4">
                <div class="mb-3">
                    <label class="form-label">
                        Registration Type
                        <span class="required-field">*</span>
                    </label>
                    <select name="registration_type" class="js-example-basic-single form-select" data-width="100%" disabled>
                        <option selected>{{$sup->registration_type}}</option>
                        <option value="DI">Registered</option>
                        <option value="RS">Un-Registered</option>
                        <option value="RI">Overseas</option>
                        <option value="AL">Special Economic Zone</option>
                        <option value="AF">Deemed Export</option>
                    </select>
                </div>
            </div>
            <div class="col-sm-4">
                <div class="mb-3">
                    <label class="form-label">Registration Number<span class="required-field">*</span> </label>
                    <input type="text" name="registration_number" value="{{$sup->registration_number}}" class="form-control" disabled/>
                </div>
            </div>
            <!-- Col -->
        </div>
        <!-- Row -->
    </div>
</div>

<!----------------------- Billing in customer form start------------------------ -->
<div class="col-md-12 stretch-card mt-3">
    <div class="card card-shadow-apply">
        <div class="card-body">
            <div class="row">
                <h3 class="heading">Billing Address</h3>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">
                            Address Line 1
                            <span class="required-field">*</span>
                        </label>
                        <input type="text" name="billing_address_line_1" value="{{$sup->billing_address_line_1}}" class="form-control" disabled />
                    </div>
                </div>
                <!-- Col -->
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Address Line 2<small>(optional)</small></label>
                        <input type="text" name="billing_address_line_2" value="{{$sup->billing_address_line_2}}" class="form-control" disabled />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">
                            City/Town
                            <span class="required-field">*</span>
                        </label>
                        <input type="text" name="billing_city_town" value="{{$sup->billing_city_town}}" class="form-control" disabled />
                    </div>
                </div>
                <!-- Col -->
            </div>
            <!-- Row -->
            <div class="row">
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">
                            State/Province
                            <span class="required-field">*</span>
                        </label>
                        <input type="text" name="billing_state_province" value="{{$sup->billing_state_province}}" class="form-control" disabled />
                    </div>
                </div>
                <!-- Col -->
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">
                            Country
                            <span class="required-field">*</span>
                        </label>
                        <select name="billing_country" class="js-example-basic-single form-select" data-width="100%" disabled>
                            <option selected>{{$sup->billing_country}}</option>
                            <option value="India">India</option>
                            <option value="Saudi">Saudi</option>
                            <option value="China">China</option>
                            <option value="Afghanistan">Afghanistan</option>
                        </select>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">
                            Pincode
                            <span class="required-field">*</span>
                        </label>
                        <input type="text" name="billing_pincode" value="{{$sup->billing_country}}" class="form-control" disabled />
                    </div>
                </div>
                <!-- Col -->
            </div>
            <!-- Row -->
        </div>
    </div>
</div>
<!----------------------- Billing in customer form end------------------------ -->

<!-----------------------  payment details in customer form start------------------------ -->
<div class="col-md-12 stretch-card mt-3">
    <div class="card card-shadow-apply">
        <div class="card-body">
            <div class="row">
                <h3 class="heading">Payment Details</h3>
                <div class="col-sm-3">
                    <div class="mb-3">
                        <label class="form-label">Preferred Payment Method </label>
                        <input type="text" name="payment_method" value="{{$sup->payment_method}}" class="form-control" disabled/>
                    </div>
                </div>
                <!-- Col -->
                <div class="col-sm-3">
                    <div class="mb-3">
                        <label class="form-label">Terms</label>
                        <select name="terms" class="js-example-basic-single form-select" data-width="100%" disabled>
                            <option selected>{{$sup->payment_method}}</option>
                            <option value="DI">Net 5</option>
                            <option value="RS">Net 15</option>
                            <option value="RI">Net 30</option>
                            <option value="AL">Net 40</option>
                        </select>
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="mb-3">
                        <label class="form-label">Credit Limit </label>
                        <input type="text" name="credit_limit" value="{{$sup->credit_limit}}" class="form-control" disabled/>
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="mb-3">
                        <label class="form-label">Currency</label>
                        <select name="payment_currency" class="js-example-basic-single form-select" data-width="100%" disabled>
                            <option selected>{{$sup->payment_currency}}</option>
                            <option value="DI">Dinar</option>
                            <option value="RS">Rupees</option>
                            <option value="RI">Riyal</option>
                            <option value="AL">Albanian Lak</option>
                            <option value="AF">Afghan Afghani</option>
                        </select>
                    </div>
                </div>
                <!-- Col -->
            </div>
            <!-- Row -->
        </div>
    </div>
</div>
<!----------------------- payment details in customer form end------------------------ -->

<!----------------------- bank details in customer form start------------------------ -->

<div class="col-md-12 stretch-card mt-3">
    <div class="card card-shadow-apply">
        <div class="card-body">
            <h3 class="heading">Bank Details</h3>
            <div class="row">
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Bank Name</label>
                        <input type="text" name="bank_name" value="{{$sup->bank_name}}" class="form-control" disabled/>
                    </div>
                </div>
                <!-- Col -->
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Account Number</label>
                        <input type="text" name="account_number" value="{{$sup->account_number}}" class="form-control" disabled/>
                    </div>
                </div>
                <!-- Col -->
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Bank Code</label>
                        <input type="text" name="bank_code" value="{{$sup->bank_code}}" class="form-control" disabled/>
                    </div>
                </div>
                <!-- Col -->
            </div>
            <!-- Row -->

            <div class="row">
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Swift Code</label>
                        <input type="text" name="swift_code" value="{{$sup->swift_code}}" class="form-control" disabled/>
                    </div>
                </div>
                <!-- Col -->

                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Currency</label>
                        <select name="currency" class="js-example-basic-single form-select" data-width="100%" disabled>
                            <option selected>{{$sup->currency}}</option>
                            <option value="DI">Dinar</option>
                            <option value="RS">Rupees</option>
                            <option value="RI">Riyal</option>
                            <option value="AL">Albanian Lak</option>
                            <option value="AF">Afghan Afghani</option>
                        </select>
                    </div>
                </div>

                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Iban Number</label>
                        <input type="value" name="iban_number" value="{{$sup->iban_number}}" class="form-control" disabled/>
                    </div>
                </div>
                <!-- Col -->
            </div>
            <!-- Row -->
        </div>
    </div>
</div>

<!----------------------- bank details in customer form end------------------------ -->

<!----------------------- tax details in customer form start------------------------ -->

<div class="col-md-12 stretch-card mt-3">
    <div class="card card-shadow-apply">
        <div class="card-body">
            <div class="row">
                <h3 class="heading">Tax Details</h3>
                <div class="col-sm-3">
                    <div class="mb-3">
                        <label class="form-label">Tax/Pan/Kra </label>
                        <input type="text" name="tax_pan_kra_number" value="{{$sup->tax_pan_kra_number}}" class="form-control" disabled />
                    </div>
                </div>
                <!-- Col -->
                <div class="col-sm-3">
                    <div class="mb-3">
                        <label class="form-label" for="DateOfBirth" class="">Issue Date </label><label class="" style="color: red;">*</label><input name="tax_issue_date" type="date" class="form-control" disabled value="{{$sup->tax_issue_date}}" />
                        <small style="color: red;"></small>
                    </div>
                </div>
                <!-- Col -->
                <div class="col-sm-3">
                    <div class="mb-3">
                        <label class="form-label" for="DateOfBirth" class="">Expiry Date </label><label class="" style="color: red;">*</label>
                        <input name="tax_expiry_date" type="date" class="form-control" disabled value="{{$sup->tax_expiry_date}}" /><small style="color: red;"></small>
                    </div>
                </div>
                <!-- Col -->

                <div class="col-sm-3">
                    <div class="mb-3">
                        @if($sup->tax_kra_file)
                        <label style="margin-top: 0rem;" class="form-label" for="DateOfBirth"><a href="/uploads/{{$sup->tax_kra_file}}" target="_new">{{$sup->tax_kra_file}}</a></label>
                        <input class="form-control" disabled name="tax_kra_file" value="{{$sup->tax_kra_file}}" type="file" id="formFile" />
                        @else
                        <label style="margin-top: 1rem;" class="form-label" for="DateOfBirth"><a href="/uploads/{{$sup->tax_kra_file}}" target="_new">{{$sup->tax_kra_file}}</a></label>
                        <input class="form-control" disabled name="tax_kra_file" value="{{$sup->tax_kra_file}}" type="file" id="formFile" />
                        @endif
                        
                    </div>
                </div>

                <!-- Col -->
            </div>
            <!-- Row -->

            <div class="row">
                <div class="col-sm-3">
                    <div class="mb-3">
                        <label class="form-label">Tax Registration </label>
                        <input type="text" name="tax_registration_number" value="{{$sup->tax_registration_number}}" class="form-control" disabled />
                    </div>
                </div>
                <!-- Col -->
                <div class="col-sm-3">
                    <div class="mb-3">
                        <label class="form-label" for="DateOfBirth" class="">Issue Date </label><label class="" style="color: red;">*</label>
                        <input name="registration_issue_date" type="date" class="form-control" disabled value="{{$sup->registration_issue_date}}" /><small style="color: red;"></small>
                    </div>
                </div>
                <!-- Col -->
                <div class="col-sm-3">
                    <div class="mb-3">
                        <label class="form-label" for="DateOfBirth" class="">Expiry Date </label><label class="" style="color: red;">*</label>
                        <input name="registration_expiry_date" type="date" class="form-control" disabled value="{{$sup->registration_expiry_date}}" /><small style="color: red;"></small>
                    </div>
                </div>
                <!-- Col -->

                <div class="col-sm-3">
                    <div class="mb-3">
                        @if($sup->registration_file)
                        <label style="margin-top: 0rem;" class="form-label" for="DateOfBirth"><a href="/uploads/{{$sup->registration_file}}" target="_new">{{$sup->registration_file}}</a></label>
                        <input class="form-control" disabled name="registration_file" value="{{$sup->registration_file}}" type="file" id="formFile" />
                        @else
                        <label style="margin-top: 1rem;" class="form-label" for="DateOfBirth"><a href="/uploads/{{$sup->registration_file}}" target="_new">{{$sup->registration_file}}</a></label>
                        <input class="form-control" disabled name="registration_file" value="{{$sup->registration_file}}" type="file" id="formFile" />
                        @endif
                        
                    </div>
                </div>

                <!-- Col -->
            </div>
            <div class="row">
                <div class="col-sm-3">
                    <div class="mb-3">
                        <label class="form-label">Other Documents <span class="required-field">*</span></label>
                        <input type="text" name="other_doc_number" value="{{$sup->other_doc_number}}" class="form-control" disabled />
                    </div>
                </div>
                <!-- Col -->

                <div class="col-sm-3">
                    <div class="mb-3">
                        @if($sup->other_doc_file)
                        <label style="margin-top: 0rem;" class="form-label" for="DateOfBirth"><a href="/uploads/{{$sup->other_doc_file}}" target="_new">{{$sup->other_doc_file}}</a></label>
                        <input class="form-control" disabled name="other_doc_file" value="{{$sup->other_doc_file}}" type="file" id="formFile" />
                        @else
                        <label style="margin-top: 1rem;" class="form-label" for="DateOfBirth"><a href="/uploads/{{$sup->other_doc_file}}" target="_new">{{$sup->other_doc_file}}</a></label>
                        <input class="form-control" disabled name="other_doc_file" value="{{$sup->other_doc_file}}" type="file" id="formFile" />
                        @endif
                    </div>
                </div>
                <!-- Col -->
            </div>
        </div>
    </div>
</div>

<div class="col-md-12 stretch-card mt-3">
    <div class="card card-shadow-apply">
        <div class="card-body">
            <h3 class="heading">Notes</h3>
            <div class="row">
                <div class="col-sm-12">
                    <div class="mb-3">
                        <label class="form-label">
                            Notes
                            <small class="optional-color">(optional)</small>
                        </label>
                        <textarea class="form-control" name="notes" id="exampleFormControlTextarea1" rows="3" disabled>{{$sup->notes}}</textarea>
                    </div>
                </div>
                <!-- Col -->
            </div>
            <!-- Row -->
        </div>
    </div>
</div>

<div class="buttons-alignment mt-4">
    <div>
    </div>
</div>
</form>


        <br><br><br>

        

      </div><!-- container -->

     
    <style>
    tbody tr:hover {background-color: #F5F5F5;}
    .card-example>.card-body::before {
    content: ""
    }
    </style>
@endsection 
