@extends('layouts.master')


@section('content')

<div class="pull-right mt-3 mb-3">
    <a type="button" href="{{ route('hotel.index') }}" class="btn btn-primary btn-icon-text mb-2 mb-md-0">
        <i class="btn-icon-prepend" data-feather="arrow-left-circle"></i>
        Back
    </a>
</div>
@if($errors->any())
<h4>{{$errors->first()}}</h4>
@endif
@include('sweetalert::alert')

<h1>Create Hotel &nbsp;&nbsp;&nbsp;&nbsp;</h1>


<div class="row mt-3">
    <div class="col-md-12 stretch-card">
        <div class="card card-shadow-apply">
            <div class="card-body">
                <h6 class="card-title" style="font-size:1.2em;font-weight:550;letter-spacing:1px">ADD
                    Hotel</h6>
                {!! Form::open(array('route' => 'hotel.store','method'=>'POST','id'=>'quickForm','enctype'=>'multipart/form-data')) !!}
                <div class="row">
                    <h3 class="heading">Basic Details</h3>

                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label class="form-label">Hotel Type
                                <span class="required-field">*</span>

                            </label>
                            <select name="hotel_type" class="js-example-basic-single form-select" data-width="100%">
                                <option Selected>Select</option>
                                <option value="Resort">Resort</option>
                                <option value="Home-Stay">Home-Stay</option>
                                <option value="Rental">Rental</option>
                                <option value="Tent">Tent</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-sm-6">
                        <div class="mb-3">

                            <label class="form-label">Hotel Name
                                <span class="required-field">*</span>
                            </label>
                            <input type="text" name="hotel_name" class="form-control">
                        </div>
                    </div><!-- Col -->


                </div><!-- Row -->
                <div class="row">

                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label class="form-label">Address Line 1
                                <span class="required-field">*</span>
                            </label>
                            <input type="text" name="address_line_1" class="form-control">

                        </div>
                    </div>
                    <!-- Col -->

                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label class="form-label">Address Line 2
                                <small class="optional-color">(optional)</small>
                            </label>
                            <input type="text" name="address_line_2" class="form-control">
                        </div>
                    </div>


                </div><!-- Row -->


                <div class="row">
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label class="form-label">City/Town</label>
                            <input type="text" name="city_town" class="form-control">
                        </div>
                    </div><!-- Col -->
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label class="form-label">State/Province</label>
                            <input type="text" name="state_province" class="form-control">
                        </div>
                    </div><!-- Col -->
                </div>

                <div class="row">

                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label class="form-label">Country
                                <span class="required-field">*</span>

                            </label>
                            <select name="country" class="js-example-basic-single form-select" data-width="100%">
                                <option Selected>Select</option>
                                <option value="India">India</option>
                                <option value="Saudi">Saudi</option>
                                <option value="China">China</option>
                                <option value="Abc">Abc</option>
                                <option value="Afghanistan">Afghanistan</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="mb-3">
                            <label class="form-label">Pincode
                                <span class="required-field">*</span>
                            </label>
                            <input type="number" name="pincode" class="form-control">
                        </div>
                    </div><!-- Col -->
                </div><!-- Row -->

                <div class="buttons-alignment mt-4">
                    <button type="submit" class="btn btn-primary submit-button-alignment">Submit</button>
                </div>
                {!! Form::close() !!}
            </div>
        </div>

    </div>
</div>



@endsection