@extends('layouts.master')


@section('content')

<div class="pull-right mt-3 mb-3">
    <a type="button" href="{{ route('inventory.index') }}" class="btn btn-primary btn-icon-text mb-2 mb-md-0">
        <i class="btn-icon-prepend" data-feather="arrow-left-circle"></i>
        Back
    </a>
</div>
@if($errors->any())
<h4>{{$errors->first()}}</h4>
@endif
@include('sweetalert::alert')

<h1>Inventory Inventory view&nbsp;&nbsp;&nbsp;&nbsp;</h1>


<div class="row mt-3">
    <div class="col-md-12 stretch-card">
        <div class="card card-shadow-apply">
            <div class="card-body">
                <h6 class="card-title">Inventory Details</h6>
                {!! Form::model($inv, ['method' => 'PATCH','id'=>'quickForm','enctype'=>'multipart/form-data','route' => ['inventory.update', $inv->id]]) !!}
                <div class="row">
                    <h3 class="heading">Basic Details</h3>
                    <div class="col-sm-4">
                        <div class="mb-3">

                            <label class="form-label">Item Name
                                <span class="required-field">*</span>
                            </label>
                            <input type="text" name="item_name" value="{{$inv->item_name}}" class="form-control" disabled>
                        </div>
                    </div><!-- Col -->
                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">SKU
                                <small>(optional)</small>
                            </label>
                            <input type="text" name="sku" value="{{$inv->sku}}" class="form-control" disabled>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">HSN Code<small>(optional)</small></label>
                            <input type="text" name="hsn_code" value="{{$inv->hsn}}" class="form-control" disabled>
                        </div>
                    </div>

                    <!-- Col -->
                </div>

                <div class="row">

                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">Unit
                                <small>(optional)</small>

                            </label>
                            <select name="unit" class="js-example-basic-single form-select" data-width="100%" disabled>
                                <option Selected>{{$inv->sku}}</option>
                                <option value="RS">BAG - BAGS</option>
                                <option value="DO">BAL - BALE</option>
                                <option value="DO">BDL - BUNDLES</option>
                                <option value="DO">BKL - BUCKLES</option>
                                <option value="DO">BOU - BILLIONS OF UNIT</option>
                                <option value="DO">BOX - BOX</option>
                                <option value="DO">BTL - BOTTLES</option>
                                <option value="RS">BUN - BUNCHES</option>
                                <option value="DO">CAN - CANS</option>
                                <option value="DO">CBM - CUBIC METER</option>
                                <option value="DO">CCN - CUBIC CENTIMETER</option>
                                <option value="DO">CMS - CENTIMETER</option>
                                <option value="DO">CTN - CARTONS</option>
                                <option value="DO">DOZ - DOZEN</option>
                                <option value="RS">BAG - BAGS</option>
                                <option value="DO">DRM - DRUM</option>
                                <option value="DO">GGR - GREAT GROSS</option>
                                <option value="DO">GGM - GRAMS</option>
                                <option value="DO">GRS - GROSS</option>
                                <option value="DO">GYD - GROSS YARDS</option>
                                <option value="DO">KGS - KILOGRAMS</option>
                                <option value="RS">KLO - KILOLITER</option>
                                <option value="DO">KME - KILOMETRE</option>
                                <option value="DO">MLT - MILLILITRE</option>
                                <option value="DO">MTR - METERS</option>
                                <option value="DO">NOS - NUMBERS</option>
                                <option value="DO">PAC - PACKS</option>
                                <option value="DO">PCS - PIECES</option>
                                <option value="DO">PRS - PAIRS</option>
                                <option value="RS">QTL - QUINTAL</option>
                                <option value="DO">ROL - ROLLS</option>
                                <option value="DO">SET - SETS</option>
                                <option value="DO">SQF - SQUARE FEET</option>
                                <option value="DO">SQM - SQUARE METERS</option>
                                <option value="DO">TBS - TABLETS</option>
                                <option value="DO">TGM - TEN GROSS</option>
                                <option value="DO">THD - THOUSANDS</option>
                                <option value="DO">TON - TONNES</option>
                                <option value="DO">TUB - TUBES</option>
                                <option value="RS">UGS - US GALLONS</option>
                                <option value="DO">YDS - YARDS</option>
                                <option value="DO">OTH - OTHERS</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">Display Value
                                <small>(optional)</small>

                            </label>
                            <input type="text" class="form-control" value="{{$inv->display_value}}" name="display_value" placeholder="Display value in invoice/sales forms" disabled>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">Category
                                <small>(optional)</small>

                            </label>
                            <select name="category" class="js-example-basic-single form-select" data-width="100%" disabled>
                                <option Selected>{{$inv->display_value}}</option>
                                <option value="DI">Category</option>
                                <option value="RS">Sub-Category</option>

                            </select>
                        </div>
                    </div>

                </div><!-- Row -->

                <div class="row">

                    <div class="col-sm-4">
                        <div class="mb-3">

                            <label class="form-label">Initial quantity on hand
                                <span class="required-field">*</span>
                            </label>
                            <input type="number" value="{{$inv->initial_quantity}}" name="initial_quantity" class="form-control" disabled>
                        </div>
                    </div><!-- Col -->
                    <div class="col-sm-4">
                        <div class="mb-3"><label class="form-label" for="DateOfBirth" class="">As of
                                Date
                            </label><label class="" style="color: red;">*</label><input name="as_of_date" type="date" class="form-control" value="{{$inv->as_of_date}}" disabled><small style="color: red;"></small>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">Inventory asset account
                                <small>(optional)</small>

                            </label>
                            <select name="inventory_asset_account" class="js-example-basic-single form-select" data-width="100%" disabled>
                                <option Selected>{{$inv->inventory_asset_account}}</option>
                                <option value="RS">FILL</option>
                                <option value="DO">FILL</option>

                            </select>
                        </div>
                    </div>
                    <!-- Col -->
                </div>


                <div class="row">

                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">Inclusive of Tax
                                <small>(optional)</small>
                            </label>
                            <select name="inclusive_of_tax" class="js-example-basic-single form-select" data-width="100%" disabled>
                                <option Selected>{{$inv->inclusive_of_tax}}</option>
                                <option value="RS">Fill</option>
                                <option value="DO">Fill</option>

                            </select>
                        </div>
                    </div>


                    <div class="col-sm-4">
                        <div class="mb-3">

                            <label class="form-label">Sales price/rate
                                <span class="required-field">*</span>
                            </label>
                            <input type="number" value="{{$inv->sales_price}}" name="sales_price" class="form-control" disabled>
                        </div>
                    </div><!-- Col -->

                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">Income account
                                <small>(optional)</small>
                            </label>
                            <select name="income_account" class="js-example-basic-single form-select" data-width="100%" disabled>
                                <option Selected>{{$inv->income_account}}</option>
                                <option value="RS">Fill</option>
                                <option value="DO">Fill</option>

                            </select>
                        </div>
                    </div>

                </div>

                <div class="row">
                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">Tax
                                <small>(optional)</small>

                            </label>
                            <select name="tax" class="js-example-basic-single form-select" data-width="100%" disabled>
                                <option Selected>{{$inv->tax}}</option>
                                <option value="RS">Fill</option>
                                <option value="DO">Fill</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="mb-3">

                        <label class="form-label">Description
                            <small>(optional)</small>
                        </label>
                        <textarea class="form-control" name="description" id="exampleFormControlTextarea1" rows="3" disabled>{{$inv->description}}</textarea>
                    </div>
                </div><!-- Col -->
                {!! Form::close() !!}
            </div>
        </div>
    </div>
</div>
@endsection