<?php
 use Carbon\Carbon;
?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <title>Voucher</title>
    <link rel="stylesheet" type="text/css" href="styles.css">
<style>
 @page {
            margin: 0 !important;
        }
    body {
    width: 210mm;
    height: 297mm;
    margin: 0 auto;
    font-family: Arial, sans-serif;
    /*background-color: #f5f5f5;*/
}

.container {
    /*max-width: 100%;*/
    margin: 0 auto;
    padding: 0 30px;
}

#page-wrap {
    background-color: #fff;
    /*padding: 30px;*/
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

.logo-container {
    text-align: center;
    margin-bottom: 20px;
}

.logo-container img {
    max-width: 150px;
}

.hotel-info {
    margin-bottom: 30px;
}

.hotel-info h3 {
    font-size: 18px;
    margin-bottom: 5px;
}

.hotel-info p {
    font-size: 14px;
    margin: 0;
}

.voucher-info h3 {
    font-size: 24px;
    text-align: center;
    margin-bottom: 20px;
    border-bottom: 1px solid #ccc;
    padding-bottom: 10px;
}

.booking-info {
    margin-bottom: 30px;
}

.booking-table {
    width: 100%;
    border-collapse: collapse;
}

.booking-table td {
    padding: 20px;
    padding-bottom: 40px;
    border: 1px solid #ccc;
    text-align: center;
    margin: auto:;
}

.booking-table h5 {
    font-size: 16px;
    margin-bottom: 5px;
}

.booking-table p {
    font-size: 14px;
    margin: 0;
}

.room-details {
    margin-top: 10px;
}

.room-details h5 {
    font-size: 16px;
    margin-bottom: 5px;
}

.room-details p {
    font-size: 14px;
    margin: 0;
}

.clear {
    clear: both;
}

</style>
</head>
<body>
    <div class="container">
        <div id="page-wrap">
        <div class="voucher-info">
                <h3>Hotel Voucher</h3>
            </div>

            <?php
               $checkin=$hotel->start_date;
               $checkout=$hotel->end_date;
               $checkin = Carbon::parse($checkin);
               $checkout = Carbon::parse($checkout);
               $checkin = $checkin->format('d M Y');
               $checkout = $checkout->format('d M Y');
               
            ?>
            
            <div style="width:50%; float:left;" class="hotel-info">
                <h3><?php echo e($hotel->hotel_name); ?></h3>
                <?php if($hotel_data): ?>
                <p><?php echo e($hotel_data->address_line_1); ?>, <?php echo e($hotel_data->address_line_2); ?>,<br> <?php echo e($hotel_data->city_town); ?>, <?php echo e($hotel_data->state_province); ?>,<br> <?php echo e($hotel_data->country); ?></p><br>
                <?php endif; ?>
<!--                 <p>Phone Number: 0987654</p>
 --><!--                 <p>Email: abc@gmail.com</p>
 -->            </div>
            
            <div style="width:50%; float:left;" class="hotel-info">
                <div class="room-detail">
                    <h3>Room Details</h3>
                    <div style="width:50%; float:left;">
                    <span>Room No: <?php echo e($hotel->room_name_number); ?></span> <br>
                    <span>Occupancy: <?php echo e($hotel->occupancy); ?></span><br>
                    <span>Bed: <?php echo e($hotel->bed); ?></span> <br>
                    <span>Meal: <?php echo e($hotel->meal); ?></span>
                    </div>
                    <div style="width:50%; float:right;">
                    
                    </div>
                    
                    
                </div>
            </div>

            
            
            <div class="clear"></div>
            <div class="booking-info">
                <table class="booking-table">
                    <tr>
                        <td>
                            <h5>Check In</h5>
                            <p><?php echo e($checkin); ?></p>
                        </td>
                        <td>
                            <h5>Check Out</h5>
                            <p><?php echo e($checkout); ?></p>
                        </td>
                    </tr>
                </table>
<style>
  .room-details {
    display: grid;
    grid-template-columns: repeat(5, 20%);
    grid-gap: 5px;
  }
</style>
                <div class="room-details">
  <h5>Passenger Information</h5>
  <?php $__currentLoopData = $passengers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <span><?php echo e($data->passengers); ?></span> <br>
     
  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
 
</div>
                
            </div>
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/u842563099/domains/codesquarry.online/public_html/naksha/resources/views/voucher/hotelvoucher.blade.php ENDPATH**/ ?>