<?php
 use Carbon\Carbon;
?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <title>Voucher</title>
    <link rel="stylesheet" type="text/css" href="styles.css">
<style>
 @page {
            margin: 0 !important;
        }
    body {
    width: 210mm;
    height: 297mm;
    margin: 0 auto;
    font-family: Arial, sans-serif;
    /*background-color: #f5f5f5;*/
}

.container {
    /*max-width: 100%;*/
    margin: 0 auto;
    padding: 0 30px;
}

#page-wrap {
    background-color: #fff;
    /*padding: 30px;*/
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

.logo-container {
    text-align: center;
    margin-bottom: 20px;
}

.logo-container img {
    max-width: 150px;
}

.hotel-info {
    margin-bottom: 30px;
}

.hotel-info h3 {
    font-size: 18px;
    margin-bottom: 5px;
}

.hotel-info p {
    font-size: 14px;
    margin: 0;
}

.voucher-info h3 {
    font-size: 24px;
    text-align: center;
    margin-bottom: 20px;
    border-bottom: 1px solid #ccc;
    padding-bottom: 10px;
}

.booking-info {
    margin-bottom: 30px;
}

.booking-table {
    width: 100%;
    border-collapse: collapse;
}

.booking-table td {
    padding: 10px;
    border: 1px solid #ccc;
    text-align: center;
}

.booking-table h5 {
    font-size: 16px;
    margin-bottom: 5px;
}

.booking-table p {
    font-size: 14px;
    margin: 0;
}

.room-details {
    margin-top: 10px;
}

.room-details h5 {
    font-size: 16px;
    margin-bottom: 5px;
}

.room-details p {
    font-size: 14px;
    margin: 0;
}

.clear {
    clear: both;
}

</style>
</head>
<body>
    <div class="container">
        <div id="page-wrap">
        <div class="voucher-info">
                <h3>Visa Voucher</h3>
            </div>
            <?php
               $issue_date=$visa->issue_date;
               $expiry_date=$visa->expiry_date;
               $issue_date = Carbon::parse($issue_date);
               $expiry_date = Carbon::parse($expiry_date);
               $issue_date = $issue_date->format('d M Y');
               $expiry_date = $expiry_date->format('d M Y');
               
            ?>
            
            <div style="width:50%; float:left;" class="hotel-info">
                <h3></h3>
                <p>Passenger Name: <?php echo e($visa->passenger_name); ?><br>
                <p>Passport No: <?php echo e($visa->passport_number); ?></p>
                <p>Date of Birth: <?php echo e($visa->dob); ?></p>
                <p>Email: <?php echo e($visa->email); ?></p>
            </div>

            <div style="width:50%; float:right;" class="hotel-info">
                <h3></h3>
                <p>Visa No: <?php echo e($visa->visa_number); ?><br>
                <p>Visa Entry Type: <?php echo e($visa->visa_entry_type); ?></p>
                <p>Visa Type: <?php echo e($visa->visa_type); ?></p>
                <p>Country: <?php echo e($visa->country); ?></p>
            </div>
            
            <div class="clear"></div>
            <div class="booking-info">
                <table class="booking-table">
                    <tr>
                        <td>
                            <h5>Issue Date</h5>
                            <p><?php echo e($issue_date); ?></p>
                        </td>
                        <td>
                            <h5>Expiry Date</h5>
                            <p><?php echo e($expiry_date); ?></p>
                        </td>
                    </tr>
                </table>
                
                
            </div>
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/nakshine/test.nakshatravels.com/resources/views/voucher/visavoucher.blade.php ENDPATH**/ ?>