<?php $__env->startSection('content'); ?>



<div class="row">
  <div class="col-lg-12 margin-tb">
    <div class="pull-left">
      <h2>Hotel List</h2>
    </div>
    <br>
    <div class="mt-5 mb-3">
      <a type="button" href="<?php echo e(route('hotel.create')); ?>" class="btn btn-success btn-icon-text mb-2 mb-md-0">
        <i class="btn-icon-prepend" data-feather="user"></i>
        Create Hotel
      </a>
    </div>
  </div>
</div>

<?php if($message = Session::get('success')): ?>
<?php echo $__env->make('sweetalert::alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>


<div class="col-md-12 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <div class="table-responsive">
        <table id="dataTableExample" class="table">
          <thead class="text-center">
            <tr>
              <th>No</th>
              <th>Hotel Name</th>
              <th>Hotel Type</th>
              <th>Address</th>
              <th>City</th>
              <th>Status</th>
              <th width="280px">Action</th>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $hotel; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $hotel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr class="fw-bold fs-5">
              <td><?php echo e(++$i); ?></td>
              <td><?php echo e($hotel->hotel_name); ?></td>
              <td><?php echo e($hotel->hotel_type); ?></td>
              <td><?php echo e($hotel->address_line_1); ?></td>
              <td><?php echo e($hotel->city_town); ?></td>
              <?php if($hotel->status == "Active"): ?>
              <td><span class="badge bg-success">Active</span></td>
              <?php else: ?>
              <td><span class="badge bg-danger">Inactive</span></td>
              <?php endif; ?>
              <td>
                <a href="hotel/<?php echo e($hotel->id); ?>/view/"><i class="text-primary btn-icon-prepend" data-feather="eye"></i></a>
                <a href="hotel/<?php echo e($hotel->id); ?>/edit/"><i class="text-success btn-icon-prepend" data-feather="edit"></i></a>
                <a href="hotel/<?php echo e($hotel->id); ?>/delete/"><i class="text-danger btn-icon-prepend" data-feather="trash"></i></a>
              </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Arman\Downloads\New Download\Naksha (6)\Naksha\resources\views/hotel/index.blade.php ENDPATH**/ ?>