
@extends('includes.master')

@section('content')

<div class="main-mobile-header doc-mobile-header">
      <a id="menuLink" href="#" class="menu-link"><i class="ri-menu-line"></i></a>
    </div>

   

    



     <div class="main main-app p-3 p-lg-4">
        
        <div class="mb-4">
          <ol class="breadcrumb fs-sm mb-1">
            <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
            <li class="breadcrumb-item active" aria-current="page">View Quotation</li>
          </ol>
        </div>




      <div class="">
        
        <div class="row">

          <div class="col-lg-8">
            <h2 class="main-title">View Quotation</h2>
            
          </div>
          <div style="text-align: right;" class="col-lg-4 text-right">
           <!--  <button type="button" class="btn btn-primary">Add Employee</button> -->
            <!-- <a href="/form" class="btn btn-primary">Add Employee</a>
 -->
          </div>

        </div>

        <hr class="main-separator">        
    
        

<input type="hidden" id="" name="quotation_id" value="{{$id}}" />

<input type="hidden" id="corporate_id" name="corporate_id" value="" />
<input type="hidden" id="individual_id" name="individual_id" value="" />

<div class="card" style="background-color: white; padding: 3rem;">
    <div class="row">
        <div class="col-sm-4">
            <div class="mb-3">
                <label class="form-label">Date</label>
                <input type="date" class="form-control" name="quotation_date" id="" value="{{ $quotation->quotation_date }}" />
            </div>
        </div>

        <div class="col-sm-4">
            <div class="mb-3">
                <label class="form-label">Expiry Date</label>
                <input type="date" class="form-control" name="expiry_date" id="" value="{{ $quotation->expiry_date }}" />
            </div>
        </div>

        <div class="col-sm-4">
            <div class="mb-3">
                <label class="form-label">Reference No</label>
                <input type="text" class="form-control" name="reference_no" id="" value="" value="{{ $quotation->reference_no }}" />
            </div>
        </div>

        <div class="col-sm-4">
            <div class="mb-3">
                <label class="form-label">Select Custumer Type</label>
                <select class="form-select select2" name="customer_type" id="SelectAB" onclick="displayAB()">
                    <option value="{{ $quotation->customer_type }}" selected>{{ $quotation->customer_type }}</option>
                    <option value="Corporate">Corporate</option>
                    <option value="Individual">Individual</option>
                    <option value="New">New</option>
                </select>
                <script>
                    function displayAB() {
                        var x = document.getElementById("SelectAB").value;
                        if (x == "Corporate") {
                            document.getElementById("ce").style.display = "block";
                            document.getElementById("cf").style.display = "none";
                            document.getElementById("new1").style.display = "none";
                            document.getElementById("new2").style.display = "none";
                            document.getElementById("new3").style.display = "none";
                            document.getElementById("new4").style.display = "none";
                        } else if (x == "Individual") {
                            document.getElementById("ce").style.display = "none";
                            document.getElementById("cf").style.display = "block";
                            document.getElementById("new1").style.display = "none";
                            document.getElementById("new2").style.display = "none";
                            document.getElementById("new3").style.display = "none";
                            document.getElementById("new4").style.display = "none";
                        } else if (x == "New") {
                            document.getElementById("ce").style.display = "none";
                            document.getElementById("cf").style.display = "none";
                            document.getElementById("new1").style.display = "block";
                            document.getElementById("new2").style.display = "block";
                            document.getElementById("new3").style.display = "block";
                            document.getElementById("new4").style.display = "none";
                        }
                    }
                </script>
            </div>
        </div>

        <div class="col-sm-4" id="ce">
            <div class="mb-3">
                <label class="form-label">Select By Company Name</label>
                <select class="form-select select2" name="select_company_name" id="SelectAc" data-width="100%">
                    <option value="{{ $quotation->customer_name }}" selected>{{ $quotation->customer_name }}</option>
                    @foreach($corporate as $corporate)
                    <option value="{{$corporate->company_name}}">{{$corporate->company_name}}</option>
                    @endforeach
                </select>
                <script>

                                            $(document).ready(function() {


                    $('#SelectAc').on('change', function() {

                        console.log('{!! json_encode($cdata->toArray()) !!}');

                    var initialIndividual = {!! json_encode($cdata->toArray()) !!};

                    var selectedType = $(this).val();

                    var filteredIndividual = initialIndividual.filter(function(cdata) {
                    return cdata.company_name == selectedType ;
                    });


                    // Update the details


                    // console.log(filteredIndividual[0].citizenship)
                    $('.blank').empty();
                    $('#corporate_id').val(filteredIndividual[0].id);


                    $('.company_name').append(filteredIndividual[0].company_name);
                    $('.display_name').append(filteredIndividual[0].display_name);
                    $('.corporate_email').append(filteredIndividual[0].email);
                    $('.corporate_phone').append(filteredIndividual[0].phone);
                      $('.registration_type').append(filteredIndividual[0].registration_type);
                      $('.registration_number').append(filteredIndividual[0].registration_number);
                      $('.billing_state_province').append(filteredIndividual[0].billing_state_province);
                      $('.billing_city_town').append(filteredIndividual[0].billing_city_town);
                      $('.billing_country').append(filteredIndividual[0].billing_country);

                      $('.office_state_province').append(filteredIndividual[0].office_state_province);
                      $('.office_city_town').append(filteredIndividual[0].office_city_town);
                      $('.office_country').append(filteredIndividual[0].office_country);

                      document.getElementById("p").style.display = "block";
                      document.getElementById("o").style.display = "none";





                    });

                    });
                </script>
            </div>
        </div>

        <div class="col-sm-4" id="cf" style="display: none;">
            <div class="mb-3">
                <label class="form-label">Select By Individual Name</label>
                <select class="form-select select2" name="select_individual_name" id="SelectAbc" data-width="100%">
                    <option value="{{ $quotation->customer_name }}" selected>{{ $quotation->customer_name }}</option>
                    @foreach($individual as $individual)
                    <option value="{{$individual->first_name}}">{{$individual->first_name.' '.$individual->last_name}}</option>
                    @endforeach
                </select>
                <script>


                                            $(document).ready(function() {


                                            $('#SelectAbc').on('change', function() {

                                                console.log('{!! json_encode($idata->toArray()) !!}');

                    var initialIndividual = {!! json_encode($idata->toArray()) !!};

                    var selectedType = $(this).val();

                    var filteredIndividual = initialIndividual.filter(function(idata) {
                    return idata.first_name == selectedType ;
                    });


                    // Update the details

                    //   console.log(filteredIndividual[0].citizenship)
                      $('.blank').empty();
                      $('#individual_id').val(filteredIndividual[0].id);

                      $('.name').append(filteredIndividual[0].first_name);
                      $('.email').append(filteredIndividual[0].email);
                      $('.phone').append(filteredIndividual[0].phone);
                      $('.gender').append(filteredIndividual[0].gender);
                      $('.citizenship').append(filteredIndividual[0].citizenship);
                      $('.billing_state_province').append(filteredIndividual[0].billing_state_province);
                      $('.billing_city_town').append(filteredIndividual[0].billing_city_town);
                      $('.billing_country').append(filteredIndividual[0].billing_country);


                      document.getElementById("o").style.display = "block";
                      document.getElementById("p").style.display = "none";



                    });

                    });
                </script>
            </div>
        </div>

        <div id="new1" class="col-sm-4" style="display: none;">
            <div class="mb-3">
                <label class="form-label">Customer Name</label>
                <input type="text" class="form-control" name="customer_name" id="" value="" />
            </div>
        </div>

        <div id="new2" class="col-sm-4" style="display: none;">
            <div class="mb-3">
                <label class="form-label">Email</label>
                <input type="email" class="form-control" name="email" id="" value="" />
            </div>
        </div>

        <div id="new3" class="col-sm-4" style="display: none;">
            <div class="mb-3">
                <label class="form-label">Phone</label>
                <input type="text" class="form-control" name="mobile" id="" value="" />
            </div>
        </div>

        <div id="new4" class="col-sm-4" style="display: none;">
            <div class="mb-3">
                <label class="form-label">Address</label>
                <input type="text" class="form-control" name="address" id="" value="" />
            </div>
        </div>

        <div class="col-sm-4">
            <div class="mb-3">
                <label class="form-label">Currency</label>
                <select class="form-select select2 currency" name="currency" data-width="100%">
                    <option value="{{ $quotation->currency }}" selected>{{ $quotation->currency }}</option>
                    <option value="AFN">Afghan Afghani</option>
                    <option value="ALL">Albanian Lek</option>
                    <option value="DZD">Algerian Dinar</option>
                    <option value="AOA">Angolan Kwanza</option>
                    <option value="ARS">Argentine Peso</option>
                    <option value="AMD">Armenian Dram</option>
                    <option value="AWG">Aruban Florin</option>
                    <option value="AUD">Australian Dollar</option>
                    <option value="AZN">Azerbaijani Manat</option>
                    <option value="BSD">Bahamian Dollar</option>
                    <option value="BHD">Bahraini Dinar</option>
                    <option value="BDT">Bangladeshi Taka</option>
                    <option value="BBD">Barbadian Dollar</option>
                    <option value="BYR">Belarusian Ruble</option>
                    <option value="BEF">Belgian Franc</option>
                    <option value="BZD">Belize Dollar</option>
                    <option value="BMD">Bermudan Dollar</option>
                    <option value="BTN">Bhutanese Ngultrum</option>
                    <option value="BTC">Bitcoin</option>
                    <option value="BOB">Bolivian Boliviano</option>
                    <option value="BWP">Botswanan Pula</option>
                    <option value="BRL">Brazilian Real</option>
                    <option value="GBP">British Pound Sterling</option>
                    <option value="BND">Brunei Dollar</option>
                    <option value="BGN">Bulgarian Lev</option>
                    <option value="BIF">Burundian Franc</option>
                    <option value="KHR">Cambodian Riel</option>
                    <option value="CAD">Canadian Dollar</option>
                    <option value="CVE">Cape Verdean Escudo</option>
                    <option value="KYD">Cayman Islands Dollar</option>
                    <option value="XOF">CFA Franc BCEAO</option>
                    <option value="XAF">CFA Franc BEAC</option>
                    <option value="XPF">CFP Franc</option>
                    <option value="CLP">Chilean Peso</option>
                    <option value="CNY">Chinese Yuan</option>
                    <option value="COP">Colombian Peso</option>
                    <option value="KMF">Comorian Franc</option>
                    <option value="CDF">Congolese Franc</option>
                    <option value="CRC">Costa Rican ColÃ³n</option>
                    <option value="HRK">Croatian Kuna</option>
                    <option value="CUC">Cuban Convertible Peso</option>
                    <option value="CZK">Czech Republic Koruna</option>
                    <option value="DKK">Danish Krone</option>
                    <option value="DJF">Djiboutian Franc</option>
                    <option value="DOP">Dominican Peso</option>
                    <option value="XCD">East Caribbean Dollar</option>
                    <option value="EGP">Egyptian Pound</option>
                    <option value="ERN">Eritrean Nakfa</option>
                    <option value="EEK">Estonian Kroon</option>
                    <option value="ETB">Ethiopian Birr</option>
                    <option value="EUR">Euro</option>
                    <option value="FKP">Falkland Islands Pound</option>
                    <option value="FJD">Fijian Dollar</option>
                    <option value="GMD">Gambian Dalasi</option>
                    <option value="GEL">Georgian Lari</option>
                    <option value="DEM">German Mark</option>
                    <option value="GHS">Ghanaian Cedi</option>
                    <option value="GIP">Gibraltar Pound</option>
                    <option value="GRD">Greek Drachma</option>
                    <option value="GTQ">Guatemalan Quetzal</option>
                    <option value="GNF">Guinean Franc</option>
                    <option value="GYD">Guyanaese Dollar</option>
                    <option value="HTG">Haitian Gourde</option>
                    <option value="HNL">Honduran Lempira</option>
                    <option value="HKD">Hong Kong Dollar</option>
                    <option value="HUF">Hungarian Forint</option>
                    <option value="ISK">Icelandic KrÃ³na</option>
                    <option value="INR">Indian Rupee</option>
                    <option value="IDR">Indonesian Rupiah</option>
                    <option value="IRR">Iranian Rial</option>
                    <option value="IQD">Iraqi Dinar</option>
                    <option value="ILS">Israeli New Sheqel</option>
                    <option value="ITL">Italian Lira</option>
                    <option value="JMD">Jamaican Dollar</option>
                    <option value="JPY">Japanese Yen</option>
                    <option value="JOD">Jordanian Dinar</option>
                    <option value="KZT">Kazakhstani Tenge</option>
                    <option value="KES">Kenyan Shilling</option>
                    <option value="KWD">Kuwaiti Dinar</option>
                    <option value="KGS">Kyrgystani Som</option>
                    <option value="LAK">Laotian Kip</option>
                    <option value="LVL">Latvian Lats</option>
                    <option value="LBP">Lebanese Pound</option>
                    <option value="LSL">Lesotho Loti</option>
                    <option value="LRD">Liberian Dollar</option>
                    <option value="LYD">Libyan Dinar</option>
                    <option value="LTL">Lithuanian Litas</option>
                    <option value="MOP">Macanese Pataca</option>
                    <option value="MKD">Macedonian Denar</option>
                    <option value="MGA">Malagasy Ariary</option>
                    <option value="MWK">Malawian Kwacha</option>
                    <option value="MYR">Malaysian Ringgit</option>
                    <option value="MVR">Maldivian Rufiyaa</option>
                    <option value="MRO">Mauritanian Ouguiya</option>
                    <option value="MUR">Mauritian Rupee</option>
                    <option value="MXN">Mexican Peso</option>
                    <option value="MDL">Moldovan Leu</option>
                    <option value="MNT">Mongolian Tugrik</option>
                    <option value="MAD">Moroccan Dirham</option>
                    <option value="MZM">Mozambican Metical</option>
                    <option value="MMK">Myanmar Kyat</option>
                    <option value="NAD">Namibian Dollar</option>
                    <option value="NPR">Nepalese Rupee</option>
                    <option value="ANG">Netherlands Antillean Guilder</option>
                    <option value="TWD">New Taiwan Dollar</option>
                    <option value="NZD">New Zealand Dollar</option>
                    <option value="NIO">Nicaraguan CÃ³rdoba</option>
                    <option value="NGN">Nigerian Naira</option>
                    <option value="KPW">North Korean Won</option>
                    <option value="NOK">Norwegian Krone</option>
                    <option value="OMR">Omani Rial</option>
                    <option value="PKR">Pakistani Rupee</option>
                    <option value="PAB">Panamanian Balboa</option>
                    <option value="PGK">Papua New Guinean Kina</option>
                    <option value="PYG">Paraguayan Guarani</option>
                    <option value="PEN">Peruvian Nuevo Sol</option>
                    <option value="PHP">Philippine Peso</option>
                    <option value="PLN">Polish Zloty</option>
                    <option value="QAR">Qatari Rial</option>
                    <option value="RON">Romanian Leu</option>
                    <option value="RUB">Russian Ruble</option>
                    <option value="RWF">Rwandan Franc</option>
                    <option value="SVC">Salvadoran ColÃ³n</option>
                    <option value="WST">Samoan Tala</option>
                    <option value="SAR">Saudi Riyal</option>
                    <option value="RSD">Serbian Dinar</option>
                    <option value="SCR">Seychellois Rupee</option>
                    <option value="SLL">Sierra Leonean Leone</option>
                    <option value="SGD">Singapore Dollar</option>
                    <option value="SKK">Slovak Koruna</option>
                    <option value="SBD">Solomon Islands Dollar</option>
                    <option value="SOS">Somali Shilling</option>
                    <option value="ZAR">South African Rand</option>
                    <option value="KRW">South Korean Won</option>
                    <option value="XDR">Special Drawing Rights</option>
                    <option value="LKR">Sri Lankan Rupee</option>
                    <option value="SHP">St. Helena Pound</option>
                    <option value="SDG">Sudanese Pound</option>
                    <option value="SRD">Surinamese Dollar</option>
                    <option value="SZL">Swazi Lilangeni</option>
                    <option value="SEK">Swedish Krona</option>
                    <option value="CHF">Swiss Franc</option>
                    <option value="SYP">Syrian Pound</option>
                    <option value="STD">São Tomé and Príncipe Dobra</option>
                    <option value="TJS">Tajikistani Somoni</option>
                    <option value="TZS">Tanzanian Shilling</option>
                    <option value="THB">Thai Baht</option>
                    <option value="TOP">Tongan pa'anga</option>
                    <option value="TTD">Trinidad & Tobago Dollar</option>
                    <option value="TND">Tunisian Dinar</option>
                    <option value="TRY">Turkish Lira</option>
                    <option value="TMT">Turkmenistani Manat</option>
                    <option value="UGX">Ugandan Shilling</option>
                    <option value="UAH">Ukrainian Hryvnia</option>
                    <option value="AED">United Arab Emirates Dirham</option>
                    <option value="UYU">Uruguayan Peso</option>
                    <option value="USD">US Dollar</option>
                    <option value="UZS">Uzbekistan Som</option>
                    <option value="VUV">Vanuatu Vatu</option>
                    <option value="VEF">Venezuelan BolÃ­var</option>
                    <option value="VND">Vietnamese Dong</option>
                    <option value="YER">Yemeni Rial</option>
                    <option value="ZMK">Zambian Kwacha</option>
                </select>
            </div>
        </div>
    </div>

    <br />
    <br />

    <div id="p" style="display: none;">
        <div class="row">
            <!--  <div class='form-group col-md-12 col-12'>
                            <label>Image</label><br>
                            <img width="250px" src="<?php  ?>">
                            
                          </div> -->

            <div class="form-group col-md-3 col-12">
                <label>Company Name</label>
                <div style="background-color: #e9ecef; color: #495057; padding: 10px;">
                    <div class="blank company_name"></div>
                </div>
            </div>

            <div class="form-group col-md-3 col-12">
                <label>Display Name</label>
                <div style="background-color: #e9ecef; color: #495057; padding: 10px;">
                    <div class="blank display_name"></div>
                </div>
            </div>

            <div class="form-group col-md-3 col-12">
                <label>Email</label>
                <div style="background-color: #e9ecef; color: #495057; padding: 10px;">
                    <div class="blank corporate_email"></div>
                </div>
            </div>

            <div class="form-group col-md-3 col-12">
                <label>Phone</label>
                <div style="background-color: #e9ecef; color: #495057; padding: 10px;">
                    <div class="blank corporate_phone"></div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="form-group col-md-3 col-12">
                <label>Company Address</label>
                <div style="background-color: #e9ecef; color: #495057; padding: 10px;">
                    <div class="blank office_state_province"></div>
                    <div class="blank office_city_town"></div>
                    <div class="blank office_country"></div>
                </div>
            </div>

            <div class="form-group col-md-3 col-12">
                <label>Billing Address</label>
                <div style="background-color: #e9ecef; color: #495057; padding: 10px;">
                    <div class="blank billing_state_province"></div>
                    <div class="blank billing_city_town"></div>
                    <div class="blank billing_country"></div>
                </div>
            </div>

            <div class="form-group col-md-3 col-12">
                <label>Registration Type</label>
                <div style="background-color: #e9ecef; color: #495057; padding: 10px;">
                    <div class="blank registration_type"></div>
                </div>
            </div>

            <div class="form-group col-md-3 col-12">
                <label>Registration Number</label>
                <div style="background-color: #e9ecef; color: #495057; padding: 10px;">
                    <div class="blank registration_number"></div>
                </div>
            </div>
        </div>
    </div>

    <div id="o" style="display: none;">
        <div class="row">
            <div class="form-group col-md-3 col-12">
                <label>Company Name</label>
                <div style="background-color: #e9ecef; color: #495057; padding: 10px;">
                    <div class="blank name"></div>
                </div>
            </div>

            <div class="form-group col-md-3 col-12">
                <label>Email</label>
                <div style="background-color: #e9ecef; color: #495057; padding: 10px;">
                    <div class="blank email"></div>
                </div>
            </div>

            <div class="form-group col-md-3 col-12">
                <label>Phone</label>
                <div style="background-color: #e9ecef; color: #495057; padding: 10px;">
                    <div class="blank phone"></div>
                </div>
            </div>

            <div class="form-group col-md-3 col-12">
                <label>Gender</label>
                <div style="background-color: #e9ecef; color: #495057; padding: 10px;">
                    <div class="blank gender"></div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="form-group col-md-3 col-12">
                <label>Citizenship</label>
                <div style="background-color: #e9ecef; color: #495057; padding: 10px;">
                    <div class="blank citizenship"></div>
                </div>
            </div>

            <div class="form-group col-md-3 col-12">
                <label>Billing Address</label>
                <div style="background-color: #e9ecef; color: #495057; padding: 10px;">
                    <div class="blank billing_state_province"></div>
                    <div class="blank billing_city_town"></div>
                    <div class="blank billing_country"></div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- End section -->

<div class="card" style="background-color: white; padding-top: 3rem;">
    <div class="p-4 mt-4" style="margin-top: -30px !important;">
        <div class=""></div>
        <div class="card-body mt-xl-n5">
            <div class="row"></div>

            <br />

            <div class="row">
                <div class="col-lg-6 mb-5">
                    <button id="myButton" data-value="" type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#exampleModal">
                        ADD Services
                    </button>
                </div>
                <div class="col-lg-6 mb-5">
                    <div class="text-right">
                        <select name="tax-type" id="tax-type" class="form-select">
                            <option value="inclusive" selected>Tax Inclusive</option>
                            <option value="exclusive">Tax Exclusive</option>
                        </select>
                    </div>
                </div>
            </div>
            <!-- </form> -->
            <!-- setup start -->

            <div id="" style="display: block;">
                <div class="col-md-12 grid-margin stretch-card">
                    <div class="table-responsive" style="min-width: 69vw;">
                        <table id="table" class="table">
                            <thead>
                                <tr class="bg-light">
                                    <th style="width: 300px;" class="table-first-row">Item Details</th>
                                    <th class="table-first-row">Quantity</th>
                                    <th class="table-first-row">Rate</th>
                                    <th class="table-first-row">Discount (%)</th>
                                    <th class="table-first-row">Tax</th>
                                    <th class="table-first-row">Amount</th>
                                    <!-- <th class="table-first-row">Action</th> -->
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($services['hotel'] as $key => $data)
                                <tr>
                                    <td style="width: 500px;">
                                        <span>Hotel Name: {{$data->hotel_name}},</span> <span>Room No: {{$data->room_name_number}}</span><br />
                                        <span>Bed: {{$data->bed}},</span> <span>Meal: {{$data->meal}}</span><br />
                                    </td>
                                    <input type="hidden" class="itm-details" name="" value="Hotel Name: {{$data->hotel_name}}, Room No: {{$data->room_name_number}}, Bed: {{$data->bed}}, Meal: {{$data->meal}} " />
                                    <td style="width: 100px;"><input type="text" class="form-control formz itm-qty" name="quantity[]" value="1" /></td>
                                    <td style="width: 200px;"><input class="form-control formz itm-rate" type="text" name="rate[]" value="{{$data->hotel_price}}" /></td>
                                    <td style="width: 200px;">
                                        <input style="text-align: center;" class="form-control formz itm-discount" type="text" name="discount[]" value="0" />
                                    </td>
                                    <td style="width: 200px;">
                                        @if ($data->tax_amount==0)
                                        <span class="tax-amt" style="text-align: center;">{{$data->other_tax}}</span>
                                        <span class="tax-rat" style="text-align: center; display: none;">{{$data->tax_amount}}</span>
                                        @else
                                        <span class="tax-amt" style="text-align: center; display: none;">{{$data->other_tax}}</span>
                                        <span class="tax-rat" style="text-align: center;">{{$data->tax_amount}}</span>% @endif
                                    </td>
                                    <input type="hidden" class="item-tax itm-tax-rate" value="{{$data->tax_amount}}" />
                                    <input type="hidden" class="item-tax itm-tax-amount" value="0" />
                                    <td style="width: 100px;" class="hotel-price">{{$data->hotel_price}}</td>
                                    <input type="hidden" class="itm-price" name="hotel-price[]" value="{{$data->hotel_price}}" />
                                    <td><a href="/quotation/delete/hotel/{{$data->id}}">X</a></td>
                                    <!-- {{ number_format($data->hotel_price, 2) }} -->
                                    <!-- <td>
                                    <a href="/mice/summary/data/{{$data->user_id}}" class="btn text-primary"><i data-feather="download"></i></a>

                                        <a href="ADDServicesDSR.html">
                                        <i data-feather="trash" class="me-2 icon-md" style="color:red"></i>
                                        </a>
                                    </td> -->
                                </tr>
                                @endforeach @foreach ($services['flight'] as $key => $data)
                                <tr>
                                    <td style="width: 500px;">
                                        <span>Travel Date: {{$data->travel_date}},</span> <span>Airline Name: {{$data->airline_name}}</span><br />
                                        <span>Ticket No: {{ $data->ticket_number }}</span><span>PNR No: {{ $data->pnr_number }}</span><br />
                                    </td>
                                    <input type="hidden" class="itm-details" name="" value="Travel Date: {{$data->travel_date}}, Airline Name: {{$data->airline_name}}, Ticket No: {{$data->ticket_number}}, PNR No: {{$data->pnr_number}} " />
                                    <td style="width: 100px;"><input type="text" class="form-control formz itm-qty" name="quantity" value="1" /></td>
                                    <td><input class="form-control formz itm-rate" type="text" name="rate" value="{{$data->fare_price}}" /></td>
                                    <td>
                                        <input style="text-align: center;" class="form-control formz itm-discount" type="text" name="discount" value="0" />
                                    </td>
                                    <td style="width: 200px;">
                                        @if ($data->tax_amount==0)
                                        <span class="tax-amt" style="text-align: center;">{{$data->other_tax}}</span>
                                        <span class="tax-rat" style="text-align: center; display: none;">{{$data->tax_amount}}</span>
                                        @else
                                        <span class="tax-amt" style="text-align: center; display: none;">{{$data->other_tax}}</span>
                                        <span class="tax-rat" style="text-align: center;">{{$data->tax_amount}}</span>% @endif
                                    </td>
                                    <input type="hidden" class="item-tax itm-tax-rate" value="{{$data->tax_amount}}" />
                                    <input type="hidden" class="item-tax itm-tax-amount" value="0" />
                                    <td class="hotel-price">{{$data->fare_price}}</td>
                                    <input type="hidden" class="itm-price" name="hotel-price" value="{{$data->fare_price}}" />
                                    <td><a href="/quotation/delete/flight/{{$data->id}}">X</a></td>

                                    <!-- <td>
                                    <a href="/mice/summary/data/{{$data->user_id}}" class="btn text-primary"><i data-feather="download"></i></a>

                                        <a href="ADDServicesDSR.html">
                                        <i data-feather="trash" class="me-2 icon-md" style="color:red"></i>
                                        </a>
                                    </td> -->
                                </tr>
                                @endforeach @foreach ($services['visa'] as $key => $data)
                                <tr>
                                    <td style="width: 500px;">
                                        <span>Passenger: {{ $data->passenger_name }}</span> <span>DOB: {{ $data->dob }}</span><br />
                                        <span>Country: {{ $data->country }}</span> <span>Passport No: {{ $data->passport_number }}</span><br />
                                    </td>
                                    <input type="hidden" class="itm-details" name="" value="Passenger: {{$data->passenger_name}}, DOB: {{$data->dob}}, Country: {{$data->country}}, Passport No: {{$data->passport_number}} " />
                                    <td style="width: 100px;"><input type="text" class="form-control formz itm-qty" name="quantity" value="1" /></td>
                                    <td><input class="form-control formz itm-rate" type="text" name="rate" value="{{$data->visa_price}}" /></td>
                                    <td>
                                        <input style="text-align: center;" class="form-control formz itm-discount" type="text" name="discount" value="0" />
                                    </td>
                                    <td style="width: 200px;">
                                        @if ($data->tax_amount==0)
                                        <span class="tax-amt" style="text-align: center;">{{$data->other_tax}}</span>
                                        <span class="tax-rat" style="text-align: center; display: none;">{{$data->tax_amount}}</span>
                                        @else
                                        <span class="tax-amt" style="text-align: center; display: none;">{{$data->other_tax}}</span>
                                        <span class="tax-rat" style="text-align: center;">{{$data->tax_amount}}</span>% @endif
                                    </td>
                                    <input type="hidden" class="item-tax itm-tax-rate" value="{{$data->tax_amount}}" />
                                    <input type="hidden" class="item-tax itm-tax-amount" value="0" />
                                    <td class="hotel-price">{{$data->visa_price}}</td>
                                    <input type="hidden" class="itm-price" name="hotel-price[]" value="{{$data->visa_price}}" />
                                    <td><a href="/quotation/delete/visa/{{$data->id}}">X</a></td>
                                    <!-- <td>
                                    <a href="/mice/summary/data/{{$data->user_id}}" class="btn text-primary"><i data-feather="download"></i></a>

                                        <a href="ADDServicesDSR.html">
                                        <i data-feather="trash" class="me-2 icon-md" style="color:red"></i>
                                        </a>
                                    </td> -->
                                </tr>
                                @endforeach @foreach ($services['insurance'] as $key => $data)
                                <tr>
                                    <td style="width: 500px;">
                                        <span>Passenger: {{ $data->passenger_name }}</span> <br />
                                        <span>Company Name: {{ $data->company_name }}</span> <span>Policy No: {{ $data->policy_number }}</span><br />
                                        <span>Issue Date: {{ $data->issue_date }}</span> <span>Expiry Date: {{ $data->expiry_date }}</span><br />
                                    </td>
                                    <input
                                        type="hidden"
                                        class="itm-details"
                                        name=""
                                        value="Passenger: {{$data->passenger_name}}, Company Name: {{$data->company_name}}, Policy No: {{$data->policy_number}}, Issue Date: {{$data->issue_date}}, Expiry Date: {{$data->expiry_date}} "
                                    />
                                    <td style="width: 100px;"><input type="text" class="form-control formz itm-qty" name="quantity" value="1" /></td>
                                    <td><input class="form-control formz itm-rate" type="text" name="rate" value="{{$data->insurance_price}}" /></td>
                                    <td>
                                        <input style="text-align: center;" class="form-control formz itm-discount" type="text" name="discount" value="0" />
                                    </td>
                                    <td style="width: 200px;">
                                        @if ($data->tax_amount==0)
                                        <span class="tax-amt" style="text-align: center;">{{$data->other_tax}}</span>
                                        <span class="tax-rat" style="text-align: center; display: none;">{{$data->tax_amount}}</span>
                                        @else
                                        <span class="tax-amt" style="text-align: center; display: none;">{{$data->other_tax}}</span>
                                        <span class="tax-rat" style="text-align: center;">{{$data->tax_amount}}</span>% @endif
                                    </td>
                                    <input type="hidden" class="item-tax itm-tax-rate" value="{{$data->tax_amount}}" />
                                    <input type="hidden" class="item-tax itm-tax-amount" value="0" />
                                    <td class="hotel-price">{{$data->insurance_price}}</td>
                                    <input type="hidden" class="itm-price" name="hotel-price[]" value="{{$data->insurance_price}}" />
                                    <td><a href="/quotation/delete/insurance/{{$data->id}}">X</a></td>
                                    <!-- <td>
                                    <a href="/mice/summary/data/{{$data->user_id}}" class="btn text-primary"><i data-feather="download"></i></a>

                                        <a href="ADDServicesDSR.html">
                                        <i data-feather="trash" class="me-2 icon-md" style="color:red"></i>
                                        </a>
                                    </td> -->
                                </tr>
                                @endforeach @foreach ($services['other'] as $key => $data)
                                <tr>
                                    <td style="width: 500px;">
                                        <span>Item Name: {{ $data->item_details }}</span>
                                    </td>
                                    <input type="hidden" class="itm-details" name="" value="Item Name: {{$data->item_details}}" />
                                    <td style="width: 100px;"><input type="text" class="form-control formz itm-qty" name="quantity" value="1" /></td>
                                    <td><input class="form-control itm-rate" type="text" name="rate" value="{{$data->price}}" /></td>
                                    <td>
                                        <input style="text-align: center;" class="form-control formz itm-discount" type="text" name="discount" value="0" />
                                    </td>
                                    <td style="width: 200px;">
                                        @if ($data->tax_amount==0)
                                        <span class="tax-amt" style="text-align: center;">{{$data->other_tax}}</span>
                                        <span class="tax-rat" style="text-align: center; display: none;">{{$data->tax_amount}}</span>
                                        @else
                                        <span class="tax-amt" style="text-align: center; display: none;">{{$data->other_tax}}</span>
                                        <span class="tax-rat" style="text-align: center;">{{$data->tax_amount}}</span>% @endif
                                    </td>
                                    <input type="hidden" class="item-tax itm-tax-rate" value="{{$data->tax_amount}}" />
                                    <input type="hidden" class="item-tax itm-tax-amount" value="0" />
                                    <td class="hotel-price">{{$data->price}}</td>
                                    <input type="hidden" class="itm-price" name="hotel-price[]" value="{{$data->price}}" />
                                    <td><a href="/quotation/delete/other/{{$data->id}}">X</a></td>
                                    <!-- <td>
                                    <a href="/mice/summary/data/{{$data->user_id}}" class="btn text-primary"><i data-feather="download"></i></a>

                                        <a href="ADDServicesDSR.html">
                                        <i data-feather="trash" class="me-2 icon-md" style="color:red"></i>
                                        </a>
                                    </td> -->
                                </tr>
                                @endforeach
                            </tbody>
                        </table>

                        <script>
                            $(document).ready(function () {
                                $(".currency").on("change", function () {
                                    var curr = $(this).val();
                                    $("#currency").text("(" + curr + ")");
                                });

                                $(".formz").on("change", function () {
                                    var row = $(this).closest("tr");
                                    var quantity = row.find("td:eq(1) input").val();
                                    var rate = row.find("td:eq(2) input").val();
                                    var discount = row.find("td:eq(3) input").val();
                                    var taxRate = row.find("td:eq(4) span").text();
                                    var amount = quantity * rate * (1 - discount / 100);
                                    var tax = rate * (taxRate / 100);
                                    row.find("td:eq(5)").text(amount.toFixed(2));
                                    row.find(".hotel-price").text(amount.toFixed(2));
                                    row.find(".item-tax").val(tax);

                                    var total = 0;

                                    $("#table tbody tr").each(function () {
                                        var amount = $(this).find(".hotel-price").text().replace(/\D/g, "");
                                        total = parseInt(total) + parseInt(amount);
                                    });

                                    $(".subtotal").text(total.toFixed(2));
                                    $("#subtotal").val(total.toFixed(2));
                                    $(".total").text(total.toFixed(2));
                                    $("#total").val(total.toFixed(2));

                                    var totaltax = 0;

                                    $("#table tbody tr").each(function () {
                                        var tax = $(this).find(".item-tax").val();
                                        totaltax = parseInt(totaltax) + parseInt(tax);
                                    });

                                    console.log("tax", totaltax);

                                    // $('.total_tax').text(totaltax.toFixed(2));
                                    // $('#total_tax').val(totaltax.toFixed(2));
                                });

                                //          // Get input fields
                                //          var quantity = row.find('td:eq(1)');
                                //   var rate = $("#rate");
                                //   var discount = $("#discount");
                                //   var tax = $("#tax");

                                //   var quantity = row.find('td:eq(1)').text();

                                //   // Get amount field
                                //   var amount = $("#amount");

                                //   // Add event listeners to input fields
                                //   quantity.on("input", calculateAmount);
                                //   rate.on("input", calculateAmount);
                                //   discount.on("input", calculateAmount);
                                //   tax.on("input", calculateAmount);

                                //   // Function to calculate amount
                                //   function calculateAmount() {
                                //     var quantityVal = parseFloat(quantity.val());
                                //     var rateVal = parseFloat(rate.val());
                                //     var discountVal = parseFloat(discount.val());
                                //     var taxVal = parseFloat(tax.val());

                                //     // Calculate amount
                                //     var amountVal = quantityVal * rateVal;
                                //     amountVal -= amountVal * discountVal / 100;
                                //     amountVal += amountVal * taxVal / 100;

                                //     // Update amount field
                                //     amount.val(amountVal.toFixed(2));
                                //   }
                            });
                        </script>
                    </div>
                </div>
            </div>

            <!-- <form action="/quotation/save" method="get" enctype="multipart/form-data"> -->

            <div class="row">
                <div class="col-6">
                    <div style="padding: 10px 0;" class="">
                        Customer Notes
                        <input style="width: 300px;" type="text" class="form-control" name="customer_note" id="" value="{{ $quotation->customer_note }}"/>
                    </div>

                    <div style="padding: 10px 0;" class="">
                        Terms & Conditions
                        <textarea name="terms" class="form-control" rows="2">{{ $quotation->terms }}</textarea>
                    </div>
                    <div style="padding: 10px 0;" class="">
                        File Upload
                        <input type="file" name="quotation_file" class="form-control" />
                    </div>
                </div>
                <div class="col-6 vat">
                    <div style="padding: 10px 0;" class="row">
                        <div class="col-6">
                            Subtotal
                        </div>
                        <div class="col-6">
                            <h6 class="subtotal" style="text-align: center;">0</h6>
                            <input id="subtotal" type="hidden" class="form-control" name="subtotal" value="{{ $quotation->subtotal }}"/>
                        </div>
                    </div>
                    <div class="row gst-18"></div>
                    <div class="row gst-20"></div>
                    <div class="row gst-26"></div>
                    <div class="row other-tax"></div>

                    <div style="padding: 10px 0;" class="row">
                        <div class="col-6">
                            Shipping Charges
                            <input style="width: 100px;" type="text" class="form-control" name="shipping_charge" id="quotation-shipping-charge" value="{{ $quotation->shipping_charge }}"/>
                        </div>
                        <div class="col-6">
                            <h6 id="shipping-charge" style="text-align: center;">0</h6>
                            <input id="" type="hidden" class="form-control" name="" value="0" />
                        </div>
                    </div>
                    <div style="padding: 10px 0;" class="row">
                        <div class="col-6">
                            Adjustment
                            <input style="width: 100px;" type="text" class="form-control" name="adjustment_charge" id="quotation-adjustment" value="{{ $quotation->adjustment_charge }}"/>
                        </div>
                        <div class="col-6">
                            <h6 class="quotation-adjustment" style="text-align: center;">0</h6>
                            <input type="hidden" class="form-control" value="0" />
                        </div>
                    </div>
                    <div style="padding: 10px 0;" class="row">
                        <div class="col-6">
                            <div style="font-weight: bold;">Total <span id="currency"></span></div>
                        </div>
                        <div class="col-6">
                            <h6 class="total" style="text-align: center;">{{ $quotation->total }}</h6>
                            <input id="total" type="hidden" class="form-control" name="quotation_total" value="{{ $quotation->total }}"/>

                            <script>
                                  // Get all the hotel price cells and calculate the total
                                  const hotelPriceCells = document.querySelectorAll('#table .hotel-price');
                                  let totalHotelPrice = 0;
                                  for (let i = 0; i < hotelPriceCells.length; i++) {
                                    totalHotelPrice += parseFloat(hotelPriceCells[i].textContent);
                                  }

                                  // Display the total
                                //   const totalHotelPriceCell = document.createElement('td');
                                //   totalHotelPriceCell.textContent = totalHotelPrice.toFixed(2);
                                //   document.querySelector('.total').appendChild(totalHotelPriceCell);

                                  $(document).ready(function() {


                                    $('.subtotal').text(totalHotelPrice.toFixed(2));
                                    $('#subtotal').val(totalHotelPrice.toFixed(2));
                                    $('.total').text(totalHotelPrice.toFixed(2));
                                    $('#total').val(totalHotelPrice.toFixed(2));

                                    var tax=0;
                                    $('#table tbody tr').each(function() {
                                        var amount = $(this).find('.hotel-price').text().replace(/\D/g, '');
                                        var rate = $(this).find('.tax-rat').text().replace(/\D/g, '');
                                        var tax =  parseFloat(amount) * (parseFloat(rate) / 100);

                                        $(this).find('.item-tax').val(tax);

                                    });

                                    var othertax=0;

                                    $('#table tbody tr').each(function() {
                                        var rate = $(this).find('.tax-rat').text().replace(/\D/g, '');

                                        if (rate==0) {
                                            var taxamount = $(this).find('.tax-amt').text();
                                            othertax = parseFloat(othertax) + parseFloat(taxamount);
                                        }



                                    });

                                    if (othertax > 0) {
                                        $('.other-tax').append('<div class="col-6">Other Tax</div><div class="col-6"><h6 class="" style="text-align:center;">'+ othertax.toFixed(2) +'</h6><input id="" type="hidden" class="form-control" name="tax"></div>');
                                    }




                                    // Define GST rates and their names

                                    var gstArray = {!! json_encode($taxmaster->toArray()) !!};


                                // Calculate tax amount for each GST rate
                                var gstTotals = {};
                                for (var i = 0; i < gstArray.length; i++) {
                                    var rate = gstArray[i].sales_rate;
                                    var name = gstArray[i].tax_name;
                                    var total = 0;

                                    $('#table tbody tr').each(function() {
                                        var taxrate = $(this).find('.tax-rat').text().replace(/\D/g, '');

                                        if (taxrate == rate) {
                                            var taxamount = $(this).find('.item-tax').val();
                                            total += parseFloat(taxamount);
                                        }
                                    });

                                    gstTotals[rate] = total;

                                    // Output the GST total in the HTML

                                    if (total > 0) {
                                        $('.gst-' + rate).html('<div class="col-6">' + name + '</div><div class="col-6"><h6 class="" style="text-align:center;">' + total.toFixed(2) + '</h6><input id="" type="hidden" class="form-control" name="tax"></div>');
                                    }

                                }


                                    // ____________________________



                                    var totaltax=0;
                                    $('#table tbody tr').each(function() {
                                        var taxamount = $(this).find('.item-tax').val();
                                        totaltax = parseFloat(totaltax) + parseFloat(taxamount);

                                        console.log("tx", totaltax)

                                    });

                                    console.log("tx", totaltax)


                                    $('.total_tax').text(totaltax.toFixed(2));
                                    $('#total_tax').val(totaltax.toFixed(2));




                                    $('#tax-type').change(function() {

                                var type = $(this).val();

                                if (type == "inclusive") {
                                  // code block for inclusive type

                                  var total = 0;

                                $('#table tbody tr').each(function() {
                                    var amount = $(this).find('.hotel-price').text().replace(/\D/g, '');
                                    total = parseInt(total) + parseInt(amount);
                                });

                                totalAmount= total;

                                    $('.total').text(totalAmount.toFixed(2));
                                    $('#total').val(totalAmount.toFixed(2));


                                } else if (type == "exclusive") {
                                  // code block for exclusive type


                                        var total = 0;

                                    $('#table tbody tr').each(function() {
                                        var amount = $(this).find('.hotel-price').text().replace(/\D/g, '');
                                        total = parseInt(total) + parseInt(amount);
                                    });



                                    var totaltax = 0;

                                    $('#table tbody tr').each(function() {
                                        var tax = $(this).find('.item-tax').val();
                                        totaltax = parseInt(totaltax) + parseInt(tax);
                                    });

                                    totalAmount= total + totaltax;

                                    $('.total').text(totalAmount.toFixed(2));
                                    $('#total').val(totalAmount.toFixed(2));

                                    console.log(" total final", totalAmount)

                                }


                                    });



                                    // var price = $('#hotel-price').text();

                                //     const hotelPriceCells = $('#hotel-price');
                                //   let totalHotelPrice = 0;
                                //   for (let i = 0; i < hotelPriceCells.length; i++) {
                                //     totalHotelPrice += parseFloat(hotelPriceCells[i].text);
                                //   }




                                //   $('#item-details').on('change', function() {

                                //       var initialOther = {!! json_encode($other->toArray()) !!};

                                //       var selectedType = $(this).val();

                                //     var filteredOther = initialOther.filter(function(other) {
                                //       return other.item_name == selectedType ;
                                //     });


                                //    // Update the visa options
                                //         $('#item-price').val(filteredOther[0].sales_price);
                                //         $('#item-invoice').val(filteredOther[0].sales_price);
                                //         $('#item-total').val(filteredOther[0].sales_price);


                                //   });


                                //   $('#item-tax-rate').change(function() {

                                //   var totalAmount = $('#item-price').val();
                                //   var taxRate = $('#item-tax-rate').val();
                                //   var rate = parseInt(taxRate) / 100;
                                //   console.log(totalAmount)
                                //   console.log(taxRate)

                                //   var taxAmount = totalAmount * rate;
                                //   // $('#item-tax').val(taxAmount);

                                //   $('#item-invoice').val(parseInt(totalAmount) + parseInt(taxAmount));

                                //   });

                                //   $('#item-tax').on('change', function() {

                                //       var itemInvoice = $('#item-invoice');
                                //       var taxAmount = $('#item-tax');
                                //       var itemPrice =   $('#item-price').val();

                                //       itemInvoice.val(parseInt(itemPrice) + parseInt(taxAmount.val()));

                                //   });

                                  $('#quotation-shipping-charge').on('change', function() {


                                     inputVal = $(this).val();
                                    $('#shipping-charge').text(inputVal);


                                      var itemPrice = $('.total');
                                      var newPrice = $('#total');
                                      shippingPrice = $('.quotation-adjustment').text();


                                      total = parseFloat(newPrice.val()) + parseFloat(inputVal) + parseFloat(shippingPrice);

                                      itemPrice.text(total);

                                      console.log(itemPrice)

                                  });

                                  $('#quotation-adjustment').on('change', function() {

                                  inputVal = $(this).val();
                                 $('.quotation-adjustment').text(inputVal);


                                   var itemPrice = $('.total');
                                   var newPrice = $('#total');
                                    adjustmentPrice = $('#shipping-charge').text();

                                   total = parseFloat(newPrice.val()) + parseFloat(inputVal) + parseFloat(adjustmentPrice);

                                   itemPrice.text(total);

                                   console.log(itemPrice)

                                });


                                // var selectedType = $(this).val();


                                // var price = filteredBed[0].price;
                                // // console.log(price)
                                // $('#bed-price').val(filteredBed[0].price);

                                // // console.log(price)
                                // var bedp = $('#bed-price').val();
                                // var mealp =$('#meal-price').val();
                                // realPrice= $('.hotel_price').val(parseInt(bedp) + parseInt(mealp));

                                // //   realPrice= $('.hotel_price').val(response.data.price);

                                // var hotelInvoice = $('#hotel-invoice');
                                // var taxAmount = $('#hotel-tax');

                                // hotelInvoice.val(parseInt(realPrice.val()) + parseInt(taxAmount.val()));


                                var a = 1;
                                var b = 1;
                                var c = 1;
                                var d = 1;
                                var e = 1;
                                var f = 1;
                                var g = 1;
                                $('#table tbody tr').each(function() {

                                    $(this).find('.itm-details').attr('name', 'item_details[' + a++ + ']');
                                    $(this).find('.itm-qty').attr('name', 'quantity[' + b++ + ']');
                                    $(this).find('.itm-rate').attr('name', 'rate[' + c++ + ']');
                                    $(this).find('.itm-discount').attr('name', 'discount[' + d++ + ']');
                                    $(this).find('.itm-tax-rate').attr('name', 'tax_rate[' + e++ + ']');
                                    $(this).find('.itm-tax-amount').attr('name', 'tax_amount[' + f++ + ']');
                                    $(this).find('.itm-price').attr('name', 'total[' + g++ + ']');

                                });



                                });
                            </script>
                        </div>
                    </div>
                </div>
            </div>

            <!--<div style="padding: 0 20px;" class="row pt-2 mt-4">-->
            <!--    <div class="col-6"></div>-->
            <!--    <div style="text-align: right;" class="col-6">-->
            <!--        <button class="btn btn-primary text-right">Submit</button>-->
            <!--    </div>-->
            <!--</div>-->

        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" style="padding: 3rem;">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">
                    Modal title
                </h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="mb-3">
                            <label class="form-label">Select Your Services </label>
                            <select class="country form-select iqs" id="SelectA" onclick="display()" data-width="100%">
                                <option class="iqss" selected>Select </option>
                                <option value="aa">Hotel</option>
                                <option value="bb">Package</option>
                                <option value="cc">Flight</option>
                                <option value="dd">Visa</option>
                                <option value="ee">Insurance</option>
                                <option value="ff">Inventory</option>
                                <option value="gg">Car Hire</option>
                                <option value="hh">Assist</option>
                                <option value="ii">Other</option>
                            </select>
                            <script>
                                function display() {
                                    var x = document.getElementById("SelectA").value;
                                    console.log(x);

                                    if (x == "aa") {
                                        document.getElementById("a").style.display = "block";
                                        document.getElementById("b").style.display = "none";
                                        document.getElementById("c").style.display = "none";
                                        document.getElementById("d").style.display = "none";
                                        document.getElementById("e").style.display = "none";
                                        document.getElementById("f").style.display = "none";
                                        document.getElementById("g").style.display = "none";
                                        document.getElementById("h").style.display = "none";
                                        document.getElementById("i").style.display = "none";
                                        document.getElementById("noForm").style.display = "none";
                                    } else if (x == "bb") {
                                        document.getElementById("a").style.display = "none";
                                        document.getElementById("b").style.display = "block";
                                        document.getElementById("c").style.display = "none";
                                        document.getElementById("d").style.display = "none";
                                        document.getElementById("e").style.display = "none";
                                        document.getElementById("f").style.display = "none";
                                        document.getElementById("g").style.display = "none";
                                        document.getElementById("h").style.display = "none";
                                        document.getElementById("i").style.display = "none";
                                        document.getElementById("noForm").style.display = "none";
                                    } else if (x == "cc") {
                                        document.getElementById("a").style.display = "none";
                                        document.getElementById("b").style.display = "none";
                                        document.getElementById("c").style.display = "block";
                                        document.getElementById("d").style.display = "none";
                                        document.getElementById("e").style.display = "none";
                                        document.getElementById("f").style.display = "none";
                                        document.getElementById("g").style.display = "none";
                                        document.getElementById("h").style.display = "none";
                                        document.getElementById("i").style.display = "none";
                                        document.getElementById("noForm").style.display = "none";
                                    } else if (x == "dd") {
                                        document.getElementById("a").style.display = "none";
                                        document.getElementById("b").style.display = "none";
                                        document.getElementById("c").style.display = "none";
                                        document.getElementById("d").style.display = "block";
                                        document.getElementById("e").style.display = "none";
                                        document.getElementById("f").style.display = "none";
                                        document.getElementById("g").style.display = "none";
                                        document.getElementById("h").style.display = "none";
                                        document.getElementById("i").style.display = "none";
                                        document.getElementById("noForm").style.display = "none";
                                    } else if (x == "ee") {
                                        document.getElementById("a").style.display = "none";
                                        document.getElementById("b").style.display = "none";
                                        document.getElementById("c").style.display = "none";
                                        document.getElementById("d").style.display = "none";
                                        document.getElementById("e").style.display = "block";
                                        document.getElementById("f").style.display = "none";
                                        document.getElementById("g").style.display = "none";
                                        document.getElementById("h").style.display = "none";
                                        document.getElementById("i").style.display = "none";
                                        document.getElementById("noForm").style.display = "none";
                                    } else if (x == "ff") {
                                        document.getElementById("a").style.display = "none";
                                        document.getElementById("b").style.display = "none";
                                        document.getElementById("c").style.display = "none";
                                        document.getElementById("d").style.display = "none";
                                        document.getElementById("e").style.display = "none";
                                        document.getElementById("f").style.display = "block";
                                        document.getElementById("g").style.display = "none";
                                        document.getElementById("h").style.display = "none";
                                        document.getElementById("i").style.display = "none";
                                        document.getElementById("noForm").style.display = "none";
                                    } else if (x == "gg") {
                                        document.getElementById("a").style.display = "none";
                                        document.getElementById("b").style.display = "none";
                                        document.getElementById("c").style.display = "none";
                                        document.getElementById("d").style.display = "none";
                                        document.getElementById("e").style.display = "none";
                                        document.getElementById("f").style.display = "none";
                                        document.getElementById("g").style.display = "block";
                                        document.getElementById("h").style.display = "none";
                                        document.getElementById("i").style.display = "none";
                                        document.getElementById("noForm").style.display = "none";
                                    } else if (x == "hh") {
                                        document.getElementById("a").style.display = "none";
                                        document.getElementById("b").style.display = "none";
                                        document.getElementById("c").style.display = "none";
                                        document.getElementById("d").style.display = "none";
                                        document.getElementById("e").style.display = "none";
                                        document.getElementById("f").style.display = "none";
                                        document.getElementById("g").style.display = "none";
                                        document.getElementById("h").style.display = "block";
                                        document.getElementById("i").style.display = "none";
                                        document.getElementById("noForm").style.display = "none";
                                    } else if (x == "ii") {
                                        document.getElementById("a").style.display = "none";
                                        document.getElementById("b").style.display = "none";
                                        document.getElementById("c").style.display = "none";
                                        document.getElementById("d").style.display = "none";
                                        document.getElementById("e").style.display = "none";
                                        document.getElementById("f").style.display = "none";
                                        document.getElementById("g").style.display = "none";
                                        document.getElementById("h").style.display = "none";
                                        document.getElementById("i").style.display = "block";
                                        document.getElementById("noForm").style.display = "none";
                                    }
                                }
                            </script>

                            <br />

                            <div id="a" style="display: none;">
                                <form action="/quotation/hotelservice/add" method="POST" enctype="multipart/form-data">
                                    @csrf
                                    <input class="userId" type="hidden" name="user_id" value="" />
                                    <input class="dsr_number" type="hidden" name="dsr_number" value="{{$id}}" />
                                    <div>
                                        <div class="row">
                                            <h3 style="margin-bottom: 0.45em; font-family: auto;">
                                                Hotel
                                            </h3>
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Hotel Name </label>
                                                    <select name="hotel_name" id="hotel_room_name" class="form-select" data-width="100%">
                                                        <option selected>
                                                            Select
                                                        </option>
                                                        @foreach($hotels as $hotel)
                                                        <option value="{{$hotel->hotel_name}}">{{$hotel->hotel_name}}</option>
                                                        @endforeach
                                                    </select>

                                                    <script>
                                                            $('#hotel_room_name').on('change', function() {
                                                                var selectedValue = $(this).val();

                                                                $.ajax({
                                                                    url: '/roomno-data',
                                                                    type: 'GET',
                                                                    data: {
                                                                        selected_value: selectedValue
                                                                    },
                                                                    success: function(response) {
                                                                        console.log("roomd",response);
                                                                       // Remove existing options from the select element
                                                                    $('#hotel_room_no').empty();

                                                                    $('#hotel_room_no').prop('disabled', false);


                                                            // Loop through the data and create a new option element for each item
                                                                response.data.forEach(function(item) {
                                                                var option = $('<option>', { value: item.room_name_number, text: item.room_name_number });
                                                               $('#hotel_room_no').append(option);
                                                            });

                                                            // $('#meal').empty();


                                                            // response.data.forEach(function(item) {
                                                            //     var meal = $('<option>', { value: item.meal, text: item.meal });
                                                            //    $('#meal').append(meal);
                                                            // });

                                                            // $('#bed').empty();


                                                            // response.data.forEach(function(item) {
                                                            //     var bed = $('<option>', { value: item.bed, text: item.bed });
                                                            //    $('#bed').append(bed);
                                                            // });


                                                            // $('#hotel_price').val(response.data[0].price);


                                                                    }
                                                                });
                                                            });

                                                            $(document).ready(function() {
                                                            // Store the initial insurance data
                                                            var initialRoom= {!! json_encode($room->toArray()) !!};
                                                            var initialBed= {!! json_encode($bed->toArray()) !!};
                                                            var initialMeal= {!! json_encode($meal->toArray()) !!};


                                                            $('#hotel_room_no').on('change', function() {


                                                            var selectedType = $(this).val();

                                                          var filteredRoom = initialRoom.filter(function(room) {
                                                            return room.room_name_number == selectedType ;
                                                          });
                                                          console.log(filteredRoom)

                                                          var id = filteredRoom[0].id;
                                                          console.log(id)
                                                          var occupancy = filteredRoom[0].occupancy;


                                                          var filteredBed = initialBed.filter(function(bed) {
                                                            return bed.room_id == id ;
                                                          });

                                                          var filteredMeal = initialMeal.filter(function(meal) {
                                                            return meal.room_id == id ;
                                                          });

                                                          console.log(bed)

                                                         // Update the visa options
                                                              $('#bed').empty();
                                                              $('#meal').empty();
                                                              $('#occupancy').val(occupancy);
                                                              $('#bed').append('<option selected>Select</option>');
                                                              filteredBed.forEach(function(bed) {
                                                                $('#bed').append('<option value="' + bed.bed + '">' + bed.bed + ' ' + bed.price +  '</option>');
                                                              });

                                                              $('#meal').append('<option selected>Select</option>');
                                                              filteredMeal.forEach(function(meal) {
                                                                $('#meal').append('<option value="' + meal.meal + '">' + meal.meal + ' ' + meal.price + '</option>');
                                                              });





                                                        });

                                                           $('#bed').on('click', function() {

                                                            var selectedType = $(this).val();

                                                            var filteredBed = initialBed.filter(function(bed) {
                                                            return bed.bed == selectedType ;
                                                            });

                                                            var price = filteredBed[0].price;
                                                            // console.log(price)
                                                            $('#bed-price').val(filteredBed[0].price);

                                                        // console.log(price)
                                                        var bedp = $('#bed-price').val();
                                                        var mealp =$('#meal-price').val();
                                                         realPrice= $('.hotel_price').val(parseInt(bedp) + parseInt(mealp));

                                                            //   realPrice= $('.hotel_price').val(response.data.price);

                                                                        var hotelInvoice = $('#hotel-invoice');
                                                            var taxAmount = $('#hotel-tax');

                                                          hotelInvoice.val(parseInt(realPrice.val()) + parseInt(taxAmount.val()));


                                                           });

                                                           $('#meal').on('click', function() {

                                                        var selectedType = $(this).val();

                                                        var filteredMeal = initialMeal.filter(function(meal) {
                                                        return meal.meal == selectedType ;
                                                        });

                                                        // console.log(price)

                                                        var price = filteredMeal[0].price;
                                                        $('#meal-price').val(filteredMeal[0].price);

                                                        // console.log(price)
                                                        var bedp = $('#bed-price').val();
                                                        var mealp =$('#meal-price').val();
                                                        realPrice= $('.hotel_price').val(parseInt(bedp) + parseInt(mealp));

                                                            //   realPrice= $('.hotel_price').val(response.data.price);

                                                                        var hotelInvoice = $('#hotel-invoice');
                                                            var taxAmount = $('#hotel-tax');

                                                          hotelInvoice.val(parseInt(realPrice.val()) + parseInt(taxAmount.val()));

                                                        });



                                                        });
                                                    </script>
                                                    <input type="hidden" id="meal-price" />
                                                    <input type="hidden" id="bed-price" />
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Room Numbers/Name </label>
                                                    <select name="room_name_number" id="hotel_room_no" class="form-select room_name_no" data-width="100%" disabled>
                                                        <option selected>
                                                            Select
                                                        </option>
                                                    </select>

                                                    <script>
                                                        var realPrice;
                                                        $(".room_name_n").on("click", function () {
                                                            var selectedValue = $(this).val();

                                                            $.ajax({
                                                                url: "/room-data",
                                                                type: "GET",
                                                                data: {
                                                                    selected_value: selectedValue,
                                                                },
                                                                success: function (response) {
                                                                    console.log("room", response);
                                                                    // Set the data as the value of the input field
                                                                    $("#meal").val(response.data.meal);
                                                                    $("#occupancy").val(response.data.occupancy);
                                                                    $("#bed").val(response.data.bed);
                                                                    realPrice = $(".hotel_price").val(response.data.price);

                                                                    var hotelInvoice = $("#hotel-invoice");
                                                                    var taxAmount = $("#hotel-tax");

                                                                    hotelInvoice.val(parseInt(realPrice.val()) + parseInt(taxAmount.val()));
                                                                },
                                                            });
                                                            console.log("test", realPrice);
                                                        });
                                                    </script>
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Occupancy</label>
                                                    <!-- <select name="bed" id="bed" class="form-select" data-width="100%">
                                                                                            <option Selected>
                                                                                                Select
                                                                                            </option>
                                                                                            
                                                                                        </select> -->
                                                    <input name="occupancy" type="text" class="form-control" id="occupancy" />
                                                </div>
                                            </div>
                                        </div>
                                        <!-- </div> -->
                                        <div class="row">
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Meal Plan</label>
                                                    <select name="meal" id="meal" class="form-select" data-width="100%">
                                                        <option selected>
                                                            Select
                                                        </option>
                                                    </select>
                                                    <!-- <input name="meal" type="text" class="form-control" id="meal"> -->
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Bed</label>
                                                    <select name="bed" id="bed" class="form-select" data-width="100%">
                                                        <option selected>
                                                            Select
                                                        </option>
                                                    </select>
                                                    <!-- <input name="bed" type="text" class="form-control" id="bed"> -->
                                                </div>
                                            </div>

                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <!-- <label class="form-label">Guest
                                                                                            Name</label> -->
                                                    <div>
                                                        <!-- <select id="gest" class="guest form-select" name="guest[]" multiple="multiple">

                                                                                            @foreach($passengers as $data)
                                                                                               <option value="Name">Name</option>
                                                                                               <option value="Name">Name</option>
                                                                                               <option value="Name">Name</option>
                                                                                               <option value="Name">{{$data->name}}</option>
                                                                                            @endforeach
                                                                                     </select> -->
                                                        <!-- <div class="multi-select">
  <div class="selected-items">
    <span>Select Guest</span>
  </div>
  <div class="items-list">
    <ul>
    @foreach($passengers as $data)
     <li><label><input name="guest[]" type="checkbox" value="{{$data->name}}" required>{{$data->name}}</label></li>
    @endforeach
    </ul>
  </div>
</div> -->

                                                        <!-- jQuery code -->
                                                        <script>
                                                            $(document).ready(function () {
                                                                // hide the items list by default
                                                                $(".multi-select .items-list").hide();

                                                                // toggle the items list when clicking on the selected items div
                                                                $(".multi-select .selected-items").on("click", function () {
                                                                    $(".multi-select .items-list").toggle();
                                                                });

                                                                // update the selected items when a checkbox is clicked
                                                                $(".multi-select .items-list input[type=checkbox]").on("change", function () {
                                                                    var selectedItems = [];
                                                                    $(".multi-select .items-list input[type=checkbox]:checked").each(function () {
                                                                        selectedItems.push($(this).parent().text().trim());
                                                                    });

                                                                    if (selectedItems.length == 0) {
                                                                        $(".multi-select .selected-items span").html("Select Items");
                                                                    } else if (selectedItems.length == 1) {
                                                                        $(".multi-select .selected-items span").html(selectedItems[0]);
                                                                    } else {
                                                                        $(".multi-select .selected-items span").html(selectedItems.length + " Items Selected");
                                                                    }
                                                                });
                                                            });
                                                        </script>

                                                        <!-- CSS code -->
                                                        <style>
                                                            .multi-select {
                                                                position: relative;
                                                                width: 200px;
                                                            }

                                                            .multi-select .selected-items {
                                                                background-color: #eee;
                                                                border: 1px solid #ccc;
                                                                cursor: pointer;
                                                                padding: 5px;
                                                            }

                                                            .multi-select .items-list {
                                                                background-color: #fff;
                                                                border: 1px solid #ccc;
                                                                border-top: none;
                                                                max-height: 150px;
                                                                overflow-y: auto;
                                                                position: absolute;
                                                                top: 100%;
                                                                left: 0;
                                                                right: 0;
                                                                z-index: 1;
                                                            }

                                                            .multi-select .items-list ul {
                                                                list-style: none;
                                                                margin: 0;
                                                                padding: 5px;
                                                            }

                                                            .multi-select .items-list li {
                                                                margin-bottom: 5px;
                                                            }

                                                            .multi-select .items-list label {
                                                                display: block;
                                                                padding: 5px;
                                                            }

                                                            .multi-select .items-list input[type="checkbox"] {
                                                                margin-right: 5px;
                                                            }
                                                        </style>

                                                        <script>
                                                            //                                                                                       $(document).ready(function() {
                                                            //     $('.guest').select2({
                                                            //         placeholder: 'Guest name',
                                                            //         allowClear: true,
                                                            //         tags: true // With this, you can add data that are not in the select options
                                                            //     });
                                                            // });
                                                        </script>

                                                        <!-- <select class="form-select any" name="guestz[]"  data-width="100%" multiple>
                                                                                               <option value="Hello">Hello</option>
                                                                                               <option value="Hi">Hi</option>
                                                                                     </select> -->

                                                        <script></script>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Col -->

                                            <!-- Col -->
                                        </div>
                                        <!-- Row -->

                                        <div class="row">
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label" for="DateOfBirth" class="">Booking Date </label><label class="" style="color: red;">*</label>
                                                    <input name="booking_date" type="date" class="form-control" value="" value="{{ date('Y-m-d') }}" /><small style="color: red;"></small>
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label" class="">Start Date </label><label class="" style="color: red;">*</label><input name="start_date" type="date" class="form-control" value="" />
                                                    <small style="color: red;"></small>
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label" class="">End Date </label><label class="" style="color: red;">*</label><input name="end_date" type="date" class="form-control" value="" />
                                                    <small style="color: red;"></small>
                                                </div>
                                            </div>

                                            <!-- <div class="col-sm-4">
                                                                                    <div class="mb-3">
                                                                                        <label class="form-label">Supplier
                                                                                        </label>
                                                                                        <select name="supplier" class="form-select" data-width="100%">
                                                                                            <option Selected>
                                                                                                Select
                                                                                            </option>
                                                                                            <option>Transcon
                                                                                                Exports
                                                                                            </option>
                                                                                            <option>Infosys
                                                                                            </option>
                                                                                            <option>TPS
                                                                                                Serena
                                                                                            </option>

                                                                                        </select>
                                                                                    </div>
                                                                                </div> -->

                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Total Days</label>
                                                    <!-- <input name="total_night" type="number"  class="form-control" placeholder="Total Night" value="1"> -->
                                                    <div class="input-group">
                                                        <div class="input-group-prepend">
                                                            <button class="btn btn-outline-secondary" type="button" id="decrement">-</button>
                                                        </div>
                                                        <input type="number" class="form-control text-center" id="quantity" name="total_night" value="1" />
                                                        <div class="input-group-append">
                                                            <button class="btn btn-outline-secondary" type="button" id="increment">+</button>
                                                        </div>
                                                    </div>

                                                    <script>
                                                        $(document).ready(function () {
                                                            // Get the input element and the increment and decrement buttons
                                                            var quantityInput = $("#quantity");
                                                            var decrementButton = $("#decrement");
                                                            var incrementButton = $("#increment");
                                                            var hotelPrice = $("#hotel_price");
                                                            var price = $("#real_price");
                                                            var hotelInvoice = $("#hotel-invoice");
                                                            var taxAmount = $("#hotel-tax");

                                                            // Add event listeners for the button clicks
                                                            decrementButton.on("click", function () {
                                                                // Get the current value of the input
                                                                var currentValue = parseInt(quantityInput.val());

                                                                // Decrement the value if it is greater than 1
                                                                if (currentValue > 1) {
                                                                    quantityInput.val(currentValue - 1);

                                                                    hotelPrice.val(parseInt(price.val()) * quantityInput.val());

                                                                    hotelInvoice.val(parseInt(realPrice.val()) + parseInt(taxAmount.val()));

                                                                    var totalAmount = $("#hotel_price").val();
                                                                    var taxRate = $("#hotel-tax-rate").val();
                                                                    var rate = parseInt(taxRate) / 100;

                                                                    var totalTax = totalAmount * rate;
                                                                    $("#hotel-tax").val(totalTax);

                                                                    hotelInvoice.val(parseInt(realPrice.val()) + totalTax);
                                                                }
                                                            });

                                                            incrementButton.on("click", function () {
                                                                // Get the current value of the input
                                                                var currentValue = parseInt(quantityInput.val());

                                                                // Increment the value
                                                                quantityInput.val(currentValue + 1);

                                                                var currentPrice = parseInt(hotelPrice.val());

                                                                hotelPrice.val(parseInt(price.val()) * quantityInput.val());
                                                                //   console.log(realPrice.val())

                                                                var totalAmount = $("#hotel_price").val();
                                                                var taxRate = $("#hotel-tax-rate").val();
                                                                var rate = parseInt(taxRate) / 100;

                                                                var totalTax = totalAmount * rate;
                                                                $("#hotel-tax").val(totalTax);

                                                                hotelInvoice.val(parseInt(realPrice.val()) + totalTax);
                                                            });
                                                        });

                                                        $(document).ready(function () {
                                                            $("#supplier-charge").change(function () {
                                                                var hotelRetain = $("#hotel-retain");
                                                                var inputVal = $(this).val();

                                                                console.log("Input Value:", inputVal);

                                                                hotelRetain.val(parseInt(realPrice.val()) - inputVal);
                                                            });

                                                            $("#hotel-tax").change(function () {
                                                                var hotelInvoice = $("#hotel-invoice");
                                                                var taxAmount = $("#hotel-tax");

                                                                hotelInvoice.val(parseInt(realPrice.val()) + parseInt(taxAmount.val()));
                                                            });

                                                            $("#hotel-tax-rate").change(function () {
                                                                // $('#hotel-tax').prop('disabled', true);

                                                                var totalAmount = $("#hotel_price").val();
                                                                var taxRate = $("#hotel-tax-rate").val();
                                                                var rate = parseInt(taxRate) / 100;
                                                                console.log(totalAmount);
                                                                console.log(taxRate);

                                                                var taxAmount = totalAmount * rate;
                                                                $("#hotel-tax").val(taxAmount);

                                                                $("#hotel-invoice").val(parseInt(realPrice.val()) + parseInt(taxAmount));
                                                            });

                                                            $("#hotel-sas-tax").change(function () {
                                                                var totalAmount = $("#hotel_price").val();
                                                                var taxRate1 = $("#hotel-tax-rate").val();
                                                                var taxRate2 = $("#hotel-sas-tax").val();
                                                                taxRate = parseInt(taxRate1) + parseInt(taxRate2);
                                                                var rate = parseInt(taxRate) / 100;
                                                                console.log(totalAmount);
                                                                console.log(taxRate);

                                                                var taxAmount = totalAmount * rate;
                                                                $("#hotel-tax").val(taxAmount);

                                                                $("#hotel-invoice").val(parseInt(realPrice.val()) + parseInt(taxAmount));
                                                            });

                                                            var hotelInvoice = $("#hotel-invoice");
                                                            var taxAmount = $("#hotel-tax");

                                                            hotelInvoice.val(parseInt(realPrice.val()) + parseInt(taxAmount.val()));
                                                        });
                                                    </script>
                                                </div>
                                            </div>
                                            <!-- Col -->
                                        </div>

                                        <div class="row"></div>

                                        <hr />
                                        <br />

                                        <div class="row">
                                            <div class="col-sm-6">
                                                <!-- <label for="myfile">
                                                                                            <h4>Hotel
                                                                                                Details
                                                                                            </h4>
                                                                                        </label>
                                                                                        <br />
                                                                                        <br />
                                                                                        <input name="hotel_details" type="file">
                                                                                    <br />
                                                                                    <br />
                                                                                    <br />
                                                                                    <div class="mb-3">
                                                                                        <label for="exampleFormControlTextarea1" class="form-label">
                                                                                            <h4>Note</h4>
                                                                                        </label>
                                                                                        <textarea name="remark" class="form-control" id="exampleFormControlTextarea1" rows="3" placeholder="Remark"></textarea>
                                                                                    </div> -->
                                            </div>

                                            <div class="col-sm-6">
                                                <!-- <div class="row">
                                                                                        <div class="col-sm-2">

                                                                                        </div>
                                                                                        <div class="col-sm-4">
                                                                                            <label class="form-label">Supplier
                                                                                                Service
                                                                                                Charge
                                                                                            </label>
                                                                                        </div>
                                                                                        <div class="col-sm-6">
                                                                                            <input id="supplier-charge" name="supplier_service_charge" type="number" class="form-control" value="0">
                                                                                        </div>
                                                                                    </div>
                                                                                    <br /> -->
                                                <div class="row">
                                                    <div class="col-sm-2"></div>
                                                    <div class="col-sm-4">
                                                        <label class="form-label">Hotel Price</label>
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <input id="hotel_price" name="hotel_price" type="number" class="form-control hotel_price" value="0" />
                                                        <input id="real_price" type="hidden" class="form-control hotel_price" value="0" />
                                                    </div>
                                                </div>
                                                <br />
                                                <div class="row">
                                                    <div class="col-sm-2"></div>
                                                    <div class="col-sm-4"><label class="form-label">Tax </label><br /></div>

                                                    <div class="col-sm-6">
                                                        <!-- <input name="" class="form-check-input" type="checkbox" id="check1" name="option1" value="ch" > -->
                                                        <div>
                                                            <script>
                                                                $(document).ready(function () {
                                                                    $(".checktax").click(function () {
                                                                        var inputVal = $(this).val();

                                                                        if (inputVal == "rate") {
                                                                            $("#hotel-tax").hide();
                                                                            $("#hotel-tax-rate").show();

                                                                            $("#hotel-tax").val(0);
                                                                        } else if (inputVal == "amount") {
                                                                            $("#hotel-tax").show();
                                                                            $("#hotel-tax-rate").hide();

                                                                            $("#hotel-tax-rate").val(0);
                                                                        }
                                                                    });
                                                                });
                                                            </script>
                                                            <label>
                                                                <input name="tax_type" class="form-check-input checktax" type="radio" value="rate" />
                                                                Rate
                                                            </label>
                                                            <label>
                                                                <input name="tax_type" class="form-check-input checktax" type="radio" value="amount" />
                                                                Amount
                                                            </label>
                                                        </div>
                                                        <br />

                                                        <input style="display: none;" id="hotel-tax" name="tax_amount" type="number" class="form-control" value="0" />
                                                        <select id="hotel-tax-rate" name="tax_rate" class="form-select" data-width="47.5%">
                                                            <option value="0" selected>
                                                                Select
                                                            </option>
                                                            @foreach($taxmaster as $data)
                                                            <option value="{{$data->sales_rate}}">{{$data->sales_rate}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="align-dropdown-box"></div>
                                                </div>
                                                <!-- <br />
                                                                                    <div class="row">
                                                                                        <div class="col-sm-2">

                                                                                        </div>
                                                                                        <div class="col-sm-4">
                                                                                            <label class="form-label">Invoice
                                                                                                Total</label>
                                                                                        </div>
                                                                                        <div class="col-sm-6">
                                                                                            <input id="hotel-invoice" name="total_amount" type="number" class="form-control" value="0" style="background-color: #f5f5f1;">
                                                                                        </div>
                                                                                    </div>
                                                                                    <br />
                                                                                    <div class="row">
                                                                                        <div class="col-sm-2">

                                                                                        </div>
                                                                                        <div class="col-sm-4">
                                                                                            <label class="form-label">Retain</label>
                                                                                        </div>
                                                                                        <div class="col-sm-6">
                                                                                            <input id="hotel-retain" name="retain" type="number" class="form-control" value="0" style="background-color: #f5f5f1;">
                                                                                        </div>
                                                                                    </div> -->
                                                <br />
                                                 
                                            </div>
                                            
                                        </div>
                                        <br />
                                       <div style="">
                                            <div class="row">
                                                <button type="submit" value="submit" class="btn btn-primary mr-2" style="width: 100px;">ADD</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>

                            <div id="b" style="display: none;">
                                <form action="/quotation/tourservice/add" method="POST" enctype="multipart/form-data">
                                    @csrf
                                    <div>
                                        <div class="row">
                                            <h3 style="margin-bottom: 0.45em; font-family: auto;">
                                                Package
                                            </h3>
                                            <br />
                                        </div>

                                        <script>
                                               $(document).ready(function() {

                                             var initialTour = {!! json_encode($tour->toArray()) !!};


                                            $('#package-name').on('change', function() {

                                                var selectedType = $(this).val();

                                              var filteredTour = initialTour.filter(function(tour) {
                                                return tour.package_name == selectedType ;
                                              });

                                              console.log(filteredTour[0].destination)

                                             // Update the visa options
                                                  $('#destination').val(filteredTour[0].destination);
                                                  $('#tour-price').val(filteredTour[0].price_per_person);
                                                  // $('#item-invoice').val(filteredTour[0].sales_price);
                                                  // $('#item-total').val(filteredTour[0].sales_price);


                                            });


                                            $('#tour-tax-rate').change(function() {

                                            var totalAmount = $('#tour-price').val();
                                            var taxRate = $('#tour-tax-rate').val();
                                            var rate = parseInt(taxRate) / 100;
                                            console.log(totalAmount)
                                            console.log(taxRate)

                                            var taxAmount = totalAmount * rate;
                                            // $('#tour-tax').val(taxAmount);

                                            $('#tour-invoice').val(parseInt(totalAmount) + parseInt(taxAmount));

                                            });

                                            $('#tour-tax').on('change', function() {

                                                var tourInvoice = $('#tour-invoice');
                                                var taxAmount = $('#tour-tax');
                                                var tourPrice =   $('#tour-price').val();

                                                tourInvoice.val(parseInt(tourPrice) + parseInt(taxAmount.val()));

                                            });

                                            $('#tour-supplier-charge').on('change', function() {

                                                var tourRetain = $('#tour-retain');
                                                var tourPrice = $('#tour-price').val();
                                                var inputVal = $(this).val();

                                                tourRetain.val(parseInt(tourPrice) - inputVal);

                                                console.log(inputVal)

                                            });

                                              });
                                        </script>

                                        <div class="row">
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Package Type </label>
                                                    <select id="package-name" name="package" class="form-select" data-width="100%">
                                                        <option selected>
                                                            Select
                                                        </option>
                                                        @foreach($tour as $data)
                                                        <option value="{{$data->package_name}}">{{$data->package_name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Destination </label>
                                                    <input id="destination" name="destination" type="text" class="form-control" value="" />
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <!-- <label class="form-label" for="DateOfBirth" class="">Select
                                                                                            Passenger
                                                                                        </label>
<div class="multi-select">
  <div class="selected-items">
    <span>Select Guest</span>
  </div>
  <div class="items-list">
    <ul>
    @foreach($passengers as $data)
     <li><label><input name="guest[]" type="checkbox" value="{{$data->name}}">{{$data->name}}</label></li>
    @endforeach
    </ul>
  </div>
</div> -->
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-4">
                                                <div class="mb-3"><label class="form-label">Start Date </label><input name="start_date" type="date" class="form-control" value="" /></div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="mb-3"><label class="form-label">End Date </label><input name="end_date" type="date" class="form-control" value="" /></div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Adult</label>
                                                    <input name="adult" type="text" class="form-control" placeholder="Adult" />
                                                </div>
                                            </div>
                                            <!-- Col -->
                                        </div>
                                        <!-- Row -->

                                        <div class="row">
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Children</label>
                                                    <input name="children" type="text" class="form-control" placeholder="Children" />
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Supplier Name </label>
                                                    <select name="supplier" class="form-select" data-width="100%">
                                                        <option selected>
                                                            Select
                                                        </option>
                                                        <option>
                                                            Transcon Exports
                                                        </option>
                                                        <option>
                                                            Infosys
                                                        </option>
                                                        <option>TPS Serena </option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <hr />
                                        <br />
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <label for="myfile">
                                                    <h4>Package Details</h4>
                                                </label>
                                                <br />
                                                <br />
                                                <input type="file" name="tour_details" />
                                                <br />
                                                <br />
                                                <br />
                                                <div class="mb-3">
                                                    <label for="exampleFormControlTextarea1" class="form-label">
                                                        <h4>Note</h4>
                                                    </label>
                                                    <textarea name="remark" class="form-control" id="exampleFormControlTextarea1" rows="3" placeholder="Remark"></textarea>
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <div class="row">
                                                    <div class="col-sm-2"></div>
                                                    <div class="col-sm-4">
                                                        <label class="form-label">Supplier Service Charge</label>
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <input id="tour-supplier-charge" name="supplier_service_charge" type="number" class="form-control" value="0" />
                                                    </div>
                                                </div>
                                                <br />
                                                <div class="row">
                                                    <div class="col-sm-2"></div>
                                                    <div class="col-sm-4">
                                                        <label class="form-label">Package Price</label>
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <input id="tour-price" name="tour_price" type="number" class="form-control" value="0" />
                                                    </div>
                                                </div>
                                                <br />
                                                <div class="row">
                                                    <div class="col-sm-2"></div>
                                                    <div class="col-sm-4"><label class="form-label">Tax Amount</label><br /></div>
                                                    <div class="col-sm-6">
                                                        <!-- <input name="tax_amount" type="number" class="form-control" value="0"> -->
                                                        <select id="tour-tax-rate" name="tax_amount" class="form-select" data-width="47.5%">
                                                            <option selected>
                                                                Select
                                                            </option>
                                                            @foreach($taxmaster as $data)
                                                            <option value="{{$data->sales_rate}}">{{$data->sales_rate}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                                <br />
                                                <div class="row">
                                                    <div class="col-sm-2"></div>
                                                    <div class="col-sm-4">
                                                        <label class="form-label">Invoice Total</label>
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <input id="tour-invoice" name="total_amount" type="number" class="form-control" value="0" style="background-color: #f5f5f1;" />
                                                    </div>
                                                </div>
                                                <br />
                                                <div class="row">
                                                    <div class="col-sm-2"></div>
                                                    <div class="col-sm-4">
                                                        <label class="form-label">Retain</label>
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <input id="tour-retain" type="retain" class="form-control" value="0" style="background-color: #f5f5f1;" />
                                                    </div>
                                                </div>
                                                <br />
                                            </div>
                                        </div>
                                        <br />
                                        <div style="margin-left: 92%;">
                                            <div class="row">
                                                <button type="submit" value="submit" class="btn btn-primary mr-2" style="width: 100px;">ADD</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>

                            <div id="c" style="display: none;">
                                <form action="/quotation/flightservice/add" method="POST" enctype="multipart/form-data">
                                    @csrf
                                    <input class="userId" type="hidden" name="user_id" value="" />
                                    <input class="dsr_number" type="hidden" name="dsr_number" value="{{$id}}" />
                                    <div class="row">
                                        <h3 style="margin-bottom: 0.45em; font-family: auto;">
                                            Flight
                                        </h3>
                                        <br />
                                    </div>

                                    <div class="col-sm-4">
                                        <div class="mb-3">
                                            <label class="form-label">Travel Date </label><label style="color: red;">*</label><input name="travel_date" type="date" class="form-control" value="" /><small style="color: red;"></small>
                                        </div>
                                    </div>
                                    <!-- Col -->
                                    <div class="row">
                                        <div class="col-sm-4">
                                            <div class="mb-3">
                                                <label class="form-label">AirLine Name </label>
                                                <select name="airline_name" class="form-select" data-width="100%">
                                                    <option selected>
                                                        Select
                                                    </option>
                                                    @foreach($flight as $data)
                                                    <option value="{{$data->flight_name}}">{{$data->flight_name}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <!-- <div class="col-sm-4">
                                                                                <div class="mb-3"> -->
                                        <!-- <label class="form-label">Passenger


                                                                                    </label>
                                                                                    -->
                                        <!-- <select class="passenger form-select" name="passenger_name[]" multiple="multiple" data-width="100%">

                                                                                        @foreach($passengers as $data)
                                                                                               <option value="{{$data->name}}">{{$data->name}}</option>
                                                                                            @endforeach
                                                                                     </select> -->
                                        <!-- <div class="multi-select">
  <div class="selected-items">
    <span>Select Guest</span>
  </div>
  <div class="items-list">
    <ul>
    @foreach($passengers as $data)
     <li><label><input name="passenger_name[]" type="checkbox" value="{{$data->name}}">{{$data->name}}</label></li>
    @endforeach
    </ul>
  </div>
</div> -->
                                        <!-- </div>
                                                                            </div> -->
                                        <div class="col-sm-4">
                                            <div class="mb-3">
                                                <label class="form-label">Trip Type </label>
                                                <select name="trip_type" class="form-select" data-width="100%">
                                                    <option selected>
                                                        Select
                                                    </option>
                                                    <option value="1">
                                                        One Way
                                                    </option>
                                                    <option value="2">
                                                        Round Trip
                                                    </option>
                                                    <option value="3">
                                                        Multi City
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Row -->
                                    <div class="row">
                                        <div class="col-sm-4">
                                            <div class="mb-3">
                                                <label class="form-label">GDS Portal </label>
                                                <input name="gds_portal" type="text" class="form-control" placeholder="GDS Portal" />
                                            </div>
                                        </div>
                                        <!-- Col -->
                                        <div class="col-sm-4">
                                            <div class="mb-3">
                                                <label class="form-label">Ticket Number </label>
                                                <input name="ticket_number" type="text" class="form-control" placeholder="Ticket Number" />
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="mb-3">
                                                <label class="form-label">PNR Number </label>
                                                <input name="pnr_number" type="text" class="form-control" placeholder=" PNR Number" />
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Row -->
                                    <div class="row">
                                        <div class="col-sm-4">
                                            <div class="mb-3">
                                                <label class="form-label">Route </label>
                                                <input name="route" type="text" class="form-control" placeholder="Route" />
                                            </div>
                                        </div>
                                        <!-- <div class="col-sm-4">
                                                                                <div class="mb-3">
                                                                                    <label class="form-label">Supplier


                                                                                    </label>
                                                                                    <select name="supplier" class="form-select" data-width="100%">
                                                                                        <option Selected>
                                                                                            Select
                                                                                        </option>
                                                                                        <option value="1">
                                                                                            Transcon
                                                                                            Exports
                                                                                        </option>
                                                                                        <option value="2">
                                                                                            Infosys
                                                                                        </option>
                                                                                        <option value="3">
                                                                                            TPS Serena
                                                                                        </option>
                                                                                    </select>
                                                                                </div>
                                                                            </div> -->
                                    </div>
                                    <hr />
                                    <br />
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <!-- <label for="myfile">
                                                                                        <h4>Flight
                                                                                            Details
                                                                                        </h4>
                                                                                    </label>
                                                                                    <br />
                                                                                    <br />
                                                                                    <input name="flight_details" type="file">
                                                                                <br />
                                                                                <br />
                                                                                <br />
                                                                                <div class="mb-3">
                                                                                    <label for="exampleFormControlTextarea1" class="form-label">
                                                                                        <h4>Note</h4>
                                                                                    </label>
                                                                                    <textarea name="remark" class="form-control" id="exampleFormControlTextarea1" rows="3" placeholder="Remark"></textarea>
                                                                                </div> -->
                                        </div>
                                        <div class="col-sm-6">
                                            <script>
                                                $(document).ready(function () {
                                                    $("#flight-price").on("change", function () {
                                                        var inputVal = $(this).val();

                                                        var visaInvoice = $("#flight-invoice");
                                                        var visaPrice = $("#flight-price").val();
                                                        var taxAmount = $("#flight-tax");

                                                        // visaInvoice.val(parseInt(inputVal) + parseInt(taxAmount.val()));
                                                        visaInvoice.val(parseInt(inputVal));
                                                    });

                                                    $("#flight-tax-rate").change(function () {
                                                        var totalAmount = $("#flight-price").val();
                                                        var taxRate = $("#flight-tax-rate").val();
                                                        var rate = parseInt(taxRate) / 100;
                                                        console.log(totalAmount);
                                                        console.log(taxRate);

                                                        var taxAmount = totalAmount * rate;
                                                        // $('#flight-tax').val(taxAmount);

                                                        $("#flight-invoice").val(parseInt(totalAmount) + parseInt(taxAmount));
                                                    });

                                                    $("#flight-tax").on("change", function () {
                                                        var visaInvoice = $("#flight-invoice");
                                                        var taxAmount = $("#flight-tax");
                                                        var visaPrice = $("#flight-price").val();

                                                        visaInvoice.val(parseInt(visaPrice) + parseInt(taxAmount.val()));
                                                    });

                                                    $("#flight-supplier-charge").on("change", function () {
                                                        var visaRetain = $("#flight-retain");
                                                        var visaPrice = $("#flight-price").val();
                                                        var inputVal = $(this).val();

                                                        visaRetain.val(parseInt(visaPrice) - inputVal);

                                                        console.log(inputVal);
                                                    });
                                                });
                                            </script>
                                            <div class="row">
                                                <div class="col-sm-2"></div>
                                                <div class="col-sm-4">
                                                    <label class="form-label">Fare Charge</label>
                                                </div>
                                                <div class="col-sm-6">
                                                    <input id="flight-price" name="fare_price" type="number" class="form-control" value="0" />
                                                </div>
                                            </div>
                                            <br />
                                            <div class="row">
                                                <div class="col-sm-2"></div>
                                                <div class="col-sm-4"><label class="form-label">Tax</label><br /></div>
                                                <div class="col-sm-6">
                                                    <div>
                                                        <script>
                                                            $(document).ready(function () {
                                                                $(".checktax").click(function () {
                                                                    var inputVal = $(this).val();

                                                                    if (inputVal == "rate") {
                                                                        $("#flight-tax").hide();
                                                                        $("#flight-tax-rate").show();

                                                                        $("#flight-tax").val(0);
                                                                    } else if (inputVal == "amount") {
                                                                        $("#flight-tax").show();
                                                                        $("#flight-tax-rate").hide();

                                                                        $("#flight-tax-rate").val(0);
                                                                    }
                                                                });
                                                            });
                                                        </script>
                                                        <label>
                                                            <input name="tax_type" class="form-check-input checktax" type="radio" value="rate" />
                                                            Rate
                                                        </label>
                                                        <label>
                                                            <input name="tax_type" class="form-check-input checktax" type="radio" value="amount" />
                                                            Amount
                                                        </label>
                                                    </div>
                                                    <br />
                                                    <input style="display: none;" id="flight-tax" name="tax_amount" type="number" class="form-control" value="0" />
                                                    <select id="flight-tax-rate" name="tax_rate" class="form-select" data-width="47.5%">
                                                        <option value="0" selected>
                                                            Select
                                                        </option>
                                                        @foreach($taxmaster as $data)
                                                        <option value="{{$data->sales_rate}}">{{$data->sales_rate}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="align-dropdown-box"></div>
                                            </div>
                                            <!-- <div class="row">
                                                                                    <div class="col-sm-2">

                                                                                    </div>
                                                                                    <div class="col-sm-4">
                                                                                        <label class="form-label">
                                                                                            IPP</label>
                                                                                    </div>
                                                                                    <div class="col-sm-6">
                                                                                        <input id="flight-ipp" name="ipp" type="number" class="form-control" value="0">

                                                                                    </div>

                                                                                </div>
                                                                                <br /> -->
                                            <!-- <div class="row">
                                                                                    <div class="col-sm-2">

                                                                                    </div>
                                                                                    <div class="col-sm-4">
                                                                                        <label class="form-label">Tax
                                                                                            Amount</label>
                                                                                    </div>
                                                                                    <div class="col-sm-6">
                                                                                        <select id="flight-tax-rate" name="tax_amount" class="form-select" data-width="47.5%">
                                                                                                <option Selected>
                                                                                                    Select
                                                                                                </option>
                                                                                                @foreach($taxmaster as $data)
                                                                                               <option value="{{$data->sales_rate}}">{{$data->sales_rate}}</option>
                                                                                               @endforeach  
                                                                                            </select>
                                                                                    </div>

                                                                                </div>
                                                                                <br />
                                                                                <div class="row">
                                                                                    <div class="col-sm-2">

                                                                                    </div>
                                                                                    <div class="col-sm-4">
                                                                                        <label class="form-label">Supplier
                                                                                            Service</label><br />
                                                                                        <label class="form-label">Charge</label>
                                                                                    </div>
                                                                                    <div class="col-sm-6">
                                                                                        <input id="flight-supplier-charge" name="supplier_service_charge" type="number" class="form-control" value="0" style="background-color: #f5f5f1;">
                                                                                    </div>

                                                                                </div>
                                                                                <br />
                                                                                <div class="row">
                                                                                    <div class="col-sm-2">

                                                                                    </div>
                                                                                    <div class="col-sm-4">
                                                                                        <label class="form-label">Supplier
                                                                                            Total</label>
                                                                                    </div>
                                                                                    <div class="col-sm-6">
                                                                                        <input name="supplier_total" type="number" class="form-control" value="0" style="background-color: #f5f5f1;">
                                                                                    </div>

                                                                                </div>
                                                                                <br />
                                                                                <div class="row">
                                                                                    <div class="col-sm-2">

                                                                                    </div>
                                                                                    <div class="col-sm-4">
                                                                                        <label class="form-label">
                                                                                            Invoice
                                                                                            Amount</label>
                                                                                    </div>
                                                                                    <div class="col-sm-6">
                                                                                        <input id="flight-invoice" name="total_amount" type="number" class="form-control" value="0">

                                                                                    </div>

                                                                                </div>
                                                                                <br />
                                                                                <div class="row">
                                                                                    <div class="col-sm-2">

                                                                                    </div>
                                                                                    <div class="col-sm-4">
                                                                                        <label class="form-label">
                                                                                            Retain</label>
                                                                                    </div>
                                                                                    <div class="col-sm-6">
                                                                                        <input id="flight-retain" name="retain" type="number" class="form-control" value="0">

                                                                                    </div>

                                                                                </div>
                                                                                <br /> -->
                                        </div>
                                    </div>
                                    <br />
                                    <div style="margin-left: 92%;">
                                        <div class="row">
                                            <button type="submit" value="submit" class="btn btn-primary mr-2" style="width: 100px;">ADD</button>
                                        </div>
                                    </div>
                                </form>
                            </div>

                            <div id="d" style="display: none;">
                                <form action="/quotation/visaservice/add" method="POST" enctype="multipart/form-data">
                                    @csrf
                                    <input class="userId" type="hidden" name="user_id" value="" />
                                    <input class="dsr_number" type="hidden" name="dsr_number" value="{{$id}}" />
                                    <div>
                                        <div class="row">
                                            <h3 style="margin-bottom: 0.45em; font-family: auto;">
                                                Visa
                                            </h3>
                                            <br />
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Passenger Name </label>

                                                    <select id="visa-passenger" name="passenger_name" class="form-select" data-width="100%">
                                                        <option selected>
                                                            Select
                                                        </option>
                                                        @foreach($passengers as $data)
                                                        <option value="{{$data->name}}">{{$data->name}}</option>
                                                        @endforeach
                                                    </select>

                                                    <script>
                                                        $("#visa-passenger").on("change", function () {
                                                            var selectedValue = $(this).val();

                                                            $.ajax({
                                                                url: "/visa-data",
                                                                type: "GET",
                                                                data: {
                                                                    selected_value: selectedValue,
                                                                },
                                                                success: function (response) {
                                                                    console.log("visa", response.data.id);
                                                                    // Set the data as the value of the input field
                                                                    $("#passport_number").val(response.data.passport_number);
                                                                    $("#visa-email").val(response.data.email);
                                                                    $("#visa-dob").val(response.data.dob);
                                                                },
                                                            });
                                                        });
                                                    </script>
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Passport Number </label>
                                                    <input id="passport_number" name="passport_number" type="number" class="form-control" value="" />
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="mb-3"><label class="form-label" for="DateOfBirth" class="">Date Of Birth </label><input name="dob" type="date" class="form-control" value="" /></div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Email </label>
                                                    <input id="visa-email" name="email" type="email" class="form-control" value="" />
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Visa Number </label>
                                                    <input name="visa_number" type="number" class="form-control" value="" />
                                                </div>
                                            </div>

                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Visa Type</label>
                                                    <select id="visa-type" name="visa_type" class="form-select" data-width="100%">
                                                        <option selected>Select</option>
                                                        @foreach($visa as $data)
                                                        <option value="{{$data->visa_type}}">{{$data->visa_type}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Visa Entry Type</label>
                                                    <select id="visa-entry-type" name="visa_entry_type" class="form-select" data-width="100%">
                                                        <option selected>Select</option>
                                                        @foreach($visa as $data)
                                                        <option value="{{$data->visa_entry_type}}" data-type="{{$data->visa_type}}">{{$data->visa_entry_type}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>

                                            <script>
                                                  $(document).ready(function() {
                                                    // Store the initial visa data
                                                    var initialVisa = {!! json_encode($visa->toArray()) !!};

                                                    // Filter visa options based on the selected entry type
                                                    $('#visa-type').on('change', function() {
                                                      var selectedType = $(this).val();
                                                      var filteredVisa = initialVisa.filter(function(visa) {
                                                        return visa.visa_type == selectedType;
                                                      });

                                                      // Update the visa options
                                                      $('#visa-entry-type').empty();
                                                      $('#visa-entry-type').append('<option selected>Select</option>');
                                                      filteredVisa.forEach(function(visa) {
                                                        $('#visa-entry-type').append('<option value="' + visa.visa_entry_type + '">' + visa.visa_entry_type + '</option>');
                                                      });
                                                    });

                                                    // Filter visa options based on the selected visa entry type
                                                $('#visa-entry-type').on('change', function() {
                                                  var selectedType = $(this).val();
                                                  var visaType =   $('#visa-type').val();

                                                  var filteredVisa = initialVisa.filter(function(visa) {
                                                    return visa.visa_entry_type == selectedType && visa.visa_type == visaType;
                                                  });

                                                  // Update the visa country options
                                                  $('#visa-country').empty();
                                                  $('#visa-country').append('<option selected>Select</option>');
                                                  filteredVisa.forEach(function(visa) {
                                                    $('#visa-country').append('<option value="' + visa.country + '">' + visa.country + '</option>');
                                                  });
                                                });

                                                $('#visa-country').on('change', function() {
                                                  var selectedType = $(this).val();
                                                  var visaType =   $('#visa-type').val();
                                                  var visaEntryType =   $('#visa-entry-type').val();

                                                  var filteredVisa = initialVisa.filter(function(visa) {
                                                    return visa.country == selectedType && visa.visa_type == visaType && visa.visa_entry_type == visaEntryType ;
                                                  });

                                                  // Update the visa country options
                                                  $('#visa-price').val(filteredVisa[0].price);
                                                  $('#visa-invoice').val(filteredVisa[0].price);

                                                });

                                                $('#visa-tax-rate').change(function() {

                                                var visaPrice = $('#visa-price').val();
                                                var taxRate = $('#visa-tax-rate').val();
                                                var rate = parseInt(taxRate) / 100;
                                                console.log(visaPrice)
                                                console.log(taxRate)

                                                var taxAmount = visaPrice * rate;
                                                // $('#visa-tax').val(taxAmount);

                                                $('#visa-invoice').val(parseInt(visaPrice) + parseInt(taxAmount));

                                                });

                                                $('#visa-tax').on('change', function() {

                                                    var visaInvoice = $('#visa-invoice');
                                                    var taxAmount = $('#visa-tax');
                                                    var visaPrice =   $('#visa-price').val();

                                                    visaInvoice.val(parseInt(visaPrice) + parseInt(taxAmount.val()));

                                                });

                                                $('#visa-supplier-charge').on('change', function() {

                                                    var visaRetain = $('#visa-retain');
                                                    var visaPrice = $('#visa-price').val();
                                                    var inputVal = $(this).val();

                                                    visaRetain.val(parseInt(visaPrice) - inputVal);

                                                    console.log(inputVal)

                                                });

                                                  });
                                            </script>
                                        </div>
                                        <!-- Row -->

                                        <div class="row">
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Country</label>
                                                    <select id="visa-country" name="country" class="form-select" data-width="100%">
                                                        <option selected>
                                                            Select
                                                        </option>
                                                        @foreach($visa as $data)
                                                        <option value="{{$data->country}}" data-type="{{$data->visa_entry_type}}">{{$data->country}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="mb-3"><label class="form-label">Issue Date </label><input name="issue_date" type="date" class="form-control" value="" /></div>
                                            </div>

                                            <div class="col-sm-4">
                                                <div class="mb-3"><label class="form-label">Expiry Date </label><input name="expiry_date" type="date" class="form-control" value="" /></div>
                                            </div>
                                            <!-- <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Supplier</label>
                        <select name="supplier" class="form-select" data-width="100%">
                            <option selected>
                                Select
                            </option>
                            <option> Transcon Exports </option>

                            <option> </option>
                            <option>
                                Infosys
                            </option>
                            <option>TPS Serena </option>
                        </select>
                    </div>
                </div> -->
                                        </div>

                                        <hr />
                                        <br />
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <!-- <label for="myfile">
                        <h4>Visa Details</h4>
                    </label>
                    <br />
                    <br />
                    <input type="file" name="visa_details" />
                    <br />
                    <br />
                    <br />
                    <div class="mb-3">
                        <label for="exampleFormControlTextarea1" class="form-label">
                            <h4>Note</h4>
                        </label>
                        <textarea name="remark" class="form-control" id="exampleFormControlTextarea1" rows="3" placeholder="Remark"></textarea>
                    </div> -->
                                            </div>
                                            <div class="col-sm-6">
                                                <div class="row">
                                                    <div class="col-sm-2"></div>
                                                    <div class="col-sm-4">
                                                        <label class="form-label">Visa Price</label>
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <input id="visa-price" name="visa_price" type="number" class="form-control" value="0" />
                                                    </div>
                                                </div>
                                                <br />
                                                <div class="row">
                                                    <div class="col-sm-2"></div>
                                                    <div class="col-sm-4"><label class="form-label">Tax </label><br /></div>
                                                    <div class="col-sm-6">
                                                        <div>
                                                            <script>
                                                                $(document).ready(function () {
                                                                    $(".checktax").click(function () {
                                                                        var inputVal = $(this).val();

                                                                        if (inputVal == "rate") {
                                                                            $("#visa-tax").hide();
                                                                            $("#visa-tax-rate").show();

                                                                            $("#visa-tax").val(0);
                                                                        } else if (inputVal == "amount") {
                                                                            $("#visa-tax").show();
                                                                            $("#visa-tax-rate").hide();

                                                                            $("#visa-tax-rate").val(0);
                                                                        }
                                                                    });
                                                                });
                                                            </script>
                                                            <label>
                                                                <input name="tax_type" class="form-check-input checktax" type="radio" value="rate" />
                                                                Rate
                                                            </label>
                                                            <label>
                                                                <input name="tax_type" class="form-check-input checktax" type="radio" value="amount" />
                                                                Amount
                                                            </label>
                                                        </div>
                                                        <br />

                                                        <input style="display: none;" id="visa-tax" name="tax_amount" type="number" class="form-control" value="0" />
                                                        <select id="visa-tax-rate" name="tax_rate" class="form-select" data-width="47.5%">
                                                            <option value="0" selected>
                                                                Select
                                                            </option>
                                                            @foreach($taxmaster as $data)
                                                            <option value="{{$data->sales_rate}}">{{$data->sales_rate}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="align-dropdown-box"></div>
                                                </div>
                                                <!-- <div class="row">
                        <div class="col-sm-2"></div>
                        <div class="col-sm-4">
                            <label class="form-label">Tax Amount</label><br />

                            
                        </div>
                        <div class="col-sm-6">
                                <select id="visa-tax-rate" name="tax_amount" class="form-select" data-width="47.5%">
                                  <option Selected>
                                         Select
                                       </option>
                                       @foreach($taxmaster as $data)
                                      <option value="{{$data->sales_rate}}">{{$data->sales_rate}}</option>
                                      @endforeach  
                                   </select>
                            </div>
                        <br />
                        <div class="row">
                            <div class="col-sm-2"></div>
                            <div class="col-sm-4">
                                <label class="form-label">Invoice Total</label>
                            </div>
                            <div class="col-sm-6">
                                <input id="visa-invoice" name="total_amount" type="number" class="form-control" value="0" style="background-color: #f5f5f1;" />
                            </div>
                        </div>
                        <br />
                        <div class="row">
                            <div class="col-sm-2"></div>
                            <div class="col-sm-4">
                                <label class="form-label">Retain</label>
                            </div>
                            <div class="col-sm-6">
                                <input id="visa-retain" name="retain" type="number" class="form-control" value="0" style="background-color: #f5f5f1;" />
                            </div>
                        </div>
                        <br /> -->
                                            </div>
                                        </div>
                                        <br />
                                        <div style="margin-left: 92%;">
                                            <div class="row">
                                                <button type="submit" value="submit" class="btn btn-primary mr-2" style="width: 100px;">ADD</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>

                            <div id="e" style="display: none;">
                                <form action="/quotation/insuranceservice/add" method="POST" enctype="multipart/form-data">
                                    @csrf
                                    <input class="userId" type="hidden" name="user_id" value="" />
                                    <input class="dsr_number" type="hidden" name="dsr_number" value="{{$id}}" />
                                    <div>
                                        <div class="row">
                                            <h3 style="margin-bottom: 0.45em; font-family: auto;">
                                                Insurance
                                            </h3>
                                            <br />
                                        </div>

                                        <div class="row">
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Passenger Name </label>
                                                    <select name="passenger_name" class="form-select" data-width="100%">
                                                        <option selected>
                                                            Select
                                                        </option>
                                                        @foreach($passengers as $data)
                                                        <option value="{{$data->name}}">{{$data->name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Company Name </label>
                                                    <select id="company-name" name="company_name" class="form-select" data-width="100%">
                                                        <option selected>
                                                            Select
                                                        </option>
                                                        @foreach($insurance as $data)
                                                        <option value="{{$data->company_name}}">{{$data->company_name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="mb-3"><label class="form-label" class="">Policy Number </label><input name="policy_number" type="number" class="form-control" value="" /></div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-sm-4">
                                                <div class="mb-3"><label class="form-label" class="">Issue Date </label><input name="issue_date" type="date" class="form-control" value="" /></div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Expiry Date </label>
                                                    <input name="expiry_date" type="date" class="form-control" value="" />
                                                </div>
                                            </div>

                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Insurance Plan </label>
                                                    <select id="insurance-plan-name" name="insurance_plan" class="form-select" data-width="100%">
                                                        <option selected>
                                                            Select
                                                        </option>
                                                        @foreach($insuranceplan as $data)
                                                        <option value="{{$data->plan_name}}" data-type="{{$data->insurance_id}}">{{$data->plan_name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <hr />
                                        <br />
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <!-- <label for="myfile">
                                                                                                <h4>Insurance
                                                                                                    Details
                                                                                                </h4>
                                                                                            </label>
                                                                                            <br />
                                                                                            <br />
                                                                                            <input type="file" name="insurance_details">
                                                                                        <br />
                                                                                        <br />
                                                                                        <br />
                                                                                        <div class="mb-3">
                                                                                            <label for="exampleFormControlTextarea1" class="form-label">
                                                                                                <h4>Note</h4>
                                                                                            </label>
                                                                                            <textarea name="remark" class="form-control" id="exampleFormControlTextarea1" rows="3" placeholder="Remark"></textarea>
                                                                                        </div> -->
                                            </div>
                                            <div class="col-sm-6">
                                                <script>
                                                      $(document).ready(function() {
                                                        // Store the initial insurance data
                                                    //     var initialInsurance = {!! json_encode($insurance->toArray()) !!};
                                                    //     var initialInsurancePlan = {!! json_encode($insuranceplan->toArray()) !!};

                                                    //     var selectedType = $(this).val();

                                                    //   var filteredinsurance = initialInsurance.filter(function(insurance) {
                                                    //     return insurance.company_name == selectedType ;
                                                    //   });

                                                    //   var id = filteredinsurance[0].id;

                                                    //   var filteredinsuranceplan = initialInsurancePlan.filter(function(insuranceplan) {
                                                    //     return insuranceplan.insurance_id == id ;
                                                    //   });


                                                    //  // Update the visa options
                                                    //       $('#insurance-plan-name').empty();
                                                    //       $('#insurance-plan-name').append('<option selected>Select</option>');
                                                    //       filteredinsuranceplan.forEach(function(insuranceplan) {
                                                    //         $('#insurance-plan-name').append('<option value="' + insuranceplan.plan_name + '">' + insuranceplan.plan_name + '</option>');
                                                    //       });

                                                    $('#insurance-plan-name').on('change', function() {

                                                        var initialInsurancePlan = {!! json_encode($insuranceplan->toArray()) !!};

                                                        var selectedType = $(this).val();

                                                      var filteredinsuranceplan = initialInsurancePlan.filter(function(insuranceplan) {
                                                        return insuranceplan.plan_name == selectedType ;
                                                      });


                                                     // Update the visa options
                                                          $('#insurance-price').val(filteredinsuranceplan[0].price);
                                                          console.log(filteredinsuranceplan[0].price)


                                                    });


                                                    $('#company-name').on('change', function() {
                                                        console.log("name")
                                                        var selectedValue = $(this).val();

                                                    $.ajax({
                                                        url: '/insurance-data',
                                                        type: 'GET',
                                                        data: {
                                                            selected_value: selectedValue
                                                        },
                                                        success: function(response) {
                                                            console.log("roomd",response);
                                                           // Remove existing options from the select element
                                                        $('#insurance-plan-name').empty();

                                                        $('#insurance-plan-name').prop('disabled', false);


                                                         // Loop through the data and create a new option element for each item
                                                        response.data.forEach(function(item) {
                                                        var option = $('<option>', { value: item.plan_name, text: item.plan_name });
                                                         $('#insurance-plan-name').append(option);
                                                         });

                                                        }

                                                      });
                                                    });


                                                    $('#insurance-tax-rate').change(function() {

                                                    var totalAmount = $('#insurance-price').val();
                                                    var taxRate = $('#insurance-tax-rate').val();
                                                    var rate = parseInt(taxRate) / 100;
                                                    console.log(totalAmount)
                                                    console.log(taxRate)

                                                    var taxAmount = totalAmount * rate;
                                                    // $('#insurance-tax').val(taxAmount);

                                                    $('#insurance-invoice').val(parseInt(totalAmount) + parseInt(taxAmount));

                                                    });


                                                    $('#insurance-tax').on('change', function() {

                                                        var insuranceInvoice = $('#insurance-invoice');
                                                        var taxAmount = $('#insurance-tax');
                                                        var insurancePrice =   $('#insurance-price').val();

                                                        insuranceInvoice.val(parseInt(insurancePrice) + parseInt(taxAmount.val()));

                                                    });

                                                    $('#insurance-supplier-charge').on('change', function() {

                                                        var insuranceRetain = $('#insurance-retain');
                                                        var insurancePrice = $('#insurance-price').val();
                                                        var inputVal = $(this).val();

                                                        insuranceRetain.val(parseInt(insurancePrice) - inputVal);

                                                        console.log(inputVal)

                                                    });

                                                      });
                                                </script>

                                                <!-- <div class="row">
                                                                                            <div class="col-sm-2">

                                                                                            </div>
                                                                                            <div class="col-sm-4">
                                                                                                <label class="form-label">Supplier
                                                                                                    Service
                                                                                                    Charge</label>
                                                                                            </div>
                                                                                            <div class="col-sm-6">
                                                                                                <input id="insurance-supplier-charge" name="supplier_service_charge" type="number" class="form-control" value="0">
                                                                                            </div>
                                                                                        </div> -->

                                                <div class="row">
                                                    <div class="col-sm-2"></div>
                                                    <div class="col-sm-4">
                                                        <label class="form-label">Insurance Price</label>
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <input id="insurance-price" name="insurance_price" type="number" class="form-control" value="0" />
                                                    </div>
                                                </div>
                                                <br />

                                                <div class="row">
                                                    <div class="col-sm-2"></div>
                                                    <div class="col-sm-4"><label class="form-label">Tax </label><br /></div>
                                                    <div class="col-sm-6">
                                                        <div>
                                                            <script>
                                                                $(document).ready(function () {
                                                                    $(".checktax").click(function () {
                                                                        var inputVal = $(this).val();

                                                                        if (inputVal == "rate") {
                                                                            $("#insurance-tax").hide();
                                                                            $("#insurance-tax-rate").show();

                                                                            $("#insurance-tax").val(0);
                                                                        } else if (inputVal == "amount") {
                                                                            $("#insurance-tax").show();
                                                                            $("#insurance-tax-rate").hide();

                                                                            $("#insurance-tax-rate").val(0);
                                                                        }
                                                                    });
                                                                });
                                                            </script>
                                                            <label>
                                                                <input name="tax_type" class="form-check-input checktax" type="radio" value="rate" />
                                                                Rate
                                                            </label>
                                                            <label>
                                                                <input name="tax_type" class="form-check-input checktax" type="radio" value="amount" />
                                                                Amount
                                                            </label>
                                                        </div>
                                                        <br />

                                                        <input style="display: none;" id="insurance-tax" name="tax_amount" type="number" class="form-control" value="0" />
                                                        <select id="insurance-tax-rate" name="tax_rate" class="form-select" data-width="47.5%">
                                                            <option value="0" selected>
                                                                Select
                                                            </option>
                                                            @foreach($taxmaster as $data)
                                                            <option value="{{$data->sales_rate}}">{{$data->sales_rate}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="align-dropdown-box"></div>
                                                </div>

                                                <!-- <div class="row">
                                                                                            <div class="col-sm-2">

                                                                                            </div>
                                                                                            <div class="col-sm-4">
                                                                                                <label class="form-label">Tax
                                                                                                    Amount</label><br />
                                                                                            </div>
                                                                                            <div class="col-sm-6">
                                                                                                <input id="insurance-tax" name="tax_amount" type="number" class="form-control" value="0">
                                                                                                <select id="insurance-tax-rate" name="tax_amount" class="form-select" data-width="47.5%">
                                                                                                 <option Selected>
                                                                                                        Select
                                                                                                      </option>
                                                                                                      @foreach($taxmaster as $data)
                                                                                                     <option value="{{$data->sales_rate}}">{{$data->sales_rate}}</option>
                                                                                                     @endforeach  
                                                                                                  </select>
                                                                                            </div>
                                                                                        </div>
                                                                                        <br />
                                                                                        <div class="row">
                                                                                            <div class="col-sm-2">

                                                                                            </div>
                                                                                            <div class="col-sm-4">
                                                                                                <label class="form-label">Invoice
                                                                                                    Total</label>
                                                                                            </div>
                                                                                            <div class="col-sm-6">
                                                                                                <input id="insurance-invoice" name="total_amount" type="number" class="form-control" value="0" style="background-color: #f5f5f1;">
                                                                                            </div>
                                                                                        </div>
                                                                                        <br />
                                                                                        <div class="row">
                                                                                            <div class="col-sm-2">

                                                                                            </div>
                                                                                            <div class="col-sm-4">
                                                                                                <label class="form-label">Retain</label>
                                                                                            </div>
                                                                                            <div class="col-sm-6">
                                                                                                <input id="insurance-retain" name="retain" type="number" class="form-control" value="0" style="background-color: #f5f5f1;">
                                                                                            </div>
                                                                                        </div>
                                                                                        <br /> -->
                                            </div>
                                        </div>
                                        <br />
                                        <div style="margin-left: 92%;">
                                            <div class="row">
                                                <button type="submit" value="submit" class="btn btn-primary mr-2" style="width: 100px;">ADD</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>

                            <div id="f" style="display: none;">
                                <form action="/quotation/otherservice/add" method="POST" enctype="multipart/form-data">
                                    @csrf
                                    <input class="userId" type="hidden" name="user_id" value="" />
                                    <input class="dsr_number" type="hidden" name="dsr_number" value="{{$id}}" />
                                    <div>
                                        <div class="row">
                                            <h3 style="margin-bottom: 0.45em; font-family: auto;">
                                                Inventory
                                            </h3>
                                            <br />
                                            <div class="col-sm-3">
                                                <div class="mb-3">
                                                    <label class="form-label">Item Details </label>
                                                    <select id="item-details" name="item_details" class="form-select" data-width="100%">
                                                        <option selected>
                                                            Select
                                                        </option>
                                                        @foreach($other as $data)
                                                        <option value="{{$data->item_name}}">{{$data->item_name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="mb-3">
                                                    <label class="form-label">Quantity </label>
                                                    <input id="item-quantity" name="quantity" type="number" class="form-control" value="0" />
                                                    <!-- <select class="form-select" data-width="100%">
                                                                                                <option Selected>
                                                                                                    Select
                                                                                                </option>
                                                                                                <option value="DI">
                                                                                                    Kilo Gram
                                                                                                </option>
                                                                                                <option value="RS">
                                                                                                    Gram
                                                                                                </option>
                                                                                            </select> -->
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="mb-3">
                                                    <label class="form-label">Per Price </label>
                                                    <input id="item-price" name="price" type="number" class="form-control" />
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="mb-3">
                                                    <label class="form-label">Total Amount </label>
                                                    <input id="item-total" name="amount" type="number" class="form-control" />
                                                </div>
                                            </div>
                                        </div>
                                        <hr />
                                        <br />
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <!-- <label for="myfile">
                                                                                                <h4>Other
                                                                                                    Details
                                                                                                </h4>
                                                                                            </label>
                                                                                            <br />
                                                                                            <br />
                                                                                            <input type="file" name="other_details">
                                                                                        <br />
                                                                                        <br />
                                                                                        <br />
                                                                                        <div class="mb-3">
                                                                                            <label for="exampleFormControlTextarea1" class="form-label">
                                                                                                <h4>Note</h4>
                                                                                            </label>
                                                                                            <textarea name="remark" class="form-control" id="exampleFormControlTextarea1" rows="3" placeholder="Remark"></textarea>
                                                                                        </div> -->
                                            </div>
                                            <div class="col-sm-6">
                                                <script>
                                                      $(document).ready(function() {


                                                    $('#item-details').on('change', function() {

                                                        var initialOther = {!! json_encode($other->toArray()) !!};

                                                        var selectedType = $(this).val();

                                                      var filteredOther = initialOther.filter(function(other) {
                                                        return other.item_name == selectedType ;
                                                      });


                                                     // Update the visa options
                                                          $('#item-price').val(filteredOther[0].sales_price);
                                                          $('#item-invoice').val(filteredOther[0].sales_price);
                                                          $('#item-total').val(filteredOther[0].sales_price);


                                                    });


                                                    $('#item-tax-rate').change(function() {

                                                    var totalAmount = $('#item-price').val();
                                                    var taxRate = $('#item-tax-rate').val();
                                                    var rate = parseInt(taxRate) / 100;
                                                    console.log(totalAmount)
                                                    console.log(taxRate)

                                                    var taxAmount = totalAmount * rate;
                                                    // $('#item-tax').val(taxAmount);

                                                    $('#item-invoice').val(parseInt(totalAmount) + parseInt(taxAmount));

                                                    });

                                                    $('#item-tax').on('change', function() {

                                                        var itemInvoice = $('#item-invoice');
                                                        var taxAmount = $('#item-tax');
                                                        var itemPrice =   $('#item-price').val();

                                                        itemInvoice.val(parseInt(itemPrice) + parseInt(taxAmount.val()));

                                                    });

                                                    $('#item-supplier-charge').on('change', function() {

                                                        var itemRetain = $('#item-retain');
                                                        var itemPrice = $('#item-price').val();
                                                        var inputVal = $(this).val();

                                                        itemRetain.val(parseInt(itemPrice) - inputVal);

                                                        console.log(inputVal)

                                                    });

                                                      });
                                                </script>

                                                <div class="row">
                                                    <div class="col-sm-2"></div>
                                                    <div class="col-sm-4"><label class="form-label">Tax </label><br /></div>
                                                    <div class="col-sm-6">
                                                        <div>
                                                            <script>
                                                                $(document).ready(function () {
                                                                    $(".checktax").click(function () {
                                                                        var inputVal = $(this).val();

                                                                        if (inputVal == "rate") {
                                                                            $("#other-tax").hide();
                                                                            $("#other-tax-rate").show();

                                                                            $("#other-tax").val(0);
                                                                        } else if (inputVal == "amount") {
                                                                            $("#other-tax").show();
                                                                            $("#other-tax-rate").hide();

                                                                            $("#other-tax-rate").val(0);
                                                                        }
                                                                    });
                                                                });
                                                            </script>
                                                            <label>
                                                                <input name="tax_type" class="form-check-input checktax" type="radio" value="rate" />
                                                                Rate
                                                            </label>
                                                            <label>
                                                                <input name="tax_type" class="form-check-input checktax" type="radio" value="amount" />
                                                                Amount
                                                            </label>
                                                        </div>
                                                        <br />

                                                        <input style="display: none;" id="other-tax" name="tax_amount" type="number" class="form-control" value="0" />
                                                        <select id="other-tax-rate" name="tax_rate" class="form-select" data-width="47.5%">
                                                            <option value="0" selected>
                                                                Select
                                                            </option>
                                                            @foreach($taxmaster as $data)
                                                            <option value="{{$data->sales_rate}}">{{$data->sales_rate}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="align-dropdown-box"></div>
                                                </div>
                                                <!-- <div class="row">
                                                                                            <div class="col-sm-2">

                                                                                            </div>
                                                                                            <div class="col-sm-4">
                                                                                                <label class="form-label">Supplier
                                                                                                    Service
                                                                                                    Charge</label>
                                                                                            </div>
                                                                                            <div class="col-sm-6">
                                                                                                <input id="item-supplier-charge" name="supplier_service_charge" type="number" class="form-control" value="0">
                                                                                            </div>
                                                                                        </div>
                                                                                        <br /> -->

                                                <!-- <div class="row">
                                                                                            <div class="col-sm-2">

                                                                                            </div>
                                                                                            <div class="col-sm-4">
                                                                                                <label class="form-label">Tax
                                                                                                    Amount</label><br />

                                                                                            </div>
                                                                                            <div class="col-sm-6">
                                                                                           

                                                                                                <input id="item-tax" name="tax_amount" type="number" class="form-control" value="0">
                                                                                                <select id="item-tax-rate" name="tax_amount" class="form-select" data-width="47.5%">
                                                                                                 <option Selected>
                                                                                                        Select
                                                                                                      </option>
                                                                                                      @foreach($taxmaster as $data)
                                                                                                     <option value="{{$data->sales_rate}}">{{$data->sales_rate}}</option>
                                                                                                     @endforeach  
                                                                                                  </select>
                                                                                            </div>
                                                                                        </div>
                                                                                        <br /> -->
                                                <!-- <div class="row">
                                                                                            <div class="col-sm-2">

                                                                                            </div>
                                                                                            <div class="col-sm-4">
                                                                                                <label class="form-label">Invoice
                                                                                                    Total</label>
                                                                                            </div>
                                                                                            <div class="col-sm-6">
                                                                                                <input id="item-invoice" name="total_amount" type="number" class="form-control" value="0" style="background-color: #f5f5f1;">
                                                                                            </div>
                                                                                        </div>
                                                                                        <br />
                                                                                        <div class="row">
                                                                                            <div class="col-sm-2">

                                                                                            </div>
                                                                                            <div class="col-sm-4">
                                                                                                <label class="form-label">Retain</label>
                                                                                            </div>
                                                                                            <div class="col-sm-6">
                                                                                                <input id="item-retain" name="retain" type="number" class="form-control" value="0" style="background-color: #f5f5f1;">
                                                                                            </div>
                                                                                        </div>
                                                                                        <br /> -->
                                            </div>
                                        </div>
                                        <br />
                                        <div style="margin-left: 92%;">
                                            <div class="row">
                                                <button type="submit" value="submit" class="btn btn-primary mr-2" style="width: 100px;">ADD</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>

                            <div id="g" style="display: none;">
                                <form action="/quotation/carhireservice/add" method="POST" enctype="multipart/form-data">
                                    @csrf
                                    <input class="userId" type="hidden" name="user_id" value="" />
                                    <input class="dsr_number" type="hidden" name="dsr_number" value="{{$id}}" />
                                    <div>
                                        <div class="row">
                                            <h3 style="margin-bottom: 0.45em; font-family: auto;">
                                                Car Hire
                                            </h3>
                                            <br />
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Vehicle Type </label>
                                                    <select id="item-details" name="vehicle_type" class="form-select" data-width="100%">
                                                        <option selected>
                                                            Select
                                                        </option>
                                                        @foreach($carhire as $data)
                                                        <option value="{{$data->type_of_vehicle}}">{{$data->type_of_vehicle}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Select Days </label>
                                                    <input id="item-quantity" name="days" type="number" class="form-control" value="0" />
                                                    <!-- <select class="form-select" data-width="100%">
                                                                                                <option Selected>
                                                                                                    Select
                                                                                                </option>
                                                                                                <option value="DI">
                                                                                                    Kilo Gram
                                                                                                </option>
                                                                                                <option value="RS">
                                                                                                    Gram
                                                                                                </option>
                                                                                            </select> -->
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Price</label>
                                                    <input id="item-price" name="price" type="number" class="form-control" />
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Pickup Location </label>
                                                    <input id="item-total" name="pickup_location" type="text" class="form-control" />
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Drop Location </label>
                                                    <input id="item-total" name="drop_location" type="text" class="form-control" />
                                                </div>
                                            </div>
                                        </div>
                                        <hr />
                                        <br />
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <!-- <label for="myfile">
                                                                                                <h4>Other
                                                                                                    Details
                                                                                                </h4>
                                                                                            </label>
                                                                                            <br />
                                                                                            <br />
                                                                                            <input type="file" name="other_details">
                                                                                        <br />
                                                                                        <br />
                                                                                        <br />
                                                                                        <div class="mb-3">
                                                                                            <label for="exampleFormControlTextarea1" class="form-label">
                                                                                                <h4>Note</h4>
                                                                                            </label>
                                                                                            <textarea name="remark" class="form-control" id="exampleFormControlTextarea1" rows="3" placeholder="Remark"></textarea>
                                                                                        </div> -->
                                            </div>
                                            <div class="col-sm-6">
                                                <script>
                                                      $(document).ready(function() {


                                                    $('#item-details').on('change', function() {

                                                        var initialOther = {!! json_encode($other->toArray()) !!};

                                                        var selectedType = $(this).val();

                                                      var filteredOther = initialOther.filter(function(other) {
                                                        return other.item_name == selectedType ;
                                                      });


                                                     // Update the visa options
                                                          $('#item-price').val(filteredOther[0].sales_price);
                                                          $('#item-invoice').val(filteredOther[0].sales_price);
                                                          $('#item-total').val(filteredOther[0].sales_price);


                                                    });


                                                    $('#item-tax-rate').change(function() {

                                                    var totalAmount = $('#item-price').val();
                                                    var taxRate = $('#item-tax-rate').val();
                                                    var rate = parseInt(taxRate) / 100;
                                                    console.log(totalAmount)
                                                    console.log(taxRate)

                                                    var taxAmount = totalAmount * rate;
                                                    // $('#item-tax').val(taxAmount);

                                                    $('#item-invoice').val(parseInt(totalAmount) + parseInt(taxAmount));

                                                    });

                                                    $('#item-tax').on('change', function() {

                                                        var itemInvoice = $('#item-invoice');
                                                        var taxAmount = $('#item-tax');
                                                        var itemPrice =   $('#item-price').val();

                                                        itemInvoice.val(parseInt(itemPrice) + parseInt(taxAmount.val()));

                                                    });

                                                    $('#item-supplier-charge').on('change', function() {

                                                        var itemRetain = $('#item-retain');
                                                        var itemPrice = $('#item-price').val();
                                                        var inputVal = $(this).val();

                                                        itemRetain.val(parseInt(itemPrice) - inputVal);

                                                        console.log(inputVal)

                                                    });

                                                      });
                                                </script>

                                                <div class="row">
                                                    <div class="col-sm-2"></div>
                                                    <div class="col-sm-4"><label class="form-label">Tax </label><br /></div>
                                                    <div class="col-sm-6">
                                                        <div>
                                                            <script>
                                                                $(document).ready(function () {
                                                                    $(".checktax").click(function () {
                                                                        var inputVal = $(this).val();

                                                                        if (inputVal == "rate") {
                                                                            $("#carhire-tax").hide();
                                                                            $("#carhire-tax-rate").show();

                                                                            $("#carhire-tax").val(0);
                                                                        } else if (inputVal == "amount") {
                                                                            $("#carhire-tax").show();
                                                                            $("#carhire-tax-rate").hide();

                                                                            $("#carhire-tax-rate").val(0);
                                                                        }
                                                                    });
                                                                });
                                                            </script>
                                                            <label>
                                                                <input name="tax_type" class="form-check-input checktax" type="radio" value="rate" />
                                                                Rate
                                                            </label>
                                                            <label>
                                                                <input name="tax_type" class="form-check-input checktax" type="radio" value="amount" />
                                                                Amount
                                                            </label>
                                                        </div>
                                                        <br />

                                                        <input style="display: none;" id="carhire-tax" name="tax_amount" type="number" class="form-control" value="0" />
                                                        <select id="carhire-tax-rate" name="tax_rate" class="form-select" data-width="47.5%">
                                                            <option value="0" selected>
                                                                Select
                                                            </option>
                                                            @foreach($taxmaster as $data)
                                                            <option value="{{$data->sales_rate}}">{{$data->sales_rate}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="align-dropdown-box"></div>
                                                </div>
                                                <!-- <div class="row">
                                                                                            <div class="col-sm-2">

                                                                                            </div>
                                                                                            <div class="col-sm-4">
                                                                                                <label class="form-label">Supplier
                                                                                                    Service
                                                                                                    Charge</label>
                                                                                            </div>
                                                                                            <div class="col-sm-6">
                                                                                                <input id="item-supplier-charge" name="supplier_service_charge" type="number" class="form-control" value="0">
                                                                                            </div>
                                                                                        </div>
                                                                                        <br /> -->

                                                <!-- <div class="row">
                                                                                            <div class="col-sm-2">

                                                                                            </div>
                                                                                            <div class="col-sm-4">
                                                                                                <label class="form-label">Tax
                                                                                                    Amount</label><br />

                                                                                            </div>
                                                                                            <div class="col-sm-6">
                                                                                           

                                                                                                <input id="item-tax" name="tax_amount" type="number" class="form-control" value="0">
                                                                                                <select id="item-tax-rate" name="tax_amount" class="form-select" data-width="47.5%">
                                                                                                 <option Selected>
                                                                                                        Select
                                                                                                      </option>
                                                                                                      @foreach($taxmaster as $data)
                                                                                                     <option value="{{$data->sales_rate}}">{{$data->sales_rate}}</option>
                                                                                                     @endforeach  
                                                                                                  </select>
                                                                                            </div>
                                                                                        </div>
                                                                                        <br /> -->
                                                <!-- <div class="row">
                                                                                            <div class="col-sm-2">

                                                                                            </div>
                                                                                            <div class="col-sm-4">
                                                                                                <label class="form-label">Invoice
                                                                                                    Total</label>
                                                                                            </div>
                                                                                            <div class="col-sm-6">
                                                                                                <input id="item-invoice" name="total_amount" type="number" class="form-control" value="0" style="background-color: #f5f5f1;">
                                                                                            </div>
                                                                                        </div>
                                                                                        <br />
                                                                                        <div class="row">
                                                                                            <div class="col-sm-2">

                                                                                            </div>
                                                                                            <div class="col-sm-4">
                                                                                                <label class="form-label">Retain</label>
                                                                                            </div>
                                                                                            <div class="col-sm-6">
                                                                                                <input id="item-retain" name="retain" type="number" class="form-control" value="0" style="background-color: #f5f5f1;">
                                                                                            </div>
                                                                                        </div>
                                                                                        <br /> -->
                                            </div>
                                        </div>
                                        <br />
                                        <div style="margin-left: 92%;">
                                            <div class="row">
                                                <button type="submit" value="submit" class="btn btn-primary mr-2" style="width: 100px;">ADD</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>

                            <div id="h" style="display: none;">
                                <form action="/quotation/assistservice/add" method="POST" enctype="multipart/form-data">
                                    @csrf
                                    <input class="userId" type="hidden" name="user_id" value="" />
                                    <input class="dsr_number" type="hidden" name="dsr_number" value="{{$id}}" />
                                    <div>
                                        <div class="row">
                                            <h3 style="margin-bottom: 0.45em; font-family: auto;">
                                                Assist
                                            </h3>
                                            <br />
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Airport</label>
                                                    <select id="assist-airport" name="airport" class="form-select" data-width="100%">
                                                        <option selected>Select</option>
                                                        @php $item_names = array(); // initialize an empty array to store item names @endphp @foreach($assist as $data) @if(!in_array($data->airport, $item_names))
                                                        <!-- check if item name is not already in the array -->
                                                        @php $item_names[] = $data->airport; @endphp
                                                        <!-- add the item name to the array -->
                                                        <option value="{{ $data->airport }}">{{ $data->airport }}</option>
                                                        @endif @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Meeting Type</label>
                                                    <select id="assist-meeting" name="meeting_type" class="select2 form-select" data-width="100%">
                                                        <option selected>Select</option>
                                                        @foreach($assist as $data)
                                                        <option value="{{$data->meeting_type}}">{{$data->meeting_type}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">No of Person </label>
                                                    <input id="assist-person" name="no_person" type="number" class="form-control" value="1" />
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Price</label>
                                                    <input id="assist-price" name="price" type="number" class="form-control" />
                                                </div>
                                            </div>
                                        </div>
                                        <hr />
                                        <br />
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <!-- <label for="myfile">
                                                                                                <h4>Other
                                                                                                    Details
                                                                                                </h4>
                                                                                            </label>
                                                                                            <br />
                                                                                            <br />
                                                                                            <input type="file" name="other_details">
                                                                                        <br />
                                                                                        <br />
                                                                                        <br />
                                                                                        <div class="mb-3">
                                                                                            <label for="exampleFormControlTextarea1" class="form-label">
                                                                                                <h4>Note</h4>
                                                                                            </label>
                                                                                            <textarea name="remark" class="form-control" id="exampleFormControlTextarea1" rows="3" placeholder="Remark"></textarea>
                                                                                        </div> -->
                                            </div>
                                            <div class="col-sm-6">
                                                <script>
                                                      $(document).ready(function() {


                                                        var initialAssist = {!! json_encode($assist->toArray()) !!};

                                                        // Filter assist options based on the selected entry type
                                                        $('#assist-airport').on('change', function() {
                                                          var selectedType = $(this).val();
                                                          var filteredassist = initialAssist.filter(function(assist) {
                                                            return assist.airport == selectedType;
                                                          });

                                                          // Update the assist options
                                                          $('#assist-meeting').empty();
                                                          $('#assist-meeting').append('<option selected>Select</option>');
                                                          filteredassist.forEach(function(assist) {
                                                            $('#assist-meeting').append('<option value="' + assist.meeting_type + '">' + assist.meeting_type + '</option>');
                                                          });
                                                        });

                                                        // Filter assist options based on the selected assist entry type
                                                    $('#assist-meeting').on('change', function() {
                                                      var selectedType = $(this).val();
                                                      var assistType =   $('#assist-type').val();

                                                      var filteredassist = initialAssist.filter(function(assist) {
                                                        return assist.assist_entry_type == selectedType && assist.assist_type == assistType;
                                                      });

                                                      // Update the assist country options
                                                      $('#assist-country').empty();
                                                      $('#assist-country').append('<option selected>Select</option>');
                                                      filteredassist.forEach(function(assist) {
                                                        $('#assist-country').append('<option value="' + assist.country + '">' + assist.country + '</option>');
                                                      });
                                                    });

                                                    $('#assist-country').on('change', function() {
                                                      var selectedType = $(this).val();
                                                      var assistType =   $('#assist-type').val();
                                                      var assistEntryType =   $('#assist-entry-type').val();

                                                      var filteredassist = initialAssist.filter(function(assist) {
                                                        return assist.country == selectedType && assist.assist_type == assistType && assist.assist_entry_type == assistEntryType ;
                                                      });

                                                      // Update the assist country options
                                                      $('#assist-price').val(filteredassist[0].price);
                                                      $('#assist-invoice').val(filteredassist[0].price);

                                                    });


                                                    $('#item-tax-rate').change(function() {

                                                    var totalAmount = $('#item-price').val();
                                                    var taxRate = $('#item-tax-rate').val();
                                                    var rate = parseInt(taxRate) / 100;
                                                    console.log(totalAmount)
                                                    console.log(taxRate)

                                                    var taxAmount = totalAmount * rate;
                                                    // $('#item-tax').val(taxAmount);

                                                    $('#item-invoice').val(parseInt(totalAmount) + parseInt(taxAmount));

                                                    });

                                                    $('#item-tax').on('change', function() {

                                                        var itemInvoice = $('#item-invoice');
                                                        var taxAmount = $('#item-tax');
                                                        var itemPrice =   $('#item-price').val();

                                                        itemInvoice.val(parseInt(itemPrice) + parseInt(taxAmount.val()));

                                                    });

                                                    $('#item-supplier-charge').on('change', function() {

                                                        var itemRetain = $('#item-retain');
                                                        var itemPrice = $('#item-price').val();
                                                        var inputVal = $(this).val();

                                                        itemRetain.val(parseInt(itemPrice) - inputVal);

                                                        console.log(inputVal)

                                                    });

                                                      });
                                                </script>

                                                <div class="row">
                                                    <div class="col-sm-2"></div>
                                                    <div class="col-sm-4"><label class="form-label">Tax </label><br /></div>
                                                    <div class="col-sm-6">
                                                        <div>
                                                            <script>
                                                                $(document).ready(function () {
                                                                    $(".checktax").click(function () {
                                                                        var inputVal = $(this).val();

                                                                        if (inputVal == "rate") {
                                                                            $("#assist-tax").hide();
                                                                            $("#assist-tax-rate").show();

                                                                            $("#assist-tax").val(0);
                                                                        } else if (inputVal == "amount") {
                                                                            $("#assist-tax").show();
                                                                            $("#assist-tax-rate").hide();

                                                                            $("#assist-tax-rate").val(0);
                                                                        }
                                                                    });
                                                                });
                                                            </script>
                                                            <label>
                                                                <input name="tax_type" class="form-check-input checktax" type="radio" value="rate" />
                                                                Rate
                                                            </label>
                                                            <label>
                                                                <input name="tax_type" class="form-check-input checktax" type="radio" value="amount" />
                                                                Amount
                                                            </label>
                                                        </div>
                                                        <br />

                                                        <input style="display: none;" id="assist-tax" name="tax_amount" type="number" class="form-control" value="0" />
                                                        <select id="assist-tax-rate" name="tax_rate" class="form-select" data-width="47.5%">
                                                            <option value="0" selected>
                                                                Select
                                                            </option>
                                                            @foreach($taxmaster as $data)
                                                            <option value="{{$data->sales_rate}}">{{$data->sales_rate}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="align-dropdown-box"></div>
                                                </div>
                                                <!-- <div class="row">
                                                                                            <div class="col-sm-2">

                                                                                            </div>
                                                                                            <div class="col-sm-4">
                                                                                                <label class="form-label">Supplier
                                                                                                    Service
                                                                                                    Charge</label>
                                                                                            </div>
                                                                                            <div class="col-sm-6">
                                                                                                <input id="item-supplier-charge" name="supplier_service_charge" type="number" class="form-control" value="0">
                                                                                            </div>
                                                                                        </div>
                                                                                        <br /> -->

                                                <!-- <div class="row">
                                                                                            <div class="col-sm-2">

                                                                                            </div>
                                                                                            <div class="col-sm-4">
                                                                                                <label class="form-label">Tax
                                                                                                    Amount</label><br />

                                                                                            </div>
                                                                                            <div class="col-sm-6">
                                                                                           

                                                                                                <input id="item-tax" name="tax_amount" type="number" class="form-control" value="0">
                                                                                                <select id="item-tax-rate" name="tax_amount" class="form-select" data-width="47.5%">
                                                                                                 <option Selected>
                                                                                                        Select
                                                                                                      </option>
                                                                                                      @foreach($taxmaster as $data)
                                                                                                     <option value="{{$data->sales_rate}}">{{$data->sales_rate}}</option>
                                                                                                     @endforeach  
                                                                                                  </select>
                                                                                            </div>
                                                                                        </div>
                                                                                        <br /> -->
                                                <!-- <div class="row">
                                                                                            <div class="col-sm-2">

                                                                                            </div>
                                                                                            <div class="col-sm-4">
                                                                                                <label class="form-label">Invoice
                                                                                                    Total</label>
                                                                                            </div>
                                                                                            <div class="col-sm-6">
                                                                                                <input id="item-invoice" name="total_amount" type="number" class="form-control" value="0" style="background-color: #f5f5f1;">
                                                                                            </div>
                                                                                        </div>
                                                                                        <br />
                                                                                        <div class="row">
                                                                                            <div class="col-sm-2">

                                                                                            </div>
                                                                                            <div class="col-sm-4">
                                                                                                <label class="form-label">Retain</label>
                                                                                            </div>
                                                                                            <div class="col-sm-6">
                                                                                                <input id="item-retain" name="retain" type="number" class="form-control" value="0" style="background-color: #f5f5f1;">
                                                                                            </div>
                                                                                        </div>
                                                                                        <br /> -->
                                            </div>
                                        </div>
                                        <br />
                                        <div style="margin-left: 92%;">
                                            <div class="row">
                                                <button type="submit" value="submit" class="btn btn-primary mr-2" style="width: 100px;">ADD</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>

                            <div id="i" style="display: none;">
                                <form action="/quotation/otherservice/add" method="POST" enctype="multipart/form-data">
                                    @csrf
                                    <input class="userId" type="hidden" name="user_id" value="" />
                                    <input class="dsr_number" type="hidden" name="dsr_number" value="{{$id}}" />
                                    <div>
                                        <div class="row">
                                            <h3 style="margin-bottom: 0.45em; font-family: auto;">
                                                Others
                                            </h3>
                                            <br />
                                            <div class="col-sm-3">
                                                <div class="mb-3">
                                                    <label class="form-label">Item Name </label>
                                                    <input type="text" name="other_details" class="form-control" />
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="mb-3">
                                                    <label class="form-label">Quantity </label>
                                                    <input id="item-quantity" name="quantity" type="number" class="form-control" value="0" />
                                                    <!-- <select class="form-select" data-width="100%">
                                                                                                <option Selected>
                                                                                                    Select
                                                                                                </option>
                                                                                                <option value="DI">
                                                                                                    Kilo Gram
                                                                                                </option>
                                                                                                <option value="RS">
                                                                                                    Gram
                                                                                                </option>
                                                                                            </select> -->
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="mb-3">
                                                    <label class="form-label">Per Price </label>
                                                    <input id="item-price" name="price" type="number" class="form-control" />
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="mb-3">
                                                    <label class="form-label">Total Amount </label>
                                                    <input id="item-total" name="amount" type="number" class="form-control" />
                                                </div>
                                            </div>
                                        </div>
                                        <hr />
                                        <br />
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <!-- <label for="myfile">
                                                                                                <h4>Other
                                                                                                    Details
                                                                                                </h4>
                                                                                            </label>
                                                                                            <br />
                                                                                            <br />
                                                                                            <input type="file" name="other_details">
                                                                                        <br />
                                                                                        <br />
                                                                                        <br />
                                                                                        <div class="mb-3">
                                                                                            <label for="exampleFormControlTextarea1" class="form-label">
                                                                                                <h4>Note</h4>
                                                                                            </label>
                                                                                            <textarea name="remark" class="form-control" id="exampleFormControlTextarea1" rows="3" placeholder="Remark"></textarea>
                                                                                        </div> -->
                                            </div>
                                            <div class="col-sm-6">
                                                <script>
                                                      $(document).ready(function() {


                                                    $('#item-details').on('change', function() {

                                                        var initialOther = {!! json_encode($other->toArray()) !!};

                                                        var selectedType = $(this).val();

                                                      var filteredOther = initialOther.filter(function(other) {
                                                        return other.item_name == selectedType ;
                                                      });


                                                     // Update the visa options
                                                          $('#item-price').val(filteredOther[0].sales_price);
                                                          $('#item-invoice').val(filteredOther[0].sales_price);
                                                          $('#item-total').val(filteredOther[0].sales_price);


                                                    });


                                                    $('#item-tax-rate').change(function() {

                                                    var totalAmount = $('#item-price').val();
                                                    var taxRate = $('#item-tax-rate').val();
                                                    var rate = parseInt(taxRate) / 100;
                                                    console.log(totalAmount)
                                                    console.log(taxRate)

                                                    var taxAmount = totalAmount * rate;
                                                    // $('#item-tax').val(taxAmount);

                                                    $('#item-invoice').val(parseInt(totalAmount) + parseInt(taxAmount));

                                                    });

                                                    $('#item-tax').on('change', function() {

                                                        var itemInvoice = $('#item-invoice');
                                                        var taxAmount = $('#item-tax');
                                                        var itemPrice =   $('#item-price').val();

                                                        itemInvoice.val(parseInt(itemPrice) + parseInt(taxAmount.val()));

                                                    });

                                                    $('#item-supplier-charge').on('change', function() {

                                                        var itemRetain = $('#item-retain');
                                                        var itemPrice = $('#item-price').val();
                                                        var inputVal = $(this).val();

                                                        itemRetain.val(parseInt(itemPrice) - inputVal);

                                                        console.log(inputVal)

                                                    });

                                                      });
                                                </script>

                                                <div class="row">
                                                    <div class="col-sm-2"></div>
                                                    <div class="col-sm-4"><label class="form-label">Tax </label><br /></div>
                                                    <div class="col-sm-6">
                                                        <div>
                                                            <script>
                                                                $(document).ready(function () {
                                                                    $(".checktax").click(function () {
                                                                        var inputVal = $(this).val();

                                                                        if (inputVal == "rate") {
                                                                            $("#other-tax").hide();
                                                                            $("#other-tax-rate").show();

                                                                            $("#other-tax").val(0);
                                                                        } else if (inputVal == "amount") {
                                                                            $("#other-tax").show();
                                                                            $("#other-tax-rate").hide();

                                                                            $("#other-tax-rate").val(0);
                                                                        }
                                                                    });
                                                                });
                                                            </script>
                                                            <label>
                                                                <input name="tax_type" class="form-check-input checktax" type="radio" value="rate" />
                                                                Rate
                                                            </label>
                                                            <label>
                                                                <input name="tax_type" class="form-check-input checktax" type="radio" value="amount" />
                                                                Amount
                                                            </label>
                                                        </div>
                                                        <br />

                                                        <input style="display: none;" id="other-tax" name="tax_amount" type="number" class="form-control" value="0" />
                                                        <select id="other-tax-rate" name="tax_rate" class="form-select" data-width="47.5%">
                                                            <option value="0" selected>
                                                                Select
                                                            </option>
                                                            @foreach($taxmaster as $data)
                                                            <option value="{{$data->sales_rate}}">{{$data->sales_rate}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="align-dropdown-box"></div>
                                                </div>
                                                <!-- <div class="row">
                                                                                            <div class="col-sm-2">

                                                                                            </div>
                                                                                            <div class="col-sm-4">
                                                                                                <label class="form-label">Supplier
                                                                                                    Service
                                                                                                    Charge</label>
                                                                                            </div>
                                                                                            <div class="col-sm-6">
                                                                                                <input id="item-supplier-charge" name="supplier_service_charge" type="number" class="form-control" value="0">
                                                                                            </div>
                                                                                        </div>
                                                                                        <br /> -->

                                                <!-- <div class="row">
                                                                                            <div class="col-sm-2">

                                                                                            </div>
                                                                                            <div class="col-sm-4">
                                                                                                <label class="form-label">Tax
                                                                                                    Amount</label><br />

                                                                                            </div>
                                                                                            <div class="col-sm-6">
                                                                                           

                                                                                                <input id="item-tax" name="tax_amount" type="number" class="form-control" value="0">
                                                                                                <select id="item-tax-rate" name="tax_amount" class="form-select" data-width="47.5%">
                                                                                                 <option Selected>
                                                                                                        Select
                                                                                                      </option>
                                                                                                      @foreach($taxmaster as $data)
                                                                                                     <option value="{{$data->sales_rate}}">{{$data->sales_rate}}</option>
                                                                                                     @endforeach  
                                                                                                  </select>
                                                                                            </div>
                                                                                        </div>
                                                                                        <br /> -->
                                                <!-- <div class="row">
                                                                                            <div class="col-sm-2">

                                                                                            </div>
                                                                                            <div class="col-sm-4">
                                                                                                <label class="form-label">Invoice
                                                                                                    Total</label>
                                                                                            </div>
                                                                                            <div class="col-sm-6">
                                                                                                <input id="item-invoice" name="total_amount" type="number" class="form-control" value="0" style="background-color: #f5f5f1;">
                                                                                            </div>
                                                                                        </div>
                                                                                        <br />
                                                                                        <div class="row">
                                                                                            <div class="col-sm-2">

                                                                                            </div>
                                                                                            <div class="col-sm-4">
                                                                                                <label class="form-label">Retain</label>
                                                                                            </div>
                                                                                            <div class="col-sm-6">
                                                                                                <input id="item-retain" name="retain" type="number" class="form-control" value="0" style="background-color: #f5f5f1;">
                                                                                            </div>
                                                                                        </div>
                                                                                        <br /> -->
                                            </div>
                                        </div>
                                        <br />
                                        <div style="margin-left: 92%;">
                                            <div class="row">
                                                <button type="submit" value="submit" class="btn btn-primary mr-2" style="width: 100px;">ADD</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- Col -->
                    </div>
                    <!-- Row -->

                    <br />
                    <div class="row No_Form" id="noForm">
                        <div class="col-sm-12">
                            <div class="mb-3">
                                <p>No Form Selected</p>
                            </div>
                        </div>
                        <!-- Col -->
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Model -->
</div>



        <br><br><br>

        

      </div><!-- container -->

     
    <style>
    tbody tr:hover {background-color: #F5F5F5;}
    .card-example>.card-body::before {
    content: ""
    }
    </style>
@endsection 
