<?php

namespace App\Http\Controllers\Taxmaster;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Taxmaster\Taxmaster;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Facades\Redirect;

class TaxmasterController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $taxmaster = Taxmaster::orderBy('id', 'DESC')->get();
        return view('taxmaster.index', compact('taxmaster'))
            ->with('i', ($request->input('page', 1) - 1) * 5);
    }


    function status_update($id)
    {
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('taxmaster.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $tax = new Taxmaster;
        $tax->tax_name = $request->input("tax_name");
        $tax->tax_agency = $request->input("tax_agency");
        $tax->discription = $request->input("discription");
        $tax->purchase_rate = $request->input("purchase_rate");
        $tax->purchase_account = $request->input("purchase_account");
        $tax->purchase_amount_return = $request->input("purchase_amount_return");
        $tax->sales_rate = $request->input("sales_rate");
        $tax->sales_account = $request->input("sales_account");
        $tax->sales_amount_return = $request->input("sales_amount_return");
        $tax->save();
        session()->flash('success', 'You\'ve created Taxmaster successfully.');
        return redirect()->route('taxmaster.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function show()
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $tax = Taxmaster::find($id);
        //dd($emp);
        return view('taxmaster.edit', compact('tax'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function update($id, Request $request)
    {
        $tax = Taxmaster::find($id);
        $tax->tax_name = $request->input("tax_name");
        $tax->tax_agency = $request->input("tax_agency");
        $tax->discription = $request->input("discription");
        $tax->purchase_rate = $request->input("purchase_rate");
        $tax->purchase_account = $request->input("purchase_account");
        $tax->purchase_amount_return = $request->input("purchase_amount_return");
        $tax->sales_rate = $request->input("sales_rate");
        $tax->sales_account = $request->input("sales_account");
        $tax->sales_amount_return = $request->input("sales_amount_return");
        $tax->save();
        session()->flash('success', 'You\'ve Updated  Taxmaster successfully.');
        return Redirect::back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $tax = Taxmaster::find($id);
        $tax->delete();
        session()->flash('success', 'You\'ve Deleted Taxmaster successfully.');
        return Redirect::back();
    }
}
