<?php

namespace App\Http\Controllers\Visa;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Visa\Visa;
use Illuminate\Support\Facades\Redirect;

class VisaController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index(Request $request)
    {
        $visa = Visa::orderBy('id', 'DESC')->get();
        //dd($hotel);
        return view('visa.index', compact('visa'))
            ->with('i', ($request->input('page', 1) - 1) * 5);
    }

    function status_update($id)
    {
        return Redirect::back();

        //get product status with the help of product ID
        $visa = Visa::select('status')
            ->where('id', '=', $id)
            ->first();

        //dd($customer);

        //Check user status
        if ($visa->status == 'Active') {
            $status = 'Inactive';
        } else {
            $status = 'Active';
        }

        //update product status
        $values = array('status' => $status);
        //dd($values);
        Visa::where('id', $id)->update($values);

        session()->flash('success', 'You\'ve Change Status Successfully');

        return Redirect::back();
    }


    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        $visa = new Visa;
        $visa->visa_entry_type = $request->input("visa_entry_type");
        $visa->country = $request->input("country");
        $visa->visa_type = $request->input("visa_type");
        $visa->days = $request->input("days");
        $visa->currency = $request->input("currency");
        $visa->price = $request->input("price");
        $visa->status = $request->input("status") ? "Active" : "Inactive";

        $visa->save();
        session()->flash('success', 'You\'ve Added visa Successfully');

        return Redirect::back();
    }

    public function show()
    {
        //
    }


    public function edit($id)
    {
        $visa = Visa::find($id);
        //dd($emp);
        return response()->json([
            'status' => 200,
            'visa' => $visa,
        ]);
    }


    public function update(Request $request)
    {
        $id = $request->input('visa_id');
        $visa = Visa::find($id);
        $visa->visa_entry_type = $request->input("visa_entry_type");
        $visa->country = $request->input("country");
        $visa->visa_type = $request->input("visa_type");
        $visa->days = $request->input("days");
        $visa->currency = $request->input("currency");
        $visa->price = $request->input("price");
        $visa->status = $request->input("status") ? "Active" : "Inactive";
        $visa->update();
        session()->flash('success', 'You\'ve Updated visa Successfully');

        return Redirect::back();
    }

    public function destroy($id)
    {
        $visa = Visa::find($id);
        $visa->delete();
        session()->flash('success', 'You\'ve Deleted Visa Successfully');

        return Redirect::back();
    }
}