<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Imports\VehicleImport;
use App\Imports\TrailerImport;
use App\Imports\TyreInventoryImport;
use App\Imports\BatteryInventoryImport;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class ImportController extends Controller
{
    public function import(Request $request)
    {
        $type= $request->type;
        $request->validate([
            'file' => 'required|file|mimes:xlsx,xls'
        ]);

        if ($type=="Vehicle") {
            
            Excel::import(new VehicleImport, $request->file('file'));
            return back()->with('success', 'Data imported successfully.');
        }
        else if ($type=="Trailer") {

            Excel::import(new TrailerImport, $request->file('file'));
            return back()->with('success', 'Data imported successfully.');
        }
        else if ($type=="TyreInventory") {
            Excel::import(new TyreInventoryImport, $request->file('file'));
            return back()->with('success', 'Data imported successfully.');            
        }
        else if ($type=="BatteryInventory") {
            Excel::import(new BatteryInventoryImport, $request->file('file'));
            return back()->with('success', 'Data imported successfully.');            
        }
        
    }
}
