<?php

namespace App\Http\Controllers\Admin\Masters;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Masters\TrailerType;
use Illuminate\Support\Facades\Redirect;

class TrailerTypeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        $type = TrailerType::orderBy('id', 'DESC')->get();

        return view('masters.trailer_type', compact('type'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $type = new TrailerType;
        $type->name = $request->input("name");
        $type->save();
        
        session()->flash('success', 'Type added successfully.');
        return Redirect::back();
    }
    
    public function update(Request $request)
    {
        $id = $request->input("brand_id");
        $type = TrailerType::find($id);
        $type->name = $request->input("name");
        $type->save();
        
        session()->flash('success', 'Type updated successfully.');

        return Redirect::back();
    }
   

    public function destroy($id)
    {
        //
        $type = TrailerType::find($id);
        $type->delete();
        session()->flash('success', 'Type deleted successfully.');
        
        return Redirect::back();
    }

}
