<?php

namespace App\Http\Controllers\Dashboard;

use Illuminate\Support\Facades\Auth;
use App\Models\User\UserHistory;
use App\Models\User;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Mail;

use SimpleSoftwareIO\QrCode\Facades\QrCode;
use App\Models\Masters\VehicleType;
use App\Models\Masters\ServiceType;
use App\Models\Masters\ActionType;
use App\Models\Masters\InspectionFaq;
use App\Models\Masters\RimInspection;
use App\Models\Masters\BatteryInspection;

use App\Models\Vehicles\Vehicles;
use App\Models\Vehicles\VehicleDocuments;
use App\Models\Vehicles\VehicleInspection;
use App\Models\Vehicles\VehicleTrailers;
use App\Models\Trailers\Trailers;
use App\Models\Trailers\TrailerHistory;
use App\Models\Tires\Tires;
use App\Models\Rims\Rims;
use App\Models\Battery\Batteries;

use App\Models\Tires\TireHistory;
use App\Models\Tires\TireServiceHistory;
use App\Models\Tires\TireInspectionHistory;

use App\Models\Rims\RimHistory;
use App\Models\Rims\RimServiceHistory;
use App\Models\Rims\RimInspectionHistory;

use App\Models\Battery\BatteryHistory;
use App\Models\Battery\BatteryServiceHistory;
use App\Models\Battery\BatteryInspectionHistory;

use App\Models\Vehicles\VehicleTyres;
use App\Models\Vehicles\VehicleRims;
use App\Models\Vehicles\VehicleBatteries;


class DashboardController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
     
    function login(Request $request) {
        
    $username = $request->input('email');
    $password = $request->input('password');

    // $user = DB::table('users')->where('email', $username)->where('role', "Staff")->first();
    $user = DB::table('users')->where('email', $username)->first();

    if ($user && Hash::check($password, $user->password)) {
        // The password is correct, proceed with authentication
        $request->session()->put('username', $username);
        return redirect('/dashboard');
     } else {
        // Invalid credentials
        return redirect()->back()->with('error', 'Invalid credentials');
    }



    }
    
    
    public function store_inspection(Request $request)
    {
        
        $username= $request->session()->get('username');
        $date = date('Y-m-d');
        $user = User::where('email', $username)->first();
        $vehicle_id = $request->input("vehicle_id");
        $odometer_value_new = $request->input("odometer_value");

        $type = new VehicleInspection;
        $type->vehicle_id = $request->input("vehicle_id");
        $type->date = $date;
        $type->inspection_user = $user->id;
        $type->odometer_value = $request->input("odometer_value");
        $type->attachment = $request->input("attachment");
        $type->remarks = $request->input("remarks");

        $type->save();
        
        $tyres= Tires::where('location_status', 'Vehicle')->where('vehicle_id', $vehicle_id)->get();
        // $tyre->odometer_value= $odometer_value;
        // $tyre->save();
        
        foreach ($tyres as $tire) {
    $odometer_value_old = $tire->odometer_value;
    $tire->odometer_value = $odometer_value_new + $odometer_value_old;
    $tire->save();
}
        
        
        session()->flash('success', 'Odometer value updated successfully.');
        return Redirect::back();
    }


    public function home(Request $request)
    {
        $vehicles = Vehicles::orderBy('id', 'DESC')->get();
        return view('dashboard.home', compact('vehicles'));
    }
    
    public function vehicle($id)
    {
        $vehicle = Vehicles::where('vehicle_id', $id)->first();
        $vid= $vehicle->id;
        $image= $vehicle->axle_tyre_configuration;
        $data = json_decode($image, true);
        
        $vehicle_trailers =  VehicleTrailers::where('vehicle_id', $vid)->get();
        
        return view('dashboard.vehicle', compact('id','data',  'vehicle_trailers', 'vehicle'));
    }
    
    public function viewTyre($id ,$position)
    {
        $tyres = Tires::where('location_status', 'Store')->get();
        $vehicle_tyres = VehicleTyres::where('vehicle_id', $id)->where('tyre_position', $position)->first();
        
        if($vehicle_tyres){
          $tire_id= $vehicle_tyres->tyre_id;
        $tire = Tires::where('tire_id', $tire_id)->first();
        $service_type = ServiceType::all();
        $action_type = ActionType::all();
        $faq = InspectionFaq::all();

        // return $tire_id;


        $tire_history = TireHistory::where('tire_id', $id)->take(2)->get();
      return  $service_history = TireServiceHistory::where('tire_id', $id)->take(2)->get();
        $inspection_history = TireInspectionHistory::where('tire_id', $tire_id)->take(2)->get();
        $inspection = TireInspectionHistory::where('tire_id', $tire->id)
                             ->latest('created_at') 
                             ->first();      
        if($inspection){
            $action_needed= $inspection->action_type;
        }
        else{
          $action_needed='';
            
        }

          

        return view('dashboard.tyre', compact('tire', 'id', 'position', 'service_type', 'action_type', 'tire_history', 'service_history', 'inspection_history', 'faq', 'action_needed'));
            
        }
        else{
          session()->flash('error', 'Tyre has not installed yet');
           return redirect()->back();
            
        }
        
    }
    
     public function viewRim($id ,$position)
    {
        $tyres = Rims::where('location_status', 'Store')->get();
        $vehicle_tyres = VehicleRims::where('vehicle_id', $id)->where('rim_position', $position)->first();
        
        if($vehicle_tyres){
          $tire_id= $vehicle_tyres->rim_id;
        $tire = Rims::where('rim_id', $tire_id)->first();
        $service_type = ServiceType::all();
        $action_type = ActionType::all();
        $faq = RimInspection::all();
        
        $vehicle_tire = VehicleRims::where('rim_id', $tire_id)->first();
        if($vehicle_tire){
          $position=$vehicle_tire->rim_position;
        }
        else{
          $position='';
            
        }
        
        $rim_history = RimHistory::where('rim_id', $tire->id)->take(2)->get();
        $service_history = RimServiceHistory::where('rim_id', $tire->id)->take(2)->get();
        $inspection_history = RimInspectionHistory::where('rim_id', $tire->id)->take(2)->get();
        $inspection = RimInspectionHistory::where('rim_id', $tire->id)
                             ->latest('created_at') 
                             ->first();      
        if($inspection){
            $action_needed= $inspection->action_type;
        }
        else{
          $action_needed='';
            
        }

     
        return view('dashboard.rim', compact('tire', 'faq', 'action_type', 'service_type', 'rim_history', 'service_history', 'inspection_history', 'position', 'action_needed'));
        
        // return view('rim.view', compact('tire', 'id', 'position', 'service_type', 'action_type'));
            
        }
        else{
          session()->flash('error', 'Rim has not installed yet');
       return redirect()->back();
            
        }
        
    }
    
     public function viewBattery($id ,$position)
    {
        $tyres = Batteries::where('location_status', 'Store')->get();
        $vehicle_tyres = VehicleBatteries::where('vehicle_id', $id)->where('battery_position', $position)->first();
        
        if($vehicle_tyres){
          $tire_id= $vehicle_tyres->battery_id;
        $tire = Batteries::where('battery_id', $tire_id)->first();
        $service_type = ServiceType::all();
        $action_type = ActionType::all();
        
        $faq = BatteryInspection::all();
        
        $vehicle_tire = VehicleBatteries::where('battery_id', $tire_id)->first();
        if($vehicle_tire){
          $position=$vehicle_tire->battery_position;
        }
        else{
          $position='';
            
        }
        

        $battery_history = BatteryHistory::where('battery_id', $tire_id)->take(2)->get();
        $service_history = BatteryServiceHistory::where('battery_id', $tire->id)->take(2)->get();
        $inspection_history = BatteryInspectionHistory::where('battery_id', $tire->id)->take(2)->get();
        $inspection = BatteryInspectionHistory::where('battery_id', $tire->id)
                             ->latest('created_at') 
                             ->first();      
        if($inspection){
            $action_needed= $inspection->action_type;
        }
        else{
          $action_needed='';
            
        }

     
        return view('dashboard.battery', compact('tire', 'faq', 'action_type', 'service_type', 'battery_history', 'service_history', 'inspection_history', 'position', 'action_needed'));
            

          

          return view('battery.view', compact('tire', 'id', 'position', 'service_type', 'action_type'));
            
        }
        else{
          session()->flash('error', 'Battery has not installed yet');
       return redirect()->back();
            
        }

    }

    
   
    public function documents($id)
    {
        $documents = VehicleDocuments::where('vehicle_id', $id)->get();

        return view('vehicle.vehicle_documents', compact('id','documents'));
    }
    
   
    public function tyre_history($id)
    {
        $tyre_history = TireHistory::orderBy('id', 'DESC')->where('tire_id', $id)->get();
        return view('dashboard.tyre_history', compact('tyre_history'));
    }
    
    public function tyre_service_history($id)
    {
        $service_history = TireServiceHistory::orderBy('id', 'DESC')->where('tire_id', $id)->get();
        return view('dashboard.tyre_service', compact('service_history'));
    }
    
    public function tyre_inspection_history($id)
    {
        $inspection_history = TireInspectionHistory::orderBy('id', 'DESC')->where('tire_id', $id)->get();
        return view('dashboard.tyre_inspection', compact('inspection_history'));
    }
    
    
     public function rim_history($id)
    {
        $rim_history = TireHistory::orderBy('id', 'DESC')->where('rim_id', $id)->get();
        return view('dashboard.rim_history', compact('rim_history'));
    }
    
    public function rim_service_history($id)
    {
        $service_history = TireServiceHistory::orderBy('id', 'DESC')->where('rim_id', $id)->get();
        return view('dashboard.rim_service', compact('service_history'));
    }
    
    public function rim_inspection_history($id)
    {
        $inspection_history = TireInspectionHistory::orderBy('id', 'DESC')->where('rim_id', $id)->get();
        return view('dashboard.rim_inspection', compact('inspection_history'));
    }
    
     public function battery_history($id)
    {
        $battery_history = TireHistory::orderBy('id', 'DESC')->where('tire_id', $id)->get();
        return view('dashboard.battery_history', compact('battery_history'));
    }
    
    public function battery_service_history($id)
    {
        $service_history = TireServiceHistory::orderBy('id', 'DESC')->where('tire_id', $id)->get();
        return view('dashboard.battery_service', compact('service_history'));
    }
    
    public function battery_inspection_history($id)
    {
        $inspection_history = TireInspectionHistory::orderBy('id', 'DESC')->where('tire_id', $id)->get();
        return view('dashboard.battery_inspection', compact('inspection_history'));
    }
   
    public function destroy($id)
    {
        $tourPack = Vehicles::find($id);
        $tourPack->delete();
        session()->flash('success', 'Vehicle deleted Successfully');

        return Redirect::back();
    }
}
