<?php

namespace App\Imports;

use App\Models\Inventory\BatteryInventory;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Carbon\Carbon; // Import Carbon for date parsing

class BatteryInventoryImport implements ToModel
{
   

    public function model(array $row)
    {
        return new BatteryInventory([
            'date' => Carbon::parse($row[0]),
            'fleet_no' => $row[1],
            'brand' => $row[2],
            'model_name' => $row[3],
            'capacity_ah' => $row[4],
            'battery_type' => $row[5],
            'voltage' => $row[6],
            'dry_weight' => $row[7],
            'model_number' => $row[8],
            'cold_cranking_amps' => $row[9],
            'reserve_capacity_minutes' => $row[10],
            'quantity' => $row[11],
            'unit_price' => $row[12],
            'total_price' => $row[13],
            'currency' => $row[14],
            'purchased_date' => Carbon::parse($row[15]),
            'warranty_type' => $row[16],
            'warranty_start_date' => Carbon::parse($row[17]),
            'warranty_end_date' => Carbon::parse($row[18]),
            'attachment' => $row[19], // Handle attachment as needed
            'remarks' => $row[20],
        ]);
    }
}
