<?php

namespace App\Imports;

use App\Models\Vehicles\Vehicles;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Carbon\Carbon; // Import Carbon for date parsing

class VehicleImport implements ToModel
{
    

    public function model(array $row)
    {
        return new Vehicles([
            'vehicle_id' => $row[0],
            'vehicle_type' => $row[1],
            'make' => $row[2],
            'model' => $row[3],
            'year' => $row[4],
            'vin_number' => $row[5],
            'registration_number' => $row[6],
            'title_status' => $row[7],
            'fuel_type' => $row[8],
            'engine_type' => $row[9],
            'transmission_type' => $row[10],
            'color' => $row[11],
            'mileage' => $row[12],
            'last_trip_end_date' => Carbon::parse($row[13]),
            'purchase_date' => Carbon::parse($row[14]),
            'purchase_price' => $row[15],
            'owner_name' => $row[16],
            'owner_contact' => $row[17],
            'gps_device_id' => $row[18],
            'vehicle_class' => $row[19],
            'axle_tyre_configuration' => $row[20],
        ]);
    }
}
