
@extends('layout.master')

@section('content')

<div class="main-mobile-header doc-mobile-header">
      <a id="menuLink" href="#" class="menu-link"><i class="ri-menu-line"></i></a>
    </div>

   

    



     <div class="main main-app p-3 p-lg-4">
        
        <div class="mb-4">
          <ol class="breadcrumb fs-sm mb-1">
            <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
            <li class="breadcrumb-item active" aria-current="page">Edit Trailer</li>
          </ol>
        </div>

      

      <div class="">
        
        <div class="row">

          <div class="col-lg-8">
            <h2 class="main-title">Edit Trailer</h2>
            
          </div>
          <div style="text-align: right;" class="col-lg-4 text-right">
           <!--  <button type="button" class="btn btn-primary">Add Taxmaster</button> -->
            <!-- <a href="/form" class="btn btn-primary">Add Taxmaster</a>
 -->
          </div>

        </div>

        <hr class="main-separator">        
    
            
       <div class="card card-shadow-apply">
    <div class="card-body">
        <form action="{{ route('trailer.update') }}" method="POST">
            @csrf
            <input type="hidden" name="id" value="{{ $trailer->id }}">
            
            <div class="row">
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Trailer ID</label>
                        <input type="text" name="trailer_id" placeholder="Trailer ID" class="form-control" value="{{ $trailer->trailer_id }}" readonly />
                    </div>
                </div>
                
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Trailer Type</label>
                        <select class="form-select" name="trailer_type">
                            <option vlaue="">Select</option>
                            @foreach ($trailer_type as $key => $service)
                                      <option {{ $trailer->trailer_type === $service->name ? 'selected' : '' }}>{{ $service->name }}</option>
                             @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Manufacturer</label>
                        <select class="form-select" name="manufacturer">
                            <option vlaue="">Select</option>
                            @foreach ($trailer_brand as $key => $service)
                                      <option {{ $trailer->manufacturer === $service->name ? 'selected' : '' }}>{{ $service->name }}</option>
                             @endforeach
                        </select>
                    </div>
                </div>
                
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Model</label>
                        <span class="required-field">*</span>
                        <input type="text" name="model" placeholder="Model" class="form-control" value="{{ $trailer->model }}" required />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Year</label>
                        <input type="number" name="year" placeholder="Year" class="form-control" value="{{ $trailer->year }}" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Length (ft)</label>
                        <input type="number" name="length" placeholder="Length (ft)" class="form-control" value="{{ $trailer->length }}" />
                    </div>
                </div>
            
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Width (ft)</label>
                        <input type="number" name="width" placeholder="Width (ft)" class="form-control" value="{{ $trailer->width }}" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Height (ft)</label>
                        <input type="number" name="height" placeholder="Height (ft)" class="form-control" value="{{ $trailer->height }}" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">GVWR (lbs)</label>
                        <input type="number" name="gvwr" placeholder="GVWR (lbs)" class="form-control" value="{{ $trailer->gvwr }}" />
                    </div>
                </div>

                <!--<div class="col-sm-4">-->
                <!--    <div class="mb-3">-->
                <!--        <label class="form-label">Axle Configuration</label>-->
                <!--        <input type="text" name="axle_tyre_configuration" placeholder="Axle Configuration" class="form-control" value="{{ $trailer->axle_tyre_configuration }}" />-->
                <!--    </div>-->
                <!--</div>-->
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Tare Weight (lbs)</label>
                        <input type="number" name="tare_weight" placeholder="Tare Weight (lbs)" class="form-control" value="{{ $trailer->tare_weight }}" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Payload Capacity (lbs)</label>
                        <input type="number" name="payload_capacity" placeholder="Payload Capacity (lbs)" class="form-control" value="{{ $trailer->payload_capacity }}" />
                    </div>
                </div>
            
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Status</label>
                        <input type="text" name="status" placeholder="Status" class="form-control" value="{{ $trailer->status }}" />
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="mb-3">
                        <label class="form-label">Remarks</label>
                        <textarea name="remarks" placeholder="Remarks" class="form-control" rows="3">{{ $trailer->remarks }}</textarea>
                    </div>
                </div>
            </div>

            <div class="buttons-alignment mt-4">
                <div>
                    <button type="submit" class="btn btn-primary submit-button-alignment">Update</button>
                </div>
            </div>
        </form>
    </div>
</div>












        <br><br><br>

        

      </div><!-- container -->

     
    <style>
    tbody tr:hover {background-color: #F5F5F5;}
    .card-example>.card-body::before {
    content: ""
    }
    </style>


<script>

</script>


<script>
    $(document).ready(function() {
        $("#tour_package").validate({
            rules: {
                package_name: {
                    required: true,
                    maxlength: 20,
                },
                destination: {
                    required: true,
                    maxlength: 20,
                },
                days: {
                    required: true,
                    maxlength: 20,
                },
                hotel_type: {
                    required: true,
                    maxlength: 20,
                },
                meal: {
                    required: true,
                    maxlength: 20,
                },
                currency: {
                    required: true,
                    maxlength: 20,
                },
                price_per_person: {
                    required: true,
                    maxlength: 20,
                },
            },
            messages: {
                package_name: {
                    required: "Package Name is required",
                    maxlength: "Package Name cannot be more than 20 characters"
                },

                destination: {
                    required: "Destination  is required",
                    maxlength: "Destination  cannot be more than 20 characters",
                },

                days: {
                    required: "Day is required",
                    maxlength: "Day cannot be more than 20 characters",
                },

                hotel_type: {
                    required: "Hotel is required",
                    maxlength: "Hotel cannot be more than 20 characters",
                },

                meal: {
                    required: "Meal Price is required",
                    maxlength: "Meal Price cannot be more than 20 characters",
                },

                currency: {
                    required: "Currency is required",
                    maxlength: "Currency cannot be more than 20 characters",
                },

                price_per_person: {
                    required: "Price is required",
                    maxlength: "Price cannot be more than 20 characters",
                },

            }
        });
    });

    $('.select2').select2();
</script>

@endsection

