<!DOCTYPE html>
<html lang="en">
<head>

  <meta charset="utf-8">
  <title>TMS | Inspect Vehicles</title>

  <!-- Mobile Specific Metas
  ================================================== -->
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=5.0">
  <meta name="description" content="Create your ecommerce store">
  <meta name="author" content="TMS">

  <!-- Favicon -->
  <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('public/user/images/favicon.png')); ?>" />
    <!--<link rel="stylesheet" href="https://tms.vokks.in/assets/css/style.css">-->
  
  <!-- PLUGINS CSS STYLE -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.2/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.css" integrity="sha512-wR4oNhLBHf7smjy0K4oqzdWumd+r5/+6QO/vDda76MW5iug4PT7v86FoEkySIJft3XA0Ae6axhIvHrqwm793Nw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.css" integrity="sha512-6lLUdeQ5uheMFbWm3CP271l14RsX1xtx+J5x2yeIDkkiBpeVTNhTqijME7GgRKKi6hCqovwCoBTlRBEC20M8Mg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<!--   <link rel="stylesheet" href="plugins/aos/aos.css">
 -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css" integrity="sha512-xh6O/CkQoPOWDdYTDqeRdPCVd1SpvCA9XXcUnZS2FmJNp1coAFzvtCN9BmamE+4aHK8yyUHUSCcJHgXloTyT2A==" crossorigin="anonymous" referrerpolicy="no-referrer" />

  <link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Alata&family=Outfit&display=swap" rel="stylesheet">

  <!-- CUSTOM CSS -->
  <link href="<?php echo e(asset('public/user/css/styles.css')); ?>" rel="stylesheet">
  
 <style>
        /* Vehicle Container */
        .front {
            display: flex;
            align-items: center;
        }

        /* Left Wheel */
        .wheel {
            width: 25px;
            height: 60px;
            background: radial-gradient(#b5aeae, #312e2e);
            border-radius: 20px;
            margin: 0 5px;
        }
        .wheel-danger{
            background: radial-gradient(#f7f7f7, #ed1010)!important;
        }
        .wheel-zero{
            background: radial-gradient(#f7f7f7, #d1b9b9)!important;
        }
        .wheel-green{
            background: radial-gradient(#f7f7f7, #27a511)!important;
        }
        
        .rim {
            width: 10px;
    height: 30px;
    background: radial-gradient(#b5aeae, #a19999);
    border-radius: 20px;
    margin: 0 5px;
        }

        /* Vehicle Body */
        .body {
            width: 100px;
            height: 40px;
            background-color: #333;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        /* Middle Bar */
        .bar {
            width: 10px;
            height: 40px;
            background-color: #333;
        }
        .vehicle{
            display: flex;
    flex-direction: column;
    align-items: center;
        }
        .space{
            width: 0px;
            margin: 30px auto;
        }
        .rod{
            width: 20px;
    height: 100px;
    background: darkgray;
    border: 2px solid #c1a1a1;
        }
    </style>

</head>

<body style="background: aliceblue;" class="body-wrapper" data-spy="scroll" data-target=".privacy-nav">


<nav style="padding: 15px 0px!important;" class="navbar navbar-expand-lg sticky-top bg-white shadow-sm">
  <div class="container">
    <a class="navbar-brand m-auto" href="#"><img style="width:150px!important;" src="https://tab-tms.codesquarry.online/assets/images/logo.png"   alt="logo"></a>
    <!--<button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">-->
    <!--  <span class="navbar-toggler-icon"></span>-->
    <!--</button>-->
    <!--<div class="collapse navbar-collapse" id="navbarNav">-->
    <!--  <ul style="margin-left: auto;" class="navbar-nav ml-auto">-->
    <!--    <li class="nav-item">-->
    <!--      <a class="nav-link active" aria-current="page" href="#">Home</a>-->
    <!--    </li>-->
        
    <!--    <li class="nav-item">-->
    <!--      <a class="nav-link" href="#about">About</a>-->
    <!--    </li>-->
    <!--    <li class="nav-item">-->
    <!--      <a class="nav-link" href="#contact">Contact</a>-->
    <!--    </li>-->
        
    <!--  </ul>-->
    <!--</div>-->
  </div>
</nav>

<!--====================================
=            Hero Section            =
=====================================-->

   <section style="margin-top: 0px!important; background: teal;" class="booking-section py-5 text-white" id="book_now">
                <h1 class="text-center">Rim Inspection History </h1>
                

                
<div style="margin-top: 20px;" id="unassigned">
    <div class="card card-example">
    <div class="card-body" style="background-color: white; min-height: 600px;">
        <div class="table-responsive">
            <table id="tableGrid1" class="table table-hover">
                <thead class="text-center">
                    <tr>
                        <th>No</th>
                        <th>Date</th>
                        <th>Tread Depth</th>
                        <th>Pressure</th>
                        <th>Condition</th>
                        <th>Current Rolling (KM)</th>
                        <th>Attachment</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $inspection_history; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tire): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($key + 1); ?></td>
                        <td><?php echo e($tire->inspection_date); ?></td>
                        <td><?php echo e($tire->tread_depth_mm); ?></td>
                        <td><?php echo e($tire->pressure); ?></td>
                        <td><?php echo e($tire->tire_condition); ?></td>
                        <td><?php echo e($tire->current_rolling_km); ?></td>
                        <td>
                            <?php echo e($tire->attachment); ?>

                        </td>
                        
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div><!-- table-responsive -->
    </div><!-- card-body -->
</div><!-- card -->
     </div>




    </section>
            
            
            
            
            

    




<!--============================
=            Footer            =
=============================-->
<footer style="background: black;">
  
  <div class="text-center py-4">
    <small class="text-white">Tms &copy; <script>document.write(new Date().getFullYear())</script>. All rights reserved</small class="text-secondary">
  </div>

	<div class="text-center py-1">
     <!-- <small class="text-white"> <p>Designed By <a href="https://tms.com/">TMS</a></p></small> -->  
    </div>
</footer>


  <!-- To Top -->
  <!-- <div class="scroll-top">
    <i class="ti-angle-up"></i>
  </div> -->
  
  <!-- JAVASCRIPTS -->
  <script src="https://code.jquery.com/jquery-3.6.1.js" integrity="sha256-3zlB5s2uwoUzrXK3BT7AX3FyvojsraNFxCc2vC/7pNI=" crossorigin="anonymous"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.2/dist/js/bootstrap.min.js" integrity="sha384-IDwe1+LCz02ROU9k972gdyvl+AESN10+x7tBKgc9I5HFtuNz0wWnPclzo6p9vxnk" crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.js" integrity="sha512-XtmMtDEcNz2j7ekrtHvOVR4iwwaD6o/FUJe6+Zq+HgcCsk3kj4uSQQR8weQ2QVj1o0Pk6PwYLohm206ZzNfubg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.js" integrity="sha512-A7AYk1fGKX6S2SsHywmPkrnzTZHrgiVT7GcQkLGDe2ev0aWb8zejytzS8wjo7PGEXKqJOrjQ4oORtnimIRZBtw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
  <!-- google map -->
<!--   <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAgeuuDfRlweIs7D6uo4wdIHVvJ0LonQ6g"></script>
 -->  
  <script src="<?php echo e(asset('public/user/js/script.js')); ?>"></script>
  
  <script>
        // Add event listeners to radio buttons using jQuery
        $(document).ready(function () {
            $('#scan-qr').change(function () {
                if ($(this).is(':checked')) {
                    $('#scan-qr-content').show();
                    $('#search-id-content').hide();
                }
            });

            $('#search-id').change(function () {
                if ($(this).is(':checked')) {
                    $('#scan-qr-content').hide();
                    $('#search-id-content').show();
                }
            });
        });
    </script>
</body>

</html><?php /**PATH /home/megamarket/public_html/tms/resources/views/dashboard/tyre_inspection.blade.php ENDPATH**/ ?>