<?php

namespace App\Http\Controllers\Admin\Masters;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Masters\BatteryActionType;
use Illuminate\Support\Facades\Redirect;

class BatteryActionTypeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        $type = BatteryActionType::orderBy('id', 'DESC')->get();

        return view('masters.battery_action_type', compact('type'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $type = new BatteryActionType;
        $type->name = $request->input("name");
        $type->save();
        
        session()->flash('success', 'ActionType added successfully.');
        return Redirect::back();
    }
    
    public function update(Request $request)
    {
        $id = $request->input("brand_id");
        $type = BatteryActionType::find($id);
        $type->name = $request->input("name");
        $type->save();
        
        session()->flash('success', 'ActionType updated successfully.');

        return Redirect::back();
    }
   

    public function destroy($id)
    {
        //
        $type = BatteryActionType::find($id);
        $type->delete();
        session()->flash('success', 'ActionType deleted successfully.');
        
        return Redirect::back();
    }

}
