<?php

namespace App\Http\Controllers\Admin\Masters;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Masters\RimBrands;
use Illuminate\Support\Facades\Redirect;

class RimBrandsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        $type = RimBrands::orderBy('id', 'DESC')->get();

        return view('masters.rim_brand', compact('type'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $type = new RimBrands;
        $type->name = $request->input("name");
        $type->save();
        
        session()->flash('success', 'Brand added successfully.');
        return Redirect::back();
    }
    
    public function update(Request $request)
    {
        $id = $request->input("brand_id");
        $type = RimBrands::find($id);
        $type->name = $request->input("name");
        $type->save();
        
        session()->flash('success', 'Brand updated successfully.');

        return Redirect::back();
    }
   

    public function destroy($id)
    {
        //
        $type = RimBrands::find($id);
        $type->delete();
        session()->flash('success', 'Brand deleted successfully.');
        
        return Redirect::back();
    }

}
