<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\Masters\InspectionFaq;
use App\Models\Masters\ActionType;
use App\Models\Tires\Tires;
use App\Models\Tires\TyreHistory;
use App\Models\Tires\TyreInspectionHistory;
use App\Models\Inventory\TyreInventory;
use App\Models\Inventory\InventoryHistory;
use Illuminate\Support\Facades\Redirect;

class TyreController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index(Request $request)
    {
        $tyre = Tires::orderBy('id', 'DESC')->get();
        return view('tyre.index', compact('tyre'));
    }


    public function create()
    {
         $tyres = TyreInventory::all();
        return view('tyre.create', compact('tyres'));
    }
    
    
    
    public function store(Request $request)
{
    
    $tire_id = $request->input('item_id');
    $inventory = TyreInventory::find($tire_id);

    // Create a new tyre instance and populate it with request data
    $tire = new Tires;

    // Assign all request fields to the corresponding model fields
    $tire->tire_id = $request->input('tire_id');
    // Assuming you have $inventory and $tire objects
    $tire->warranty_type = $inventory->warranty_type;
    $tire->warranty_start_date = $inventory->warranty_start_date;
    $tire->warranty_end_date = $inventory->warranty_end_date;
    $tire->commercial_name = $inventory->commercial_name;
    $tire->identity = $inventory->identity;
    $tire->load_pressure_information = $inventory->load_pressure_information;
    $tire->indicated_exterior = $inventory->indicated_exterior;
    $tire->type_of_construction = $inventory->type_of_construction;
    $tire->tyre_sections_width_mm = $inventory->tyre_sections_width_mm;
    $tire->section_height_to_section_width_ratio = $inventory->section_height_to_section_width_ratio;
    $tire->rim_diameter_inches = $inventory->rim_diameter_inches;
    $tire->load_capacity_index = $inventory->load_capacity_index;
    $tire->speed_rating = $inventory->speed_rating;
    $tire->tyre_type = $inventory->tyre_type;
    $tire->remarks = $inventory->remarks;

    // Save the tire to the database
    $tire->save();
    
    $date = date('Y-m-d');
    
    $inventoryHistory = new InventoryHistory;
    $inventoryHistory->date = $date;
    $inventoryHistory->inventory_id = $request->input('item_id');
    $inventoryHistory->item_code = $request->input('tire_id');
    $inventoryHistory->save();

    


    // Redirect to the tyre's details page or the index page
    session()->flash('success', 'Tyre Added Successfully');
    return redirect()->route('tyres');
}


    public function store_history(Request $request)
    {

        $type = new TireServiceHistory;
        $type->tire_id = $request->input("tire_id");
        $type->service_date = $request->input("date");
        $type->service_type = $request->input("service_type");
        $type->cost = $request->input("cost");
        $type->attachment = $request->input("attachment");
        $type->description = $request->input("description");
       
        $type->save();
        
        session()->flash('success', 'Tyre  Service added successfully.');
        return Redirect::back();
    }
    
    public function store_services(Request $request)
    {

        $type = new TireServiceHistory;
        $type->tire_id = $request->input("tire_id");
        $type->service_date = $request->input("date");
        $type->service_type = $request->input("service_type");
        $type->cost = $request->input("cost");
        $type->attachment = $request->input("attachment");
        $type->description = $request->input("description");
       
        $type->save();
        
        session()->flash('success', 'Tyre  Service added successfully.');
        return Redirect::back();
    }
    
    public function store_inspection(Request $request)
    {

        $type = new TireInspectionHistory;
        $type->tire_id = $request->input("tire_id");
        $type->inspection_date = $request->input("inspection_date");
        $type->tread_depth_mm = $request->input("tread_depth_mm");
        $type->tread_depth_mm = $request->input("tread_depth_mm");
        $type->question = $request->input("question");
        $type->tread_depth_mm = $request->input("tread_depth_mm");
        $type->question_ = $request->input("question_");
        $type->is_good_condition = $request->input("is_good_condition");
        $type->attachment = $request->input("attachment");
        $type->description = $request->input("description");       
        $type->save();

        
        session()->flash('success', 'Tyre  Inspection added successfully.');
        return Redirect::back();
    }

    
   

    public function show($id)
    {
        $tire = Tires::find($id);
        $faq = InspectionFaq::all();
        $action_type = ActionType::all();
        //dd($emp);
        return view('tyre.view', compact('tire', 'faq', 'action_type'));
    }


    public function edit($id, Request $request)
    {
        $tire = Tires::find($id);

        return view('tyre.edit', compact('tire'));
    }


    public function update($id, Request $request)
    {
        $tyre = Tires::find($id);
       
        $tyre->status = $request->input("status") ? "Active" : "Inactive";
        $tyre->save();
        session()->flash('success', 'Tyre Updated Successfully');

        return Redirect::back();
    }

    public function destroy($id)
    {
        $tyre = Tires::find($id);
        $tyre->delete();
        session()->flash('success', 'Tyre Deleted Successfully');

        return Redirect::back();
    }
}
