<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Redirect;
use App\Models\User\UserModel;
use App\Models\User\UserHistory;
use App\Models\User;
use App\Models\Permission;

class UserManagementController extends Controller
{
    //
    function index(Request $request){
        // echo "data is to be pasted----------------------------------------------";
        // return view("Users/users");
        $data = User::all();
        $permission = Permission::all();
        return view('users.users', compact('data', 'permission'))
            ->with('i', ($request->input('page', 1) - 1) * 5);
    }
    
    function history(){
       
      return  $data = UserHistory::all();
        $permission = Permission::all();
        return view('users.history', compact('data', 'permission'))
            ->with('i', ($request->input('page', 1) - 1) * 5);
    }
    
    function edit($id){
        // echo "data is to be pasted----------------------------------------------";
        // return view("Users/users");
        $user = UserModel::find($id);
        $permission = Permission::where('user_id', $id)->first();
        return view('users.edit', compact('user', 'permission'));
    }
    
    function create(Request $request){
        
        $password = Hash::make($request->input("password"));

        $user = new UserModel;
        $user->name=$request->input("employee_name_modal");
        $user->email=$request->input("employee_email_modal");
        $user->password=$password;
        $user->save();

        $persion = new Permission;
        $persion->user_id= $user->id;
        $persion->sales_data=$request->input("sales_data");
        $persion->approval=$request->input("approval");
        $persion->customer=$request->input("customer");
        $persion->sales=$request->input("sales");
        $persion->purchases=$request->input("purchases");
        $persion->grn=$request->input("grn");
        $persion->products_services=$request->input("products_services");
        $persion->accounts=$request->input("accounts");
        $persion->employee=$request->input("employee");
        $persion->user_management=0;
        $persion->save();
        
        return Redirect::back()->withErrors(['msg' => 'The Message']);

        
        // Alert::success('Congrats', 'You\'ve Added Entry Successfully');
        // return Redirect::back()->withErrors(['msg' => 'The Message']);
        // return view("Users/users");
    }
    function update(Request $request){
                
        $id=$request->input("id");
        $password = Hash::make($request->input("password"));

        $user = UserModel::find($id);
        $user->name=$request->input("employee_name_modal");
        $user->email=$request->input("employee_email_modal");
        if($request->input("password")) {
        $user->password=$password;
        }
        $user->save();

        $persion = Permission::where('user_id', $id)->first();
        $persion->sales_data=$request->input("sales_data");
        $persion->approval=$request->input("approval");
        $persion->customer=$request->input("customer");
        $persion->sales=$request->input("sales");
        $persion->purchases=$request->input("purchases");
        $persion->grn=$request->input("grn");
        $persion->products_services=$request->input("products_services");
        $persion->accounts=$request->input("accounts");
        $persion->employee=$request->input("employee");
        $persion->save();        
        session()->flash('success','Updated Successfully');
        return Redirect::back()->withErrors(['msg' => 'The Message']);
    }
    
    function delete($id){
        $user_create = UserModel::find($id);
        $user_create->delete();
        return Redirect::back()->withErrors(['msg' => 'The Message']);
        
    }
}

