<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Support\Facades\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

use SimpleSoftwareIO\QrCode\Facades\QrCode;
use App\Models\Masters\VehicleType;
use App\Models\Masters\VehicleBrands;
use App\Models\Masters\ServiceType;
use App\Models\Masters\RimServiceType;
use App\Models\Masters\BatteryServiceType;
use App\Models\Masters\ActionType;
use App\Models\Masters\RimActionType;
use App\Models\Masters\BatteryActionType;
use App\Models\Masters\DocumentType;
use App\Models\Masters\InspectionFaq;
use App\Models\Masters\RimInspection;
use App\Models\Masters\BatteryInspection;

use App\Models\Vehicles\Vehicles;
use App\Models\Vehicles\VehicleDocuments;
use App\Models\Vehicles\VehicleInspection;
use App\Models\Vehicles\VehicleTrailers;
use App\Models\Trailers\Trailers;
use App\Models\Trailers\TrailerHistory;
use App\Models\Tires\Tires;
use App\Models\Tires\TireHistory;
use App\Models\Tires\TireServiceHistory;
use App\Models\Tires\TireInspectionHistory;
use App\Models\Rims\Rims;
use App\Models\Battery\Batteries;

use App\Models\Rims\RimHistory;
use App\Models\Rims\RimServiceHistory;
use App\Models\Rims\RimInspectionHistory;

use App\Models\Battery\BatteryHistory;
use App\Models\Battery\BatteryServiceHistory;
use App\Models\Battery\BatteryInspectionHistory;

use App\Models\Vehicles\VehicleTyres;
use App\Models\Vehicles\VehicleRims;
use App\Models\Vehicles\VehicleBatteries;
use App\Models\Vehicles\VehicleStepneyTyres;
use App\Models\Vehicles\VehicleStepneyRims;

use App\Models\User\UserHistory;


use Illuminate\Support\Facades\Redirect;

class VehicleController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index(Request $request)
    {
        $vehicles = Vehicles::orderBy('id', 'DESC')->get();
        return view('vehicle.index', compact('vehicles'));
    }


    public function create()
    {
        $vehicle_type = VehicleType::all();
        $vehicle_brand = VehicleBrands::all();
        return view('vehicle.create', compact('vehicle_type', 'vehicle_brand'));
    }
    

    
    
     public function add_battery($id ,$position)
    {
        $tyres = Batteries::where('location_status', 'Store')->get();
        $vehicle_tyres = VehicleBatteries::where('vehicle_id', $id)->where('battery_position', $position)->first();
        
        if($vehicle_tyres){
          $tire_id= $vehicle_tyres->battery_id;
        $tire = Batteries::where('battery_id', $tire_id)->first();
        $service_type = ServiceType::all();
        $action_type = ActionType::all();
        
        $faq = BatteryInspection::all();
        
        $vehicle_tire = VehicleBatteries::where('battery_id', $tire_id)->first();
        if($vehicle_tire){
          $position=$vehicle_tire->battery_position;
        }
        else{
          $position='';
            
        }
        

        $battery_history = BatteryHistory::where('battery_id', $tire_id)->take(2)->get();
        $service_history = BatteryServiceHistory::where('battery_id', $tire->id)->take(2)->get();
        $inspection_history = BatteryInspectionHistory::where('battery_id', $tire->id)->take(2)->get();
        $inspection = BatteryInspectionHistory::where('battery_id', $tire->id)
                             ->latest('created_at') 
                             ->first();      
        if($inspection){
            $action_needed= $inspection->action_type;
        }
        else{
          $action_needed='';
            
        }

     
        return view('battery.view', compact('tire', 'faq', 'action_type', 'service_type', 'battery_history', 'service_history', 'inspection_history', 'position', 'action_needed'));
            

          

          return view('battery.view', compact('tire', 'id', 'position', 'service_type', 'action_type'));
            
        }
        else{
          return view('vehicle.add_battery', compact('tyres', 'id', 'position'));
            
        }
        
    }
    
       public function install_battery(Request $request){
           
        
        $date = date('Y-m-d');
        $time = date('H:i:s');  
        $user = Auth::user();
        $battery_id = $request->input('battery_id');
        $vehicle_id = $request->input('vehicle_id');
        $ve = Vehicles::find($vehicle_id);
        $v_id=$ve->vehicle_id;
           
        $vehicle = new VehicleBatteries();
        $vehicle->vehicle_id = $request->input('vehicle_id');
        $vehicle->battery_id = $request->input('battery_id');
        $vehicle->battery_position = $request->input('battery_position');
       
        // Save the vehicle tyre record
        $vehicle->save();
        
        $tire = Batteries::where('battery_id', $battery_id)->first();
        $tire->installation_date = $date;
        $tire->vehicle_id = $request->input('vehicle_id');
        $tire->location_status = 'Vehicle';
        $tire->save();
        
        $UserHistory = new UserHistory();
        $UserHistory->user_id = $user->id;
        $UserHistory->module = 'Battery';
        $UserHistory->action_type = 'Added Battery to vehicle (' . $v_id . ')';
        $UserHistory->item_id = $request->input('battery_id');
        $UserHistory->date = $date;
        $UserHistory->time = $time;
        $UserHistory->save();
        
        $type = new BatteryHistory;
        $type->battery_id = $tire->id;
        $type->date = $date;
        $type->moved_from = 'Store';
        $type->moved_to = 'Vehicle';
        $type->vehicle_id= $request->input('vehicle_id');
        $type->attachment = $request->input("attachment");
        $type->remark = $request->input("remark");
        $type->save();
        
         // Redirect to the vehicle's details page or the index page
       session()->flash('success', 'Battery Added to vehicle Successfully');

       return redirect()->back();
    //   return redirect()->route('vehicles');
           
       }
       
       
        public function view_battery($id ,$position)
    {
        $tyres = Batteries::where('location_status', 'Store')->get();
        $vehicle_tyres = VehicleBatteries::where('vehicle_id', $id)->where('battery_position', $position)->first();
        
        if($vehicle_tyres){
          $tire_id= $vehicle_tyres->battery_id;
        $tire = Batteries::where('battery_id', $tire_id)->first();
        $service_type = BatteryServiceType::all();
        $action_type = BatteryActionType::all();
        
        $faq = BatteryInspection::all();
        
        $vehicle_tire = VehicleBatteries::where('battery_id', $tire_id)->first();
        if($vehicle_tire){
          $position=$vehicle_tire->battery_position;
        }
        else{
          $position='';
            
        }
        

        $battery_history = BatteryHistory::where('battery_id', $tire_id)->take(2)->get();
        $service_history = BatteryServiceHistory::where('battery_id', $tire->id)->take(2)->get();
        $inspection_history = BatteryInspectionHistory::where('battery_id', $tire->id)->take(2)->get();
        $inspection = BatteryInspectionHistory::where('battery_id', $tire->id)
                             ->latest('created_at') 
                             ->first();      
        if($inspection){
            $action_needed= $inspection->action_type;
        }
        else{
          $action_needed='';
            
        }

     
        return view('battery.view', compact('tire', 'faq', 'action_type', 'service_type', 'battery_history', 'service_history', 'inspection_history', 'position', 'action_needed'));
            

          

          return view('battery.view', compact('tire', 'id', 'position', 'service_type', 'action_type'));
            
        }
        else{
          session()->flash('error', 'Battery has not installed yet');
       return redirect()->back();
            
        }
        
    }
    
    public function add_stepney_tyre($id ,$position)
    {
        $tyres = Tires::where('location_status', 'Store')->get();
        $vehicle_tyres = VehicleStepneyTyres::where('vehicle_id', $id)->where('tyre_position', $position)->first();
        
        if($vehicle_tyres){
          $tire_id= $vehicle_tyres->tyre_id;
        $tire = Tires::where('tire_id', $tire_id)->first();
        $service_type = ServiceType::all();
        $action_type = ActionType::all();

        $faq = InspectionFaq::all();

        
        $tire_history = TireHistory::orderBy('id', 'DESC')->where('tire_id', $tire->id)->take(2)->get();
        $service_history = TireServiceHistory::orderBy('id', 'DESC')->where('tire_id', $tire->id)->take(2)->get();
        $inspection_history = TireInspectionHistory::where('tire_id', $tire->id)->take(2)->get();
        $inspection = TireInspectionHistory::where('tire_id', $tire->id)
                             ->latest('created_at') 
                             ->first();      
        if($inspection){
            $action_needed= $inspection->action_type;
        }
        else{
          $action_needed='';
            
        }

           

        return view('tyre.view', compact('tire', 'id', 'position', 'service_type', 'action_type', 'tire_history', 'service_history', 'inspection_history', 'faq', 'action_needed'));
            
        }
        else{
          return view('vehicle.add_stepney_tyre', compact('tyres', 'id', 'position'));
            
        }
        
    }
    
    public function install_stepney_tyre(Request $request){
           
        $date = date('Y-m-d');
        $time = date('H:i:s');  
        $user = Auth::user();
        $tire_id = $request->input('tire_id');
        $vehicle_id = $request->input('vehicle_id');
        $ve = Vehicles::find($vehicle_id);
        $v_id=$ve->vehicle_id;


           
        $vehicle = new VehicleStepneyTyres();
        $vehicle->vehicle_id = $request->input('vehicle_id');
        $vehicle->tyre_id = $request->input('tire_id');
        $vehicle->tyre_position = $request->input('tire_position');
       
        // Save the vehicle tyre record
        $vehicle->save();
        
        $tire = Tires::where('tire_id', $tire_id)->first();
        $tire->installation_date = $date;
        $tire->vehicle_id = $request->input('vehicle_id');
        $tire->position_on_vehicle = $request->input('tire_position');
        $tire->location_status = 'Vehicle';
        $tire->save();
        
        $UserHistory = new UserHistory();
        $UserHistory->user_id = $user->id;
        $UserHistory->module = 'Tyre';
        $UserHistory->action_type = 'Added Stepney Tyre to vehicle (' . $v_id . ')';
        $UserHistory->item_id = $request->input('tire_id');
        $UserHistory->date = $date;
        $UserHistory->time = $time;
        $UserHistory->save();
        
        $type = new TireHistory;
        $type->tire_id = $tire->id;
        $type->date = $date;
        $type->moved_from = 'Store';
        $type->moved_to = 'Vehicle';
        $type->vehicle_id= $request->input('vehicle_id');
        $type->attachment = $request->input("attachment");
        $type->remark = $request->input("remark");
        $type->save();
        
         // Redirect to the vehicle's details page or the index page
       session()->flash('success', 'Stepney Tyre Added to vehicle Successfully');
       return redirect()->back();
    //   return redirect()->route('vehicles');
           
       }
       
       
    public function view_stepney_tyre($id ,$position)
    {
        $tyres = Tires::where('location_status', 'Store')->get();
        $vehicle_tyres = VehicleStepneyTyres::where('vehicle_id', $id)->where('tyre_position', $position)->first();
        
        if($vehicle_tyres){
          $tire_id= $vehicle_tyres->tyre_id;
        $tire = Tires::where('tire_id', $tire_id)->first();
        $service_type = ServiceType::all();
        $action_type = ActionType::all();

        $faq = InspectionFaq::all();

        

        $tire_history = TireHistory::where('tire_id', $tire->id)->take(2)->get();
        $service_history = TireServiceHistory::where('tire_id', $tire->id)->take(2)->get();
        $inspection_history = TireInspectionHistory::where('tire_id', $tire->id)->take(2)->get();
        $inspection = TireInspectionHistory::where('tire_id', $tire->id)
                             ->latest('created_at') 
                             ->first();      
        if($inspection){
            $action_needed= $inspection->action_type;
        }
        else{
          $action_needed='';
            
        }

          

        return view('tyre.view', compact('tire', 'id', 'position', 'service_type', 'action_type', 'tire_history', 'service_history', 'inspection_history', 'faq', 'action_needed'));
             
        }
        else{
          session()->flash('error', 'Stepney tyre has not installed yet');
       return redirect()->back();
            
        }
        
    }
    
    public function add_stepney_rim($id ,$position)
    {
        $tyres = Rims::where('location_status', 'Store')->get();
        $vehicle_tyres = VehicleStepneyRims::where('vehicle_id', $id)->where('rim_position', $position)->first();
        
        if($vehicle_tyres){
          $tire_id= $vehicle_tyres->rim_id;
        $tire = Rims::where('rim_id', $tire_id)->first();
        $service_type = ServiceType::all();
        $action_type = ActionType::all();

        $faq = InspectionFaq::all();
        

        $vehicle_tire = VehicleRims::where('rim_id', $tire_id)->first();
        if($vehicle_tire){
          $position=$vehicle_tire->rim_position;
        }
        else{
          $position='';
            
        }
        
        $rim_history = RimHistory::where('rim_id', $tire->id)->take(2)->get();
        $service_history = RimServiceHistory::where('rim_id', $tire->id)->take(2)->get();
        $inspection_history = RimInspectionHistory::where('rim_id', $tire->id)->take(2)->get();
        $inspection = RimInspectionHistory::where('rim_id', $tire->id)
                             ->latest('created_at') 
                             ->first();      
        if($inspection){
            $action_needed= $inspection->action_type;
        }
        else{
          $action_needed='';
            
        }

     
        return view('rim.view', compact('tire', 'faq', 'action_type', 'service_type', 'rim_history', 'service_history', 'inspection_history', 'position', 'action_needed'));
    
        }
        else{
          return view('vehicle.add_stepney_rim', compact('tyres', 'id', 'position'));
            
        }
        
    }
    
    public function install_stepney_rim(Request $request){
           
        
        
        $date = date('Y-m-d');
        $time = date('H:i:s');  
        $user = Auth::user();
        $rim_id = $request->input('rim_id');
        $vehicle_id = $request->input('vehicle_id');
        $ve = Vehicles::find($vehicle_id);
        $v_id=$ve->vehicle_id;
           
        $vehicle = new VehicleStepneyRims();
        $vehicle->vehicle_id = $request->input('vehicle_id');
        $vehicle->rim_id = $request->input('rim_id');
        $vehicle->rim_position = $request->input('rim_position');
       
        // Save the vehicle tyre record
        $vehicle->save();
        
        $tire = Rims::where('rim_id', $rim_id)->first();
        $tire->installation_date = $date;
        $tire->vehicle_id = $request->input('vehicle_id');
        $tire->position_on_vehicle = $request->input('rim_position');
        $tire->location_status = 'Vehicle';
        $tire->save();
        
        $UserHistory = new UserHistory();
        $UserHistory->user_id = $user->id;
        $UserHistory->module = 'Rim';
        $UserHistory->action_type = 'Added Stepney Rim to vehicle (' . $v_id . ')';
        $UserHistory->item_id = $request->input('rim_id');
        $UserHistory->date = $date;
        $UserHistory->time = $time;
        $UserHistory->save();
        
        $type = new RimHistory;
        $type->rim_id = $tire->id;
        $type->date = $date;
        $type->moved_from = 'Store';
        $type->moved_to = 'Vehicle';
        $type->vehicle_id= $request->input('vehicle_id');
        $type->attachment = $request->input("attachment");
        $type->remark = $request->input("remark");
        $type->save();
        
         // Redirect to the vehicle's details page or the index page
       session()->flash('success', 'Stepney Tyre Added to vehicle Successfully');

       return redirect()->back();
    //   return redirect()->route('vehicles');
           
       }
       
       
    public function view_stepney_rim($id ,$position)
    {
        $tyres = Rims::where('location_status', 'Store')->get();
        $vehicle_tyres = VehicleStepneyRims::where('vehicle_id', $id)->where('rim_position', $position)->first();
        
        if($vehicle_tyres){
          $tire_id= $vehicle_tyres->rim_id;
        $tire = Rims::where('rim_id', $tire_id)->first();
        $service_type = RimServiceType::all();
        $action_type = RimActionType::all();

        $faq = InspectionFaq::all();
        

        $tire_history = RimHistory::where('rim_id', $id)->take(2)->get();
        $service_history = RimServiceHistory::where('rim_id', $id)->take(2)->get();
        $inspection_history = RimInspectionHistory::where('rim_id', $id)->take(2)->get();

          

        return view('rim.view', compact('tire', 'id', 'position', 'service_type', 'action_type', 'tire_history', 'service_history', 'inspection_history', 'faq'));
            
        }
        else{
          session()->flash('error', 'Stepney rim has not installed yet');
       return redirect()->back();
            
        }
        
    }
    
    public function viewTyre($id ,$position)
    {
        $tyres = Tires::where('location_status', 'Store')->get();
        $vehicle_tyres = VehicleTyres::where('vehicle_id', $id)->where('tyre_position', $position)->first();
        
        if($vehicle_tyres){
          $tire_id= $vehicle_tyres->tyre_id;
        $tire = Tires::where('tire_id', $tire_id)->first();
        $service_type = ServiceType::all();
        $action_type = ActionType::all();
        $faq = InspectionFaq::all();

        

        $tire_history = TireHistory::where('tire_id', $tire->id)->take(2)->get();
        $service_history = TireServiceHistory::where('tire_id', $tire->id)->take(2)->get();
        $inspection_history = TireInspectionHistory::where('tire_id', $tire->id)->take(2)->get();
        $inspection = TireInspectionHistory::where('tire_id', $tire->id)
                             ->latest('created_at') 
                             ->first();      
        if($inspection){
            $action_needed= $inspection->action_type;
        }
        else{
          $action_needed='';
            
        }

          

        return view('tyre.view', compact('tire', 'id', 'position', 'service_type', 'action_type', 'tire_history', 'service_history', 'inspection_history', 'faq', 'action_needed'));
            
        }
        else{
          session()->flash('error', 'Tyre has not installed yet');
       return redirect()->back();
            
        }
        
    }    
    
     public function addTyre($id ,$position)
    {
        $tyres = Tires::where('location_status', 'Store')->get();
        $vehicle_tyres = VehicleTyres::where('vehicle_id', $id)->where('tyre_position', $position)->first();
        
        if($vehicle_tyres){
          $tire_id= $vehicle_tyres->tyre_id;
        $tire = Tires::where('tire_id', $tire_id)->first();
        $service_type = ServiceType::all();
        $action_type = ActionType::all();
        $faq = InspectionFaq::all();

        

        $tire_history = TireHistory::orderBy('id', 'DESC')->where('tire_id', $tire->id)->take(2)->get();
        $service_history = TireServiceHistory::orderBy('id', 'DESC')->where('tire_id', $tire->id)->take(2)->get();
        $inspection_history = TireInspectionHistory::where('tire_id', $tire->id)->take(2)->get();
        $inspection = TireInspectionHistory::where('tire_id', $tire->id)
                             ->latest('created_at') 
                             ->first();      
        if($inspection){
            $action_needed= $inspection->action_type;
        }
        else{
          $action_needed='';
            
        }

           

        return view('tyre.view', compact('tire', 'id', 'position', 'service_type', 'action_type', 'tire_history', 'service_history', 'inspection_history', 'faq', 'action_needed'));
            
        }
        else{
          return view('vehicle.add_tyre', compact('tyres', 'id', 'position'));
            
        }
        
    }
    
       public function install_tyre(Request $request){
           
        $date = date('Y-m-d');
        $time = date('H:i:s');  
        $user = Auth::user();
        $tire_id = $request->input('tire_id');
        $vehicle_id = $request->input('vehicle_id');
        $ve = Vehicles::find($vehicle_id);
        $v_id=$ve->vehicle_id;


           
        $vehicle = new VehicleTyres();
        $vehicle->vehicle_id = $request->input('vehicle_id');
        $vehicle->tyre_id = $request->input('tire_id');
        $vehicle->tyre_position = $request->input('tire_position');
       
        // Save the vehicle tyre record
        $vehicle->save();
        
        $tire = Tires::where('tire_id', $tire_id)->first();
        $tire->installation_date = $date;
        $tire->vehicle_id = $request->input('vehicle_id');
        $tire->position_on_vehicle = $request->input('tire_position');
        $tire->location_status = 'Vehicle';
        $tire->save();
        
        $UserHistory = new UserHistory();
        $UserHistory->user_id = $user->id;
        $UserHistory->module = 'Tyre';
        $UserHistory->action_type = 'Added Tyre to vehicle (' . $v_id . ')';
        $UserHistory->item_id = $request->input('tire_id');
        $UserHistory->date = $date;
        $UserHistory->time = $time;
        $UserHistory->save();
        
        $type = new TireHistory;
        $type->tire_id = $tire->id;
        $type->date = $date;
        $type->moved_from = 'Store';
        $type->moved_to = 'Vehicle';
        $type->vehicle_id= $vehicle->id;
        $type->attachment = $request->input("attachment");
        $type->remark = $request->input("remark");
        $type->save();
        
        
        
         // Redirect to the vehicle's details page or the index page
       session()->flash('success', 'Tyre Added to vehicle Successfully');

       return redirect()->back();
    //   return redirect()->route('vehicles');
           
       }
       
       
        public function viewRim($id ,$position)
    {
        $tyres = Rims::where('location_status', 'Store')->get();
        $vehicle_tyres = VehicleRims::where('vehicle_id', $id)->where('rim_position', $position)->first();
        
        if($vehicle_tyres){
          $tire_id= $vehicle_tyres->rim_id;
        $tire = Rims::where('rim_id', $tire_id)->first();
        $service_type = RimServiceType::all();
        $action_type = RimActionType::all();
        
        $faq = RimInspection::all();
        
        $vehicle_tire = VehicleRims::where('rim_id', $tire_id)->first();
        if($vehicle_tire){
          $position=$vehicle_tire->rim_position;
        }
        else{
          $position='';
            
        }
        
        $rim_history = RimHistory::where('rim_id', $tire->id)->take(2)->get();
        $service_history = RimServiceHistory::where('rim_id', $tire->id)->take(2)->get();
        $inspection_history = RimInspectionHistory::where('rim_id', $tire->id)->take(2)->get();
        $inspection = RimInspectionHistory::where('rim_id', $tire->id)
                             ->latest('created_at') 
                             ->first();      
        if($inspection){
            $action_needed= $inspection->action_type;
        }
        else{
          $action_needed='';
            
        }

     
        return view('rim.view', compact('tire', 'faq', 'action_type', 'service_type', 'rim_history', 'service_history', 'inspection_history', 'position', 'action_needed'));
    

          

          return view('rim.view', compact('tire', 'id', 'position', 'service_type', 'action_type'));
            
        }
        else{
          session()->flash('error', 'Rim has not installed yet');
       return redirect()->back();
            
        }
        
    }
    
        public function addRim($id ,$position)
    {
        $tyres = Rims::where('location_status', 'Store')->get();
        $vehicle_tyres = VehicleRims::where('vehicle_id', $id)->where('rim_position', $position)->first();
        
        if($vehicle_tyres){
          $tire_id= $vehicle_tyres->rim_id;
        $tire = Rims::where('rim_id', $tire_id)->first();
        $service_type = ServiceType::all();
        $action_type = ActionType::all();
        
        $faq = RimInspection::all();
        
        $vehicle_tire = VehicleRims::where('rim_id', $tire_id)->first();
        if($vehicle_tire){
          $position=$vehicle_tire->rim_position;
        }
        else{
          $position='';
            
        }
        
        $rim_history = RimHistory::where('rim_id', $tire->id)->take(2)->get();
        $service_history = RimServiceHistory::where('rim_id', $tire->id)->take(2)->get();
        $inspection_history = RimInspectionHistory::where('rim_id', $tire->id)->take(2)->get();
        $inspection = RimInspectionHistory::where('rim_id', $tire->id)
                             ->latest('created_at') 
                             ->first();      
        if($inspection){
            $action_needed= $inspection->action_type;
        }
        else{
          $action_needed='';
            
        }

     
        return view('rim.view', compact('tire', 'faq', 'action_type', 'service_type', 'rim_history', 'service_history', 'inspection_history', 'position', 'action_needed'));
    

          return view('rim.view', compact('tire', 'id', 'position', 'service_type', 'action_type'));
            
        }
        else{
          return view('vehicle.add_rim', compact('tyres', 'id', 'position'));
            
        }
        
    }
    
       public function install_rim(Request $request){
           
        $date = date('Y-m-d');
        $time = date('H:i:s');  
        $user = Auth::user();
        $rim_id = $request->input('rim_id');
        $vehicle_id = $request->input('vehicle_id');
        $ve = Vehicles::find($vehicle_id);
        $v_id=$ve->vehicle_id;
           
        $vehicle = new VehicleRims();
        $vehicle->vehicle_id = $request->input('vehicle_id');
        $vehicle->rim_id = $request->input('rim_id');
        $vehicle->rim_position = $request->input('rim_position');
       
        // Save the vehicle tyre record
        $vehicle->save();
        
        $tire = Rims::where('rim_id', $rim_id)->first();
        $tire->installation_date = $date;
        $tire->vehicle_id = $request->input('vehicle_id');
        $tire->position_on_vehicle = $request->input('rim_position');
        $tire->location_status = 'Vehicle';
        $tire->save();
        
        $UserHistory = new UserHistory();
        $UserHistory->user_id = $user->id;
        $UserHistory->module = 'Rim';
        $UserHistory->action_type = 'Added Rim to vehicle (' . $v_id . ')';
        $UserHistory->item_id = $request->input('rim_id');
        $UserHistory->date = $date;
        $UserHistory->time = $time;
        $UserHistory->save();
        
        $type = new RimHistory;
        $type->rim_id = $tire->id;
        $type->date = $date;
        $type->moved_from = 'Store';
        $type->moved_to = 'Vehicle';
        $type->vehicle_id= $request->input('vehicle_id');
        $type->attachment = $request->input("attachment");
        $type->remark = $request->input("remark");
        $type->save();
        
         // Redirect to the vehicle's details page or the index page
       session()->flash('success', 'Rim Added to vehicle Successfully');

       return redirect()->back();
    //   return redirect()->route('vehicles');
           
       }
            
        

    
    public function qr_gn(Request $request){

      $vehicles= Vehicles::all();
      foreach($vehicles as $data){

        $vehicleId= $data->vehicle_id;
        QrCode::size(200)->format('png')->margin(2)->generate($vehicleId, public_path('uploads/' . $vehicleId . '.png'));
        $qrCode=$vehicleId . '.png';

        $vehicle=Vehicles::where('vehicle_id', $vehicleId)->first();
        $vehicle->qr_code=$qrCode;
        $vehicle->save();

      }

    }
    
    
    public function store(Request $request)
{

    $vehicleId = $request->input('vehicle_id');

    // Generate the QR code with just the vehicle ID
    // $qrCode = QrCode::size(2000)->generate($vehicleId);
    //   QrCode::size(200)->format('png')->generate($vehicleId, public_path('uploads/' . $vehicleId . '.png'));
    //   QrCode::size(200)->format('png')->backgroundColor(255, 255, 255)->generate($vehicleId, public_path('uploads/' . $vehicleId . '.png'));
       QrCode::size(200)->format('png')->margin(2)->generate($vehicleId, public_path('uploads/' . $vehicleId . '.png'));
       $qrCode=$vehicleId . '.png';


    // Store the QR code in the database (assuming you have a 'qrcode' column)

    
      $config = [
    [
        "axle" => "Front Axle",
        "no_tyre" => 2,
        "position" => "F",
        "battery_labels" => [
         "Battery1",
         "Battery2"
         ],
        "tire_labels_left" => ["FL0"],
        "tire_labels_right" => ["FR0"],
        "rim_labels_left" => ["RL0"],
        "rim_labels_right" => ["RR0"],
    ],
    [
        "axle" => "Rear Axle",
        "no_tyre" => 2,
        "position" => "R",
        "stepney_labels" => [
         "Stepney1",
         "Stepney2"
         ],
        "tire_labels_left" => ["RL0"],
        "tire_labels_right" => ["RR0"],
        "rim_labels_left" => ["RL0"],
        "rim_labels_right" => ["RR0"],
    ],
];


    
    // Create a new vehicle record
        $vehicle = new Vehicles();
        $vehicle->vehicle_id = $request->input('vehicle_id');
        $vehicle->vehicle_type = $request->input('vehicle_type');
        $vehicle->make = $request->input('make');
        $vehicle->model = $request->input('model');
        $vehicle->year = $request->input('year');
        $vehicle->vin_number = $request->input('vin_number');
        $vehicle->registration_number = $request->input('registration_number');
        $vehicle->title_status = $request->input('title_status');
        $vehicle->fuel_type = $request->input('fuel_type');
        $vehicle->engine_type = $request->input('engine_type');
        $vehicle->transmission_type = $request->input('transmission_type');
        $vehicle->color = $request->input('color');
        $vehicle->mileage = $request->input('mileage');
        $vehicle->purchase_date = $request->input('purchase_date');
        $vehicle->purchase_price = $request->input('purchase_price');
        $vehicle->owner_name = $request->input('owner_name');
        $vehicle->owner_contact = $request->input('owner_contact');
        $vehicle->gps_device_id = $request->input('gps_device_id');
        $vehicle->vehicle_class = $request->input('vehicle_class');
        $vehicle->notes_comments = $request->input('notes_comments');
        
        $jsonData = json_encode($config);

        $vehicle->axle_tyre_configuration = $jsonData;
        $vehicle->qr_code = $qrCode;

        // Save the vehicle record
        $vehicle->save();
        $vehicle->id;

    // Redirect to the vehicle's details page or the index page
    session()->flash('success', 'Vehicle Added Successfully');
    return redirect()->route('vehicle.configuration', $vehicle->id);
}


        public function download_qr($id)
{
     $image = Vehicles::findOrFail($id);
     $pathToFile = public_path('uploads/' . $image->qr_code);
    // $pathToFile = url('uploads/' . $image->qr_code);


if ($image->qr_code!='') {
    return response()->download($pathToFile);
} else {
    session()->flash('success', 'QR Code does not exist.');
    return redirect()->back();
}



    // $pathToFile = storage_path('app/public/documents/document.pdf');
    // $headers = [
    //     'Content-Type' => 'application/pdf',
    // ];
    // return response()->download($pathToFile, 'document.pdf', $headers);
}


    public function store_documents(Request $request)
    {

        $type = new VehicleDocuments;
        $type->vehicle_id = $request->input("vehicle_id");
        $type->document_type = $request->input("document_type");
        $type->id_number = $request->input("id_number");
        $type->issue_date = $request->input("issue_date");
        $type->expiry_date = $request->input("expiry_date");
        $type->renewal_date = $request->input("renewal_date");
        $type->remarks = $request->input("remarks");
        
        if ($request->file('attachment_file')) {
            $photo = $request->file('attachment_file');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $type->attachment_file = $filename;
        }

        $type->save();
        
        session()->flash('success', 'Vehicle Documents added successfully.');
        return Redirect::back();
    }
    
    public function update_documents(Request $request)
    {
        $id = $request->input("vehicle_id");

        $type = VehicleDocuments::find($id);
        $type->document_type = $request->input("document_type");
        $type->id_number = $request->input("id_number");
        $type->issue_date = $request->input("issue_date");
        $type->expiry_date = $request->input("expiry_date");
        $type->renewal_date = $request->input("renewal_date");
        $type->remarks = $request->input("remarks");
        
        if ($request->file('attachment_file')) {
            $photo = $request->file('attachment_file');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $type->attachment_file = $filename;
        }

        $type->save();
        
        session()->flash('success', 'Vehicle Documents updated successfully.');
        return Redirect::back();
    }

    
   
    public function image($id)
    {
        $trailers = Trailers::where('location_status', 'Parking')->get();
        
        $vehicle = Vehicles::find($id);
        $image= $vehicle->axle_tyre_configuration;
        $data = json_decode($image, true);
        
        $vehicle_trailers =  VehicleTrailers::where('vehicle_id', $id)->get();
        


        return view('vehicle.vehicle_image', compact('id','data', 'trailers', 'vehicle_trailers', 'vehicle'));
    }
    
    public function documents($id)
    {
        
        $document_type = DocumentType::all();
        $documents = VehicleDocuments::where('vehicle_id', $id)->get();

        return view('vehicle.vehicle_documents', compact('id','documents', 'document_type'));
    }
    
    public function configuration($id)
    {
        $vehicle = Vehicles::find($id);
        $image= $vehicle->axle_tyre_configuration;
        $data = json_decode($image, true);


        return view('vehicle.edit_configuration', compact('id','data'));
    }
    
    public function imageStore(Request $request)
    {
      $axle_tyre_configuration=  $request->input('axle_tyre_configuration');
      $id=  $request->input('vehicle_id');
        
        $vehicle = Vehicles::find($id);
        $vehicle->axle_tyre_configuration = $axle_tyre_configuration;
        $vehicle->save();
        // $data = json_decode($image, true);

        return Redirect::back();
        // return redirect()->route('vehicle.image', $id);

        // return view('vehicle.vehicle_image', compact('data'));
    }

    public function show($id)
    {
        $vehicle = Vehicles::find($id);
        //dd($emp);
        return view('vehicle.show', compact('vehicle'));
    }


    public function edit($id, Request $request)
    {
        $vehicle = Vehicles::find($id);
        $vehicle_type = VehicleType::all();
        $vehicle_brand = VehicleBrands::all();
        return view('vehicle.edit', compact('vehicle', 'vehicle_type', 'vehicle_brand'));
    }
    
     public function attach_trailer($id){
         
        $trailers = Trailers::all();
        return view('vehicle.add_trailer', compact('id', 'trailers'));
     }

     public function add_trailer(Request $request)
    {
    $trailer_id = $request->input('trailer_id');
    $trailer_data =  Trailers::where('id', $trailer_id)->first();
    $axle_tyre_configuration= $trailer_data->axle_tyre_configuration;
        
    $vehicleTrailer = new VehicleTrailers();
    // Assign values from the request to the model fields
    $vehicleTrailer->vehicle_id = $request->input('vehicle_id');
    $vehicleTrailer->trailer_id = $request->input('trailer_id');
    $vehicleTrailer->trailer_configuration = $axle_tyre_configuration;
    $vehicleTrailer->save();
    
    
    $trailerHistory = new TrailerHistory();
    // Assign values from the request to the model fields
    $trailerHistory->date = $request->input('date');
    $trailerHistory->action_type = 'Added';
    $trailerHistory->vehicle_id = $request->input('vehicle_id');
    $trailerHistory->trailer_id = $request->input('trailer_id');
    // $trailerHistory->remarks = $request->input('remarks');
    $trailerHistory->save();
    
    $trailer =  Trailers::where('id', $trailer_id)->first();
    $trailer->vehicle_id= $request->input('vehicle_id');
    $trailer->save();

        
    session()->flash('success', 'Trailer Added Successfully');
    return Redirect::back();
    
    }
    
    public function remove_trailer($id)
    {
        $date = date('Y-m-d');

        $trailer =  VehicleTrailers::where('trailer_id', $id)->first();
        $vehicle_id= $trailer->vehicle_id;
        $trailer->delete();
        
        $trailerHistory = new TrailerHistory();
    // Assign values from the request to the model fields
    $trailerHistory->date = $date;
    $trailerHistory->action_type = 'Removed';
    $trailerHistory->vehicle_id = $vehicle_id;
    $trailerHistory->trailer_id = $id;
    // $trailerHistory->remarks = $request->input('remarks');
    $trailerHistory->save();
    
    $trailer =  Trailers::where('id', $id)->first();
    $trailer->vehicle_id= '';
    $trailer->save();
        
    
    session()->flash('success', 'Trailer Removed Successfully');
    return Redirect::back();
    
    }


    public function update(Request $request)
    {
        $id = $request->input('id');

        $vehicle = Vehicles::find($id);
        $vehicle->vehicle_id = $request->input('vehicle_id');
        $vehicle->vehicle_type = $request->input('vehicle_type');
        $vehicle->make = $request->input('make');
        $vehicle->model = $request->input('model');
        $vehicle->year = $request->input('year');
        $vehicle->vin_number = $request->input('vin_number');
        $vehicle->registration_number = $request->input('registration_number');
        $vehicle->title_status = $request->input('title_status');
        $vehicle->fuel_type = $request->input('fuel_type');
        $vehicle->engine_type = $request->input('engine_type');
        $vehicle->transmission_type = $request->input('transmission_type');
        $vehicle->color = $request->input('color');
        $vehicle->mileage = $request->input('mileage');
        $vehicle->purchase_date = $request->input('purchase_date');
        $vehicle->purchase_price = $request->input('purchase_price');
        $vehicle->owner_name = $request->input('owner_name');
        $vehicle->owner_contact = $request->input('owner_contact');
        $vehicle->gps_device_id = $request->input('gps_device_id');
        $vehicle->vehicle_class = $request->input('vehicle_class');
        $vehicle->notes_comments = $request->input('notes_comments');
       
        // $vehicle->status = $request->input("status") ? "Active" : "Inactive";
        $vehicle->save();
        session()->flash('success', 'Vehicle Updated Successfully');

        return Redirect::back();
    }

    public function destroy($id)
    {
        $tourPack = Vehicles::find($id);
        $tourPack->delete();
        session()->flash('success', 'Vehicle deleted Successfully');

        return Redirect::back();
    }
}
