@extends('layouts.master')

@section('content')

<div class="row">
  <div class="col-lg-12 margin-tb">
    <div class="pull-left">
      <h2>Users Management</h2>
    </div>
    <br>
    <div class=" mt-5 mb-3">
      <a type="button" href="{{ route('users.create') }}" class="btn btn-success btn-icon-text mb-2 mb-md-0">
        <i class="btn-icon-prepend" data-feather="user"></i>
        Create New User
      </a>
    </div>
  </div>
</div>

@if ($message = Session::get('success'))
   @include('sweetalert::alert')
@endif


<div class="col-md-12 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <div class="table-responsive">
        <table id="dataTableExample" class="table">
          <thead>
            <tr>
              <th>No</th>
              <th>Name</th>
              <th>Email</th>
              <th>Roles</th>
              <th width="280px">Action</th>
            </tr>
          </thead>
          <tbody>
            @foreach ($data as $key => $user)
            <tr>
              <td>{{ ++$i }}</td>
              <td>{{ $user->name }}</td>
              <td>{{ $user->email }}</td>
              @if(!empty($user->getRoleNames()))
              @foreach($user->getRoleNames() as $v)
              <td><span class="badge bg-success">{{ $v }}</span></td>
              @endforeach
              @endif
              </td>
              <td>
                <a class="btn btn-info" href="{{ route('users.show',$user->id) }}"><i class="btn-icon-prepend" data-feather="eye"></i></a>
                <a class="btn btn-primary" href="{{ route('users.edit',$user->id) }}"><i class="btn-icon-prepend" data-feather="edit"></i></a>
                {!! Form::open(['method' => 'DELETE','route' => ['users.destroy', $user->id],'style'=>'display:inline']) !!}
                {{ Form::button('<i class="btn-icon-prepend" data-feather="trash"></i>', ['type' => 'submit', 'class' => 'btn btn-danger btn-lg'] )  }}
                {!! Form::close() !!}
              </td>
            </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
@endsection