<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\UserController;
use App\Http\Controllers\RoleController;


use App\Http\Controllers\User\UserManagementController;
use App\Http\Controllers\Dashboard\DashboardController;

use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\WhatsappController;
use App\Http\Controllers\InvoiceController;

use App\Http\Controllers\Admin\VehicleController;
use App\Http\Controllers\Admin\TrailerController;
use App\Http\Controllers\Admin\InventoryController;
use App\Http\Controllers\Admin\BrandController;
use App\Http\Controllers\UserendController;

use App\Http\Controllers\Admin\File\TyreController;
use App\Http\Controllers\Admin\File\RimController;
use App\Http\Controllers\Admin\File\BatteryController;

// Masters
use App\Http\Controllers\Admin\Masters\VehicleTypeController;
use App\Http\Controllers\Admin\Masters\TrailerTypeController;
use App\Http\Controllers\Admin\Masters\ServiceTypeController;
use App\Http\Controllers\Admin\Masters\RimServiceTypeController;
use App\Http\Controllers\Admin\Masters\BatteryServiceTypeController;
use App\Http\Controllers\Admin\Masters\DocumentTypeController;
use App\Http\Controllers\Admin\Masters\ActionTypeController;
use App\Http\Controllers\Admin\Masters\RimActionTypeController;
use App\Http\Controllers\Admin\Masters\BatteryActionTypeController;
use App\Http\Controllers\Admin\Masters\BatteryTypeController;
use App\Http\Controllers\Admin\Masters\VehicleBrandsController;
use App\Http\Controllers\Admin\Masters\TrailerBrandsController;
use App\Http\Controllers\Admin\Masters\TyreBrandsController;
use App\Http\Controllers\Admin\Masters\RimBrandsController;
use App\Http\Controllers\Admin\Masters\BatteryBrandsController;

use App\Http\Controllers\Admin\Masters\InspectionFaqController;
use App\Http\Controllers\Admin\Masters\RimInspectionController;
use App\Http\Controllers\Admin\Masters\BatteryInspectionController;

use App\Http\Controllers\Admin\TicketController;
use App\Http\Controllers\Admin\ImportController;






use App\Models\Permission;



/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/qr/gn', [VehicleController::class,'qr_gn']);


Route::view('/data/import', 'import');
Route::post('data/import', [ImportController::class, 'import']);
 
Route::view('/dashboard/login', 'dashboard.login');
Route::post('dashboard/login', [DashboardController::class, 'login'])->name('DashboardLogin');

Route::group(['middleware'=>['dashboard']],function(){
    
    Route::get('/dashboard', [DashboardController::class,'home']);
    Route::get('/dashboard/vehicle/{id}', [DashboardController::class,'vehicle']);
    Route::post('/dashboard/vehicle/inspection/store', [DashboardController::class,'store_inspection']);
    
    Route::get('dashboard/vehicle/view/tyre/{id}/{position}', [DashboardController::class, 'viewTyre'])->name('dashboard.veiw_tyre');
    Route::get('dashboard/vehicle/view/rim/{id}/{position}', [DashboardController::class, 'viewRim'])->name('dashboard.veiw_rim');
    Route::get('dashboard/vehicle/view/battery/{id}/{position}', [DashboardController::class, 'viewBattery'])->name('dashboard.veiw_battery');
    Route::get('dashboard/vehicle/view/stepney/tyre/{id}/{position}', [DashboardController::class, 'viewStepneyTyre'])->name('dashboard.veiw_tyre');
    Route::get('dashboard/vehicle/view/stepney/rim/{id}/{position}', [DashboardController::class, 'viewStepneyRim'])->name('dashboard.veiw_rim');
    
    
    Route::get('dashboard/tyre/history/{id}', [DashboardController::class, 'tyre_history'])->name('dashboard.tyre_history');
    Route::get('dashboard/rim/history/{id}', [DashboardController::class, 'rim_history'])->name('dashboard.rim_history');
    Route::get('dashboard/battery/history/{id}', [DashboardController::class, 'battery_history'])->name('dashboard.battery_history');
    
    Route::get('dashboard/tyre/service/history/{id}', [DashboardController::class, 'tyre_service_history'])->name('dashboard.tyre_service_history');
    Route::get('dashboard/rim/service/history/{id}', [DashboardController::class, 'rim_service_history'])->name('dashboard.rim_service_history');
    Route::get('dashboard/battery/service/history/{id}', [DashboardController::class, 'battery_service_history'])->name('dashboard.battery_service_history');
    
    Route::get('dashboard/tyre/inspection/history/{id}', [DashboardController::class, 'tyre_inspection_history'])->name('dashboard.tyre_inspection_history');
    Route::get('dashboard/rim/inspection/history/{id}', [DashboardController::class, 'rim_inspection_history'])->name('dashboard.rim_inspection_history');
    Route::get('dashboard/battery/inspection/history/{id}', [DashboardController::class, 'battery_inspection_history'])->name('dashboard.battery_inspection_history');

    

    
Route::view('/dashboard/list', 'dashboard.list');

});

// Route::get('tezt', fn () => phpinfo());



    $user = Auth::user();
    
Auth::routes();

Route::prefix('')->middleware('auth')->group(function(){

    Route::view('/', 'home')->name('Dashboard');
    Route::view('/feedback', 'feedback.index')->name('feedback');
    Route::view('/ticket', 'ticket.index')->name('ticket');

    
Route::middleware(['can:view-masters'])->group(function () {
     // Masters
    Route::get('action_type', [ActionTypeController::class, 'index'])->name('action_type');
    Route::get('action_type/delete/{id}', [ActionTypeController::class, 'destroy'])->name('action_type.delete');
    Route::post('action_type/store', [ActionTypeController::class, 'store'])->name('action_type.store');
    Route::post('action_type/update', [ActionTypeController::class, 'store'])->name('action_type.update');

    Route::get('rim/action_type', [RimActionTypeController::class, 'index'])->name('rim_action_type');
    Route::get('rim/action_type/delete/{id}', [RimActionTypeController::class, 'destroy'])->name('rim_action_type.delete');
    Route::post('rim/action_type/store', [RimActionTypeController::class, 'store'])->name('rim_action_type.store');
    Route::post('rim/action_type/update', [RimActionTypeController::class, 'store'])->name('rim_action_type.update');

    Route::get('battery/action_type', [BatteryActionTypeController::class, 'index'])->name('battery_action_type');
    Route::get('battery/action_type/delete/{id}', [BatteryActionTypeController::class, 'destroy'])->name('battery_action_type.delete');
    Route::post('battery/action_type/store', [BatteryActionTypeController::class, 'store'])->name('battery_action_type.store');
    Route::post('battery/action_type/update', [BatteryActionTypeController::class, 'store'])->name('battery_action_type.update');
    
    Route::get('document_type', [DocumentTypeController::class, 'index'])->name('document_type');
    Route::get('document_type/delete/{id}', [DocumentTypeController::class, 'destroy'])->name('document_type.delete');
    Route::post('document_type/store', [DocumentTypeController::class, 'store'])->name('document_type.store');
    Route::post('document_type/update', [DocumentTypeController::class, 'store'])->name('document_type.update');
    
    Route::get('vehicle_type', [VehicleTypeController::class, 'index'])->name('vehicle_type');
    Route::get('vehicle_type/delete/{id}', [VehicleTypeController::class, 'destroy'])->name('vehicle_type.delete');
    Route::post('vehicle_type/store', [VehicleTypeController::class, 'store'])->name('vehicle_type.store');
    Route::post('vehicle_type/update', [VehicleTypeController::class, 'store'])->name('vehicle_type.update');
    
    Route::get('service_type', [ServiceTypeController::class, 'index'])->name('service_type');
    Route::get('service_type/delete/{id}', [ServiceTypeController::class, 'destroy'])->name('action_type.delete');
    Route::post('service_type/store', [ServiceTypeController::class, 'store'])->name('service_type.store');
    Route::post('service_type/update', [ServiceTypeController::class, 'update'])->name('service_type.update');
    
    Route::get('rim/service_type', [RimServiceTypeController::class, 'index'])->name('rim_service_type');
    Route::get('rim/service_type/delete/{id}', [RimServiceTypeController::class, 'destroy'])->name('action_type.delete');
    Route::post('rim/service_type/store', [RimServiceTypeController::class, 'store'])->name('rim_service_type.store');
    Route::post('rim/service_type/update', [RimServiceTypeController::class, 'update'])->name('rim_service_type.update');
    
    Route::get('battery/service_type', [BatteryServiceTypeController::class, 'index'])->name('battery_service_type');
    Route::get('battery/service_type/delete/{id}', [BatteryServiceTypeController::class, 'destroy'])->name('action_type.delete');
    Route::post('battery/service_type/store', [BatteryServiceTypeController::class, 'store'])->name('battery_service_type.store');
    Route::post('battery/service_type/update', [BatteryServiceTypeController::class, 'update'])->name('battery_service_type.update');
    
    Route::get('trailer_type', [TrailerTypeController::class, 'index'])->name('trailer_type');
    Route::get('trailer_type/delete/{id}', [TrailerTypeController::class, 'destroy'])->name('trailer_type.delete');
    Route::post('trailer_type/store', [TrailerTypeController::class, 'store'])->name('trailer_type.store');
    Route::post('trailer_type/update', [TrailerTypeController::class, 'store'])->name('trailer_type.update');
    
    Route::get('battery_type', [BatteryTypeController::class, 'index'])->name('action_type');
    Route::get('battery_type/delete/{id}', [BatteryTypeController::class, 'destroy'])->name('battery_type.delete');
    Route::post('battery_type/store', [BatteryTypeController::class, 'store'])->name('battery_type.store');
    Route::post('battery_type/update', [BatteryTypeController::class, 'update'])->name('battery_type.update');
    
    Route::get('vehicle_brand', [VehicleBrandsController::class, 'index'])->name('vehicle_brand');
    Route::get('vehicle_brand/delete/{id}', [VehicleBrandsController::class, 'destroy'])->name('vehicle_brand.delete');
    Route::post('vehicle_brand/store', [VehicleBrandsController::class, 'store'])->name('vehicle_brand.store');
    Route::post('vehicle_brand/update', [VehicleBrandsController::class, 'update'])->name('vehicle_brand.update');
    
    Route::get('trailer_brand', [TrailerBrandsController::class, 'index'])->name('trailer_brand');
    Route::get('trailer_brand/delete/{id}', [TrailerBrandsController::class, 'destroy'])->name('trailer_brand.delete');
    Route::post('trailer_brand/store', [TrailerBrandsController::class, 'store'])->name('trailer_brand.store');
    Route::post('trailer_brand/update', [TrailerBrandsController::class, 'update'])->name('trailer_brand.update');
    
    Route::get('tyre_brand', [TyreBrandsController::class, 'index'])->name('tyre_brand');
    Route::get('tyre_brand/delete/{id}', [TyreBrandsController::class, 'destroy'])->name('tyre_brand.delete');
    Route::post('tyre_brand/store', [TyreBrandsController::class, 'store'])->name('tyre_brand.store');
    Route::post('tyre_brand/update', [TyreBrandsController::class, 'update'])->name('tyre_brand.update');
    
    Route::get('rim_brand', [RimBrandsController::class, 'index'])->name('rim_brand');
    Route::get('rim_brand/delete/{id}', [RimBrandsController::class, 'destroy'])->name('rim_brand.delete');
    Route::post('rim_brand/store', [RimBrandsController::class, 'store'])->name('rim_brand.store');
    Route::post('rim_brand/update', [RimBrandsController::class, 'update'])->name('rim_brand.update');
    
    Route::get('battery_inspection', [BatteryInspectionController::class, 'index'])->name('battery_inspection');
    Route::get('battery_inspection/delete/{id}', [BatteryInspectionController::class, 'destroy'])->name('battery_inspection.delete');
    Route::post('battery_inspection/store', [BatteryInspectionController::class, 'store'])->name('battery_inspection.store');
    Route::post('battery_inspection/update', [BatteryInspectionController::class, 'update'])->name('battery_inspection.update');

    Route::get('rim_inspection', [RimInspectionController::class, 'index'])->name('rim_inspection');
    Route::get('rim_inspection/delete/{id}', [RimInspectionController::class, 'destroy'])->name('rim_inspection.delete');
    Route::post('rim_inspection/store', [RimInspectionController::class, 'store'])->name('rim_inspection.store');
    Route::post('rim_inspection/update', [RimInspectionController::class, 'update'])->name('rim_inspection.update');

    
    Route::get('battery_brand', [BatteryBrandsController::class, 'index'])->name('battery_brand');
    Route::get('battery_brand/delete/{id}', [BatteryBrandsController::class, 'destroy'])->name('battery_brand.delete');
    Route::post('battery_brand/store', [BatteryBrandsController::class, 'store'])->name('battery_brand.store');
    Route::post('battery_brand/update', [BatteryBrandsController::class, 'update'])->name('battery_brand.update');
    
    Route::get('inspection_faq', [InspectionFaqController::class, 'index'])->name('inspection_faq');
    Route::get('inspection_faq/delete/{id}', [InspectionFaqController::class, 'destroy'])->name('inspection_faq.delete');
    Route::post('inspection_faq/store', [InspectionFaqController::class, 'store'])->name('inspection_faq.store');
    Route::post('inspection_faq/update', [InspectionFaqController::class, 'update'])->name('inspection_faq.update');
    // End Master
});

Route::middleware(['can:view-inventory'])->group(function () {
    Route::get('inventory/history/{type}/{id}', [InventoryController::class, 'inventory_history'])->name('inventory.history');

    Route::get('inventory/tyre', [InventoryController::class, 'tyre'])->name('inventory.tyre');
    Route::get('inventory/{id}/delete', [InventoryController::class, 'destroy_tyre'])->name('inventory.destroy_tyre');
    Route::get('inventory/tyre/create', [InventoryController::class, 'create_tyre'])->name('inventory.create_tyre');
    Route::get('inventory/tyre/{id}/view', [InventoryController::class, 'show_tyre'])->name('inventory.show_tyre');
    Route::get('inventory/tyre/{id}/edit', [InventoryController::class, 'edit_tyre'])->name('inventory.edit_tyre');
    Route::post('inventory/tyre/store', [InventoryController::class, 'store_tyre'])->name('inventory.store_tyre');
    Route::post('inventory/tyre/update', [InventoryController::class, 'update_tyre'])->name('inventory.update_tyre');
    
    Route::get('inventory/rim', [InventoryController::class, 'rim'])->name('inventory.rim');
    Route::get('inventory/{id}/delete', [InventoryController::class, 'destroy_rim'])->name('inventory.destroy_rim');
    Route::get('inventory/rim/create', [InventoryController::class, 'create_rim'])->name('inventory.create_rim');
    Route::get('inventory/rim/{id}/view', [InventoryController::class, 'show_rim'])->name('inventory.show_rim');
    Route::get('inventory/rim/{id}/edit', [InventoryController::class, 'edit_rim'])->name('inventory.edit_rim');
    Route::post('inventory/rim/store', [InventoryController::class, 'store_rim'])->name('inventory.store_rim');
    Route::post('inventory/rim/update', [InventoryController::class, 'update_rim'])->name('inventory.update_rim');
    
    Route::get('inventory/battery', [InventoryController::class, 'battery'])->name('inventory.battery');
    Route::get('inventory/{id}/delete', [InventoryController::class, 'destroy_battery'])->name('inventory.destroy_battery');
    Route::get('inventory/battery/create', [InventoryController::class, 'create_battery'])->name('inventory.create_battery');
    Route::get('inventory/battery/{id}/view', [InventoryController::class, 'show_battery'])->name('inventory.show_battery');
    Route::get('inventory/battery/{id}/edit', [InventoryController::class, 'edit_battery'])->name('inventory.edit_battery');
    Route::post('inventory/battery/store', [InventoryController::class, 'store_battery'])->name('inventory.store_battery');
    Route::post('inventory/battery/update', [InventoryController::class, 'update_battery'])->name('inventory.update_battery');
    
});

Route::middleware(['can:view-vehicle'])->group(function () {
    Route::view('/vehicles/image', 'vehicle.vehicle_image');
   
    Route::get('vehicle', [VehicleController::class, 'index'])->name('vehicles');
    Route::get('vehicles/{id}/delete', [VehicleController::class, 'destroy'])->name('vehicle.delete');
    
    Route::get('vehicles/view/tyre/{id}/{position}', [VehicleController::class, 'viewTyre'])->name('vehicle.veiw_tyre');
    Route::get('vehicles/add/tyre/{id}/{position}', [VehicleController::class, 'addTyre'])->name('vehicle.add_tyre');
    Route::post('vehicles/install/tyre', [VehicleController::class, 'install_tyre'])->name('vehicle.install_tyre');
    
    Route::get('vehicles/view/rim/{id}/{position}', [VehicleController::class, 'viewRim'])->name('vehicle.veiw_rim');
    Route::get('vehicles/add/rim/{id}/{position}', [VehicleController::class, 'addRim'])->name('vehicle.add_rim');
    Route::post('vehicles/install/rim', [VehicleController::class, 'install_rim'])->name('vehicle.install_rim');
    
    Route::get('vehicles/view/battery/{id}/{position}', [VehicleController::class, 'view_battery'])->name('vehicle.veiw_battery');
    Route::get('vehicles/add/battery/{id}/{position}', [VehicleController::class, 'add_battery'])->name('vehicle.add_battery');
    Route::post('vehicles/install/battery', [VehicleController::class, 'install_battery'])->name('vehicle.install_battery');
    
    Route::get('vehicles/view/stepney/tyre/{id}/{position}', [VehicleController::class, 'view_stepney_tyre'])->name('vehicle.veiw_stepney_tyre');
    Route::get('vehicles/add/stepney/tyre/{id}/{position}', [VehicleController::class, 'add_stepney_tyre'])->name('vehicle.add_stepney_tyre');
    Route::post('vehicles/install/stepney/tyre', [VehicleController::class, 'install_stepney_tyre'])->name('vehicle.install_stepney_tyre');
    
    Route::get('vehicles/view/stepney/rim/{id}/{position}', [VehicleController::class, 'view_stepney_rim'])->name('vehicle.veiw_stepney_rim');
    Route::get('vehicles/add/stepney/rim/{id}/{position}', [VehicleController::class, 'add_stepney_rim'])->name('vehicle.add_stepney_rim');
    Route::post('vehicles/install/stepney/rim', [VehicleController::class, 'install_stepney_rim'])->name('vehicle.install_stepney_rim');
    
    
    Route::get('vehicles/create', [VehicleController::class, 'create'])->name('vehicle.create');
    Route::get('vehicles/{id}/edit', [VehicleController::class, 'edit'])->name('vehicle.edit');
    Route::get('vehicles/image/{id}', [VehicleController::class, 'image'])->name('vehicle.image');
    Route::get('vehicle/qr/download/{id}', [VehicleController::class, 'download_qr'])->name('vehicle.qr');
    Route::get('vehicle/documents/{id}', [VehicleController::class, 'documents'])->name('vehicle.documents');
    Route::post('vehicle/documents/store', [VehicleController::class, 'store_documents'])->name('vehicle.store_documents');
    Route::post('vehicle/documents/update', [VehicleController::class, 'update_documents'])->name('vehicle.update_documents');

    Route::get('vehicles/configuration/{id}', [VehicleController::class, 'configuration'])->name('vehicle.configuration');
    Route::post('vehicle/store', [VehicleController::class, 'store'])->name('vehicle.store');
    Route::post('vehicle/update', [VehicleController::class, 'update'])->name('vehicle.update');
    Route::post('vehicle/image/save', [VehicleController::class, 'imageStore'])->name('vehicle.image_save');
    Route::get('vehicle/attach/trailer/{id}', [VehicleController::class, 'attach_trailer'])->name('vehicle.attach_trailer');
    Route::post('vehicle/add/trailer', [VehicleController::class, 'add_trailer'])->name('vehicle.add_trailer');
    Route::get('vehicle/remove/trailer/{id}', [VehicleController::class, 'remove_trailer'])->name('vehicle.remove_trailer');
    // End Vehicle
});

Route::middleware(['can:view-trailer'])->group(function () {
    Route::get('trailer', [TrailerController::class, 'index'])->name('trailer');
    Route::get('trailer/create', [TrailerController::class, 'create'])->name('trailer.create');
    Route::get('trailer/history/{id}', [TrailerController::class, 'history'])->name('trailer.history');
    Route::get('trailer/{id}/edit', [TrailerController::class, 'edit'])->name('trailer.edit');
    Route::get('trailer/view/{id}', [TrailerController::class, 'view'])->name('trailer.view');
    Route::get('trailer/configuration/{id}', [TrailerController::class, 'configuration'])->name('trailer.configuration');
    Route::post('trailer/configuration/save', [TrailerController::class, 'configuration_save'])->name('trailer.configuration_save');
    Route::post('trailer/store', [TrailerController::class, 'store'])->name('trailer.store');
    Route::post('trailer/update', [TrailerController::class, 'update'])->name('trailer.update');
    
    Route::get('trailer/add/tyre/{id}/{position}', [TrailerController::class, 'addTyre'])->name('trailer.add_tyre');
    Route::post('trailer/install/tyre', [TrailerController::class, 'install_tyre'])->name('trailer.install_tyre');
    
    Route::get('trailer/documents/{id}', [TrailerController::class, 'documents'])->name('trailer.documents');
    Route::post('trailer/documents/store', [TrailerController::class, 'store_documents'])->name('trailer.store_documents');
    Route::post('trailer/documents/update', [TrailerController::class, 'update_documents'])->name('vehicle.update_documents');
    
    
    Route::get('trailer/view/tyre/{id}/{position}', [TrailerController::class, 'viewTyre'])->name('trailer.veiw_tyre');
    Route::get('trailer/add/tyre/{id}/{position}', [TrailerController::class, 'addTyre'])->name('trailer.add_tyre');
    Route::post('trailer/install/tyre', [TrailerController::class, 'install_tyre'])->name('trailer.install_tyre');
    
    Route::get('trailer/view/rim/{id}/{position}', [TrailerController::class, 'viewRim'])->name('trailer.veiw_rim');
    Route::get('trailer/add/rim/{id}/{position}', [TrailerController::class, 'addRim'])->name('trailer.add_rim');
    Route::post('trailer/install/rim', [TrailerController::class, 'install_rim'])->name('trailer.install_rim');
    
    
    Route::get('trailer/view/stepney/tyre/{id}/{position}', [TrailerController::class, 'view_stepney_tyre'])->name('trailer.veiw_stepney_tyre');
    Route::get('trailer/add/stepney/tyre/{id}/{position}', [TrailerController::class, 'add_stepney_tyre'])->name('trailer.add_stepney_tyre');
    Route::post('trailer/install/stepney/tyre', [TrailerController::class, 'install_stepney_tyre'])->name('trailer.install_stepney_tyre');
    
    Route::get('trailer/view/stepney/rim/{id}/{position}', [TrailerController::class, 'view_stepney_rim'])->name('trailer.veiw_stepney_rim');
    Route::get('trailer/add/stepney/rim/{id}/{position}', [TrailerController::class, 'add_stepney_rim'])->name('trailer.add_stepney_rim');
    Route::post('trailer/install/stepney/rim', [TrailerController::class, 'install_stepney_rim'])->name('trailer.install_stepney_rim');
    
    Route::get('trailer/view/battery/{id}/{position}', [TrailerController::class, 'view_battery'])->name('trailer.veiw_battery');
    Route::get('trailer/add/battery/{id}/{position}', [TrailerController::class, 'add_battery'])->name('trailer.add_battery');
    Route::post('trailer/install/battery', [TrailerController::class, 'install_battery'])->name('trailer.install_battery');
    
    // End Trailer
});

Route::middleware(['can:view-tyre'])->group(function () {
    Route::get('tyre', [TyreController::class, 'index'])->name('tyres');
    Route::get('tyre/{id}/delete', [TyreController::class, 'destroy'])->name('tyre.delete');
    Route::get('tyre/create', [TyreController::class, 'create'])->name('tyre.create');
    Route::get('tyre/{id}/edit', [TyreController::class, 'edit'])->name('tyre.edit');
    Route::get('tyre/details/{id}', [TyreController::class, 'show'])->name('tyre.view');
    Route::get('tyre/position/{id}/{id1}', [TyreController::class, 'tyre_position'])->name('tyre.position');
    Route::post('tyre/store', [TyreController::class, 'store'])->name('tyre.store');
    Route::post('tyre/update', [TyreController::class, 'update'])->name('tyre.update');
    
    Route::post('tyre/history/store', [TyreController::class, 'store_history'])->name('tyre.tyre_history');
    
    Route::get('tyre/history/{id}', [TyreController::class, 'tyre_history'])->name('tyre.inspection_historyy');
    Route::get('tyre/service/history/{id}', [TyreController::class, 'service_history'])->name('tyre.inspection_historyy');
    Route::get('tyre/inspection/history/{id}', [TyreController::class, 'inspection_history'])->name('tyre.inspection_historyy');

    Route::post('tyre/service/history/store', [TyreController::class, 'store_service'])->name('tyre.service_history');
    
    Route::post('tyre/inspection/history/store', [TyreController::class, 'store_inspection'])->name('tyre.inspection_history');
    Route::get('tyre/activity', [TyreController::class, 'tyre_activity'])->name('tyre.activity');

    // End Tyre
});

Route::middleware(['can:view-rim'])->group(function () {
    Route::get('rims', [RimController::class, 'index'])->name('rims');
    Route::get('rim/{id}/delete', [RimController::class, 'destroy'])->name('rim.delete');
    Route::get('rim/create', [RimController::class, 'create'])->name('rim.create');
    Route::get('rim/{id}/edit', [RimController::class, 'edit'])->name('rim.edit');
    Route::get('rim/details/{id}', [RimController::class, 'show'])->name('rim.view');
    Route::get('rim/position/{id}/{id1}', [RimController::class, 'rim_position'])->name('rim.position');
    Route::post('rim/store', [RimController::class, 'store'])->name('rim.store');
    Route::post('rim/update', [RimController::class, 'store'])->name('rim.update');
    
    Route::post('rim/history/store', [RimController::class, 'store_history'])->name('rim.rim_history');
    
    Route::get('rim/history/{id}', [RimController::class, 'rim_history'])->name('rim.rimm_history');
    Route::get('rim/service/history/{id}', [RimController::class, 'service_history'])->name('rim.service_history');
    Route::get('rim/inspection/history/{id}', [RimController::class, 'inspection_history'])->name('rim.inspection_historyy');
    
    Route::post('rim/service/history/store', [RimController::class, 'store_service'])->name('rim.service_history');
    Route::post('rim/inspection/history/store', [RimController::class, 'store_inspection'])->name('rim.inspection_history');
    Route::get('rim/activity', [RimController::class, 'rim_activity'])->name('rim.activity');
    // End Rim
});

Route::middleware(['can:view-battery'])->group(function () {
    Route::get('battery', [BatteryController::class, 'index'])->name('battery');
    Route::get('battery/{id}/delete', [BatteryController::class, 'destroy'])->name('battery.delete');
    Route::get('battery/create', [BatteryController::class, 'create'])->name('battery.create');
    Route::get('battery/{id}/edit', [BatteryController::class, 'edit'])->name('battery.edit');
    Route::get('battery/details/{id}', [BatteryController::class, 'show'])->name('battery.view');
    Route::post('battery/store', [BatteryController::class, 'store'])->name('battery.store');
    Route::post('battery/update', [BatteryController::class, 'store'])->name('battery.update');
    
    Route::post('battery/history/store', [BatteryController::class, 'store_history'])->name('battery.battery_history');
    
    Route::get('battery/history/{id}', [BatteryController::class, 'battery_history'])->name('battery.inspection_historyy');
    Route::get('battery/service/history/{id}', [BatteryController::class, 'service_history'])->name('battery.inspection_historyy');
    Route::get('battery/inspection/history/{id}', [BatteryController::class, 'inspection_history'])->name('battery.inspection_historyy');
    
    Route::post('battery/service/history/store', [BatteryController::class, 'store_service'])->name('battery.service_history');
    Route::post('battery/inspection/history/store', [BatteryController::class, 'store_inspection'])->name('battery.inspection_history');
    Route::get('battery/activity', [BatteryController::class, 'battery_activity'])->name('battery.activity');
    // End Battery
});

Route::middleware(['can:view-users'])->group(function () {
    Route::resource('/users', UserManagementController::class);
    Route::get('/users-history', [UserManagementController::class,'history']);
    Route::post('/users-new', [UserManagementController::class,'create']);
    Route::get('/users-edit/{id}', [UserManagementController::class,'edit']);
    Route::post('/users-update', [UserManagementController::class,'update']);
    Route::get('/users/{id}/delete', [UserManagementController::class, 'delete']);
}); 

Route::middleware(['can:view-ticket'])->group(function () {

  Route::get('ticket/create', [TicketController::class, 'createTicket'])->name('ticket.create');
  Route::post('ticket/store', [TicketController::class, 'storeTicket'])->name('ticket.store');
  Route::get('ticket/chat', [TicketController::class, 'chat'])->name('tickets.chat');
 
});

  Route::get('feedback/create', [TicketController::class, 'createFeedback'])->name('feedback.create');
  Route::post('feedback/store', [TicketController::class, 'storeFeedback'])->name('feedback.store');

Route::middleware(['can:view-manage_feedbacks'])->group(function () {

  Route::get('feedback', [TicketController::class, 'feedbackView'])->name('feedback.view');
  Route::get('feedback/details/{id}', [TicketController::class, 'feedback_details'])->name('feedback.details');
  Route::post('feedback/status/update', [TicketController::class, 'feedback_status'])->name('feedback.status_update');
  // Route::get('feedback/chat', [TicketController::class, 'chat'])->name('feedbacks.chat');
 
});

Route::middleware(['can:view-manage_tickets'])->group(function () {

  Route::get('ticket', [TicketController::class, 'ticketView'])->name('ticket.view');
  Route::get('ticket/details/{id}', [TicketController::class, 'ticket_details'])->name('ticket.details');
  Route::post('ticket/status/update', [TicketController::class, 'ticket_status'])->name('ticket.status_update');
  // Route::get('ticket/chat', [TicketController::class, 'chat'])->name('tickets.chat');
 
});

    
});

    Gate::define('view-masters', function ($user) {

      $id= $user->id;
      $p= Permission::where('user_id', $id)->first();
      $cus_p= $p->master;
      return $cus_p === 1;
    });

    Gate::define('view-vehicle', function ($user) {

      $id= $user->id;
      $p= Permission::where('user_id', $id)->first();
      $cus_p= $p->vehicle;
      return $cus_p === 1;
    });

    Gate::define('view-trailer', function ($user) {

      $id= $user->id;
      $p= Permission::where('user_id', $id)->first();
      $cus_p= $p->trailer;
      return $cus_p === 1;
    });

    Gate::define('view-tyre', function ($user) {

      $id= $user->id;
      $p= Permission::where('user_id', $id)->first();
      $cus_p= $p->tyre;
      return $cus_p === 1;
    });
    
    Gate::define('view-rim', function ($user) {

      $id= $user->id;
      $p= Permission::where('user_id', $id)->first();
      $cus_p= $p->rim;
      return $cus_p === 1;
    });

    Gate::define('view-battery', function ($user) {

      $id= $user->id;
      $p= Permission::where('user_id', $id)->first();
      $cus_p= $p->battery;
      return $cus_p === 1;
    });

    Gate::define('view-inventory', function ($user) {

      $id= $user->id;
      $p= Permission::where('user_id', $id)->first();
      $cus_p= $p->inventory;
      return $cus_p === 1;
    });

    Gate::define('view-ticket', function ($user) {

      $id= $user->id;
      $p= Permission::where('user_id', $id)->first();
      $cus_p= $p->ticket;
      return $cus_p === 1;
    });

    Gate::define('view-manage_feedbacks', function ($user) {

      $id= $user->id;
      $p= Permission::where('user_id', $id)->first();
      $cus_p= $p->manage_feedbacks;
      return $cus_p === 1;
    });

    Gate::define('view-manage_tickets', function ($user) {

      $id= $user->id;
      $p= Permission::where('user_id', $id)->first();
      $cus_p= $p->manage_tickets;
      return $cus_p === 1;
    });
    
    Gate::define('view-users', function ($user) {

      $id= $user->id;
      $p= Permission::where('user_id', $id)->first();
      $cus_p= $p->user_management;
      return $cus_p === 2;
    });
    

// $subdomain = session('subdomain');
// $subdomainArray = ['test1', 'test2', 'test3', 'ksit', 'rrnagar'];

// Route::domain('swanadmin.' . config('app.domain'))->group(function () use ($subdomainArray) {
   Route::middleware(['admin'])->group(function () {
        // Dashboard route
    
    // Route::view('/inventory/create', 'inventory.create')->name('inventory.create');
    // Route::view('/tyre/create', 'tyre.create')->name('tyre.create');
    // Route::view('/rim/create', 'rim.create')->name('rim.create');
    // Route::view('/battery/create', 'battery.create')->name('battery.create');
    // Route::view('/vehicle/create', 'vehicle.create')->name('vehicle.create');
    

;





    
    });
// });


// Catch-all route for invalid subdomains
// Route::domain('{subdomain}.' . config('app.domain'))->group(function () use ($subdomainArray) {
//     Route::get('/{any}', function () {
//         return 'Unknown Subdomain doesnt exist';
//     })->where('any', '.*');
// });



// Route::get('dashboard/update', [DashboardController::class, 'update']);


// Route::domain('abc.' .config('app.domain'))->group(function () {
//     Route::view('/', 'userend.home');

// });



// // Route::view('/dashboard/login', 'dashboard.login');
// // Route::post('dashboard/login', [DashboardController::class, 'login'])->name('DashboardLogin');

// // Route::group(['middleware'=>['dashboard']],function(){
// //     Route::view('/dashboard/testz', 'dashboard.dashboard');
// // });


  
Route::view('/tms_login', 'auth.login');
Route::post('tms_login', [LoginController::class, 'login'])->name('Login');
Route::post('admin/logout', [LoginController::class, 'logout'])->name('Logout');



