<!DOCTYPE html>
<html lang="en">
<head>

  <meta charset="utf-8">
  <title>TMS | Inspect Vehicles</title>

  <!-- Mobile Specific Metas
  ================================================== -->
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=5.0">
  <meta name="description" content="Create your ecommerce store">
  <meta name="author" content="TMS">

  <!-- Favicon -->
  <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('public/user/images/favicon.png')); ?>" />
    <!--<link rel="stylesheet" href="https://tms.vokks.in/assets/css/style.css">-->
  
  <!-- PLUGINS CSS STYLE -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.2/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.css" integrity="sha512-wR4oNhLBHf7smjy0K4oqzdWumd+r5/+6QO/vDda76MW5iug4PT7v86FoEkySIJft3XA0Ae6axhIvHrqwm793Nw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.css" integrity="sha512-6lLUdeQ5uheMFbWm3CP271l14RsX1xtx+J5x2yeIDkkiBpeVTNhTqijME7GgRKKi6hCqovwCoBTlRBEC20M8Mg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<!--   <link rel="stylesheet" href="plugins/aos/aos.css">
 -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css" integrity="sha512-xh6O/CkQoPOWDdYTDqeRdPCVd1SpvCA9XXcUnZS2FmJNp1coAFzvtCN9BmamE+4aHK8yyUHUSCcJHgXloTyT2A==" crossorigin="anonymous" referrerpolicy="no-referrer" />

  <link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Alata&family=Outfit&display=swap" rel="stylesheet">

  <!-- CUSTOM CSS -->
  <link href="<?php echo e(asset('public/user/css/styles.css')); ?>" rel="stylesheet">

<style>

 .flex-col-center {
    display: -webkit-box;
    display: -ms-flexbox;
    display: flex;
    -webkit-box-orient: vertical;
    -webkit-box-direction: normal;
    -ms-flex-direction: column;
    flex-direction: column;
    -webkit-box-pack: center;
    -ms-flex-pack: center;
    justify-content: center;
    -webkit-box-align: center;
    -ms-flex-align: center;
    align-items: center;
   }
   
   .pretty {
    position: relative;
    display: inline-block;
    margin-right: 1em;
    white-space: nowrap;
    line-height: 1;
  }
  
  .pretty input {
    position: absolute;
    left: 0;
    top: 0;
    min-width: 1em;
    width: 100%;
    height: 100%;
    z-index: 2;
    opacity: 0;
    margin: 0;
    padding: 0;
    cursor: pointer;
   }
   
   .checkboxes .pretty .custom-state label {
    font-size: 18px;
    padding-left: 5px;
}

.pretty .state label {
    position: initial;
    display: inline-block;
    font-weight: 400;
    margin: 0;
    text-indent: 1.5em;
    min-width: calc(1em + 2px);
}

  .checkboxes .pretty .custom-state label::before {
    border: 4px solid #fff;
}

.pretty.p-round .state label:after, .pretty.p-round .state label:before {
    border-radius: 100%;
}
.pretty .state label:before {
    border-color: #bdc3c7;
}
.pretty .state label:after, .pretty .state label:before {
    content: '';
    width: calc(1em + 2px);
    height: calc(1em + 2px);
    display: block;
    box-sizing: border-box;
    border-radius: 0;
    border: 1px solid transparent;
    z-index: 0;
    position: absolute;
    left: 0;
    top: calc((0% - (100% - 1em)) - 8%);
    background-color: transparent;
}

.checkboxes .pretty.p-default input:checked~.state label:after {
    background-color: #000 !important;
}
.pretty.p-default input:checked~.state label:after {
    background-color: #bdc3c7!important;
}
.checkboxes .pretty .custom-state label::after {
    background-color: transparent;
}
.pretty.p-round .state label:after, .pretty.p-round .state label:before {
    border-radius: 100%;
}
.pretty.p-default .state label:after {
    -webkit-transform: scale(.6);
    -ms-transform: scale(.6);
    transform: scale(.6);
}
.pretty .state label:after, .pretty .state label:before {
    content: '';
    width: calc(1em + 2px);
    height: calc(1em + 2px);
    display: block;
    box-sizing: border-box;
    border-radius: 0;
    border: 1px solid transparent;
    z-index: 0;
    position: absolute;
    left: 0;
    top: calc((0% - (100% - 1em)) - 8%);
    background-color: transparent;
}

.tab-button {
    background-color: #000;
    display: inline-block;
    font-weight: 700;
    font-size: 18px;
    border: 0;
    border-radius: 4px !important;
    color: #fff;
    padding: 10px 40px;
    -webkit-transition: all .3s ease;
    transition: all .3s ease;
    text-decoration: none;
}
</style>

</head>

<body style="background: aliceblue;" class="body-wrapper" data-spy="scroll" data-target=".privacy-nav">


<nav style="padding: 15px 0px!important;" class="navbar navbar-expand-lg sticky-top bg-white shadow-sm">
  <div class="container">
    <a class="navbar-brand" href="#"><img style="width:150px!important;" src="https://tab-tms.codesquarry.online/assets/images/logo.png"   alt="logo"></a>
    <button class="btn btn-primary">
      Logout
    </button>
    <!--<button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">-->
    <!--  <span class="navbar-toggler-icon"></span>-->
    <!--</button>-->
    <!--<div class="collapse navbar-collapse" id="navbarNav">-->
    <!--  <ul style="margin-left: auto;" class="navbar-nav ml-auto">-->
    <!--    <li class="nav-item">-->
    <!--      <a class="nav-link active" aria-current="page" href="#">Home</a>-->
    <!--    </li>-->
        
    <!--    <li class="nav-item">-->
    <!--      <a class="nav-link" href="#about">About</a>-->
    <!--    </li>-->
    <!--    <li class="nav-item">-->
    <!--      <a class="nav-link" href="#contact">Contact</a>-->
    <!--    </li>-->
        
    <!--  </ul>-->
    <!--</div>-->
  </div>
</nav>

<!--====================================
=            Hero Section            =
=====================================-->

<section style="margin-top: 0px!important; background: teal; min-height: 70vh;" class="booking-section py-5 text-white" id="book_now">
                <h1 class="text-center">Search for a Vehicle</h1>
                <div class="container">
                    <div class="row">
                        <div class="col-sm-12 flex-col-center">
                            <form action="book" class="mt-4 w-100" method="POST" id="booking_form"><input type="hidden" name="_token" value="tinUWoQ6yFzPTyeWyxCIpzT27dyYzpqv8D02EjUF">
                                <div style="text-align: center;" class="checkboxes flex-row-center">
                                    <div class="pretty p-default p-round" id="book-now-radio-button"><input type="radio" name="radio1" id="scan-qr" value="scan" checked>
                                        <div class="state custom-state"><label>Scan QR Code</label></div>
                                    </div>
                                    <div class="pretty p-default p-round"><input type="radio" name="radio1" id="search-id" value="search">
                                        <div class="state custom-state"><label>Search by Vehicle ID</label></div>
                                    </div>
                                </div>
                                <div class="form-inputs mt-5 w-100">
                                    <div class="row w-100 m-0 p-0">
                                        
                                        <div style="display: none; text-align: center;" class="col-lg-6 col-md-6" id="search-id-content">
                                            <div class="form-group">
                                                <!--<label for class="label-animate">Enter Vehicle ID</label>-->
                                                <input type="text" class="text-input" id="" name="vehicle_id" placeholder="Enter Vehicle ID" value>
                                                <!-- <span class="input-addon">
                                                  <img src="assets/images/frontend-icons-fleet-date.png" alt>
                                                </span> -->
                                            </div>
                                        </div>

                                        <div class="col-sm-12 ">
                                            <div style="background: antiquewhite; min-height: 300px; width: 100%;" class="cam-screen" id="scan-qr-content">
                                                <div style=" min-height: 250px; width: 100%;" id="camera-container">
                                                    <video style="width: 100%; height: 100%;" id="scanner"></video>
                                                     <!--<img id="camera-preview" src="camera-preview-image.jpg" alt="Camera Preview">-->
                                                 </div>
                                            </div>
                                        </div>
                                        <div style="text-align: center;">
                                           <!--<button class="tab-button mx-auto mt-3" type="submit" id="booking">Search</button>-->
                                           <a style="color: #fff;" class="tab-button mx-auto mt-3" id="start-scan">Scan Now</a>
                                           <a style="color: #fff; display: none;" class="tab-button mx-auto mt-3" id="close-scanner" >Close</a>
                                        </div>
                                    </div>
                            </form>
                        </div>
                    </div>
                </div>
            </section>
            
            
            
    



<script type="text/javascript">
    let videoElement = document.getElementById('scanner');
    let startButton = document.getElementById('start-scan');
    let closeButton = document.getElementById('close-scanner');
    let scanner;
    let barcodeDetected = false; // Flag to track if a barcode is detected

    async function startScanner() {
        try {
            const stream = await navigator.mediaDevices.getUserMedia({ video: { facingMode: 'environment' } });
            videoElement.srcObject = stream;
            videoElement.play();

            const barcodeDetector = new BarcodeDetector();

            scanner = setInterval(async () => {
                try {
                    const barcodes = await barcodeDetector.detect(videoElement);
                    if (barcodes.length > 0 && !barcodeDetected) {
                        barcodeDetected = true;
                        var id = barcodes[0].rawValue;
                        // window.location = 'vehicle.html#' + id;
                        
                         var vehicle_id = id;

                        var vehicles = <?php echo json_encode($vehicles->toArray()); ?>;
                        console.log(vehicles)

                        var filteredData = vehicles.filter(function(data) {
                            return data.vehicle_id == vehicle_id;
                        });
                        
                        if (filteredData.length > 0) {
                        window.location = 'dashboard/vehicle/' + id;

                        } else {
                          alert(false);
                        }

                        
                    }
                } catch (error) {
                    console.error('Error detecting barcode:', error);
                }
            }, 100);

            // Show "Close" button and hide "Scan Now" button
            closeButton.style.display = 'inline-block';
            startButton.style.display = 'none';
        } catch (error) {
            console.error('Error accessing camera:', error);
        }
    }

    function closeScanner() {
        if (scanner) {
            clearInterval(scanner);
        }

        if (videoElement.srcObject) {
            videoElement.srcObject.getVideoTracks().forEach(track => track.stop());
            videoElement.srcObject = null;
        }

        // Show "Scan Now" button and hide "Close" button
        startButton.style.display = 'inline-block';
        closeButton.style.display = 'none';

        // Reset the barcodeDetected flag
        barcodeDetected = false;
    }

    startButton.addEventListener('click', startScanner);
    closeButton.addEventListener('click', closeScanner);
</script>



<!--============================
=            Footer            =
=============================-->
<footer style="background: black;">
  
  <div class="text-center py-4">
    <small class="text-white">Tms &copy; <script>document.write(new Date().getFullYear())</script>. All rights reserved</small class="text-secondary">
  </div>

	<div class="text-center py-1">
     <!-- <small class="text-white"> <p>Designed By <a href="https://tms.com/">TMS</a></p></small> -->  
    </div>
</footer>


  <!-- To Top -->
  <!-- <div class="scroll-top">
    <i class="ti-angle-up"></i>
  </div> -->
  
  <!-- JAVASCRIPTS -->
  <script src="https://code.jquery.com/jquery-3.6.1.js" integrity="sha256-3zlB5s2uwoUzrXK3BT7AX3FyvojsraNFxCc2vC/7pNI=" crossorigin="anonymous"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.2/dist/js/bootstrap.min.js" integrity="sha384-IDwe1+LCz02ROU9k972gdyvl+AESN10+x7tBKgc9I5HFtuNz0wWnPclzo6p9vxnk" crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.js" integrity="sha512-XtmMtDEcNz2j7ekrtHvOVR4iwwaD6o/FUJe6+Zq+HgcCsk3kj4uSQQR8weQ2QVj1o0Pk6PwYLohm206ZzNfubg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.js" integrity="sha512-A7AYk1fGKX6S2SsHywmPkrnzTZHrgiVT7GcQkLGDe2ev0aWb8zejytzS8wjo7PGEXKqJOrjQ4oORtnimIRZBtw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
  <!-- google map -->
<!--   <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAgeuuDfRlweIs7D6uo4wdIHVvJ0LonQ6g"></script>
 -->  
  <script src="<?php echo e(asset('public/user/js/script.js')); ?>"></script>
  
  <script>
        // Add event listeners to radio buttons using jQuery
        $(document).ready(function () {
            $('#scan-qr').change(function () {
                if ($(this).is(':checked')) {
                    $('#scan-qr-content').show();
                    $('#search-id-content').hide();
                }
            });

            $('#search-id').change(function () {
                if ($(this).is(':checked')) {
                    $('#scan-qr-content').hide();
                    $('#search-id-content').show();
                }
            });
        });
    </script>
</body>

</html><?php /**PATH /home/vokks/public_html/tms/resources/views/dashboard/home.blade.php ENDPATH**/ ?>